; TEACHINB03.ASM 07JUN07 - TEACH IN 2008 PT2
; STATUS Cary flag checking


#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

           include p16f628.inc

	   CBLOCK h'20'
CLKCNT
	   ENDC

           __config  $3F30    ;  internal 4MHz oscillator

           ORG 0              ; reset vector
           goto STARTIT
           ORG 4              ; Interrupt vector address
           goto STARTIT
           ORG 5              ; PIC program memory location at which to start 

STARTIT:   clrf PORTA         ; clear Port A data register
           clrf PORTB         ; clear Port B data register
           BANK1              ; BANK 1
           clrf TRISA         ; Port A direction register for output
           clrf TRISB         ; Port B direction register for output
           movlw b'10000111'  ; timer 1:256, pull-ups off (bit 7 = 1)
           movwf OPTION_REG
           BANK0              ; BANK 0
                 
LOOP1      movlw 1            ; load value of 1 into Working register
           movwf PORTB        ; load this value as data into Port B
           bcf STATUS,C       ; clear Carry flag
                 
LOOP2      call DELAY
           rlf PORTB,F        ; rotate value of PORTB left by 1 logical place
           btfss STATUS,C     ; check Carry flag is set
           goto LOOP2         ; this command is actioned only if PORTB is not yet 0
                              ; the program jumping back to address LOOP2
           goto LOOP1         ; this command is only actioned when PORTB now = 0

DELAY      movlw 25                 ; set delay counter to 25
           movwf CLKCNT            ; (for 1/25th sec x 5)
           clrf INTCON             ; clear interupt flag
DELAY2                             ; 
           btfss INTCON,2          ; has a timer time-out been detected?
           goto DELAY2             ; no
           bcf INTCON,2            ; yes
           decfsz CLKCNT,F         ; dec counter, is it zero?
           goto DELAY2             ; no
           return                  ; yes

                
           END


