; TEACHINF06.ASM 16JUN07 - TEACH IN 2008 PT2
; 24 hr clock

           include p16f628.inc

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

           __config  h'3F21'    ; XT oscillator (3.2768MHz xtal)

               CBLOCK h'20'
LOOP                 ; loop counter 1 - general
CLKCNT               ; pre-counter for CLOCK
CLKSEC               ; CLOCK main counter - secs
CLKMIN               ; CLOCK - mins
CLKHRS               ; CLOCK - hours
STORE1               ; general store 1
STORE2               ; general store 2
RSLINE               ; RS line flag for LCD
HLFSEC               ; half-second counter
EVENT                ; flag for hrs/mins switch press
LOOPA                ; loop counter 2 - for LCD only
STORE
                ENDC

PROMVAL EQU h'70'          ; in both pages

                ORG 0              ; reset vector
                goto STARTIT
                ORG 4              ; Interrupt vector address
                goto STARTIT
                ORG 5              ; PIC program memory location at which to start 
                goto STARTIT

                include LCDheader.inc
                 
MESSAG          addwf PCL,F
                retlw 'T'
                retlw 'I'
                retlw 'M'
                retlw 'E'
                retlw ' '
                retlw 'N'
                retlw 'O'
                retlw 'W'
                 

CHKVAL          addwf PCL,F
                retlw B'01011001'       ;59 secs max
                retlw B'01011001'       ;59 mins max
                retlw B'00100011'       ;23 hours max

STARTIT         movlw 7
                movwf CMCON
                clrf PORTA
                clrf PORTB
                BANK1
                movlw B'00011111'
                movwf TRISA             ; Port A0-A4 as input
                movlw B'00000000'       ; RB0-RB6 output, RB7 as input
                movwf PORTB
                movlw B'10000101'       ; set timer ratio 1:64 (TMR0 rate)
                movwf OPTION_REG        ; (light pull-ups off - bit 7 high)
                BANK0


;here: goto here

                call PAUSIT
                call LCDSET
;                call PAUSIT
;                goto SETUP
                 
SETUP           call PAUSIT             ;1/5 sec delay
                 
LCDMSG          clrf LOOP               ;clear loop
                bsf RSLINE,4            ;set RS for data send
LCDMS2          movf LOOP,W             ;get table address
                call MESSAG             ;get message letter
                call LCDOUT             ;show it
                incf LOOP,F             ;inc loop
                btfss LOOP,3            ;has last LCD letter been sent?
                goto LCDMS2             ;no
                 
                clrf CLKSEC             ;clear seconds counter
                clrf CLKMIN             ;clear minutes counter
                clrf CLKHRS             ;clear hours counter

                movlw 25                ;initial basic CLKCNT val for secs timing
                movwf CLKCNT

MAIN            btfss INTCON,2          ;has a timer time-out been detected?
                goto MAIN               ;no
                bcf INTCON,2            ;yes
                call CLKADD             ;do time
                goto MAIN
                 
CLKADD          decfsz CLKCNT,F         ;increment system clock counter. Is it = 0?
                return                  ;no
                               
                movlw 25                ;reset start value of CLKCNT
                movwf CLKCNT
                call GETKEY             ;check switch status
                incf HLFSEC,F           ;inc half sec counter
                btfsc HLFSEC,0          ;is half second bit clear (= 0)?
                call CLKIT              ;no, it's = 1, so update secs etc
                return                  ;yes, so don't update secs etc
                 
CLKIT           movlw CLKSEC            ;get address of CLKSEC
                movwf FSR               ;move it into indirect reg
                movlw 3                 ;set loop to 3
                movwf LOOP
                clrf STORE1
                 
ADDCLK          incf INDF,F             ;inc units - all in BCD
                movlw 6
                addwf INDF,W            ;if 6 is added is there a digit carry?
                btfsc STATUS,DC
                movwf INDF              ;yes

ADDCL2          movf STORE1,W           ;now check if value > allowed value
                call CHKVAL
                movwf STORE2
                movf INDF,W
                subwf STORE2,F          ;is count =<  than allowed?
                btfsc STATUS,C
                goto CLKSHW             ;yes
                clrf INDF               ;no, it's greater, so clear it
                incf STORE1,F           ;and add 1 to time loop & byte
                incf FSR,F
                decfsz LOOP,F           ;dec loop, is it = 0?
                goto ADDCLK             ;no
                 
CLKSHW          call LCD21
                bsf RSLINE,4
                movf CLKHRS,W           ;get hrs
                call LCDFRM             ;format and send it
                movlw ':'               ;insert colon
                call LCDOUT
                movf CLKMIN,W           ;get mins
                call LCDFRM
                movlw '.'               ;decimal point
                call LCDOUT
                movf CLKSEC,W           ;get secs

LCDFRM          movwf STORE2            ;split & format decimal byte for LCD
                swapf STORE2,W          ;get tens nibble
                andlw 15
                iorlw 48                ;ASCII convert it
                call LCDOUT             ;send it
                movf STORE2,W           ;get units
                andlw 15
                iorlw 48                ;ASCII convert it
                call LCDOUT             ;send it
                return

GETKEY          btfss PORTA,1           ;is S1 (hrs+1) pressed?
                goto CHKSW2             ;no
                incf CLKHRS,F
                movlw 6                 ;check if units >9
                addwf CLKHRS,W          ;if 6 is added is there a digit carry?
                btfsc STATUS,DC
                movwf CLKHRS            ;yes
                movlw b'00100100'
                xorwf CLKHRS,W
                btfsc STATUS,Z
                clrf CLKHRS
                goto CLKSHW             ;show time setting
                return
                 
CHKSW2          btfss PORTA,2           ;is S2 (min+1) pressed?
                goto CHKSW3             ;no
                incf CLKMIN,F
                movlw 6                 ;check if units >9
                addwf CLKMIN,W          ;if 6 is added is there a digit carry?
                btfsc STATUS,DC
                movwf CLKMIN            ;yes
                movlw B'01100000'       ;59 mins max
                xorwf CLKMIN,W
                btfsc STATUS,Z
                clrf CLKMIN
                goto CLKSHW             ;show time setting
                return
                 
CHKSW3          btfss PORTA,3           ;is S3 (secs) pressed?
                return
                clrf CLKSEC
                bsf HLFSEC,0
                movlw 25                ;reset start value of CLKCNT
                movwf CLKCNT
                goto CLKSHW             ;show time setting
                 
PAUSIT          movlw 10                ;1/5th sec wait set
                movwf CLKCNT
                clrf INTCON             ;clear interupt flag
PAUSE                                   ;initial 1/5th sec wait before setting up LCD
                btfss INTCON,2          ;has a timer time-out been detected?
                goto PAUSE              ;no
                bcf INTCON,2            ;yes
                decfsz CLKCNT,F         ;dec loop, is it zero?
                goto PAUSE              ;no
                return                  ;yes

                include LCDroutines.inc

                end                     ;final line
