; TEACHINE04.ASM 11JUN07 - TEACH IN 2008 PT4
; XOR demo

#DEFINE BANK0 BCF STATUS,5     ; define STATUS register bit 5 clear as BANK0
#DEFINE BANK1 BSF STATUS,5     ; define STATUS register bit 5 set as BANK1

           list p=16f628       ; tell MPASM-type programmer to create a
                               ; list (LST) file

           include p16f628.inc ; bring in all standard register values

           CBLOCK h'20'
RSLINE
STORE
LOOP
LOOPA
CLKCNT
TEMP
TESTVAL
VALSTORE
           ENDC

           __config  h'3F21'   ; external xtal oscillator (3.2768MHz)

           ORG 0               ; reset vector
           goto STARTIT
           ORG 4               ; Interrupt vector address
           goto STARTIT
           ORG 5               ; PIC program memory location at which to start 
           goto STARTIT

           include LCDheader.inc

STARTIT    clrf PORTA          ; clear PORTA's output if any
           clrf PORTB          ; clear PORTB's output if any
           movlw 7             ; needed by some PICs, including PIC16F628
           movwf CMCON         ; so that PORTA is treated as digital port

           BANK1
           movlw b'00001111'   ; PORTA 0 to 3 as input
           movwf TRISA         ; data direction register for PORTA
           movlw b'00000000'   ; PORTB as output
           movwf TRISB         ; data direction register for PORTB
           movlw b'10000110'   ; timer 1:128, pull-ups off (bit 7 = 1)
           movwf OPTION_REG
           BANK0

           movlw b'00001001'   ; set test value
	   movwf TESTVAL

           call PAUSIT

           call LCDSET
	   call PAUSIT

	   call LCD1
	   bsf RSLINE,4         ; set LCD for display data

	   movf TESTVAL,W
	   movwf TEMP
           call SHOWBINARY

	   movlw ' '
	   call LCDOUT
	   movlw 'X'
	   call LCDOUT
	   movlw 'O'
	   call LCDOUT
	   movlw 'R'
	   call LCDOUT
	   movlw ' '
	   call LCDOUT
	   movlw 'V'
	   call LCDOUT
	   movlw 'A'
	   call LCDOUT
	   movlw 'L'
	   call LCDOUT
	   movlw ' '
	   call LCDOUT

MAIN       movf PORTA,W
           andlw b'00001111'
           btfsc STATUS,Z
	   goto MAIN

           movwf VALSTORE
	   movwf TEMP
	
	   call LCD21
	   bsf RSLINE,4         ; set LCD for display data	
	   call SHOWBINARY
	   movlw ' '
	   call LCDOUT
	   movlw '='
	   call LCDOUT
	   movlw ' '
	   call LCDOUT

           movf TESTVAL,W
           xorwf VALSTORE,W
           btfss STATUS,Z
           goto M2

           movlw '1'
	   call LCDOUT
	   movlw ' '
	   call LCDOUT
           movlw 'O'
	   call LCDOUT
           movlw 'K'
	   call LCDOUT
           goto M3

M2         movlw '0'
	   call LCDOUT
	   movlw ' '
	   call LCDOUT
           movlw 'N'
	   call LCDOUT
           movlw 'O'
	   call LCDOUT

M3         movf PORTA,W
           andlw b'00001111'
           btfsc STATUS,Z
           goto M3
	   goto MAIN

SHOWBINARY: movlw 8
	   movwf LOOP

SB2	   bcf STATUS,C
	   rlf TEMP,F
	   movf STATUS,W
	   andlw 1
	   xorlw 48             ; convert to ASCII value
	   call LCDOUT
           decfsz LOOP,F
	   goto SB2
	   return

PAUSIT     movlw 5             ; set delay counter to 5
           movwf CLKCNT        ; (for 1/25th sec x 5)
           clrf INTCON         ; clear interupt flag
PAUSE                          ; initial 1/5th sec wait before setting up LCD
           btfss INTCON,2      ; has a timer time-out been detected?
           goto PAUSE          ; no
           bcf INTCON,2        ; yes
           decfsz CLKCNT,F     ; dec counter, is it zero?
           goto PAUSE          ; no
           return              ; yes

           include LCDroutines.inc

           END
