; TEACHINZ520.ASM 06MAR08 - TEACH IN 2008 PTz

#DEFINE BANK0 BCF STATUS,5     ; define STATUS register bit 5 clear as BANK0
#DEFINE BANK1 BSF STATUS,5     ; define STATUS register bit 5 set as BANK1

           list p=16f628       ; tell MPASM-type programmer to create a
                               ; list (LST) file
           include p16f628.inc ; bring in all standard register values

           CBLOCK h'20'
DIGIT1
DIGIT2
DIGIT3
DIGIT4
DIGIT5
COUNT0
COUNT1
COUNT2
RSLINE
STORE
LOOP
LOOPA
STARTER
CLKCNT
USERCOUNT
PICCOUNT
LOOPTA
LOOPTB
LOOPTC
LOOPTD
RANDOM
FINISHED
DOUBLEFOUND
STORE2
STORE3
FSRSTORE
FSRSTORE2
WINNER
TILECOUNT
PROMADDR
LOOPCOUNT
PREV
SELECTLOOP
SWITCH
PREVSWITCH
FOUND
FINDDOUBLE
KNOCK
LCDLOOP
HOLDSTORE
PLAYERWIN
GRAPHIC
TILE0
	   ENDC

PROMVAL   EQU H'70'
LCDCOUNT  EQU H'7F'

LCDSTORE0 EQU H'60' ; Bank 0 LCD data memory
USER0     EQU H'A0' ; Bank 1 (at h'A0') - player's memory area
PIC0      EQU H'C0' ; Bank 1 (at h'C0') - PIC's memory area

           __config  h'3F30'     ; internal 4MHz oscillator

           ORG 0               ; reset vector
           goto STARTIT
           ORG 4               ; Interrupt vector address
           goto STARTIT
           ORG 5               ; PIC program memory location at which to start 
           goto STARTIT

           include LCDheader.inc

STARTIT    clrf PORTA          ; clear PORTA's outputs if any
           clrf PORTB          ; clear PORTB's output if any
           movlw 7             ; needed by some PICs, including PIC16F628
           movwf CMCON         ; so that PORTA is treated as digital port

           BANK1
           movlw b'00001111'   ; RA0-RA3 as input
           movwf TRISA         ; data direction register for PORTA
           movlw b'00000000'   ; PORTB as output
           movwf TRISB         ; data direction register for PORTB
           movlw b'10000110'   ; timer 1:128, pull-ups off (bit 7 = 1)
           movwf OPTION_REG
           BANK0
           movlw b'00000001' ; set timer 1 for prescale 1/1, and timer on
           movwf T1CON

           call PAUSIT
           call LCDSET
	   call PAUSIT

           movlw 64
           call PRMGET
           addlw 5
           andlw b'00011111'
           movwf RANDOM
           andlw 1
           movwf STARTER
           movf RANDOM,W
           andlw b'00011111'
           movwf RANDOM
           movwf PROMVAL
           movlw 64
           call SETPRM

           clrf GRAPHIC
           movlw 7
           movwf TILECOUNT
           movlw 30
           movwf LOOPCOUNT
           movlw 255
           movwf PREV
           call CLRLINE1
           call CLRLINE2
           call LCD21
           bsf RSLINE,4

           call CHARCT

           movlw 65
           call PRMGET
           movwf GRAPHIC

           btfss PORTA,3
           goto MAIN
           incf GRAPHIC,W
           andlw 1
           movwf GRAPHIC
           movwf PROMVAL
           movlw 65
           call SETPRM
GR         btfsc PORTA,3
           goto GR
           call PAUSIT

MAIN       call TILESETUP
MAIN2      movf RANDOM,W
           addlw 7
           andlw b'00011111'
           movwf RANDOM
           call GAMESTART

           clrf USERCOUNT
           clrf PICCOUNT
           clrf PREVSWITCH
           clrf FINDDOUBLE
           clrf KNOCK
           clrf PLAYERWIN
           clrf LCDCOUNT
           clrf FINISHED
           clrf DOUBLEFOUND
           clrf PROMADDR

           call CLRLINE1
           call CLRLINE2

           clrf SELECTLOOP
           movlw USER0
           iorlw 128
           movwf FSR

           movlw b'00010100'   ; cursor shift right
           call LCDLIN
           movlw b'00001100'   ; display on, cursor off, cursor blink off
           call LCDLIN

PLAYGAME   call CLRLINE2
           clrf LOOPTA
           call LCD21
           bsf RSLINE,4
         
           btfsc STARTER,0     ; is starter = 0?
           goto PD3            ; no = 1

PD0        call SHOWDOUBLE
           movlw USER0
           iorwf SELECTLOOP,W
           movwf FSR

           call GETUSERDOUBLE      ; User tiles
           bcf FINDDOUBLE,0
           goto PG

PD2        movlw 1
           movwf STARTER
           call GETDOUBLE      ; PIC tiles
           btfss DOUBLEFOUND,0 ; has double been found?
           goto herec          ; no, end game
           goto PG

PD3        call GETDOUBLE      ; PIC tiles
      
           call CLRLINE1
           call LCD1
           bsf RSLINE,4
           movf STARTER,W
           iorlw 48
           call LCDOUT
           movf DOUBLEFOUND,W
           iorlw 48
           call LCDOUT

           btfss DOUBLEFOUND,0 ; has double been found?
           goto PD4            ; no try user tiles
           goto PG             ; yes, play game

PD4        movlw 'N'
           call LCDOUT
     
           movlw 0             ; user tiles
           movwf STARTER
           call SHOWDOUBLE
           call GETUSERDOUBLE      ; User tiles
           btfss DOUBLEFOUND,0 ; has double been found?
           goto herec          ; no, end game
           goto PG             ; yes, play game

herec      comf STARTER,W
           andlw 1
           movwf STARTER     ; other player's turn
           call CLRLINE2
           goto MAIN2

PG         call SHOWLCD
           call GETMATCH

           movf KNOCK,W
           andlw b'11111100'
           btfss STATUS,Z
           goto PGZ

           movf USERCOUNT,W
           xorwf TILECOUNT,W
           btfsc STATUS,Z
           goto PGZ

           movf PICCOUNT,W
           xorwf TILECOUNT,W
           btfsc STATUS,Z
           goto PGZ
           decfsz LOOPCOUNT,F
           goto PG

PGZ        movlw b'00001100'   ; display on, cursor off, cursor blink off
          call LCDLIN

          call CLRLINE1
          call LCD1
          bsf RSLINE,4
          movlw 'S'
          call LCDOUT
          movlw 'c'
          call LCDOUT
          movlw 'o'
          call LCDOUT
          movlw 'r'
          call LCDOUT
          movlw 'e'
          call LCDOUT
          movlw ' '
          call LCDOUT
          movlw 'U'
          call LCDOUT
          movf USERCOUNT,W
          addlw 48
          call LCDOUT
          movlw ' '
          call LCDOUT
          movlw 'P'
          call LCDOUT
          movf PICCOUNT,W
          addlw 48
          call LCDOUT
          movf USERCOUNT,W
          xorwf PICCOUNT,W
          btfss STATUS,Z
          goto PGX
          movlw 'X'
          movwf WINNER
          movlw 2
          movwf PLAYERWIN
          goto WINNIT

PGX       movf USERCOUNT,W
          subwf PICCOUNT,W
          movlw 'P'
          movwf WINNER
          btfss STATUS,C
          movlw 'U'
          movwf WINNER
          andlw 1
          movwf PLAYERWIN

WINNIT    movlw ' '
          call LCDOUT
          movlw 'W'
          call LCDOUT
          movlw '='
          call LCDOUT
          movf WINNER,W
          call LCDOUT
          call SHOWLCD

HOLD6     nop
          btfss PORTA,0     ; is S1 pressed?
          goto HOLD6

          movf WINNER,W     ; yes, restart game
          xorlw 'X'         ; is it a draw?
          btfsc STATUS,Z
          goto STARTSET     ; yes, so swap starter
          clrf STARTER      ; no, so set starter to winner
          movf WINNER,W
          xorlw 'U'
          btfss STATUS,Z
          incf STARTER,F
          goto MAIN2
STARTSET  comf STARTER,W
          andlw 1        
          movwf STARTER
          goto MAIN2

GETUSERMATCH movlw USER0    ; allocate val to user
          return

GETPICMATCH movlw PIC0    ; allocate val to PIC
          return

GETMATCH  clrf FINDDOUBLE
          call SHOWKNOCK
          comf STARTER,W
          andlw 1
          movwf STARTER     ; other player's turn

          btfsc STARTER,0
          goto GMA2
          call GETUSERMATCH
          iorlw 128
          iorwf SELECTLOOP,W
          movwf FSR
          call GETSWITCHA
          return
    
GMA2      call GETPICMATCH
          iorlw 128
          movwf FSR
          movwf FSRSTORE
          clrf LOOPTA

GM2       movf INDF,W      ; check LHS tile for match
          andlw b'11110000'
          xorwf STORE2,W
          btfsc STATUS,Z   ; are both nibbles equal?
          goto EQUAL       ; yes

          incf FSR,F       ; no, repeat until LOOPTA = max
          incf LOOPTA,F
          movf LOOPTA,W
          xorwf TILECOUNT,W
          btfss STATUS,Z
          goto GM2
          clrf LOOPTA
          movf FSRSTORE,W
          movwf FSR      

GM3       swapf INDF,F
          movf INDF,W      ; check LHS tile for match
          andlw b'11110000'
          xorwf STORE2,W
          btfsc STATUS,Z   ; are both nibbles equal?
          goto EQUAL       ; yes
          incf FSR,F       ; no, repeat until LOOPTA = max
          incf LOOPTA,F
          movf LOOPTA,W
          xorwf TILECOUNT,W
          btfss STATUS,Z
          goto GM3
          incf KNOCK,F
          call SHOWKNOCK
          return

SHOWUSER  call CLRLINE1
          call LCD1
          bsf RSLINE,4
          movlw USER0
          iorlw 128
          movwf FSR
          clrf LOOPTA
SU        call SHOWBYTE
          incf FSR,F
          incf LOOPTA,F
          movf LOOPTA,W
          xorwf TILECOUNT,W
          btfss STATUS,Z
          goto SU

          movlw ' '
          call LCDOUT
          return

RANDOMISE  movlw 7
           addwf RANDOM,F
           bcf RANDOM,5
           return        

SHOWBYTE   movf INDF,W
           xorlw h'FF'
           btfss STATUS,Z
           goto SB
           movlw 'x'
           call LCDOUT
           movlw 'x'
           call LCDOUT
           return

SB         swapf INDF,W
           andlw 15
           btfss GRAPHIC,0
           iorlw 48
           call LCDOUT
           movf INDF,W
           andlw 15
           btfss GRAPHIC,0
           iorlw 48
           call LCDOUT
           return

PAUSIT     movlw 5             ; set delay counter to 5
           movwf CLKCNT        ; (for 1/25th sec x 5)
           clrf INTCON         ; clear interupt flag
PAUSE                          ; initial 1/5th sec wait before setting up LCD
           btfss INTCON,2      ; has a timer time-out been detected?
           goto PAUSE          ; no
           bcf INTCON,2        ; yes
           decfsz CLKCNT,F     ; dec counter, is it zero?
           goto PAUSE          ; no
           return              ; yes

PAUSIT2    movlw 15            ; set delay counter to 15
           movwf CLKCNT        ; 
           clrf INTCON         ; clear interupt flag
PAUSE2                         ; 
           btfss INTCON,2      ; has a timer time-out been detected?
           goto PAUSE2         ; no
           bcf INTCON,2        ; yes
           decfsz CLKCNT,F     ; dec counter, is it zero?
           goto PAUSE2         ; no
           return              ; yes

           include LCDroutines.inc

TILESETUP  clrf LOOPTA
           clrf LOOPTB
           clrf LOOPTC

           movlw TILE0   ; set all tiles to 255
           movwf FSR
M0         movlw 255
           movwf INDF
           incf FSR,F
           incf LOOPTA,F
           btfss LOOPTA,5
           goto M0

           clrf LOOPTA
           movlw PIC0   ; set all PIC tiles to 255
           iorlw 128
           movwf FSR
M0a        movlw 255
           movwf INDF
           incf FSR,F
           incf LOOPTA,F
           btfss LOOPTA,5
           goto M0a

           clrf LOOPTA
           movlw USER0   ; set all user tiles to 255
           iorlw 128
           movwf FSR

M0b        movlw 255
           movwf INDF
           incf FSR,F
           incf LOOPTA,F
           btfss LOOPTA,5
           goto M0b

           clrf LOOPTA
           movlw TILE0
           movwf FSR

M1         movf LOOPTC,W     ; allocate nos to 28 tiles
           movwf LOOPTA
M2         swapf LOOPTC,W
           iorwf LOOPTA,W
           movwf INDF
           incf FSR,F
           incf LOOPTB,F
           incf LOOPTA,F
           movf LOOPTA,W
           xorlw 7

           btfss STATUS,Z
           goto M2
           clrf LOOPTA
           incf LOOPTC,F
           movf LOOPTC,W
           xorlw 7
           btfss STATUS,Z
           goto M1
           return

GAMESTART clrf LOOPTA
          call LCD1
          bsf RSLINE,4
          call RANDOMISE

GS2       movlw TILE0    ; tile value in BANK0
          addwf RANDOM,W
          movwf FSR
          movf INDF,W
          movwf STORE
          incf STORE,W   ; check for value of 255
          btfss STATUS,Z
          goto GS3
          call RANDOMISE
          goto GS2

GS3       movlw 255      ; set INDF for 255
          movwf INDF
          movlw USER0    ; allocate val to user
          addwf LOOPTA,W
          iorlw 128
          movwf FSR
          movf STORE,W
          movwf INDF

          call RANDOMISE
          incf LOOPTA,F
          movf LOOPTA,W
          xorwf TILECOUNT,W
          btfss STATUS,Z
          goto GS2

          call LCD21
          bsf RSLINE,4
          clrf LOOPTA

GS2A      movlw TILE0
          addwf RANDOM,W
          movwf FSR
          movf INDF,W
          movwf STORE
          incf STORE,W   ; check for value of 255
          btfss STATUS,Z
          goto GS3A
          call RANDOMISE
          goto GS2A

GS3A      movlw 255      ; set INDF for 255
          movwf INDF
          movlw PIC0     ; allocate val to PIC
          addwf LOOPTA,W
          iorlw 128
          movwf FSR
          movf STORE,W
          movwf INDF
          call RANDOMISE
          incf LOOPTA,F
          movf LOOPTA,W
          xorwf TILECOUNT,W
          btfss STATUS,Z
          goto GS2A
          return

PLAYUSERDOUBLE  movlw 255
          movwf STORE2
          clrf LOOPTA
          movlw USER0    ; allocate val to user
          movwf FSR
          return

PLAYPICDOUBLE  movlw 255
          movwf STORE2
          clrf LOOPTA
          movlw PIC0   ; allocate val to user
          return

GETDOUBLE  btfsc STARTER,0
           goto GD10
           call PLAYUSERDOUBLE
           goto GD11
GD10       call PLAYPICDOUBLE

GD11      addwf LOOPTA,W
          iorlw 128
          movwf FSR

GD2       swapf INDF,W
          andlw 15
          xorwf INDF,W
          andlw 15
          btfsc STATUS,Z   ; are both nibbles equal?
          goto EQUAL       ; yes
          incf FSR,F       ; no, repeat until LOOPTA = max
          incf LOOPTA,F
          movf LOOPTA,W
          xorwf TILECOUNT,W
          btfss STATUS,Z
          goto GD2
          decf FSR,F
          return

EQUAL:    bsf DOUBLEFOUND,0
          movf INDF,W
          movwf STORE3
          clrf KNOCK
SB2       incf PICCOUNT,F

EQX       call STORELCD
          swapf INDF,W   ; get value & store it
          andlw b'11110000'
          movwf STORE2
          movlw 255     ; clear orig value
          movwf INDF
          return

SHOWLCD   call CLRLINE2
          call LCD21
          bsf RSLINE,4
          movlw LCDSTORE0
          movwf FSR

          clrf LOOPTD

SL2      movf LCDCOUNT,W
         movwf LCDLOOP

SL4      movf LCDLOOP,W
         andlw b'11111000'
         btfsc STATUS,Z
         goto SL3
         incf FSR,F
         incf LOOPTD,F
         decf LCDLOOP,F
         goto SL4

SL3       call SHOWBYTE
          incf FSR,F
          incf LOOPTD,F
          movf LOOPTD,W
          xorwf LCDCOUNT,W

          btfss STATUS,Z
          goto SL3

          call LCD1
          bsf RSLINE,4
          clrf SELECTLOOP
          return

; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F62x devices ********

                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in PROMVAL.
SETPRM  BANK1
        movwf EEADR     ;copy W into EEADR to set eeprom address
        movf PROMVAL,W  ;get data value and hold in W
        movwf EEDATA    ;copy W into eeprom data byte register
        bsf EECON1,WREN ;enable write MASK

MANUAL  movlw h'55'       ;these lines cause the action required by
        movwf EECON2    ;by the eeprom to store the data in EEDATA
        movlw h'AA'       ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ;set the ``perform write'' flag
	BANK0

CHKWRT  btfss PIR1,EEIF ;wait until bit 4 of PIR2 is set
        goto CHKWRT
        bcf PIR1,EEIF   ;clear bit 4 of PIR2
        return

;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F62x devices ****

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET  BANK1
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bsf EECON1,RD   ;enable read MASK
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
	BANK0
        return

PROMSTORE2 movf PROMADDR,W
        call SETPRM
        incf PROMADDR,F
        return

STOREUSER movlw 'U'
          movwf PROMVAL
          call PROMSTORE2

          movlw USER0
          iorlw 128
          movwf FSR
          clrf LOOPTA
SUP       movf INDF,W
          movwf PROMVAL
          call PROMSTORE2
          incf FSR,F
          incf LOOPTA,F
          movf LOOPTA,W
          xorwf TILECOUNT,W
          btfss STATUS,Z
          goto SUP

          movlw 'P'
          movwf PROMVAL
          call PROMSTORE2

          clrf LOOPTA
          movlw PIC0
          iorlw 128
          movwf FSR
          clrf LOOPTA
SUQ       movf INDF,W
          movwf PROMVAL
          call PROMSTORE2
          incf FSR,F
          incf LOOPTA,F
          movf LOOPTA,W
          xorwf TILECOUNT,W
          btfss STATUS,Z
          goto SUQ

          movlw 'L'
          movwf PROMVAL
          call PROMSTORE2

          clrf LOOPTA
          movlw LCDSTORE0
          movwf FSR
          clrf LOOPTA
SUS       movf INDF,W
          movwf PROMVAL
          call PROMSTORE2
          incf FSR,F
          incf LOOPTA,F
          movf LOOPTA,W
          xorlw 16
          btfss STATUS,Z
          goto SUS

STOREPACK movlw 'T'
          movwf PROMVAL
          call PROMSTORE2

          movlw TILE0
          movwf FSR
          clrf LOOPTA
SUR       movf INDF,W
          movwf PROMVAL
          call PROMSTORE2
          incf FSR,F
          incf LOOPTA,F
          btfss LOOPTA,5
          goto SUR
          return

SELECTCURSORVAL
           bcf STATUS,C
           rlf SELECTLOOP,W
           iorlw b'10000000'
           call LCDLIN
           bcf STATUS,C
           rlf SELECTLOOP,W
           iorlw b'10000001'
           call LCDLIN
           return

GETSWITCHA call SHOWUSER
           movlw b'00001101'   ; display on, cursor off, cursor blink on
           call LCDLIN
           movlw USER0
           iorwf SELECTLOOP,W
           movwf FSR

GETSWITCH  call SELECTCURSORVAL
           movf PORTA,W
           andlw b'00011111'
           movwf SWITCH
           btfss STATUS,Z
           goto GS1
           clrf PREVSWITCH
           goto GETSWITCH

GS1        movf SWITCH,W
           xorwf PREVSWITCH,W
           btfsc STATUS,Z
           goto GETSWITCH

           movf SWITCH,W
           movwf PREVSWITCH
           btfss SWITCH,0
           goto CHKS2

CHKS1      movf SELECTLOOP,W
           xorlw 0 
           btfsc STATUS,Z
           goto GETSWITCH
           decf SELECTLOOP,F
           call PAUSIT
           movlw USER0
           iorwf SELECTLOOP,W
           movwf FSR
           goto GETSWITCH

CHKS2      btfss SWITCH,1
           goto CHKS3
           movf SELECTLOOP,W
           xorlw 7 
           btfsc STATUS,Z
           goto GETSWITCH
           incf SELECTLOOP,F
           movlw USER0
           iorwf SELECTLOOP,W
           movwf FSR
           call PAUSIT
           goto GETSWITCH

CHKS3     btfss SWITCH,2
          goto CHKS4

          btfsc FINDDOUBLE,0
          goto CHKDOUBLE

          movf INDF,W      ; check LHS tile for match
          andlw b'11110000'
          xorwf STORE2,W
          btfsc STATUS,Z   ; are both nibbles equal?
          goto CHKS3C      ; yes
          swapf INDF,F     ; swap sides
          movf INDF,W      ; check LHS tile for match
          andlw b'11110000'
          xorwf STORE2,W
          btfsc STATUS,Z   ; are both nibbles equal?
          goto CHKS3C      ; yes
	  clrf SWITCH
          goto GETSWITCH

CHKS3C    movlw b'00001100'   ; display on, cursor off, cursor blink off
          call LCDLIN
          clrf SELECTLOOP
          movf INDF,W
          movwf STORE3

          movf SELECTLOOP,W
          iorlw b'10000000'
          call LCDLIN
          swapf INDF,W   ; get value & store it
          andlw b'11110000'
          movwf STORE2
          movlw 255
          movwf INDF
          clrf KNOCK
          incf USERCOUNT,F
          call STORELCD
          call SHOWLCD
          call SHOWUSER

CHKS3A    btfsc PORTA,2
          goto CHKS3a
          call PAUSIT2
          call PAUSIT2
          bsf FOUND,0
          return

CHKS4     btfss SWITCH,3
          goto GETSWITCH
          movf TMR1L,W
          andlw b'00011111'
          movwf RANDOM
          movwf PROMVAL
          movlw 64
          call SETPRM
          incf KNOCK,F
          call SHOWKNOCK
          return

CHKDOUBLE movlw USER0
          iorwf SELECTLOOP,W
          movwf FSR
          call LCD21
          bsf RSLINE,4
          movf INDF,W
          movwf STORE3
          call STORELCD

          swapf INDF,W
          andlw 15
          xorwf INDF,W
          andlw 15
          btfss STATUS,Z   ; are both nibbles equal?
          return           ; no
          movf INDF,W      ; yes
          andlw b'11110000'
          movwf STORE2
          movlw 255
          movwf INDF
          bsf DOUBLEFOUND,0
          return

STORELCD  movf FSR,W
          movwf FSRSTORE
          movlw LCDSTORE0
          addwf LCDCOUNT,W

          movwf FSR
          movf STORE3,W
          movwf INDF
          incf LCDCOUNT,F
          movf FSRSTORE,W
          movwf FSR
          return

LCD24    movlw b'11000100'
         goto LCDLIN
LCD26    movlw b'11000110'
         goto LCDLIN
LCD28    movlw b'11001000'
         goto LCDLIN
LCD31    movlw b'11001011'
         goto LCDLIN
LCD2F    movlw b'11001111'
         goto LCDLIN

GETUSERDOUBLE bsf FINDDOUBLE,0
         goto GETSWITCHA

HOLDITY movwf HOLDSTORE
        call CLRLINE2
        call LCD21
        bsf RSLINE,4
        movf HOLDSTORE,W
        call LCDOUT
HOLDITZ nop
        goto HOLDITZ

SHOWDOUBLE call LCD21
          bsf RSLINE,4
          movlw 'G'
          call LCDOUT
          movlw 'E'
          call LCDOUT
          movlw 'T'
          call LCDOUT
          movlw ' '
          call LCDOUT
          movlw 'D'
          call LCDOUT
          movlw 'O'
          call LCDOUT
          movlw 'U'
          call LCDOUT
          movlw 'B'
          call LCDOUT
          movlw 'L'
          call LCDOUT
          movlw 'E'
          call LCDOUT
          movlw ' '
          call LCDOUT
          return

SHOWKNOCK call LCD2F
         bsf RSLINE,4
         movf KNOCK,W
         addlw 48
         call LCDOUT
         call PAUSIT2
         return

HOLDITX   nop
        goto HOLDITX

;*****

CHARCT  movlw b'01000000' ;set address for CG RAM write
        call LCDLIN
        bsf RSLINE,4
        clrf LOOPTA

        movlw 4         ;Set up for sub-page 4
        movwf PCLATH

CHR     movf LOOPTA,W
        call CHRTABLE  ;call PRMGET
        call LCDOUT
        incf LOOPTA,F
        movf LOOPTA,W
        xorlw 56
        btfss STATUS,Z
        goto CHR
        clrf PCLATH
        return

        ORG H'400'

CHRTABLE addwf PCL,F
        retlw b'00000000'  ; 0
        retlw b'00000000'
        retlw b'00000000'
        retlw b'00000000'
        retlw b'00000000'
        retlw b'00000000'
        retlw b'00000000'
        retlw b'00000000'

        retlw b'00000000'  ; 1
        retlw b'00000000'
        retlw b'00000000'
        retlw b'00000100'
        retlw b'00000000'
        retlw b'00000000'
        retlw b'00000000'
        retlw b'00000000'

        retlw b'00000000'  ; 2
        retlw b'00010000'
        retlw b'00000000'
        retlw b'00000000'
        retlw b'00000000'
        retlw b'00000001'
        retlw b'00000000'
        retlw b'00000000'

        retlw b'00000000'  ; 3
        retlw b'00010000'
        retlw b'00000000'
        retlw b'00000100'
        retlw b'00000000'
        retlw b'00000001'
        retlw b'00000000'
        retlw b'00000000'

        retlw b'00000000'  ; 4
        retlw b'00010001'
        retlw b'00000000'
        retlw b'00000000'
        retlw b'00000000'
        retlw b'00010001'
        retlw b'00000000'
        retlw b'00000000'

        retlw b'00000000'  ; 5
        retlw b'00010001'
        retlw b'00000000'
        retlw b'00000100'
        retlw b'00000000'
        retlw b'00010001'
        retlw b'00000000'
        retlw b'00000000'

        retlw b'00000000'  ; 6
        retlw b'00010001'
        retlw b'00000000'
        retlw b'00010001'
        retlw b'00000000'
        retlw b'00010001'
        retlw b'00000000'
        retlw b'00000000'

         END

