; TeachInJ04.ASM 09FEB08
; A simple program which uses the TMR0 overflow
; interrupt to increment a count on PORTA

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

              include p16f628.inc

              __config  h'3F30'  ; internal 4MHz oscillator

              ORG 0              ; reset vector
              goto STARTIT
              ORG 4              ; Interrupt vector address
              goto ISR
              ORG 5              ; PIC program memory location at which to start 

STARTIT       clrf PORTA         ; clear PORTA's outputs if any
              clrf PORTB         ; clear PORTB's output if any
              movlw 7            ; needed by some PICs, including PIC16F628
              movwf CMCON        ; so that PORTA is treated as digital port

              BANK1              ; set for Bank 1
              clrf TRISA         ; PORTA as output
              clrf TRISB         ; RB0 as input
              movlw B'00000111'
              movwf OPTION_REG   ; pullups on (bit 7 = 0), TMR0 slowest rate
              BANK0
              MOVLW b'10100000'  ; enable GIE (bit 7), TMR0 overflow (bit 5)
              MOVWF INTCON

START         nop
              GOTO START

TEST          movlw b'11111111'
              movwf PORTB
              goto START

ISR           incf PORTA,F       ; inc LED count
              bcf INTCON,2        ; clear TMR0 overflow flag
              RETFIE

              END


