                                  ; Listing 6.15

     include "16F88_L.PLC"        ; Defines PLC instructions

                                  ; First section - Define state sequence

     state 0, 1, LOGIC, 1, ZERO   ; Automatic transition from state 0-1
                                  ; after power-up

     state 1, 2, TIML, 0, ONE     ; Red
     state 2, 3, TIML, 1, TWO     ; Red + Amber
     state 3, 4, TIML, 2, THREE   ; Green
     state 4, 1, TIML, 3, FOUR    ; Amber (then back to Red)

                                  ; Second Section - State transitions

     eqi   STATE, 1               ; 2 second timeout state 1-2
     timl  0, 2

     eqi   STATE, 2               ; 1 second timeout state 2-3
     timl  1, 1

     eqi   STATE, 3               ; 10 second timeout state 3-4
     timl  2, d'10'

     eqi   STATE, 4               ; 1 second timeout state 4-1
     timl  3, 1

                                  ; Third section - Actions performed

     subdef ZERO                  ; All lights off after power up
     puti  b'00000000', PORTB
     return

     subdef ONE                   ; Display Red
     puti  b'00000001', PORTB
     return

     subdef TWO                   ; Display Red + Amber
     puti  b'00000011', PORTB
     return

     subdef THREE                 ; Display Green
     puti  b'00000100', PORTB
     return

     subdef FOUR                  ; Display Amber
     puti  b'00000010', PORTB
     return

     endp                         ; End of PLC program