
#include "targetver.h"
#include <WindowsX.h>
#include "Win32Utilities.h"

HRGN CreateEllipticalRegion(int width, int height, int xpos, int ypos, bool bIncludeOutline) {
	HDC hdc = CreateCompatibleDC(NULL);
	HBITMAP hBitmap = CreateCompatibleBitmap(hdc, width, height);
	HPEN hPen = CreatePen(PS_SOLID, 1, bIncludeOutline ? RGB(255, 255, 255) : RGB(0, 0, 0));
	HBRUSH hBrush = CreateSolidBrush(RGB(255, 255, 255));
	SelectObject(hdc, hBitmap);
	SelectObject(hdc, hPen);
	SelectObject(hdc, hBrush);
	Ellipse(hdc, 0, 0, width, height);
	DeleteObject(hPen);
	DeleteObject(hBrush);
	unsigned char* buf = new unsigned char[width * height * 4];
	BITMAP bmi;
	GetObject(hBitmap, sizeof(bmi), &bmi);
	GetBitmapBits(hBitmap, width * height * 4, buf);
	DeleteObject(hBitmap);
	DeleteDC(hdc);

	HRGN ret = CreateRectRgn(0, 0, 0, 0);
	HRGN temp = CreateRectRgn(0, 0, 0, 0);
	RECT rc = { 0, 0, 0, 0 };
	bool in = false;
	for( int y = 0; y < height; ++y ) {
		for( int x = 0; x < width; ++x ) {
			bool val = (buf[bmi.bmWidthBytes * y + (x>>3)] & (1<<(7-(x&7)))) != 0;
			if( val != in ) {
				in = !in;
				if( in ) {
					rc.left = x;
					rc.top = y;
				} else {
					rc.right = x;
					rc.bottom = rc.top + 1;
					SetRectRgn(temp, rc.left, rc.top, rc.right, rc.bottom);
					UnionRgn(ret, ret, temp);
				}
			}
		}
		if( in ) {
			in = false;
			rc.right = width;
			rc.bottom = rc.top + 1;
			SetRectRgn(temp, rc.left, rc.top, rc.right, rc.bottom);
			UnionRgn(ret, ret, temp);
		}
	}
	DeleteObject(temp);
	delete [] buf;
	OffsetRgn(ret, xpos, ypos);
	return ret;
}

void CombineClipRgn(HDC hdc, HRGN hRgn) {
	HRGN rgnClip = CreateRectRgn(0, 0, 0, 0);
		RECT rcClip;
	if( !GetClipRgn(hdc, rgnClip) ) {
		GetClipBox(hdc, &rcClip);
		SetRectRgn(rgnClip, rcClip.left, rcClip.top, rcClip.right, rcClip.bottom);
	}
	CombineRgn(rgnClip, rgnClip, hRgn, RGN_DIFF);
	SelectClipRgn(hdc, rgnClip);
	DeleteObject(rgnClip);
}

HBITMAP CropBitmap( HBITMAP source, int x, int y, int width, int height ) {
    HDC hdcSrc = CreateCompatibleDC(NULL);
    HDC hdcDst = CreateCompatibleDC(NULL);
    HBITMAP hbmOld, hbmOld2, hbmNew;
    BITMAP bm;
    GetObject(source, sizeof(bm), &bm);
    hbmOld = (HBITMAP)SelectObject(hdcSrc, source);
    hbmNew = CreateBitmap( width, height, bm.bmPlanes, bm.bmBitsPixel, NULL);
    hbmOld2 = (HBITMAP)SelectObject(hdcDst, hbmNew);
    BitBlt(hdcDst, 0, 0, width, height, hdcSrc, x, y, SRCCOPY);
    SelectObject(hdcSrc, hbmOld);
    DeleteDC(hdcSrc);
    DeleteDC(hdcDst);
    return hbmNew;
}

HBITMAP CreateSingleColourBitmap( HDC hdc, int width, int height, COLORREF colour ) {
    HDC hdcDst = CreateCompatibleDC(hdc);
    HBITMAP hbmNew = CreateBitmap( width, height, 1, 32, NULL);
	HPEN hPen = CreatePen(PS_SOLID, 1, colour);
	HBRUSH hBrush = CreateSolidBrush(colour);
	SelectObject(hdcDst, hbmNew);
	SelectObject(hdcDst, hBrush);
	SelectObject(hdcDst, hPen);
	Rectangle(hdcDst, 0, 0, width, height);
	DeleteObject(hBrush);
	DeleteObject(hPen);
    DeleteDC(hdcDst);
    return hbmNew;
}

struct GetSubWindowInfo {
	DWORD id;
	HWND hwnd;
};

BOOL CALLBACK GetSubWindowProc(HWND hWnd, LPARAM lParam) {
	GetSubWindowInfo* pInfo = (GetSubWindowInfo*)lParam;
	if( GetWindowLong(hWnd, GWL_ID) == pInfo->id ) {
		pInfo->hwnd = hWnd;
		return FALSE;
	}
	return TRUE;
}

HWND GetSubWindow(HWND hWnd, DWORD id) {
	GetSubWindowInfo info;
	info.id = id;
	info.hwnd = (HWND)NULL;
	EnumChildWindows(hWnd, GetSubWindowProc, (LPARAM)&info);
	return info.hwnd;
}
