; tp4.asm
; Test for 18F242 (but should run on any 18FXX2)
; RC Osc
; connect led/resistor to ground on RA0 and RA1
; input 5v sq waves from signal generator on RB5

; illustrate low priority isr being pre-empted by high priority isr
; Malcolm Wiles, 23 Mar 05


        LIST    p=18f242,r=dec

	include P18F242.inc
 
B	equ	1
F 	equ	1


	__config H'300000', H'00'		; config
	__config H'300001', H'23'		; config
	__config H'300002', H'08'		; config
	__config H'300003', H'00'		; config
	__config H'300004', H'00'		; config
	__config H'300005', H'00'		; config
	__config H'300006', H'80'		; config
	__config H'300007', H'00'		; config
	__config H'300008', H'0F'		; config
	__config H'300009', H'C0'		; config
	__config H'30000A', H'0F'		; config
	__config H'30000B', H'E0'		; config
	__config H'30000C', H'0F'		; config
	__config H'30000D', H'40'		; config


 ;  Vars (bank 0)

TEMP1	equ	0x0
TEMP2	equ	0x1

BSAVE	equ	0x2		; lo priority ISR context save area
WSAVE	equ	0x3
SSAVE	equ	0x4

SOFTB	equ	0x5		; RB soft copy
COUNTL	equ	0x6		; count of lo priority ints
COUNTH	equ	0x7		; count of hi priority ints
COUNTHL	equ	0x8		; count of all ints

; Macros

enter_critical_section	MACRO
	bcf	INTCON,GIEH,A
	endm

leave_critical_section	MACRO
	bsf	INTCON,GIEH,A
	endm


; code

	org	0		; reset vector
	goto	init
	
	org	0008h		; hi interrupt vector
	bra	isrhi
	org	0018h
	bra	isrlo		; lo interrupt vector

; initialise PIC

	org	0020h	
init:	
	movlb	15		; set bank 15 (illustrate banked addressing)
	movlw	b'00100000'	; RB5 input	
	movwf	TRISB,B
	movlb	1		; set bank 1

; Timer 0 setup

	movlw	0xF8		; clear prescale bits
	andwf	T0CON,F,A		
	movlw	5		; prescale /32
	iorwf	T0CON,F,A
	bcf	T0CON,PSA,A	; assign prescaler
	bsf	T0CON,T08BIT,A	; 8 bit mode
	bcf	T0CON,T0CS,A	; timer mode
	clrf	TMR0H,A		; clear counter hi byte latch
	clrf	TMR0L,A		; clear counter	

; set up PORTA 

	movlw	6
	movwf	ADCON1,A	; all PORTA digital I/O
	clrf	TRISA,A		; all PORTA outputs
	movlw	0xFF
	movwf	LATA,A		; set PORTA latches

; data initialisation

	clrf	TEMP1,A		; clear counters
	clrf	TEMP2,A
	clrf	COUNTL,A
	clrf	COUNTH,A
	clrf	COUNTHL,A
	movf	PORTB,W,A
	movwf	SOFTB,A		; soft copy of PORTB

; set up interrupts

	bcf	INTCON,INT0IF,A		; ensure INT0 is clear
	bcf	INTCON,RBIF,A		; ensure RBIF clear

	bsf	INTCON2,TMR0IP,A	; set TMR0 hi priority
	bcf	INTCON2,RBIP,A		; set RB change low priority

	bsf	INTCON,T0IE,A		; enable TMR0 interrupt
	bsf	INTCON,RBIE,A		; enable RB change interrupt
	bsf	RCON,IPEN,A		; enable priority interrupts
	bsf	INTCON,GIEH,A		; enable hi priority interrupts
	bsf	INTCON,GIEL,A		; enable lo priority interrupts

; main loop
; tests whether interrupt counts add up
; stops leds flashing if so

main:
	nop
	nop
	enter_critical_section
	movf	COUNTL,W,A	; low priority interrupts count
	addwf	COUNTH,W,A	; add the high priority interrupts count
	xorwf	COUNTHL,W,A	; compare with total interrupts count
	leave_critical_section
	bz	main		; Z is set if they are equal
here:
	bcf	INTCON,GIEH,A	; counts not equal so disable interrupts
	bra	here		; and loopstop
	
; hi priority interrupt service routine 

isrhi:
	incf	COUNTHL,F,A	; bump total interrupts count
	incf	COUNTH,F,A	; bump high priority interrupts count

; timer interrupt

	btfss	INTCON, T0IF, A	; test if TMR0 int
	bra	hi_exit		; not a TMR0 int
	
	bcf	INTCON, T0IF, A	; clear the interrupt
	btg	LATA,0,A	; toggle bit to flash RA0 led on/off
hi_exit:
	retfie	FAST		; exit isr with automatic context reload

; lo priority interrupt service routine

isrlo:
	movwf	WSAVE,A		; save context
	movff	STATUS,SSAVE
	movff	BSR, BSAVE

; this method of bumping COUNTHL is not interrupt safe
	movf	COUNTHL,W,A	; total interrupts count to W
	addlw	1		; bump
	movwf	COUNTHL,A	; and save back in memory

; but bumping COUNTL like this is interrupt safe, because the incf instruction is atomic
	incf	COUNTL,F,A	; bump low priority interrupts count

	btfss	INTCON,RBIF,A	; is it RB5 change?	
	bra	lo_exit		; no
	
	movf	PORTB,W,A	; clear mismatch condition

; should really maintain a PORTB soft copy here, and compare the value just read
; with the previous soft copy value to detect diffs (see tp3.asm).
; But since in this simple setup RB5 is the only possible change, for simplicity don't bother

	bcf	INTCON,RBIF,A	; clear the interrupt
	btg	LATA,1,A	; flash led on RA1
		
lo_exit:
	movff	BSAVE,BSR
	movff	SSAVE,STATUS
	movf	WSAVE,W,A
	retfie
 
	END
