/* 
 * File:   LCD-Graphic-Font.h
 * Author: mike
 *
 * Created on 15 February 2014, 22:57
 */

#ifndef LCD_GRAPHIC_FONT_H
#define	LCD_GRAPHIC_FONT_H

#ifdef	__cplusplus
extern "C" {
#endif


// standard ascii 5x7 font
// defines ascii characters 0x20-0x7F (32-127)
static const unsigned char Font5x7[] = {
	0x00, 0x00, 0x00, 0x00, 0x00,// (space)
	0x00, 0x00, 0x5F, 0x00, 0x00,// !
	0x00, 0x07, 0x00, 0x07, 0x00,// "
	0x14, 0x7F, 0x14, 0x7F, 0x14,// #
	0x24, 0x2A, 0x7F, 0x2A, 0x12,// $
	0x23, 0x13, 0x08, 0x64, 0x62,// %
	0x36, 0x49, 0x55, 0x22, 0x50,// &
	0x00, 0x05, 0x03, 0x00, 0x00,// '
	0x00, 0x1C, 0x22, 0x41, 0x00,// (
	0x00, 0x41, 0x22, 0x1C, 0x00,// )
	0x08, 0x2A, 0x1C, 0x2A, 0x08,// *
	0x08, 0x08, 0x3E, 0x08, 0x08,// +
	0x00, 0x50, 0x30, 0x00, 0x00,// ,
	0x08, 0x08, 0x08, 0x08, 0x08,// -
	0x00, 0x60, 0x60, 0x00, 0x00,// .
	0x20, 0x10, 0x08, 0x04, 0x02,// /
	0x3E, 0x51, 0x49, 0x45, 0x3E,// 0
	0x00, 0x42, 0x7F, 0x40, 0x00,// 1
	0x42, 0x61, 0x51, 0x49, 0x46,// 2
	0x21, 0x41, 0x45, 0x4B, 0x31,// 3
	0x18, 0x14, 0x12, 0x7F, 0x10,// 4
	0x27, 0x45, 0x45, 0x45, 0x39,// 5
	0x3C, 0x4A, 0x49, 0x49, 0x30,// 6
	0x01, 0x71, 0x09, 0x05, 0x03,// 7
	0x36, 0x49, 0x49, 0x49, 0x36,// 8
	0x06, 0x49, 0x49, 0x29, 0x1E,// 9
	0x00, 0x36, 0x36, 0x00, 0x00,// :
	0x00, 0x56, 0x36, 0x00, 0x00,// ;
	0x00, 0x08, 0x14, 0x22, 0x41,// <
	0x14, 0x14, 0x14, 0x14, 0x14,// =
	0x41, 0x22, 0x14, 0x08, 0x00,// >
	0x02, 0x01, 0x51, 0x09, 0x06,// ?
	0x32, 0x49, 0x79, 0x41, 0x3E,// @
	0x7E, 0x11, 0x11, 0x11, 0x7E,// A
	0x7F, 0x49, 0x49, 0x49, 0x36,// B
	0x3E, 0x41, 0x41, 0x41, 0x22,// C
	0x7F, 0x41, 0x41, 0x22, 0x1C,// D
	0x7F, 0x49, 0x49, 0x49, 0x41,// E
	0x7F, 0x09, 0x09, 0x01, 0x01,// F
	0x3E, 0x41, 0x41, 0x51, 0x32,// G
	0x7F, 0x08, 0x08, 0x08, 0x7F,// H
	0x00, 0x41, 0x7F, 0x41, 0x00,// I
	0x20, 0x40, 0x41, 0x3F, 0x01,// J
	0x7F, 0x08, 0x14, 0x22, 0x41,// K
	0x7F, 0x40, 0x40, 0x40, 0x40,// L
	0x7F, 0x02, 0x04, 0x02, 0x7F,// M
	0x7F, 0x04, 0x08, 0x10, 0x7F,// N
	0x3E, 0x41, 0x41, 0x41, 0x3E,// O
	0x7F, 0x09, 0x09, 0x09, 0x06,// P
	0x3E, 0x41, 0x51, 0x21, 0x5E,// Q
	0x7F, 0x09, 0x19, 0x29, 0x46,// R
	0x46, 0x49, 0x49, 0x49, 0x31,// S
	0x01, 0x01, 0x7F, 0x01, 0x01,// T
	0x3F, 0x40, 0x40, 0x40, 0x3F,// U
	0x1F, 0x20, 0x40, 0x20, 0x1F,// V
	0x7F, 0x20, 0x18, 0x20, 0x7F,// W
	0x63, 0x14, 0x08, 0x14, 0x63,// X
	0x03, 0x04, 0x78, 0x04, 0x03,// Y
	0x61, 0x51, 0x49, 0x45, 0x43,// Z
	0x00, 0x00, 0x7F, 0x41, 0x41,// [
	0x02, 0x04, 0x08, 0x10, 0x20,// "\"
	0x41, 0x41, 0x7F, 0x00, 0x00,// ]
	0x04, 0x02, 0x01, 0x02, 0x04,// ^
	0x40, 0x40, 0x40, 0x40, 0x40,// _
	0x00, 0x01, 0x02, 0x04, 0x00,// `
	0x20, 0x54, 0x54, 0x54, 0x78,// a
	0x7F, 0x48, 0x44, 0x44, 0x38,// b
	0x38, 0x44, 0x44, 0x44, 0x20,// c
	0x38, 0x44, 0x44, 0x48, 0x7F,// d
	0x38, 0x54, 0x54, 0x54, 0x18,// e
	0x08, 0x7E, 0x09, 0x01, 0x02,// f
	0x08, 0x14, 0x54, 0x54, 0x3C,// g
	0x7F, 0x08, 0x04, 0x04, 0x78,// h
	0x00, 0x44, 0x7D, 0x40, 0x00,// i
	0x20, 0x40, 0x44, 0x3D, 0x00,// j
	0x00, 0x7F, 0x10, 0x28, 0x44,// k
	0x00, 0x41, 0x7F, 0x40, 0x00,// l
	0x7C, 0x04, 0x18, 0x04, 0x78,// m
	0x7C, 0x08, 0x04, 0x04, 0x78,// n
	0x38, 0x44, 0x44, 0x44, 0x38,// o
	0x7C, 0x14, 0x14, 0x14, 0x08,// p
	0x08, 0x14, 0x14, 0x18, 0x7C,// q
	0x7C, 0x08, 0x04, 0x04, 0x08,// r
	0x48, 0x54, 0x54, 0x54, 0x20,// s
	0x04, 0x3F, 0x44, 0x40, 0x20,// t
	0x3C, 0x40, 0x40, 0x20, 0x7C,// u
	0x1C, 0x20, 0x40, 0x20, 0x1C,// v
	0x3C, 0x40, 0x30, 0x40, 0x3C,// w
	0x44, 0x28, 0x10, 0x28, 0x44,// x
	0x0C, 0x50, 0x50, 0x50, 0x3C,// y
	0x44, 0x64, 0x54, 0x4C, 0x44,// z
	0x00, 0x08, 0x36, 0x41, 0x00,// {
	0x00, 0x00, 0x7F, 0x00, 0x00,// |
	0x00, 0x41, 0x36, 0x08, 0x00,// }
	0x08, 0x08, 0x2A, 0x1C, 0x08,// ->
	0x08, 0x1C, 0x2A, 0x08, 0x08 // <-
};
//
//static const unsigned char Font16x7[] = {
//    0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // Code for char ' '
//    0x03, 0x00, 0x00, 0xFE, 0x1B, 0x00, 0x00, // Code for char !
//    0x05, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, // Code for char "
//    0x0B, 0x00, 0x00, 0x10, 0x01, 0x10, 0x1D, 0xF0, 0x03, 0x1E, 0x01, 0x10, 0x01, 0x10, 0x1D, 0xF0, 0x03, 0x1E, 0x01, 0x10, 0x01, 0x00, 0x00, // Code for char #
//    0x09, 0x00, 0x04, 0x1C, 0x08, 0x22, 0x10, 0x42, 0x10, 0xFF, 0x7F, 0x42, 0x10, 0x84, 0x10, 0x00, 0x0F, 0x00, 0x00, // Code for char $
//    0x0C, 0x1C, 0x00, 0x22, 0x10, 0x22, 0x08, 0x22, 0x06, 0x1C, 0x01, 0xC0, 0x00, 0x20, 0x0E, 0x18, 0x11, 0x04, 0x11, 0x02, 0x11, 0x00, 0x0E, 0x00, 0x00,  // Code for char %
//    0x0B, 0x00, 0x00, 0x00, 0x0E, 0x1C, 0x11, 0xA2, 0x10, 0xC2, 0x10, 0x22, 0x11, 0x1C, 0x0A, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x12, 0x00, 0x00, // Code for char &
//    0x03, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, // Code for char '
//    0x06, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x1F, 0x1C, 0x60, 0x02, 0x80, 0x00, 0x00, // Code for char (
//    0x04, 0x00, 0x00, 0x06, 0xC0, 0xF8, 0x3F, 0x00, 0x00, // Code for char )
//    0x06, 0x24, 0x00, 0x18, 0x00, 0x7E, 0x00, 0x18, 0x00, 0x24, 0x00, 0x00, 0x00, // Code for char *
//    0x09, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0xF0, 0x07, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00, // Code for char +
//    0x04, 0x00, 0x00, 0x00, 0x60, 0x00, 0x18, 0x00, 0x00, // Code for char ,
//    0x05, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, // Code for char -
//    0x04, 0x00, 0x00, 0x00, 0x18, 0x00, 0x18, 0x00, 0x00, // Code for char .
//    0x08, 0x00, 0x00, 0x00, 0x40, 0x00, 0x38, 0x00, 0x07, 0xE0, 0x00, 0x1C, 0x00, 0x02, 0x00, 0x00, 0x00, // Code for char /
//    0x09, 0xF8, 0x07, 0x04, 0x08, 0x02, 0x10, 0x02, 0x10, 0x02, 0x10, 0x02, 0x10, 0x04, 0x08, 0xF8, 0x07, 0x00, 0x00, // Code for char 0
//    0x06, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00, 0xFE, 0x1F, 0x00, 0x00, // Code for char 1
//    0x09, 0x18, 0x10, 0x04, 0x18, 0x02, 0x14, 0x02, 0x12, 0x02, 0x11, 0x82, 0x10, 0x44, 0x10, 0x38, 0x10, 0x00, 0x00, // Code for char 2
//    0x09, 0x08, 0x0C, 0x04, 0x10, 0x02, 0x10, 0x42, 0x10, 0x42, 0x10, 0x44, 0x10, 0xB8, 0x08, 0x00, 0x07, 0x00, 0x00, // Code for char 3
//    0x09, 0x00, 0x02, 0x00, 0x03, 0x80, 0x02, 0x60, 0x02, 0x10, 0x02, 0x08, 0x02, 0xFE, 0x1F, 0x00, 0x02, 0x00, 0x00, // Code for char 4
//    0x09, 0x00, 0x04, 0x70, 0x08, 0x2E, 0x10, 0x22, 0x10, 0x22, 0x10, 0x22, 0x10, 0x42, 0x08, 0x82, 0x07, 0x00, 0x00, // Code for char 5
//    0x09, 0x00, 0x00, 0x00, 0x07, 0xC0, 0x08, 0x60, 0x10, 0x58, 0x10, 0x44, 0x10, 0x82, 0x08, 0x00, 0x07, 0x00, 0x00, // Code for char 6
//    0x09, 0x00, 0x00, 0x02, 0x10, 0x02, 0x0C, 0x02, 0x03, 0xC2, 0x00, 0x32, 0x00, 0x0E, 0x00, 0x02, 0x00, 0x00, 0x00, // Code for char 7
//    0x09, 0x00, 0x07, 0x98, 0x08, 0x64, 0x10, 0x42, 0x10, 0x42, 0x10, 0x64, 0x10, 0x98, 0x08, 0x00, 0x07, 0x00, 0x00, // Code for char 8
//    0x09, 0x00, 0x00, 0x38, 0x00, 0x44, 0x10, 0x82, 0x08, 0x82, 0x04, 0x82, 0x03, 0x84, 0x00, 0x78, 0x00, 0x00, 0x00, // Code for char 9
//    0x04, 0x00, 0x00, 0x30, 0x18, 0x30, 0x18, 0x00, 0x00, // Code for char :
//    0x04, 0x00, 0x00, 0x30, 0x60, 0x30, 0x18, 0x00, 0x00, // Code for char ;
//    0x0A, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x40, 0x01, 0x20, 0x02, 0x20, 0x02, 0x10, 0x04, 0x10, 0x04, 0x08, 0x08, 0x00, 0x00, // Code for char <
//    0x0A, 0x00, 0x00, 0x20, 0x01, 0x20, 0x01, 0x20, 0x01, 0x20, 0x01, 0x20, 0x01, 0x20, 0x01, 0x20, 0x01, 0x20, 0x01, 0x00, 0x00, // Code for char =
//    0x0A, 0x00, 0x00, 0x08, 0x08, 0x10, 0x04, 0x10, 0x04, 0x20, 0x02, 0x20, 0x02, 0x40, 0x01, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00, // Code for char >
//    0x08, 0x00, 0x00, 0x0C, 0x00, 0x82, 0x01, 0x42, 0x02, 0x22, 0x1A, 0x22, 0x1A, 0x9C, 0x01, 0x00, 0x00, // Code for char ?
//    0x0E, 0x00, 0x00, 0xF0, 0x03, 0x08, 0x04, 0x04, 0x08, 0xC2, 0x11, 0x22, 0x12, 0x12, 0x12, 0x12, 0x12, 0xE2, 0x11, 0x12, 0x12, 0x04, 0x12, 0x08, 0x09, 0xF0, 0x04, 0x00, 0x00, // Code for char @
//    0x0D, 0x00, 0x00, 0x00, 0x10, 0x00, 0x0E, 0x80, 0x01, 0x60, 0x01, 0x1C, 0x01, 0x02, 0x01, 0x1C, 0x01, 0x60, 0x01, 0x80, 0x01, 0x00, 0x0E, 0x00, 0x10, 0x00, 0x00, // Code for char A
//    0x09, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x1F, 0x42, 0x10, 0x42, 0x10, 0x64, 0x10, 0x98, 0x08, 0x00, 0x07, 0x00, 0x00, // Code for char B
//    0x0D, 0x00, 0x00, 0xF0, 0x03, 0x08, 0x04, 0x04, 0x08, 0x02, 0x10, 0x02, 0x10, 0x02, 0x10, 0x02, 0x10, 0x02, 0x10, 0x04, 0x08, 0x04, 0x08, 0x08, 0x04, 0x00, 0x00, // Code for char C
//    0x0C, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x1F, 0x02, 0x10, 0x02, 0x10, 0x02, 0x10, 0x02, 0x10, 0x02, 0x10, 0x04, 0x08, 0x08, 0x04, 0xF0, 0x03, 0x00, 0x00, // Code for char D
//    0x09, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x1F, 0x42, 0x10, 0x42, 0x10, 0x42, 0x10, 0x42, 0x10, 0x42, 0x10, 0x00, 0x00, // Code for char E
//    0x08, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x1F, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x00, 0x00, // Code for char F
//    0x0E, 0x00, 0x00, 0xF0, 0x03, 0x08, 0x04, 0x04, 0x08, 0x02, 0x10, 0x02, 0x10, 0x02, 0x10, 0x02, 0x10, 0x82, 0x10, 0x84, 0x10, 0x84, 0x08, 0x88, 0x04, 0x80, 0x03, 0x00, 0x00,  // Code for char G
//    0x0A, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x1F, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0xFE, 0x1F, 0x00, 0x00, // Code for char H
//    0x04, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x1F, 0x00, 0x00, // Code for char I
//    0x07, 0x00, 0x00, 0x00, 0x08, 0x00, 0x10, 0x00, 0x10, 0x00, 0x08, 0xFE, 0x07, 0x00, 0x00, // Code for char J
//    0x09, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x1F, 0x60, 0x00, 0x90, 0x01, 0x08, 0x02, 0x04, 0x0C, 0x02, 0x10, 0x00, 0x00, // Code for char K
//    0x08, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x1F, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, // Code for char L
//    0x0F, 0x00, 0x00, 0x00, 0x1C, 0xF8, 0x03, 0x06, 0x00, 0x38, 0x00, 0xC0, 0x01, 0x00, 0x0E, 0x00, 0x10, 0x00, 0x0E, 0xC0, 0x01, 0x38, 0x00, 0x06, 0x00, 0xF8, 0x03, 0x00, 0x1C, 0x00, 0x00, // Code for char M
//    0x0B, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x1F, 0x08, 0x00, 0x30, 0x00, 0x40, 0x00, 0x80, 0x00, 0x00, 0x03, 0x00, 0x04, 0xFE, 0x1F, 0x00, 0x00, // Code for char N
//    0x0E, 0x00, 0x00, 0xF0, 0x03, 0x08, 0x04, 0x04, 0x08, 0x02, 0x10, 0x02, 0x10, 0x02, 0x10, 0x02, 0x10, 0x02, 0x10, 0x02, 0x10, 0x04, 0x08, 0x08, 0x04, 0xF0, 0x03, 0x00, 0x00, // Code for char O
//    0x09, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x1F, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x24, 0x00, 0x18, 0x00, 0x00, 0x00, // Code for char P
//    0x0E, 0x00, 0x00, 0xF0, 0x03, 0x08, 0x04, 0x04, 0x08, 0x02, 0x10, 0x02, 0x10, 0x02, 0x10, 0x02, 0x11, 0x02, 0x12, 0x02, 0x0C, 0x04, 0x08, 0x08, 0x16, 0xF0, 0x21, 0x00, 0x00, // Code for char Q
//    0x0A, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x1F, 0x42, 0x00, 0xC2, 0x00, 0x42, 0x01, 0x42, 0x06, 0x24, 0x08, 0x18, 0x10, 0x00, 0x00, // Code for char R
//    0x08, 0x00, 0x04, 0x18, 0x08, 0x24, 0x10, 0x42, 0x10, 0x42, 0x10, 0x84, 0x08, 0x08, 0x07, 0x00, 0x00, // Code for char S
//    0x08, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0xFE, 0x1F, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, // Code for char T
//    0x0A, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x07, 0x00, 0x08, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x08, 0xFE, 0x07, 0x00, 0x00, // Code for char U
//    0x0C, 0x02, 0x00, 0x1C, 0x00, 0x60, 0x00, 0x80, 0x01, 0x00, 0x0E, 0x00, 0x10, 0x00, 0x0E, 0x80, 0x01, 0x60, 0x00, 0x1C, 0x00, 0x02, 0x00, 0x00, 0x00, // Code for char V
//    0x0F, 0x00, 0x00, 0x06, 0x00, 0x78, 0x00, 0x80, 0x07, 0x00, 0x18, 0x80, 0x07, 0x78, 0x00, 0x06, 0x00, 0x78, 0x00, 0x80, 0x07, 0x00, 0x18, 0x80, 0x07, 0x78, 0x00, 0x06, 0x00, 0x00, 0x00, // Code for char W
//    0x09, 0x00, 0x00, 0x06, 0x18, 0x08, 0x04, 0x30, 0x03, 0xC0, 0x00, 0x30, 0x03, 0x08, 0x04, 0x06, 0x18, 0x00, 0x00, // Code for char X
//    0x0B, 0x00, 0x00, 0x02, 0x00, 0x04, 0x00, 0x18, 0x00, 0x60, 0x00, 0x80, 0x1F, 0x60, 0x00, 0x18, 0x00, 0x04, 0x00, 0x02, 0x00, 0x00, 0x00, // Code for char Y
//    0x08, 0x02, 0x10, 0x02, 0x1C, 0x02, 0x13, 0xC2, 0x10, 0x32, 0x10, 0x0E, 0x10, 0x02, 0x10, 0x00, 0x00, // Code for char Z
//    0x06, 0x00, 0x00, 0x00, 0x00, 0xFE, 0xFF, 0x02, 0x80, 0x02, 0x80, 0x00, 0x00, // Code for char [
//    0x0A, 0x02, 0x00, 0x0C, 0x00, 0x10, 0x00, 0x60, 0x00, 0x80, 0x01, 0x00, 0x06, 0x00, 0x08, 0x00, 0x30, 0x00, 0x40, 0x00, 0x00, // Code for char BackSlash
//    0x05, 0x00, 0x00, 0x02, 0x80, 0x02, 0x80, 0xFE, 0xFF, 0x00, 0x00, // Code for char ]
//    0x0B, 0x00, 0x00, 0x00, 0x02, 0x80, 0x01, 0x70, 0x00, 0x0C, 0x00, 0x02, 0x00, 0x0C, 0x00, 0x70, 0x00, 0x80, 0x01, 0x00, 0x02, 0x00, 0x00, // Code for char ^
//    0x09, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x00, // Code for char _
//    0x05, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, // Code for char `
//    0x0B, 0x00, 0x00, 0xC0, 0x07, 0x20, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x08, 0xF0, 0x1F, 0x00, 0x00, // Code for char a
//    0x0B, 0x00, 0x00, 0xFE, 0x1F, 0x20, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x08, 0xC0, 0x07, 0x00, 0x00, // Code for char b
//    0x0A, 0x00, 0x00, 0xC0, 0x07, 0x20, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x08, 0x40, 0x04, 0x00, 0x00, // Code for char c
//    0x0B, 0x00, 0x00, 0xC0, 0x07, 0x20, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x08, 0xFE, 0x1F, 0x00, 0x00, // Code for char d
//    0x0A, 0x00, 0x00, 0xC0, 0x07, 0x20, 0x09, 0x10, 0x11, 0x10, 0x11, 0x10, 0x11, 0x10, 0x11, 0x20, 0x09, 0xC0, 0x05, 0x00, 0x00, // Code for char e
//    0x06, 0x00, 0x00, 0x10, 0x00, 0xFC, 0x1F, 0x12, 0x00, 0x12, 0x00, 0x00, 0x00, // Code for char f
//    0x0B, 0x00, 0x00, 0xC0, 0x27, 0x20, 0x48, 0x10, 0x90, 0x10, 0x90, 0x10, 0x90, 0x10, 0x90, 0x10, 0x90, 0x20, 0x48, 0xF0, 0x3F, 0x00, 0x00, // Code for char g
//    0x0A, 0x00, 0x00, 0xFE, 0x1F, 0x20, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x20, 0x00, 0xC0, 0x1F, 0x00, 0x00, // Code for char h
//    0x03, 0x00, 0x00, 0xF6, 0x1F, 0x00, 0x00, // Code for char i
//    0x03, 0x00, 0x80, 0xF6, 0x7F, 0x00, 0x00, // Code for char j
//    0x08, 0x00, 0x00, 0xFE, 0x1F, 0x00, 0x01, 0x80, 0x02, 0x40, 0x04, 0x20, 0x08, 0x10, 0x10, 0x00, 0x00, // Code for char k
//    0x03, 0x00, 0x00, 0xFE, 0x1F, 0x00, 0x00, // Code for char l
//    0x0F, 0x00, 0x00, 0xF0, 0x1F, 0x20, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x20, 0x00, 0xC0, 0x1F, 0x20, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x20, 0x00, 0xC0, 0x1F, 0x00, 0x00, // Code for char m
//    0x0A, 0x00, 0x00, 0xF0, 0x1F, 0x20, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x20, 0x00, 0xC0, 0x1F, 0x00, 0x00, // Code for char n
//    0x0A, 0x00, 0x00, 0xC0, 0x07, 0x20, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x08, 0xC0, 0x07, 0x00, 0x00, // Code for char o
//    0x0B, 0x00, 0x00, 0xF0, 0xFF, 0x20, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x08, 0xC0, 0x07, 0x00, 0x00, // Code for char p
//    0x0B, 0x00, 0x00, 0xC0, 0x07, 0x20, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x08, 0xF0, 0xFF, 0x00, 0x00, // Code for char q
//    0x06, 0x00, 0x00, 0xF0, 0x1F, 0x20, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00, // Code for char r
//    0x06, 0x60, 0x08, 0x90, 0x10, 0x10, 0x11, 0x10, 0x11, 0x20, 0x0E, 0x00, 0x00, // Code for char s
//    0x07, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0xFE, 0x1F, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00, // Code for char t
//    0x0A, 0x00, 0x00, 0xF0, 0x07, 0x00, 0x08, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x08, 0xF0, 0x07, 0x00, 0x00, // Code for char u
//    0x0A, 0x10, 0x00, 0x60, 0x00, 0x80, 0x03, 0x00, 0x0C, 0x00, 0x10, 0x00, 0x0C, 0x80, 0x03, 0x60, 0x00, 0x10, 0x00, 0x00, 0x00, // Code for char v
//    0x0E, 0x10, 0x00, 0xE0, 0x00, 0x00, 0x07, 0x00, 0x18, 0x00, 0x07, 0xE0, 0x00, 0x10, 0x00, 0xE0, 0x00, 0x00, 0x07, 0x00, 0x18, 0x00, 0x07, 0xE0, 0x00, 0x10, 0x00, 0x00, 0x00, // Code for char w
//    0x09, 0x10, 0x10, 0x20, 0x08, 0x40, 0x04, 0x80, 0x03, 0x80, 0x03, 0x40, 0x04, 0x20, 0x08, 0x10, 0x10, 0x00, 0x00, // Code for char x
//    0x09, 0x10, 0x00, 0xE0, 0x00, 0x00, 0x83, 0x00, 0x7C, 0x00, 0x0C, 0x00, 0x03, 0xE0, 0x00, 0x10, 0x00, 0x00, 0x00, // Code for char y
//    0x08, 0x10, 0x10, 0x10, 0x18, 0x10, 0x16, 0x10, 0x11, 0xD0, 0x10, 0x30, 0x10, 0x10, 0x10, 0x00, 0x00, // Code for char z
//    0x07, 0x00, 0x00, 0x00, 0x01, 0x80, 0x02, 0xFC, 0x7E, 0x02, 0x80, 0x02, 0x80, 0x00, 0x00, // Code for char {
//    0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0xFF, 0x00, 0x00, // Code for char |
//    0x06, 0x02, 0x80, 0x02, 0x80, 0xFC, 0x7E, 0x80, 0x02, 0x00, 0x01, 0x00, 0x00, // Code for char }
//    0x0A, 0x00, 0x00, 0x80, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x40, 0x00, 0x00, 0x00, // Code for char ~
//    0x05, 0xFF, 0x0F, 0x01, 0x08, 0x01, 0x08, 0xFF, 0x0F, 0x00, 0x00, // Code for char 
//};

#ifdef	__cplusplus
}
#endif

#endif	/* LCD_GRAPHIC_FONT_H */

