/* 
 * File:   main.c
 * Author: mhibbett. mike.hibbett@gmail.com, mjhdesigns.com
 *
 * Created on 25 February 2014, 13:47
 */

#include <stdio.h>
#include <stdlib.h>
#include <pic18.h>
#include "config.h"
#include "lplc-adc.h"
#include "timers.h"
// Choose the appropriate header file
//#include "LCD-Graphic-ST7735S.h"
#include "LCD-Graphic-ILI9341.h"
#include "interrupts.h"
#include "hardware.h"
#include "lcd.h"
#include "pwm.h"

/*
 * 
 */

int main(int argc, char** argv)
{
    unsigned short lpy;
    unsigned char first_sample = 1;
    unsigned char *new_samples;
    unsigned char *old_samples;

    // Initialise any low level hardware features
    HardwareInit();

    // Initialise the Interrupt sub-system
    InterruptInit();

    // Initialise the Interrupt sub-system
    timer0Init();
    timer1Init();

    // Power up delay
    delayms(50);

    // Choose the appropriate graphics display init
    //LCDST7735sInit();
    LCDILI9341Init();
    LCD_Clear(BLACK);

    // New Function to Draw the oscilloscope 'screen'
    POINT_COLOR = GRAY;
    LCD_DrawRectangle(10,10,239,319);   // Replaces 4 lines below

    // New Function to Draw Data on screen
    LCD_DrawScreenWords(0);
    
    // New Function to Draw Numbers on left hand side
    LCD_DrawVNums();
    
    // And the graticule
    POINT_COLOR = GRAY;
    LINE_MASK = 0xCC;

    for (lpy = 10 + 39; lpy < 320; lpy += 39) {
         LCD_DrawLine(11,lpy,238,lpy);
     }
   
    LCD_DrawLine(64,11,64,318);
    LCD_DrawLine(117,11,117,318);//122
    LCD_DrawLine(170,11,170,318);//180

    POINT_COLOR = GREEN;
    LINE_MASK = 0xFF;

    /* Configure the ADC. Run from Fosc/64, 2*TAD. This gives sample+conversion time of 17.3us */
    adc_init(ADC_FOSC_64 & ADC_RIGHT_JUST & ADC_2_TAD, ADC_CH0 & ADC_INT_OFF & ADC_REF_VDD_VSS,
             0, ADC_0ANA);
    
    /* Configure a timer and capture compare module to give sample 'special event trigger' */
    /* FOSC/4, Prescale by 8, enable 16bit read/write, start timer */
    T3CON = 0x33;

    /* configure ECCP2 to use timer3 as a special event trigger to fire an ADC conversion */
    CCPTMRS0 &= ~0x38; /* Mask C2TSEL bits */
    CCPTMRS0 |= 0x08; /* Select TMR3 for ECCP2 */
    CCP2CON = 0x0B; /* Special Event Trigger mode, start */

    /* Adc sampling is now running. Interrupts are not yet being generated. */
    /* So set a period to sample at, and enable interrupts */
    CCPR2H = 0;
    CCPR2L = 100; /* 26 gives maximum sample rate */

    int_enable_adc();

    // user application - main loop
    // Code here is called either
    //    a) continuously
    //    b) once per interrupt, if the sleep instruction is present

    while (1) {
        // The sleep instruction will cause the processor to halt, and enter
        // a low power state. Timer1 interrupts will still wake the processor.
        // SLEEP();

        /* Wait for ADC samples to complete */
        while (!samples_ready)
            ; /* do nothing */

        if (current_buff) {
            old_samples = samples[1];
            new_samples = samples[0];
        } else {
            old_samples = samples[0];
            new_samples = samples[1];
        }
        
        // Let's print HOLD onto the screen up the top right when we're holding our samples
        if(HOLD_SAMPLING) {
            POINT_COLOR = RED;
            LCD_ShowString(220,285," HOLD ");
        } else {
            POINT_COLOR = BLACK;
            LCD_ShowString(220,285," HOLD ");
        }
        
        CheckforButtonPress(); 
        
        /* erase the old waveform, if we have drawn one */
        /* New Checks to see if Sampling should be held, Check for Automatic or Normal Sampling and if Rising Edge or Falling Edge has been captured */
        if ((!first_sample) && (!HOLD_SAMPLING) && (((AUTO_SAMPLE) && ((FALLING_EDGE && !EDGE_SAMPLE) || (RISING_EDGE && EDGE_SAMPLE))) || !AUTO_SAMPLE )) {
            POINT_COLOR = BLACK;            
            LINE_MASK = 0xFF;
            for (lpy = 1; lpy < 308; lpy++) {
                if(!INFINITE_PERSISTENCE) {         // If Infinite Persistence is enabled, then the last line will not be overwritten
                    POINT_COLOR = BLACK;  
                    LCD_DrawLine(old_samples[lpy-1], 10+lpy, old_samples[lpy], 11+lpy );
                }
                POINT_COLOR = GREEN;
                LCD_DrawLine(new_samples[lpy-1], 10+lpy, new_samples[lpy], 11+lpy );
            }
            
            // And the graticule
            POINT_COLOR = GRAY;
            LINE_MASK = 0xCC;       // This is the medium graticule
            //LINE_MASK = 0x55;     // This is a fine graticule
            //LINE_MASK = 0xF0;     // This is the large graticule

            for (lpy = 10 + 39; lpy < 320; lpy += 39) {
                LCD_DrawLine(11,lpy,238,lpy);
            }
            LCD_DrawLine(64,11,64,318);
            LCD_DrawLine(117,11,117,318);//122
            LCD_DrawLine(170,11,170,318);//180

            LCD_DrawVNums();
            LCD_DrawTriggerLine();
            LCD_DrawMeasLine();
            
        } else
            first_sample = 0;

        samples_ready = 0;
        RISING_EDGE = 0;
        FALLING_EDGE = 0;
    }

    // Should never reach this point
    return (EXIT_SUCCESS);
}

