/*
 * File:   timers.c
 * Author: mike
 *
 * Created on 16 February 2014, 12:53
 */

#include <pic18f27j13.h>
#include "timers.h"


#define TMR0_DISABLE    0
#define TMR0_ENABLE     0x83
#define TMR1_CONF       0x8E


void timer0Init( void )
{
    T0CON = TMR0_DISABLE;
}


void timer1Init( void )
{
    // TODO
}


void delayms(unsigned short ms)
{
    while (ms--)
        usleep(USLEEP_1MS);
}


void usleep(unsigned short ticks)
{
    TMR0H = ticks >> 8;
    TMR0L = ticks & 0xFF;

    INTCON &= ~0x04;
    T0CON = TMR0_ENABLE;

    while ( !(INTCON & 0x04) ) {
        // do nothing
    }

    T0CON = TMR0_DISABLE;
}
