/*
  A simple example demonstrating how the Uno32 Video Driver works
*/

  
#include <vidgen_drv.h>


void setup() {                  
  // Start the video driver
  vidgen_setup();

  vidgen_putc('X',0,12); // leftmost, middle down
  vidgen_putc('X',0,0); // leftmost, topmost
  vidgen_putc('X',0,36); // leftmost, bottom
  vidgen_putc('X',65,36); // rightmost, bottom
  vidgen_putc('X',65,0); // leftmost, topmost
  
  vidgen_puts("Hello Worlds!", 10,10);  

  vidgen_cls();
  
  vidgen_puts("// Clear the display buffer and scan line buffers",0,0);
  vidgen_puts("memset((void *)textBuffer, ' ', sizeof(textBuffer));",0,1);
  vidgen_puts("memset((void *)vid_line0, 0x0, sizeof(vid_line0)); ",0,2);
  vidgen_puts("memset((void *)vid_line1, 0x0, sizeof(vid_line1)); ",0,3);
  vidgen_puts("",0,4);
  vidgen_puts("// Configure the SPI peripheral for 32 bit word and a 20MHz clock rate",0,5);
  vidgen_puts("// This is our pixel data generator",0,6);
  vidgen_puts("U1MODECLR =0x8000;",0,7);
  vidgen_puts("SPI1CON = 0;        // Stops and resets the SPI1.",0,8);
  vidgen_puts("TRISBSET = 0x4;     // Set RB2 as a digital input",0,9);
  vidgen_puts("TRISDCLR = 0x04;    // Vertical Sync pin",0,10);
  vidgen_puts("TRISFCLR = 0x08;     // Set pin RF3 as a digital output For SPI output (pixel data)",0,11);
  vidgen_puts("AD1PCFGSET = 0x4;   // Analog input pin in digital mode",0,12);
  vidgen_puts("rData=SPI1BUF;      // clears the receive buffer",0,13);
  vidgen_puts("IFS0CLR=0x03800000; // clear any existing event",0,14);
  vidgen_puts("IPC5CLR=0x1f000000; // clear the priority",0,15);
  vidgen_puts("IPC5SET=0x1f000000; // Set IPL=3, subpriority 1",0,16);
  vidgen_puts("IEC0SET=0x01000000;  // enable tx ints",0,17);
  vidgen_puts("SPI1BRG=0x1; // divide pb clock down by 4 ( default is 2 )",0,18);
  vidgen_puts("SPI1STATCLR=0x40;   // clear the Overflow",0,19);
  vidgen_puts("SPI1CON= 0xc0000C20; // 11100000 00000010 10000000 00100000",0,20);
  vidgen_puts("SPI1CONSET= 0x8000; // turn on module",0,21);
  vidgen_puts("",0,22);
  vidgen_puts("// Configure Output Compare peripheral OC1 ",0,23);
  vidgen_puts("// Connects to pin 3 on chipKit Uno32 header J5",0,24);
  vidgen_puts("OC1CON = 0x0d;   // Setup is 16 bit, using Timer3, +ve edge",0,25);
  vidgen_puts("OC1R =   0;      // Positive edge at count 0",0,26);
  vidgen_puts("OC1RS =  256;    // Falling edge 256 counts later",0,27);
  vidgen_puts("",0,28);
  vidgen_puts("// Timer 3 setup, to support OC1",0,29);
  vidgen_puts("PR3 = 2111;      // Timer will restart after 2111 counts",0,30);
  vidgen_puts("T3CON = 0;       // Disable timer while configuring it",0,31);
  vidgen_puts("TMR3 = 0;",0,32);
  vidgen_puts("",0,33);
  vidgen_puts("// Enable an interrupt to occur on each line. We will",0,34);
  vidgen_puts("// use this later to help generate the vertical sync",0,35);
  vidgen_puts("IFS0CLR = 0x1000; // Clear timer interrupt status flag",0,36);  
}


void loop() {
  
  // wait for the video driver to complete writing to the active area
  // of the screen. This will give us the longest time to write to the
  // display memory without (briefly) corrupting the displayed imaged
  if ( frameDone ) {
     frameDone = 0; 
     
     // Now, change any displayed content
          
  }
}

