/*
 * File:   interrupts.c
 * Author: Author: mhibbett. mike.hibbett@gmail.com, mjhdesigns.com
 *
 * Created on 31 March 2014, 20:53
 *
 * Interrupt routines.
 */

#include <pic18.h>
#include "interrupts.h"

#define TOGGLE_LED_TIME 5   // time between toggling the LED - 10s


unsigned char delay_2s;


/*************************************************************************
 * Function: InterruptInit
 * Initialises the interrupt sub-system.
 *************************************************************************
 */
void InterruptInit( void )
{
    delay_2s = TOGGLE_LED_TIME;
}


/*************************************************************************
 * Function: InterruptHandler
 * Provides a basic interrupt handler function.
 *************************************************************************
 */
void interrupt InterruptHandler( void )
{
    // Clear the interrupt flag. Only one interrupt is enabled,
    // so this must be it
    PIR1bits.TMR1IF = 0;

    delay_2s--;

    if ( !delay_2s ) {
        // Toggle the LED
        LATBbits.LATB5 = ~LATBbits.LATB5;

        delay_2s = TOGGLE_LED_TIME;
    }
}