/* 
 * File:   main.c
 * Author: mhibbett. mike.hibbett@gmail.com, mjhdesigns.com
 *          Mike P. O'Keeffe
 *
 * Created on 25 February 2014, 13:47
 */

#include <stdio.h>
#include <stdlib.h>
#include <pic18.h>
#include "config.h"
#include "lplc-adc.h"
#include "timers.h"
// Choose the appropriate header file
//#include "LCD-Graphic-ST7735S.h"
//#include "LCD-Graphic-ILI9341.h"
#include "interrupts.h"
#include "hardware.h"
#include "lcd.h"
#include "pwm.h"

/*
 * 
 */

int main(int argc, char** argv)
{
    
    unsigned int current_adc = 0;
    unsigned int balanced_value = 516;
    unsigned int level_one = 1;
    unsigned int level_two = (level_one * 2);
    unsigned int pos_level_one = 0;
    unsigned int pos_level_two = 0;
    unsigned int neg_level_one = 0;
    unsigned int neg_level_two = 0;

    // Initialise any low level hardware features
    HardwareInit();

    // Initialise the Interrupt sub-system
    InterruptInit();

    // Initialise the Interrupt sub-system
    timer0Init();
    timer1Init();

    // Power up delay
    delayms(500);

    /* Configure the ADC. Run from Fosc/64, 2*TAD. This gives sample+conversion time of 17.3us */
    adc_init(ADC_FOSC_64 & ADC_RIGHT_JUST & ADC_2_TAD, ADC_CH0 & ADC_INT_OFF & ADC_REF_VDD_VSS,
             0, ADC_0ANA);
    
    /* Configure a timer and capture compare module to give sample 'special event trigger' */
    /* FOSC/4, Prescale by 8, enable 16bit read/write, start timer */
    T3CON = 0x33;

    /* configure ECCP2 to use timer3 as a special event trigger to fire an ADC conversion */
    CCPTMRS0 &= ~0x38; /* Mask C2TSEL bits */
    CCPTMRS0 |= 0x08; /* Select TMR3 for ECCP2 */
    CCP2CON = 0x0B; /* Special Event Trigger mode, start */

    /* Adc sampling is now running. Interrupts are not yet being generated. */
    /* So set a period to sample at, and enable interrupts */
    CCPR2H = 0;
    CCPR2L = 100; /* 26 gives maximum sample rate */

    int_enable_adc();


    pos_level_one = balanced_value + level_one;
    pos_level_two = balanced_value + level_two;
    neg_level_one = balanced_value - level_one;
    neg_level_two = balanced_value - level_two;
    
    while (1) {

        delayms(250);
        current_adc = ReadADC();
        Nop();
        
        if(current_adc >= pos_level_one) {
            buzzer_enable = 1;
            LATBbits.LATB6 = 1;
            if(current_adc >= pos_level_two) {
                LATBbits.LATB7 = 1;
            } else {
                LATBbits.LATB7 = 0;
            }
        } else if (current_adc <= neg_level_one) {
            buzzer_enable = 1;
            LATBbits.LATB4 = 1;
            if(current_adc <= neg_level_two) {
                LATBbits.LATB3 = 1;
            } else {
                LATBbits.LATB3 = 0;
            }
        } else { 
            buzzer_enable = 0;
            LATBbits.LATB7 = 0;
            LATBbits.LATB6 = 0;
            LATBbits.LATB5 = 1;
            LATBbits.LATB4 = 0;
            LATBbits.LATB3 = 0;
        }
        
        if(buzzer_enable) {
            BuzzerEnable();
        }
   }
    // Should never reach this point
    return (EXIT_SUCCESS);
}

