/*
 * File:   hardware.c
 * Author: mhibbett. mike.hibbett@gmail.com, mjhdesigns.com
 *
 * Created on 31 March 2014, 20:53
 *
 * Low level hardware initialisation.
 */

#include <stdio.h>
#include <stdlib.h>
#include <pic18f27j13.h>
#include "hardware.h"
#include "LCD-Graphic-ILI9341.h"
#include "timers.h"

/**************************************************************************
* Function: HardwareInit
*           Low level hardware initialisation.
**************************************************************************
*/
void HardwareInit( void )
{
    // Initially, set all I/O to digital rather than analogue

    ANCON0 = 0xFE;
    ANCON1 = 0x7F;

    // And set the LED pin as an output, LED Off, as it draws 11mA current
    LATBbits.LATB7 = 0;
    LATBbits.LATB6 = 0;
    LATBbits.LATB5 = 0;
    LATBbits.LATB4 = 0;
    LATBbits.LATB3 = 0;
    LATCbits.LATC3 = 0;
    TRISBbits.TRISB5 = 0;
    
    // LED Setup
    TRISBbits.TRISB7 = 0;
    TRISBbits.TRISB6 = 0;
    TRISBbits.TRISB5 = 0;
    TRISBbits.TRISB4 = 0;
    TRISBbits.TRISB3 = 0;

    TRISCbits.TRISC3 = 0;    
}

void CheckforButtonPress(void) {
    if (PORTCbits.RC6) {
        //LATBbits.LATB5 ^= 1;  
        if (HOLD_SAMPLING) {
            LCD_Clear(BLACK);
            POINT_COLOR = GRAY;
            LCD_DrawRectangle(10,10,239,319);   // Replaces 4 lines below
            LCD_DrawScreenWords(BUTTON_SELECT);
            HOLD_SAMPLING = 0;
        } else {
            HOLD_SAMPLING = 1;
        }
        delayms(500);
    }
  
    // Select Screen words code
    if (PORTCbits.RC7) {
        // Checks Button Select
        if (BUTTON_SELECT == 3) {
            BUTTON_SELECT = 0;
        } else {
            BUTTON_SELECT++;
        }
        LCD_DrawScreenWords(BUTTON_SELECT);  
        delayms(500);
    }
        
    // Up Button
    if (PORTBbits.RB0) {
        if (BUTTON_SELECT == 0) {
            AUTO_SAMPLE ^= 1;
        } else if (BUTTON_SELECT == 1) {
            EDGE_SAMPLE ^= 1;
        } else if (BUTTON_SELECT == 2) {
            TRIGGER_LINE++;
        } else if (BUTTON_SELECT == 3) {
            MEASURE_LINE++;
        }
        LCD_DrawScreenWords(BUTTON_SELECT); 
        delayms(100);
    }
    
    // Down Button
    if (PORTBbits.RB1) {
        if (BUTTON_SELECT == 0) {
            AUTO_SAMPLE ^= 1;
        } else if (BUTTON_SELECT == 1) {
            EDGE_SAMPLE ^= 1;
        } else if (BUTTON_SELECT == 2) {
            TRIGGER_LINE--;
        } else if (BUTTON_SELECT == 3) {
            MEASURE_LINE--;
        }  
        LCD_DrawScreenWords(BUTTON_SELECT); 
        delayms(100);
    }
    
}

void BuzzerEnable(void) {
    unsigned int i = 0;
    unsigned int toggle_pin = 0;
    
    for(i = 0; i < 100; i++) {
        delayms(1);
        if(toggle_pin) {
            LATCbits.LATC3 = 0;
            toggle_pin = 0;
        } else {
            LATCbits.LATC3 = 1;
            toggle_pin = 1;
        }
    }
    LATCbits.LATC3 = 0;
}