// This code has been ported from the tutorial code of James Lynch, and extended with bitmap display and
// "Very Large" font support  by Mike Hibbett

#include "wiring.h"

void LCDSetup( void );
void LCDCLS( unsigned int color );
void SPISendByte( boolean mode, unsigned int data );
void LCDSetPixel(unsigned int x, unsigned int y, unsigned int color);
void LCDSetLine(unsigned int x0, unsigned int y0, unsigned int x1, unsigned int y1, unsigned int color);
void LCDPutChar(char c, int x, int y, int size, int fColor, int bColor);
void LCDPutStr(char *pString, unsigned int x, unsigned int y, unsigned int Size, unsigned int fColor, unsigned int bColor);
void LCDPutBMP( unsigned char *bitmap, unsigned int x, unsigned int y, unsigned int iwidth, unsigned int idepth);


// Font sizes
const unsigned int SMALL = 0;
const unsigned int MEDIUM = 1;
const unsigned int LARGE = 2;
const unsigned int VLARGE = 3;

// LCD Command bytes
const unsigned char  PASET = 0x75;
const unsigned char  CASET = 0x15;
const unsigned char  RAMWR = 0x5c;
const unsigned char  NOP = 0x25;
const unsigned char  DISINV = 0xA7;

// definitions for the colours used on the LCD in 12 bit mode
const unsigned int WHITE = 0xFFF;
const unsigned int BLACK = 0x000;
const unsigned int RED = 0xF00;
const unsigned int GREEN = 0x0F0;
const unsigned int BLUE = 0x00F;
const unsigned int CYAN = 0x0FF;
const unsigned int MAGENTA = 0xF0F;
const unsigned int YELLOW = 0xFF0;
const unsigned int BROWN = 0xB22;
const unsigned int ORANGE = 0xFA0;
const unsigned int PINK = 0xF6A;

// Pins to which the LCD is connected
const unsigned int BACKLIGH_PIN = 33;  // Pin to which the LCD backlight pin is connected
const unsigned int CS_PIN       = 27;  // Pin to which the LCD CS pin is connected
const unsigned int SCLK_PIN     = 29;  // Pin to which the LCD CS pin is connected
const unsigned int MOSI_PIN     = 31;  // Pin to which the LCD data in line is connected
const unsigned int RESET_PIN    = 35;  // Pin to which the LCD data in line is connected

const boolean  DATA_MODE    = HIGH; // SPI D/C bit - data mode
const boolean  COMMAND_MODE = LOW;  // SPI D/C bit - command mode


