/**
 *******************************************************************
 * 
 * LED-BinaryClock
 * 
 * Author: Mike P. O'Keeffe
 * 
 * Everyday Practical Electronics - PIC 'n Mix
 * 
 * Description:
 * 
 * PIC: 16F1829
 * Compiler: XC8 v1.4
 * IDE: MPLABX v3.2.6
 *
 * Board: LED Binary Clock
 * Date: 1.2.2017
 *
 * ******************************************************************
 */

#include <htc.h>                                     //PIC hardware mapping
#define _XTAL_FREQ 500000                            //Used by the XC8 delay_ms(x) macro

//config bits that are part-specific for the PIC16F1829
__CONFIG(FOSC_INTOSC & WDTE_OFF & PWRTE_OFF & MCLRE_OFF & CP_OFF & CPD_OFF & BOREN_ON & CLKOUTEN_OFF & IESO_OFF & FCMEN_OFF);
__CONFIG(WRT_OFF & PLLEN_OFF & STVREN_OFF & LVP_OFF);

    /* -------------------LATC-----------------
     * Bit#:  -7---6---5---4---3---2---1---0---
     * LED:   ---------------|DS4|DS3|DS2|DS1|-
     *-----------------------------------------
     */

void main(void) {
    int maxseconds = 59;
    int maxmins = 9;
    int maxtenmins = 5;
    int maxhours = 0xB0;
    int seconds = 0;
    int mins = 0;
    int tenmins = 0;
    int hours = 0;
    int val = 0;
    
    OSCCON = 0b00110000;                            //500KHz clock speed
    TRISA = 0;
    TRISB = 0;
    TRISC = 0;
    LATA = 0;
    LATB = 0;
    LATC = 0;
    
    OPTION_REG = 0b00000111;                        //1:256 prescaler for a delay of: (insruction-cycle * 256-counts)*prescaler = ((8uS * 256)*256) =~ 524mS

    LATCbits.LATC6 = 1;                             // Green LED
    LATCbits.LATC5 = 1; 
    
    // Setup PWM as RC5
    CCP1CON = 0b00001100;                           //PWM mode single output
    PR2 = 255;                                      //Frequency at 486Hz. Anything over ~60Hz will get rid of any flicker
                                                    //PWM Period = [PR2 + 1]*4*Tosc*T2CKPS = [255 + 1] * 4 * (1 / 500KHz) * 1  
    CCPTMRSbits.C2TSEL = 0b00;                      //select timer2 as PWM source
    T2CONbits.T2CKPS = 0b00;                        //1:1 prescaler
    T2CONbits.TMR2ON = 1;                           //start the PWM
    
    // RA4 Button Left
    TRISAbits.TRISA4 = 1;   // Minutes - S1
    ANSELAbits.ANSA4 = 0;
    
    // RA5 Button Right
    TRISAbits.TRISA5 = 1;   // Hours - S1
    
    // RC7 ADC
    TRISCbits.TRISC7 = 1;
    ANSELCbits.ANSC7 = 1;
    ADCON0 = 0b00100101;                            //select RC7 as source of ADC and enable the module (AN9)
    ADCON1 = 0b00010000;                            //left justified - FOSC/8 speed - Vref is Vdd
    
    while (1) {
        __delay_ms(100);
        
        while (!INTCONbits.TMR0IF) {
            if (!PORTAbits.RA4) {    // Increment Minutes
                if(mins < maxmins) {
                    mins++;
                } else {
                    mins = 0;
                    if(tenmins < maxtenmins) {
                        tenmins++;
                    } else {
                        tenmins = 0;
                    }
                }
                __delay_ms(250);
            }
            
            if (!PORTAbits.RA5) {    // Increment Hours
                if(hours < maxhours) {
                    hours = hours + 0x10;
                } else {
                    hours = 0;
                }
                __delay_ms(250);
            }
            
            continue;        //you can let the PIC do work here, but for now we will wait for the flag
        }
        INTCONbits.T0IF = 0;                        //flag MUST be cleared in software
        
        LATCbits.LATC6 ^= 1; 
        
        if(seconds < maxseconds) {
            seconds++;
        } else {
            seconds = 0;
            if(mins < maxmins) {
                mins++;
            } else {
                mins = 0;
                if(tenmins < maxtenmins) {
                    tenmins++;
                } else {
                    tenmins = 0;
                    if(hours < maxhours) {
                        hours = hours + 0x10;
                    } else {
                        hours = 0;
                    }
                }
            }
        }
    
        val = (LATC & 0xF0);        // Clears 4 LSB, keeps 4 MSB
        LATC = (val | mins);
        val = (LATA & 0xF8);
        LATA = (val | tenmins);
        val = (LATB & 0x0F);
        LATB = (val | hours);
        
        GO = 1;                                     //start the ADC conversion
        while (GO) continue;                        //wait for conversion to be finished
        
        CCPR1L = ADRESH;                            //put the top 8 MSbs into CCPR2L
        CCP1CONbits.DC1B = (ADRESL>>6);             //put the 2 LSbs into DC2B register to complete the 10bit resolution
    }
    
}
