    ;*************************************************************************
	; file: interrupts.asm
	;		Contains the main interrupt function, and code to do initial
	;		initialisation of the sub-system.
	;*************************************************************************


	;*************************************************************************
	; include files go here
	;*************************************************************************

    include <P18f27J13.INC>


	;*************************************************************************
	; extern directives - to gain access to global functions and data from 
	;					  elsewhere
	;*************************************************************************

	extern timerState
	extern decTimer

	;*************************************************************************
	; global directives - making variables and functions available elsewhere -
	;					  go here
	;*************************************************************************

	global 	InterruptInit
	global 	InterruptHandler
	global	IntOccurred


	;*************************************************************************
	; Constanst - Symbolic constants and simple macros, defined with the 
	;			  EQU directive, go here.
	;*************************************************************************

TOGGLE_LED_TIME	EQU .1	; time between toggling the LED - 2s


	;*************************************************************************
	; Definition of RAM based variables follow the udata directive
	;*************************************************************************

	udata

W_TEMP			res 1
STATUS_TEMP		res	1
BSR_TEMP		res 1
delay_2s		res 1 
IntOccurred		res	1	; Used to indicate to the foreground that a time update has occurred.


	;*************************************************************************
	; code, such as functions and ROM based data tables, follow the code directive
	;*************************************************************************

	code
		
	;*************************************************************************
	; Function: InterruptInit
	;			Initialises the interrupt sub-system.
	;*************************************************************************
InterruptInit:
	movlw	TOGGLE_LED_TIME
	movwf	delay_2s
	clrf	IntOccurred
	return


	;*************************************************************************
	; Function: InterruptHandler
	;			Provides a basic interrupt handler function.
	;*************************************************************************
InterruptHandler:
	movwf	W_TEMP
	movff	STATUS, STATUS_TEMP
	movff	BSR, BSR_TEMP

	bcf 	PIR1, TMR1IF
	
	; only toggle the LED after the required number of 2s interrupts
	decfsz	delay_2s
	goto	int_exit	
	
	; Toggle the LED if the timer is running
	movf	timerState, W
	sublw	.2
	btfss	STATUS, Z
	goto	int001
	btg	   	LATB, 5		; toggle the LED on PORTB5
	
	; Signal to the foreground that an interrupt occurred
	; 2 indicates that the timer has expired

	call	decTimer
	btfsc	STATUS, C			; did the timer expire?
	goto	intTimerExpired		; yes, so tell the foreground
								; No. So decrement again ( we do 2s per interrupt )

	call	decTimer
	btfss	STATUS, C
	movlw	1
	btfsc	STATUS, C  ; timer expired ? Skip if not.
intTimerExpired:
	movlw	2
	movwf	IntOccurred	
	
int001:
	movlw	TOGGLE_LED_TIME
	movwf	delay_2s	; reset the counter
	
int_exit:
	movff	BSR_TEMP, BSR
	movf	W_TEMP, W
	movff	STATUS_TEMP, STATUS
	retfie  FAST


	end
