/*
    Module: serialDebug.h

    Author: Mike Hibbett

    Date: 21/11/09

    Function: API to the debug harness. The framework is provided here; individual functions
              are defined elsewhere, and linked in via the serialDebugHook.c file.
              This module depends on serial rx interrupts, or a poll system to emulate them.
              Interrupts are better, as they interfere less with the structure of the
              application it is embedded in.

              Interface is as follows:

              sdTable.h - Here lives the sdDebugTable structure, which you update with the list of
                          debug functions.

              sdRxChar(char) - Call this from your interrupt routine, so send data to the debug
                               system
              sdTxChar(char) - *modify* this to output a character. Ideally, out of the serial port!
 
              sdTable.c - Here lives the implementations of debug routines. You don't have to place
                          them here; application specific ones may well be implemented in your own
                          code, it's up to you.

              serialDebug.c  - Contains the general debug routines that are common to all applications.
                               it also contains sdRxChar() and sdTxChar()

              serialDebug.h  - contains the declarations of the interface.

*/


#define DEBUG_CMD_STR_LENGTH 40  /* length of a debug command, including CRLF */


/*****************************************************************************
    Function: serialDebug

    Purpose:  Main application entry to the debugger.

    Returns: 
*****************************************************************************/
extern void serialDebug(void);


/*****************************************************************************
    Function: serialDebug

    Purpose:  called by the application to pass a character to the debugger

    Returns: 
*****************************************************************************/
extern void sdRxChar( char rxCh );
