' Colour Maximite MoodLight demonstration program (MoodLite.bas).
' Written for PE magazine - FEBRUARY 2020 edition.

' Uses Blinkt! module and SPI command.
' Refer to Practical Electronics for details regarding Blinkt! data control.

Cls : Mode 4                 ' clear screen

SetPin(1),din                ' define input pin for SPI DataIn (unused)
SetPin(2),dout               ' define output pin for SPI DataOut
SetPin(3),dout               ' define output pin for SPI Clock

Do                           ' defines start of an 'endless' loop
  For COL=1 To 7             ' work through the seven colours (not black!)
    For BTbrightness=1 To 31 ' loops to fade brightness UP
      UpdateAPA              ' call SUB to write data to Blinkt!
    Next BTbrightness        ' repeat
    Print @(20,100) CLR$(col) "Press any key for next colour ..." ' show message
    Do While KeyDown=0:Loop  ' wait until any key is pressed, then remove prompt
    Cls
    For BTbrightness=30 To 0 Step -1  ' loops to fade brightness DOWN
      UpdateAPA                       ' call SUB to write data to Blinkt!
    Next BTbrightness                 ' repeat
    Pause 100                ' delay 0.1 second
  Next COL                   ' move onto next colour
Loop                         ' when all seven colours finished, then start again


' following SUB sends data via SPI to Blinkt! module.
' (see 'Make-it-with-Micromite' article in Feb 2020 PE for full details)
'
Sub UpdateAPA
  BTrr=255*((COL And 7) And 4)  ' COL value (1-7) used to set BTrr (0 or 255)
  BTgg=255*((COL And 7) And 2)  ' likewise for Green (BTgg)
  BTbb=255*((COL And 7) And 1)  ' ikewise for Blue (BTbb)

  For i = 1 To 4                ' send 4-bytes (START frame)
    x=SPI(1,2,3,0,H,0,8)        ' define SPI to use pins 1,2 and 3 (8-bit data)
  Next i                        ' sends the 32 zeros (0)

  For i = 1 To 8                ' loop 8 times for the 8 Blinkt! LEDs
    x=SPI(1,2,3,&b11100000+BTbrightness,H,0,8)  ' brightness byte (111xxxxx)
    x=SPI(1,2,3,BTbb,H,0,8)                     ' send BLUEness byte (BTbb)
    x=SPI(1,2,3,BTgg,H,0,8)                     ' send GREENness byte (BTgg)
    x=SPI(1,2,3,BTrr,H.0.8)                     ' send REDness bte (BTrr)
  Next i                        ' loop sends 8 lots of LED frames (four-bytes)

  For i = 1 To 5                ' send 5-bytes (END frame)
    x=SPI(1,2,3,0,H,0,8)        ' send one byte of 0's
  Next i                        ' in total, sends 40 zeros (0)
Pause 20                        ' short delay
End Sub                         ' finished sending the 41-bytes of Blinkt! data

