; MATHSMULTDIV.ASM 29MAY07 - COPYRIGHT JOHN BECKER

; EQUATES FOR PETER HEMSLEY'S MATHS ROUTINES - used in bank1

;REGA0
;REGA1
;REGA2
;REGA3
;REGB0
;REGB1
;REGB2
;REGB3
;REGC0
;REGC1
;REGC2
;REGC3
;MTEMP

;COUNT0
;COUNT1
;COUNT2
;DIGIT1
;DIGIT2
;DIGIT3
;DIGIT4
;DIGIT5
;DIGIT6
;DIGIT7
;DIGIT8
;BITCNT
;DIGCNT
;MULCLSB
;MULCMSB
;MULPLSB
;MULPMSB
;PRODLSB
;PRODMSB
;DIVIDLSB
;DIVIDMSB
;REMDRLSB
;REMDRMSB
;DIVISLSB
;DIVISMSB

;ROOTL
;ROOTH
;REMDRL
;REMDRH
;NUML
;NUMM
;NUMH
;MCOUNT


bin2dec: clrf    digit1
	clrf	digit2
	clrf	digit3
	clrf	digit4
	clrf	digit5
	clrf	digit6
	clrf	digit7
	clrf	digit8

	movlw	24		;24 bits to do
	movwf	bitcnt

bitlp   rlf     count0,F        ;Shift msb into carry
	rlf	count1,F
	rlf	count2,F

	movlw	digit1
	movwf	fsr		;Pointer to digits
	movlw	8		;8 digits to do
	movwf	digcnt
adjlp	rlf	indf,F		;Shift digit 1 bit left
	movlw	10
	subwf	indf,w		;Check and adjust for decimal overflow
	skpnc
	movwf	indf

	incf	fsr,F		;Next digit
	decfsz	digcnt,F
	goto	adjlp
        decfsz  bitcnt,F        ;Next bit
	goto	bitlp
        movlw 48
        iorwf DIGIT1,F
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F
	return

;****************

;A neat Multiply routine, from Peter Hemsley 15July01.

;Multiply 16 bit multiplicand (mulcL,H) by 16 bit multiplier (mulpL,H)
;32 bit result (product) in mulpL,H (low word) and prodL,H (high word)

MULTIPLY: movlw  16        ; B'00010000' H'10'
          movwf  BITCNT  
          clrf   PRODLSB  
          clrf   PRODMSB  
JMP0014:  bcf    STATUS,0
          btfss  MULPLSB,0
          goto   JMP0028
          movf   MULCLSB,W
          addwf  PRODLSB,F
          movf   MULCMSB,W
          btfsc  STATUS,0
          goto   JMP0024
          addwf  PRODMSB,F
          goto   JMP0028
JMP0024:  addwf  PRODMSB,F
          incf   PRODMSB,F
          btfsc  STATUS,2
          bsf    STATUS,0
JMP0028:  rrf    PRODMSB,F
          rrf    PRODLSB,F
          rrf    MULPMSB,F
          rrf    MULPLSB,F
          decfsz BITCNT,F
          goto   JMP0014
          return 

DIVISION: movf   DIVISLSB,W
          iorwf  DIVISMSB,W
          btfsc  STATUS,2
          goto   JMP0041
          movlw  16
          movwf  BITCNT 
          clrf   REMDRMSB  
          clrf   REMDRLSB  
JMP0018:  bcf    STATUS,0
          rlf    DIVIDLSB,F
          rlf    DIVIDMSB,F
          rlf    REMDRLSB,F
          rlf    REMDRMSB,F
          movf   DIVISMSB,W
          subwf  REMDRMSB,W
          btfss  STATUS,2
          goto   JMP0029
          movf   DIVISLSB,W
          subwf  REMDRLSB,W
JMP0029:  btfss  STATUS,0
          goto   JMP0038
          movf   DIVISLSB,W
          subwf  REMDRLSB,F
          btfss  STATUS,0
          decf   REMDRMSB,F
          movf   DIVISMSB,W
          subwf  REMDRMSB,F
          bsf    DIVIDLSB,0
JMP0038:  decfsz BITCNT,F
          goto   JMP0018
          bcf    STATUS,2
JMP0041:  return 


; ******** SQUARE ROOT ROUTINE FROM PETER HEMSLEY *********

; Disassembly from C:\PIC\SQRT.HEX on 04-02-2002 at 21:14:19


SQRT:     clrf   ROOTL  
          clrf   ROOTH  
          clrf   REMDRL  
          clrf   REMDRH  

          movlw  12
          movwf  COUNT0
SQRLP:    rlf    NUML,F
          rlf    NUMM,F
          rlf    NUMH,F
          rlf    REMDRL,F
          rlf    REMDRH,F
          rlf    NUML,F
          rlf    NUMM,F
          rlf    NUMH,F
          rlf    REMDRL,F
          rlf    REMDRH,F
          bcf    ROOTL,0
          bsf    STATUS,0
          rlf    ROOTL,F
          rlf    ROOTH,F
          movf   ROOTH,W
          subwf  REMDRH,W
          btfss  STATUS,2
          goto   TSTGT
          movf   ROOTL,W
          subwf  REMDRL,W
TSTGT:    btfss  STATUS,0
          goto   REMLT
          movf   ROOTL,W
          subwf  REMDRL,F
          btfss  STATUS,0
          decf   REMDRH,F
          movf   ROOTH,W
          subwf  REMDRH,F
          bsf    ROOTL,1
REMLT:    decfsz COUNT0,F
          goto   SQRLP
          bcf    STATUS,0
          rrf    ROOTH,F
          rrf    ROOTL,F
         return

;*******************

;*** SIGNED 32 BIT INTEGER MATHS ROUTINES FOR PIC16 SERIES BY PETER HEMSLEY JAN 2003 ***


;*** SIGNED MULTIPLY ***
;REGA * REGB -> REGA
;Return carry set if overflow

multiply32
	clrf	MTEMP
	call	chksgna		;Make REGA positive
	skpnc
	return			;Overflow
	call	chksgnb		;Make REGB positive
	skpnc
	return			;Overflow

	call	movac		;Move REGA to REGC
	call	clra		;Clear product

	movlw	D'31'		;Loop counter
	movwf	MCOUNT

muloop	call	slac		;Shift left product and multiplicand

	rlf	REGA3,w
	skpnc			;Check for overflow
	return

	btfss	REGC3,7		;If multiplicand bit is a 1 then
	goto	nxtmul
	call	addba		;add multiplier to product

	rlf	REGA3,w
	skpnc			;Check for overflow
	return

nxtmul	decfsz	MCOUNT,f	;Next
	goto	muloop

	btfsc	MTEMP,0		;Check result sign
	call	negatea		;Negative
	return

;*** SIGNED DIVIDE ***
;REGA / REGB -> REGA
;Remainder in REGC
;Return carry set if overflow or division by zero

divide32  movf    REGB0,w         ;Trap division by zero
	iorwf	REGB1,w
	iorwf	REGB2,w
	iorwf	REGB3,w
	sublw	0
	skpnc
	return

	clrf	MTEMP
	call	chksgna		;Make dividend (REGA) positive
	skpnc
	return			;Overflow
	call	chksgnb		;Make divisor (REGB) positive
	skpnc
	return			;Overflow

	clrf	REGC0		;Clear remainder
	clrf	REGC1
	clrf	REGC2
	clrf	REGC3

	movlw	D'32'		;Loop counter
	movwf	MCOUNT

dvloop	call	slac		;Shift dividend (REGA) msb into remainder (REGC)

	movf	REGB3,w		;Test if remainder (REGC) >= divisor (REGB)
	subwf	REGC3,w
	skpz
	goto	dtstgt
	movf	REGB2,w
	subwf	REGC2,w
	skpz
	goto	dtstgt
	movf	REGB1,w
	subwf	REGC1,w
	skpz
	goto	dtstgt
	movf	REGB0,w
	subwf	REGC0,w
dtstgt	skpc			;Carry set if remainder >= divisor
	goto	dremlt

	movf	REGB0,w		;Subtract divisor (REGB) from remainder (REGC)
	subwf	REGC0,f
	movf	REGB1,w
	skpc
	incfsz	REGB1,w
	subwf	REGC1,f
	movf	REGB2,w
	skpc
	incfsz	REGB2,w
	subwf	REGC2,f
	movf	REGB3,w
	skpc
	incfsz	REGB3,w
	subwf	REGC3,f
	clrc
	bsf	REGA0,0		;Set quotient bit

dremlt	decfsz	MCOUNT,f	;Next
	goto	dvloop

	btfsc	MTEMP,0		;Check result sign
	call	negatea		;Negative
	return

;UTILITY ROUTINES

;Add REGB to REGA
;Used by add, multiply

addba	movf	REGB0,w		;Add lo byte
	addwf	REGA0,f

	movf	REGB1,w		;Add mid-lo byte
	skpnc			;No carry_in, so just add
	incfsz	REGB1,w		;Add carry_in to REGB
	addwf	REGA1,f		;Add and propagate carry_out

	movf	REGB2,w		;Add mid-hi byte
	skpnc
	incfsz	REGB2,w
	addwf	REGA2,f

	movf	REGB3,w		;Add hi byte
	skpnc
	incf	REGB3,w
	addwf	REGA3,f
	return

;Move REGA to REGC
;Used by multiply, sqrt

movac	movf	REGA0,w
	movwf	REGC0
	movf	REGA1,w
	movwf	REGC1
	movf	REGA2,w
	movwf	REGC2
	movf	REGA3,w
	movwf	REGC3
	return

;Clear REGA
;Used by multiply, sqrt

clra	clrf	REGA0
	clrf	REGA1
	clrf	REGA2
	clrf	REGA3
	return

;Check sign of REGA and convert negative to positive
;Used by multiply, divide, bin2dec

chksgna	rlf	REGA3,w
	skpc
	return

;Negate REGA
;Used by multiply, divide, bin2dec, dec2bin

negatea	movf	REGA3,w		;Save sign in w
	andlw	0x80

	comf	REGA0,f		;2's complement
	comf	REGA1,f
	comf	REGA2,f
	comf	REGA3,f
	incfsz	REGA0,f
	goto	nega1
	incfsz	REGA1,f
	goto	nega1
	incfsz	REGA2,f
	goto	nega1
	incf	REGA3,f
nega1
	incf	MTEMP,f		;flip sign flag
	addwf	REGA3,w		;Return carry set if -2147483648
	return


;Check sign of REGB and negative convert to positive
;Used by multiply, divide

chksgnb	rlf	REGB3,w
	skpc
	return

;Negate REGB
;Used by subtract, multiply, divide

negateb	movf	REGB3,w		;Save sign in w
	andlw	0x80

	comf	REGB0,f		;2's complement
	comf	REGB1,f
	comf	REGB2,f
	comf	REGB3,f
	incfsz	REGB0,f
	goto	negb1
	incfsz	REGB1,f
	goto	negb1
	incfsz	REGB2,f
	goto	negb1
	incf	REGB3,f
negb1
	incf	MTEMP,f		;flip sign flag
	addwf	REGB3,w		;Return carry set if -2147483648
	return


;Shift left REGA and REGC
;Used by multiply, divide

slac	rlf	REGA0,f
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f
	rlf	REGC0,f
	rlf	REGC1,f
	rlf	REGC2,f
	rlf	REGC3,f
	return

SHOWDIGIT8 movf DIGIT8,W       ; show decimal values
           call LCDOUT
SHOWDIGIT7 movf DIGIT7,W
           call LCDOUT
SHOWDIGIT6 movf DIGIT6,W
           call LCDOUT
SHOWDIGIT5 movf DIGIT5,W
           call LCDOUT
SHOWDIGIT4 movf DIGIT4,W
           call LCDOUT
SHOWDIGIT3 movf DIGIT3,W
           call LCDOUT
SHOWDIGIT2 movf DIGIT2,W
           call LCDOUT
SHOWDIGIT1 movf DIGIT1,W
           call LCDOUT
	   return

