; LCDroutines.inc

;******** LCD ROUTINES **********

LCD1:    movlw %10000000
         goto LCDLIN
LCD12:   movlw %10001100
         goto LCDLIN
LCD21:   movlw %11000000
         goto LCDLIN
LCD2B:   movlw %11001011
         goto LCDLIN
LCD2E:   movlw %11001110

LCDLIN:  BCF RSLINE,4

LCDOUT:  movwf STORE
         movlw 50
         movwf LOOPA
DELAYIT: decfsz LOOPA,F
         goto DELAYIT
         call SENDIT

SENDIT:  swapf STORE,F
         movf STORE,W
         andlw 15
         iorwf RSLINE,W
         movwf PORTB
         BSF PORTB,5
         nop 
         nop
         BCF PORTB,5
         RETURN

;*************

LCDSET: clrf LOOP       ;clr LCD set-up loop
        clrf RSLINE     ;clear RS line for instruction send
LCDST2: movf LOOP,W     ;get table address
        call TABLCD     ;get set-up instruction
        call LCDOUT     ;perform it
        incf LOOP,F     ;inc loop
        btfss LOOP,3    ;has last LCD set-up instruction now been done?
        goto LCDST2     ;no
        return

;*************

CLRLINE1: call LCD1      ; set address for line 1 cell 1
         bsf RSLINE,4    ; set RS for data send
         clrf LOOP       ;
CLRL1:   movlw ' '       ; clear cell
         call LCDOUT     ;
         incf LOOP,F     ; inc loop
         btfss LOOP,4    ; has last LCD letter been sent?
         goto CLRL1      ; no
         return

CLRLINE2: call LCD21
         bsf RSLINE,4
         movlw 16
         movwf LOOP
CL2:     movlw ' '
         call LCDOUT
         decfsz LOOP,F
         goto CL2
         return




