    include <P18f27J13.INC>

	CONFIG WDTEN = OFF
	CONFIG XINST = OFF
	CONFIG IESO = OFF
	CONFIG FCMEN = OFF
	CONFIG OSC = INTOSC
	CONFIG DSWDTEN = OFF
	
; RAM addresses of variables
delay_1s	EQU	0x00
	
; Constants
TMR0_COUNT_1S	EQU .3620	; TMR0 count start value for a 1s period
TMR0_CONF 		EQU 0x84	; timer is 16bit, FOSC/4 source, prescale by 32
TOGGLE_LED_TIME	EQU	.10		; time between toggling the LED - 10s
	
	
	; Set the code address to start of flash -
	; this is where the processor will start 
	; executing instructions from after a reset.
	org 0

	movlw   0x00	
	movwf   TRISB	; Set PORTB as an output
	movlw	0x70
	movwf	OSCCON	; Set processor to run at 8MHZ
	
loop:
	comf	LATB	; toggle all bits in PORTB
	movlw	TOGGLE_LED_TIME
	call	delay_s	; delay for 10 seconds
	goto    loop
	
	
; delay for a number of seconds
; value in W register defines how many seconds
delay_s
	movwf	delay_1s
	
ds1:
	bcf		INTCON,TMR0IF
	movlw	HIGH TMR0_COUNT_1S
	movwf	TMR0H
	movlw	LOW TMR0_COUNT_1S
	movwf	TMR0L
	movlw	TMR0_CONF
	movwf	T0CON	 	; Start the timer
	
ds0:
	btfss	INTCON, TMR0IF	; Wait for the 1s period to occur
	goto	ds0
	
	decfsz	delay_1s		 
	bra		ds1			; loop for the number of seconds requested
	
	clrf	T0CON		; Disable timer		
	retlw	0				
	
	end
	