; SERIAL2.ASM 12-15-2002 13:39:19
; version v1.18 DEC 2002
;PIC 16F84
;PortA
;	3=sck	clock pulses
;	4=sda	data pulses
;Port B	0=
;	1=
;	2=
;	3=
;	4=
;	5=
;	6=
;	7=
;*****************************************
#DEFINE PAGE0 BCF STATUS,5
#DEFINE PAGE1 BSF STATUS,5
	.AVSYM
PCL		EQU	$02
STATUS		EQU	$03	; STATUS register
PORTA		EQU	$05	; Port A direction register
TRISA		EQU	$05
PORTB		EQU 	$06	; Port B data register
TRISB		EQU	$06
PCLATH		EQU	$0A

LOOPA		EQU	$0D
COUNT		EQU	$0E
COUNT1		EQU	$0F
COUNT2		EQU	$10
TXTEMP		EQU	$11	;Tx temp register
RXTEMP		EQU	$12	;Rx temp register
EFLAG		EQU	$13	;Error flag
MADDC		EQU	$14	;Address of slave
MADDH		EQU	$15	;Address for info storage high bit
MADDL		EQU	$16	;Address for info storage low bit
CONTRW		EQU	$17	;Control R/W word


SCK		EQU	$3
SDA		EQU	$4
C	     	EQU	0	; Carry flag
W	     	EQU	0	; Working register flag
F		EQU	1	; File register flag
Z		EQU 	2	;Zero flag in Status register
OPTION		EQU	1

;*********************************************
		ORG 	$0004      ; Interrupt vector address
        		GOTO 	BEGIN
        		ORG	 $0005      ; Start of program memory
BEGIN:		NOP
;***************************************************************
;       MAIN ROUTINE
;***************************************************************
MAIN:		PAGE1
		MOVLW	0
		MOVWF	TRISA		,PortA set for output
		MOVWF	TRISB		;PortB set for output
		PAGE0

;**********************************************
;	Write Byte out
;**********************************************
STAR:		MOVLW	H'0
		MOVWF	EFLAG		;Clear Error Flag
		MOVWF	CONTRW		;Sets read bit
		MOVWF	MADDC		;Address of Slave Chip;Range=0-7
		MOVWF	MADDH		;Store SLAVE memory address high
		MOVWF	MADDL		;Store SLAVE memeory address low
		CALL	BOUT		;Send START bit
		BTFSC	EFLAG,1		;Check for error
		GOTO	ERROR
		CALL 	BADDO		;Send High and Low read address in SLAVE
		BTFSC	EFLAG,1		;Check for error
		GOTO	ERROR
		MOVLW	%10101010	;Byte to be stored in SLAVE
		CALL	DDOUT
		BTFSC	EFLAG,1		;Check for error
		GOTO	ERROR
		CALL	DEND		;Send STOP Bit

;********************************************
;	Write table out
;*********************************************
		MOVLW	H'F
		MOVWF	MADDL		;Store SLAVE memory write address low
		MOVLW	H'0
		MOVWF	MADDH		;Store SLAVE memory write address HIGH
		MOVWF	CONTRW		;Sets read bit
		CALL	BOUT		;Send START bit

		BTFSC	EFLAG,1		;Check for error

		GOTO	ERROR
		CALL	BADDO		;Send High and Low write address in SLAVE

		BTFSC	EFLAG,1		;Check for error
		GOTO	ERROR

		CALL	DLOOP		;Output table of values
		BTFSC	EFLAG,1		;Check for error
		GOTO	ERROR
		CALL	DEND		;Send STOP Bit

;**********************************************
;	Read byte in
;**********************************************
EADIN:		MOVLW	0
		MOVWF	MADDH		;Store SLAVE memory read address high
		MOVWF	MADDL		;Store SLAVE memory read address low
		MOVWF	CONTRW
		CALL	BOUT		;Send START bit
		BTFSC	EFLAG,1		;Check for error
		GOTO	ERROR
		CALL	BADDO		;Send High and Low write address in SLAVE
		BTFSC	EFLAG,1		;Check for error
		GOTO	ERROR
		CALL 	CADRD		;Read values in from SLAVE
		BTFSC	EFLAG,1		;Check for error
		GOTO	ERROR

;**************************************************
;		Read from current address
;**************************************************
		CALL	CADRD		;Read values in from SLAVE
		BTFSC	EFLAG,1		;Check for error
		GOTO	ERROR

;**************************************************
;		Read from sequence
;**************************************************
		MOVLW	0
		MOVWF	MADDH		;Store SLAVE memory read address high
		MOVWF	MADDL		;Store SLAVE memory read address low
		MOVWF	MADDC
		CALL	SEQRD
		BTFSC	EFLAG,1		;Check for error
		GOTO	ERROR
		GOTO	EFINI
		NOP
		NOP
FINI:		GOTO	FINI
ERROR:		MOVLW	H'F0
		MOVWF PORTB
EFINI:		GOTO	EFINI
;******************************************************
;	 SEND BLOCKS OF DATA FROM DTABLE
;	entry	:-On call
;	exit	:- W=0
;
;******************************************************
DLOOP:		MOVLW	0
		MOVWF	LOOPA		;Initialise loop pointer=0
DLOOP1:		BSF	PCLATH,0	;Enable call to DTABLE
		INCF	LOOPA,F		;Flag pointing to entry through Table
		MOVF	LOOPA,W
		CALL	DTABLE
		CLRF	PCLATH
		IORLW	0		;Forces update of STATUS register
		BTFSC	STATUS,Z
		RETURN
		CALL	DDOUT		;W holds data from DTABLE
		BTFSC	EFLAG,1		;Check foe error
		RETURN
		GOTO	DLOOP1
;****************************************
;	SEND START AND CONTROL BIT also High and Low Address
;	entry:-	W->HADD,LADD and MADDC stored
;	exit:-	1) on SATIS completion EFLAG=1
;		2) on ERROR	      EFLAG=2
;****************************************
BOUT:		CALL 	DSTART		;Send START bit
		BCF	STATUS,C	;clear CARRY ready for rotation
		RLF	MADDC,W	;Shift left SLAVE address
		IORLW	%10100000,W	;Create CONTROL word 1010AAA0
		IORWF	CONTRW,W	;Set Read/Write bit
		CALL	BYOUT		;Output CONTROL word
		CALL	ACK		;Get ACKnowlegde from SLAVE
		RETURN
;*******************************************
;	Send address High and Low bytes
;	entry	:-HADD and LADD  stored
;	exit	:-1) on SATIS completion EFLAG,1=0
;		  2) on ERROR	         EFLAG,1=1
;*******************************************
BADDO:		MOVF	MADDH,W
		CALL	BYOUT		;Output SLAVE address high word
		CALL	ACK		;Get ACKnowlegde from SLAVE
		BTFSC	EFLAG,1		;check for error
		RETURN
		MOVF	MADDL,W
		CALL	BYOUT		;Output SLAVE address low word
		CALL	ACK		;Get ACKnowlegde from SLAVE
		RETURN
;*******************************************************
;	SEND BYTE AND ACKNOWLEDGE
;	entry:-		W CONTAINS DATA
;	exit:-		1) on completion SATIS EFLAG=0
;			2) on ERROR	      EFLAG=2
;*******************************************************
DDOUT:		CALL 	BYOUT		;Output data word
		CALL	ACK		;Get ACKnowlegde from Chip
		RETURN
;****************************************
;	ROUTINE TO SEND START BIT
;	entry	:-
;	exit	:-	clock Low
;	DATA H to L while Clk H=Start
;****************************************
DSTART		PAGE1
		BCF	TRISA,SDA	;Data line set for output
		BCF	TRISA,SCK	;Clock line set for output
		PAGE0
		BCF	PORTA,SCK	;Clock low
		NOP
		BSF	PORTA,SDA	;Data High
		NOP
		NOP
		NOP
		NOP
		BSF	PORTA,SCK	;Clock High
		NOP
		NOP
		NOP
		NOP
		BCF	PORTA,SDA	;Data Low
		NOP
		NOP
		NOP
		NOP
		BCF	PORTA,SCK	;Clock Low

		RETURN
;***************************************************
;	ROUTINE TO SEND STOP BIT
;	entry;-		on call
;	exit:-		clock low
;	Data L to H while clk H = stop
****************************************************
DEND:		PAGE1
		BCF	TRISA,SDA	;Set data line to output
		PAGE0
		BCF	PORTA,SDA	;Data Low
		BSF	PORTA,SCK	;Clock High
		NOP
		NOP
		NOP
		NOP
		BSF	PORTA,SDA	;Data High
		NOP
		NOP
		NOP
		NOP
		BCF	PORTA,SCK	;Clock Low
		NOP
		NOP
DELAY2		MOVLW	H'FF		;H'40 WORKS
		MOVWF	COUNT1		;This loop stops data being
LOOP2:		DECFSZ	COUNT1,F	;sent to the slave while it is still
		GOTO	LOOP2		;saving data
		RETURN
;***************************************************
;	ROUTINE TO OUTPUT BYTE
;	entry:-	On Call W=>TXTEMP	TXTEMP holds byte to be output
;	exit:-	CLOCK low
;***************************************************
BYOUT:		MOVWF TXTEMP		;Save W in RXTEMP
		MOVWF	PORTB		;This left for testing purposes

		PAGE1
		BCF	TRISA,SDA	;Data line set for output
		PAGE0
		MOVLW	8
		MOVWF	COUNT		;Count for number of bits sent
TXSTRT:		BCF	PORTA,SDA	;Data Low
		BTFSC	TXTEMP,7	;If Bit to be sent is low skip next instruction
		BSF	PORTA,SDA	;else set Data High
		BSF	PORTA,SCK	;Clock High
		NOP			;Wait
		NOP
		NOP
		NOP
		BCF	PORTA,SCK	;Clock Low
		RLF	TXTEMP,F	;Rotate byte to ready next bit for output
		DECFSZ	COUNT,F		;Decrease bits left count
		GOTO	TXSTRT		;Start again if COUNT is not zero
		RETURN
;******************************************************
;	ROUTINE TO CAPTURE ACKNOWLEDGE BIT
;	entry:-	After  address or data sent
;	exit:-	1)	EFLAG=0 if no error
;		2)	EFLAG=2 if ACK error
;*******************************************************
ACK:		PAGE1
		BSF	TRISA,SDA	;Data line set for input
		PAGE0
		BSF	PORTA,SCK	;Clock High
		NOP			;Wait
		NOP
		NOP
		NOP
		MOVLW	H'20
		MOVWF	COUNT		;Count to wait for ACK
LACK:		MOVF	PORTA,F		;Read in Data pulse
		BTFSS	PORTA,SDA
		GOTO	OUT		;ACK received
ACKERR:		DECFSZ	COUNT,F
		GOTO	LACK		;Try again to obtain ACK
		BSF	EFLAG,1		;ACK not received
OUT:		BCF	PORTA,SCK	;Clock low
		RETURN
;********************************************************************
;	ROUTINE TO SEND MASTER ACKNOWLEDGE BIT
;	entry:-	 On Calling
;	exit:-	CLOCK low
;********************************************************************
MACK:		PAGE1
		BCF	TRISA,SDA	;Data line set for output
		PAGE0
		BCF	PORTA,SDA	;Data line LOW (MACK)
		NOP
		NOP
		NOP
		NOP
		BSF	PORTA,SCK	;Clock high
		NOP
		NOP
		NOP
		NOP
		BCF	PORTA,SCK	;Clock low
		RETURN
;************************************************
;	READ BYTE IN
;	entry	:-On Call
;	exit   	:-RXTEMP holds read byte
;
;************************************************
BYTIN:		PAGE1
		BSF	TRISA,SDA	;Data line set for input
		BCF	TRISA,SCK
		PAGE0
		MOVLW	8
		MOVWF	COUNT		;Initialise loop counter
		MOVLW	0
		MOVWF	RXTEMP		;Clear RXTEMP ready for input
RXSTRT:		RLF	RXTEMP,F	;Rotate ready for next bit
		BCF	RXTEMP,0
		BSF	PORTA,SCK	;Clock High
		BTFSC	PORTA,SDA	;SDA=0 so RXTEMP=>0
		BSF	RXTEMP,0	;SDA=1 so RXTEMP=>1
		BCF	PORTA,SCK	;Clock Low
		DECFSZ	COUNT,F		;Decrement loop counter
		GOTO	RXSTRT
		RETURN
;************************************************************
;		READ CURENT ADDRESS
;		entry	:-CONTRW=0
;		exit	:-RXTEMP holds read byte.
;
;************************************************************
CADRD:		INCF	CONTRW,F	;Control bit set to READ
		CALL	BOUT
		DECF	CONTRW,F	;Control bit reset to WRITE
		BTFSC	EFLAG,1		;Test for ERROR
		RETURN			;If ERROR then exit
		CALL	BYTIN
		CALL	MACK
		CALL	DEND
		RETURN
;*************************************************************
;		SEQUENTIAL READ
;		entry	:-
;		exit	:-RXTEMP will have held all read in bytes
;
;*************************************************************
SEQRD:		MOVLW	H'18		;Number of bytes to read in
		MOVWF	COUNT2		;Initialise loop counter
		CALL 	BOUT		;Send START bit
		BTFSC	EFLAG,1		;Test for ERROR
		RETURN
		CALL	BADDO		;Send High and Low read address in SLAVE
		BTFSC	EFLAG,1		;Test for ERROR
		RETURN
SEQLP:		INCF	CONTRW,F	;Control bit set to READ
		CALL	BOUT		;Send START bit
		DECF	CONTRW,F	;Control bit reset to WRITE
		BTFSC	EFLAG,1		;Test for ERROR
		RETURN
RXAGAIN:	CALL	BYTIN		;Read Byte in
		MOVF	RXTEMP,W
		MOVWF	PORTB

		DECFSZ	COUNT2,F	;Decrement loop counter
		GOTO	SLACK
		RETURN
SLACK:		CALL 	MACK
		GOTO	RXAGAIN
;*************************************************************
		ORG	$150
DTABLE:		ADDWF	PCL,F		;Add W to PC
		RETLW	H'22
		RETLW	H'24
		RETLW	H'26
		RETLW	H'28
		RETLW	H'30
		RETLW	H'32
		RETLW	H'34
		RETLW	H'36
		RETLW	H'38
		RETLW	H'3A
		RETLW	0
		END
