/*
 * File:   hardware.c
 * Author: mhibbett. mike.hibbett@gmail.com, mjhdesigns.com
 *
 * Created on 31 March 2014, 20:53
 *
 * Low level hardware initialisation.
 */

#include <pic18f27j13.h>
#include "hardware.h"

/**************************************************************************
* Function: HardwareInit
*           Low level hardware initialisation.
**************************************************************************
*/
void HardwareInit( void )
{
    // Initially, set all I/O to digital rather than analogue

    ANCON0 = 0xFE;
    ANCON1 = 0x7F;

    // And set the LED pin as an output, LED Off
    LATBbits.LATB5 = 0;
    TRISBbits.TRISB5 = 0; 
}