    ;*************************************************************************
	; file: interrupts.asm
	;		Contains the main interrupt function, and code to do initial
	;		initialisation of the sub-system.
	;*************************************************************************


	;*************************************************************************
	; include files go here
	;*************************************************************************

    include <P18f27J13.INC>


	;*************************************************************************
	; extern directives - to gain access to global functions and data from 
	;					  elsewhere
	;*************************************************************************


	;*************************************************************************
	; global directives - making variables and functions available elsewhere -
	;					  go here
	;*************************************************************************

	global InterruptInit
	global InterruptHandler


	;*************************************************************************
	; Constanst - Symbolic constants and simple macros, defined with the 
	;			  EQU directive, go here.
	;*************************************************************************

	TOGGLE_LED_TIME	EQU .5	; time between toggling the LED - 10s


	;*************************************************************************
	; Definition of RAM based variables follow the udata directive
	;*************************************************************************

	udata

delay_2s		res 1 


	;*************************************************************************
	; code, such as functions and ROM based data tables, follow the code directive
	;*************************************************************************

	code
		
	;*************************************************************************
	; Function: InterruptInit
	;			Initialises the interrupt sub-system.
	;*************************************************************************
InterruptInit:
	movlw	TOGGLE_LED_TIME
	movwf	delay_2s

	return


	;*************************************************************************
	; Function: InterruptHandler
	;			Provides a basic interrupt handler function.
	;*************************************************************************
InterruptHandler:
	bcf 	PIR1, TMR1IF
	
	; only toggle the LED after 5 interrupts
	decfsz	delay_2s
	goto	int_exit	
	
	btg	   	LATB, 5		; toggle the LED on PORTB5
	
	movlw	TOGGLE_LED_TIME
	movwf	delay_2s	; reset the 10s counter
	
int_exit:
	retfie  FAST


	end
