/*
 * File:   main.c
 * Author: mhibbett. mike.hibbett@gmail.com, mjhdesigns.com
 *
 * Created on 25 February 2014, 13:47
 */

#include <stdio.h>
#include <stdlib.h>
#include <pic18.h>
#include "config.h"
#include "timers.h"
#include "interrupts.h"
#include "hardware.h"
#include "lcd.h"

/*
 * 
 */
int main(int argc, char** argv)
{
    // Initialise any low level hardware features
    HardwareInit();

    // Initialise the Interrupt sub-system
    InterruptInit();

    // Initialise the Interrupt sub-system
    Timer0Init();
    Timer1Init();

    // Initialise the LCD ( optional external peripheral )
    LCDInit();

    //
    // Main, user application code starts here
    //

    // User application - start up code
    // Code here is called once following power up

    // Write something to the display
    setPos(LCD_LINE1, 0);
    LCDWrite('H');
    LCDWrite('e');
    LCDWrite('l');
    LCDWrite('l');
    LCDWrite('o');

    do {

        // The sleep instruction will cause the processor to halt, and enter
        // a low power state. Timer1 interrupts will still wake the processor.
        SLEEP();

        // user application - main loop
        // Code here is called either
        //    a) continuously
        //    b) once per interrupt, if the sleep instruction is present


    } while (1);

    // Do not place your own code here - it will not be executed.

    // This code does nothing, but keeps the compiler happy
    return (EXIT_SUCCESS);
}

