/*
 * File:   hardware.c
 * Author: mhibbett. mike.hibbett@gmail.com, mjhdesigns.com
 *
 * Created on 31 March 2014, 20:53
 *
 * Low level hardware initialisation.
 */

#include <pic18.h>
#include "hardware.h"

/**************************************************************************
* Function: HardwareInit
*           Low level hardware initialisation.
**************************************************************************
*/
void HardwareInit( void )
{
    // Disable all ADC functions. We don't use them.
    ANCON0 = 0xFF;
    ANCON1 = 0x1F;

    // LED pin must be an output
    TRISB &= ~0x20;

    // Configure PWM pin on RC3/RP14. Set as input to turn the sound off.
    TRISC |= 0x08;
    RPOR14 = 14;

    // Timer2 on, divide by 16 prescaler
    // Gives 250us at 12MHz/16 input clock to timer2
    CCPTMRS0 = 0;
    CCP1CON = 60;
    CCPR1L = 94;
    PR2 = 188;
    T2CON = 6;
}