﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

/* Program to communicate with the bird camera Video RX system.
   This end sends a byte and then starts a timer so that if no reply is received in 100mSec
   an error message is displayed */
/* Another timer is used to request battery voltage data to be sent every 2 seconds when the
   camera is on */  
namespace Bcamcon1
{
    public partial class Form1 : Form
    {
        byte[] buff = new byte[1]; //byte for transmission.
        byte inByte;               //to hold Byte read from serial port.
        bool dataFlag;             //set when next byte to be  received is a data byte. 
        float battVoltage;         //to hold battery voltage vale (in decimal).
 
        public Form1()
        {
            InitializeComponent();
        }

        private void comsButton_Click(object sender, EventArgs e)
        {
          serialPort1.PortName = "COM1";
          serialPort1.Open();
           if (serialPort1.IsOpen)
            {
             comsButton.Enabled = false;//prevent attempts to re-open port. 
             sendByte(0XAA);  //Send comms test byte (HEX AA)to Video RX.
            }
           
        }

        private void onButton_Click(object sender, EventArgs e)
        {//Send command to turn camera on.
         sendByte(0XC1);     
        }

        private void serialPort1_DataReceived(object sender, System.IO.Ports.SerialDataReceivedEventArgs e)
        {
         inByte = (byte)(serialPort1.ReadByte());       
        //Because serial port handler runs in it's own thread we have to use "invoke" to call "decByte"
        this.Invoke(new EventHandler(decByte));
        }
        private void decByte(object sender, EventArgs e)
        {
         timer1.Enabled = false; //Stop time out timer.
         if (dataFlag == true)
         {// this byte is a data (battery voltage) byte.
             dataFlag = false; // reset data flag.
             battVoltage = (float)(inByte);
             battVoltage = battVoltage / 10;
             battext.Text = battVoltage.ToString();
          return;
         }
         // Not a data byte so it must be a command response.
         switch (inByte)
         {
          case 0XAA://Video RX replied with comms test byte.
                   onButton.Enabled = true;
                   comsButton.Enabled = false;
                   comtxt.Text = "RX COMMS OK";
             break;

          case 0XC0://Camera off command response.
                   offButton.Enabled = false;
                   onButton.Enabled = true;
                   camtext.Text = "Camera OFF";
             break;
            
          case 0XC1://Camera on response.
                   onButton.Enabled = false;
                   offButton.Enabled = true;
                   timer2.Enabled = true; //Start data request timer 
                   camtext.Text = "Camera on";
             break;

          case 0XBD://Send battery data response.
                   dataFlag = true;//set data flag to signal that next byte is a data value.
             break;

        //All of the followings responses are error reports.
          case 0XE0:
                  comtxt.Text = "PC TO RX Framming ERROR";
             break;
          
          case 0XE1:
                  comtxt.Text = "PC TO RX Overrun ERROR";
             break;   
                    
          case 0XE2:
                  comtxt.Text = "TX TO RX Bit ERROR";
             break;

          case 0XE3:
                  comtxt.Text = "TX TO RX Framming ERROR";
             break;

          case 0XE8:
                  comtxt.Text = "BATTERY LOW SHUTDOWN";
             break;

          case 0XE9:
                  comtxt.Text = "RX TO TX Bit ERROR";
             break;
            
          case 0XEA:
                  comtxt.Text = "RX TO TX Framming ERROR";
             break;

          case 0XEB:
             comtxt.Text = "TX Reports Commmand ERROR";
             break;

          default://illegal response byte
             comtxt.Text = "Illegal byte received";
             break;
         }
        }
              
        
            

        private void timer1_Tick(object sender, EventArgs e)
        {
         comtxt.Text = "PC/RX coms time out";
         serialPort1.Close();//so port can be re-opened to re start session
         comsButton.Enabled = true;
        }
       
        private void offButton_Click(object sender, EventArgs e)
        {
         sendByte(0XC0);// send camera off command.
         timer2.Enabled = false;//stop data requests.
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {// closing prog so stop everthing !
            if (serialPort1.IsOpen) serialPort1.Close();
            timer1.Enabled = false;
            timer2.Enabled = false;
        }

        void sendByte(byte outByte)
        {//send a byte to Video RX and start the time out (for a reply)timer.
            if (!serialPort1.IsOpen)
            {
             comtxt.Text = "Com Port not open";
             return;
            }
            buff[0] = outByte;
            serialPort1.Write(buff, 0, 1);
            timer1.Enabled = true;
        }

        private void timer2_Tick(object sender, EventArgs e)
        {
            sendByte(0xBD);//request battery data
        }

        private void comtxt_TextChanged(object sender, EventArgs e)
        {

        }

        
        
        
  }
    
}
