


; remote controlled input selection for 3-input audio (stereo)
; added immunity to interference and full switch operation under IR interference 

; CPU configuration
	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F88
	#include p16f88.inc


;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_OFF & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _XT_OSC

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF
; Define variables at memory locations

; EEPROM
EEPROM0		equ	H'40'	; stored remote selection (TV,SAT1, SAT2)
EEPROM1		equ	H'41'	; input selection (input1, input2, input3)

; RAM
; bank 0 

REMOTE_M	equ	H'20'	; remote control input ms byte
REMOTE_L	equ	H'21'	; remote control input LS byte
REM_FLG		equ	H'22'	; flag to indicate current remote control sequencing 
REM_CNT		equ	H'23'	; interrupt count for polling remote control signal
REM_COD		equ	H'24'	; remote control bit counter mode.
TOGGLE		equ	H'25'	; remote control toggle bit
TG_BIT		equ	H'26'	; toggle bit stored flag
VALUE_1		equ	H'27'	; delay value
VALUE_2		equ	H'28'	; delay value
TEMP_R		equ	H'29'	; remote code temporary
FLG_HL		equ	H'2A'	; high or low remote control sign
TIMER1		equ	H'2B'	; timer least significant byte
TIMER2		equ	H'2C'	; timer most significant byte
SLEEPT		equ	H'2D'	; sleep timer
CODE_SOURCE	equ	H'2E'	; code source (TV, SAT1, SAT2)
INPUT		equ	H'2F'	; input
B_TEMP		equ	H'30'	; PORTB stored level
TEMP		equ	H'31'	; temporary
STORE1		equ	H'32'	; remote storage ms byte
STORE2		equ	H'33'	; remote storage ls byte
VALUE3		equ	H'34'	; delay loop
	
; all banks ram
W_TMP		equ	H'70'	; temporary store for w in interrupt
STATUS_TMP	equ	H'71'	; temporary store of status in interrupt 


	ORG     2140		; preprogram EEPROM locations
	DE		D'0'		; set at 00 (TV)
	DE		D'1'		; input selection 1 	

; define reset and interrupt vector start addresses

	org		0			; start at address 0000h
	goto	MAIN		; normal service routines from Reset vector
	org     4			; interrupt vector 0004h, start interrupt routine here


; ************************************************************************************	
; start interrupt by saving w and status registers before altered by interrupt routine

INTERRUPT
; check interrupt source	

	btfsc	INTCON,INTF	; interrupt for RB0
	bcf		INTCON,INTF	
	btfss	INTCON,TMR0IF	; TMRO overflow interrupt flag
	retfie 				; return when not timer 0 overflow
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp  
	bcf		STATUS,RP0	; select memory bank 0
	bcf		STATUS,RP1

; adjust interrupt rate with counter

COUNTER
	movlw	D'207'		; freq is 4MHz/4/2/50. = 100us
	addwf	TMR0,f		; add to timer register and takes 2 cycles to start counting
	bcf		INTCON,TMR0IF	; clear TMRO interrupt flag

; increase timer

	incfsz	TIMER1,f	; increase value least significant byte
	goto	REMST		; start remote control
	incf	TIMER2,f	; increase ms byte

; check if RB0 has gone low for start of remote control sequence

REMST
RM_SQ
	btfsc	REM_FLG,0	; has remote control sequence started		
	goto	REM_SEQ
	btfsc	PORTB,0		; is RB0 low 
	goto	RECLAIM
	bsf		REM_FLG,0	; set beginning of remote control flag
	
	movlw	D'22'		; initial time period to wait till next start bit
	movwf	REM_CNT
	movlw	D'13'		; shift register counter
	movwf	REM_COD
	bsf		REMOTE_L,0	; set first bit in remote control sequence
	clrf	FLG_HL		; clear bit 1 in high low flag
	bsf		REM_FLG,7	; start bit flag set	
;	bsf		PORTB,4		; acknowledge LED driver
	goto 	RECLAIM

REM_SEQ
	btfsc	REM_FLG,1	; has it finished
	goto	RECLAIM
	decfsz	REM_CNT,f	; decrease interrupt counter for timing
	goto	CKEDGE		; check if change in level
	bcf		REM_FLG,7	; clear start bit flag
	movlw	D'18'		; 18 x 100us = 1.8ms or period between valid bits
	movwf	REM_CNT
	rlf		REMOTE_L,f	; least sig byte in remote control code sequence
	rlf		REMOTE_M,f	; most sig byte 
	movf	PORTB,w		; check bit 0 portB
	andlw	B'00000001'	; mask out bits except bit 0
	movwf	FLG_HL		; place in flag
	btfsc	PORTB,0		; check if high or low
	goto	HI			; high so clear
	bsf		REMOTE_L,0	; if low set this bit
;	bsf		PORTB,4		; if high set acknowledge LED
	goto	BY_HI		; bypass high
HI	
	bcf		REMOTE_L,0	; clear 0 bit
;	bcf		PORTB,4		; acknowledge 
BY_HI		
	decfsz	REM_COD,f	; decrease shift register count
	goto	RECLAIM
	bsf		REM_FLG,1	; set end of remote control decoding flag
	goto	RECLAIM

; align change in level (edge detect) with REM_CNT counter
 
CKEDGE
	btfsc	REM_FLG,7	; start bit flag bypass edge detect as AGC level setting
	goto	RECLAIM
	movlw	B'00000001'	; select bit 0 for PORTB,0
	andwf	PORTB,w		; bit 0
	xorwf	FLG_HL,w	; compare PORTB,0 with FLAG (previous level)		
	btfsc	STATUS,Z	; Z=1 if zero then no change
	goto	RECLAIM		; no change 
	movlw	B'00000001'	; select bit 0 for PORTB,0
	andwf	PORTB,w		; bit 0 select 
	movwf	FLG_HL		; reload new level
	movlw	H'3'		; count of 3 for REM_CNT
	subwf	REM_CNT,w	; is REM_CNT larger or equal to 3
	btfss	STATUS,C
	goto	RECLAIM		; smaller than 3 
	movf	REM_CNT,w
	sublw	H'6'		; check if 6 or less
	btfss	STATUS,C
	goto	RECLAIM		; larger than 6 
	movlw	H'4'
	movwf	REM_CNT		; set REM_CNT to 4 to align with change in level
	
; end of interrupt reclaim w and status 

RECLAIM
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt

;********************************************************************************************** 
  
; RESET		
; Set ports A & B

MAIN
	movlw	D'10'
	movwf	SLEEPT		; time before sleep
	clrf	TG_BIT		; clear toggle bit stored flag
	clrf	REM_CNT		; remote control polling counter
	clrf	REM_FLG		; remote control flag status
	clrf	CODE_SOURCE	; remote control encoding 0=TV, 1=SAT1, 2=SAT2
	clrf	STORE1		; remote storage
	clrf	STORE2

; set inputs/outputs
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'11100001'	; Inputs/outputs
	movwf	TRISB		; port B data direction register
	movlw	B'11000000'	; 
	movwf	OPTION_REG	; TMRO prescaler is 2, PORTB pullups disabled, RB0 interrupt on 0
	movlw   B'00100011'	; Inputs/ outputs 
	movwf   TRISA		; port A data direction register

; analog inputs, A/D
	movlw	B'00000000'	; no analog inputs
	movwf	ANSEL

	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'11100001'	; 
	movwf	PORTB		; LEDs off (LED1-LED4)

	movlw	B'00000000'	; Q1, Q2 and Q3 off
	movwf	PORTA

; Code selection is made with a switch closed at power up		
; check if S1, S2 or S3 closed on the front panel as connected to RB7, RB6 and RB5 respectively.
	call	DELAY		; 1s
	movf	PORTB,w
	andlw 	B'11100000'	; look at RB5 to RB7
	xorlw	B'11100000'	; if equal, then no switches are closed at power up
	btfsc	STATUS,Z	
	goto	READ_CODE_SELECT

; check which switch is low
	clrw				; set w low as default
;	btfss	PORTB,5		; S3. If low, set a 0 for TV	
;	movlw	D'0'	
	btfss	PORTB,7		; S1. If low, set 1 for SAT1
	movlw	D'1'
	btfss	PORTB,6		; S2. If low, set 2 for SAT2
	movlw	D'2'
	movwf	CODE_SOURCE	; sets TV, SAT1 or SAT2
	movlw	EEPROM0
	call	EEREAD		; sets EEADR
	movf	CODE_SOURCE,w
	call	EEWRITE

 ; Wait for switches to open
WAIT_OPEN
	movf	PORTB,w
	andlw 	B'11100000'	; look at RB5 to RB7
	xorlw	B'11100000'	; if equal, then switches are open
	btfsc	STATUS,Z	
	goto	READ_CODE_SELECT
	call	DELAY		; 1s
	bsf		PORTB,4		; ack
	call	DELAY
	bcf	 	PORTB,4
	call	DELAY
	goto	WAIT_OPEN
	
READ_CODE_SELECT
	bcf		INTCON,RBIF	; clear port change interrupt flag

	movlw	EEPROM0
	call	EEREAD		; sets EEADR
	movwf	CODE_SOURCE	; remote control source (TV, SAT1, SAT2)

READ_INPUT_SELECT
; read input selection (input1, inut2 or input3)
	movlw	EEPROM1
	call	EEREAD
	movwf	INPUT

; set outputs for initial selected input

; Check for input 1
	movf	INPUT,w
	xorlw	D'01'
	btfsc	STATUS,Z
	goto	INPUT1
; check for input 2
	movf	INPUT,w
	xorlw	D'02'
	btfsc	STATUS,Z
	goto	INPUT2
; check for input 3	
	movf	INPUT,w
	xorlw	D'03'
	btfsc	STATUS,Z
	goto	INPUT3

INPUT1
; Q1 on, LED1 on
	movlw	B'00000010'
	movwf	PORTB
	movlw	B'00000100'
	movwf	PORTA
	goto	INTERRUPT_ENABLE

INPUT2
; Q2 on LED2 on
	movlw	B'00000100'
	movwf	PORTB
	movlw	B'00001000'
	movwf	PORTA
	goto	INTERRUPT_ENABLE

INPUT3
; Q3 on LED3 on
	movlw	B'00001000'
	movwf	PORTB
	movlw	B'00010000'
	movwf	PORTA
;	goto	INTERRUPT_ENABLE

; interrupt enable 
INTERRUPT_ENABLE

	bsf		INTCON,TMR0IE; set interrupt enable for TMR0 
	bsf		INTCON,GIE	; set global interrupt enable for above
	
; decode remote control signal
; delay

CK_AGN
	
	movf	SLEEPT,w	; sleep timing
	btfsc	STATUS,Z
	goto	T_SET
	decf	SLEEPT,f	; decrease until zero
T_SET
	movlw	D'100'		; set delay period of about 120ms between codes
	movwf	VALUE_1		; VALUE_1 = w
	movlw	D'255'		; set delay period value 2 
LP_1
	movwf	VALUE_2		; VALUE_2 = w
LP_2
	decfsz	VALUE_2,f	; decrease VALUE_2, skip if zero
	goto 	LP_2

; check for pressed switch

	btfsc	INTCON,RBIF
	goto	SWITCH

; check during delay for remote control entered flag
	
	btfsc	REM_FLG,1	; is remote control entered flag set
	goto	CODE_D
	
	decfsz	VALUE_1,f	; decrease VALUE_1, skip if zero
	goto	LP_1

; remote control decoding
	
	btfsc	REM_FLG,1	; is remote control entered flag set
	goto	CODE_D		; check codes
	
	movf	SLEEPT,w	; sleep timing
	btfss	STATUS,Z	; if zero then sleep	
	goto	CK_AGN

	bcf		PORTB,4		; ack.
	bcf		INTCON,GIE	; interrupt enable off so after sleep instructions continue on
						; rather than to interrupt vector.
	btfsc	INTCON,INTF	; interrupt flag for RB0
	goto	BY_SLEEP
	btfsc	INTCON,RBIF	; port change interrupt flag
	goto	BY_SLEEP
	bsf		INTCON,INTE	; set interrupt enable for RB0
	bsf		INTCON,RBIE	; set port change interrupt enable 

	sleep				; sleep mode
	nop
BY_SLEEP
	bcf		INTCON,INTE	; disable interrupt for RB0
	bcf		INTCON,RBIE	; bcf clear port change interrupt enable 

; check wake from sleep source
	btfss	INTCON,INTF	; PORTB,0 
	goto	SW_CHANGE
; remote control input
	bcf		INTCON,INTF	; flag cleared
	bsf		INTCON,GIE	; interrupt enable
	clrf	REM_FLG		; clear any remote control flags
	goto	CK_AGN

SWITCH
	bcf		PORTB,4		; acknowledge LED off
	clrf	REM_FLG		; clear any remote control flags
SW_CHANGE
	btfss	INTCON,RBIF
	goto	CK_AGN
	bcf		INTCON,RBIF	; clear port change interrupt flag

; read switches S1, S2, S3

; Input selection is with a switch closed		
; check if S1, S2 or S3 closed 
	movlw	D'25'
	call	DELAYT		; 0.1s
	movf	PORTB,w
	movwf	B_TEMP

; check which switch is low
CK_SWS
	clrw
	btfss	B_TEMP,7	; S1.  	
	movlw	D'1'	
	btfss	B_TEMP,6	; S2. 
	movlw	D'2'
	btfss	B_TEMP,5	; S3. 
	movlw	D'3'
	movwf	TEMP
	movf	TEMP,w		; if zero no switches closed so use original INPUT value 
	btfsc	STATUS,Z
	goto	SET_SELECT	; re-drive output
	movwf	INPUT		; sets input (1, 2 or 3)
	bcf		INTCON,GIE	; disable interrupt
	movlw	EEPROM1
	call	EEREAD		; sets EEADR
	movf	INPUT,w
	call	EEWRITE

SET_INPUT_SELECT
; read input selection (input1, inut2 or input3)
	movlw	EEPROM1
	call	EEREAD
	movwf	INPUT
	
; set outputs for initial selected input
SET_SELECT
; Check for input 1
	movf	INPUT,w
	xorlw	D'01'
	btfsc	STATUS,Z
	goto	INPUT1X
; check for input 2
	movf	INPUT,w
	xorlw	D'02'
	btfsc	STATUS,Z
	goto	INPUT2X
; check for input 3	
	movf	INPUT,w
	xorlw	D'03'
	btfsc	STATUS,Z
	goto	INPUT3X

INPUT1X
; Q1 on, LED1 on
	movlw	B'00000010'
	movwf	PORTB
	movlw	B'00000100'
	movwf	PORTA
	goto	WAIT_OPEN1

INPUT2X
; Q2 on LED2 on
	movlw	B'00000100'
	movwf	PORTB
	movlw	B'00001000'
	movwf	PORTA
	goto	WAIT_OPEN1

INPUT3X
; Q3 on LED3 on
	movlw	B'00001000'
	movwf	PORTB
	movlw	B'00010000'
	movwf	PORTA
;	goto	WAIT_OPEN1

; Wait for switches to open
WAIT_OPEN1
	movf	PORTB,w
	andlw 	B'11100000'	; look at RB5 to RB7
	xorlw	B'11100000'	; if equal, then switches are open
	btfss	STATUS,Z	
	goto	WAIT_OPEN1

INPUT_CYC
	movlw	D'25'
	call	DELAYT		; 0.1s
	bcf		INTCON,RBIF	; clear port change interrupt flag	
	goto	CK_AGN


; Philips RC5 code for infra red transmission (also used with Marantz, Grundig and Loewe)
; Comprises 2 start bits, 1 toggle bit (alternates high or low on successive same key press)
; 5-system address bits and 6 command bits. Data stream starts with the start bits. 
; biphase encoding with high to a low transition = a low and low to high = high
; each bit transmitted at 1.778ms rate. Whole code at 24.889ms and next code starts 113.778ms
; later. Can decode by detecting first start bit then waiting 1.778ms + 444.5us for next start
; bit. Successive bits are 1.778ms apart. Total of 14 bits. 

;Address
;0 TV1
;1 TV2
;2 Videotext
;3 Expansion for TV1 and TV2
;4 Laser vision player
;5 VCR1
;6 VCR2
;7 Reserved
;8 SAT1
;9 Expansion for VCR1 and VCR2
;10 SAT2
;11 Reserved
;12 CD Video
;13 Reserved
;14 CD Photo
;15 Reserved
;16 Audio preamplifier1
;17 Tuner
;18 Analogue cassetter recorder
;19 Audio Preamp2
;20 CD
;21 Audio rack
;22 Audio Satellite
;23 DCC Recorder
;24 Reserved
;25 Reserved
;26 Writable CD
;27-31 Reserved

;Keycode commands 
;0 0
;1 1
;2 2
;3 3
;4 4
;5 5
;6 6
;7 7
;8 8
;9 9
;16 Volume +
;17 Volume -
;18 Brightness +
;19 Brightness -
;20 Colour saturation +
;21 Colour Saturation -
;22 Bass +
;23 Bass -
;24 Treble +
;25 Treble -
;26 Balance right
;27 balance left
;63 System select
;71 Dim local display

; Special commands
;10 1/2/3 digits /10
;11 Freq/prog/ch11
;12 standby
;13 Mute
;14 Personal preference
;15 Display
;28 Contrast +
;29 Contrast -
;30 Search +
;31 Tint/hue
;32 CH/prog +
;33 CH/prog -
;34 Alternate CH

;37 stereo/mono
;39 Tint/hue +
;48 Pause
;50 rewind
;52 wind
;53 play
;54 stop
;55 record

; compare with address code out if invalid clear REM_FLG
; if valid check command bits and ls 2 address bits then clear REM_FLG
; but first check which code is selected 
	
CODE_D
	movlw	D'10'
	movwf	SLEEPT		; time before sleep

; compare remote code with last received. Requires 2 matching consecutive codes before an an action occurs
	movf	REMOTE_M,w	; most significant remote code 
	andlw	B'00110111'	; mask out bit 7 and 6 and toggle bit
	movwf	TEMP
	movf	STORE1,w
	andlw	B'00110111' ; mask bit 6 and 7
	xorwf	TEMP,w
	btfsc	STATUS,Z
	goto	NEXT_BYTE	; the same codes so check next code byte

TRANSFER ; transfer values when not the same
	
	movf	REMOTE_M,w	; transfer codes
	movwf	STORE1	
	movf	REMOTE_L,w
	movwf	STORE2
	goto	CLR_RMF

; compare next byte	
NEXT_BYTE
; compare remote code with last received. Requires 2 matching consecutive codes before an an action occurs
	movf	REMOTE_L,w	; most significant remote code 
	xorwf	STORE2,w
	btfss	STATUS,Z
	goto	TRANSFER	; not the same values

; matching consecutive codes
; check code source
	movf	CODE_SOURCE,w ; TV, SAT1, SAT2
	btfsc	STATUS,Z
	goto	TV_1
	xorlw	D'1'
	btfsc	STATUS,Z
	goto	SAT1		
	goto 	SAT_2

; code for television (TV1)

TV_1
	movf	REMOTE_M,w	; most significant remote code 
	andlw	B'00110111'	; mask out bit 7 and 6 and toggle bit
	
	xorlw	B'00110000'	; compare with start bits and ms 3-bits of address
	btfss	STATUS,Z	; if zero then matching
	goto	CLR_RMF		; clear remote flag

; check RA0,RA1 selection
	movf	PORTA,w
	andlw	B'00000011'
	movwf	TEMP
	btfsc	STATUS,Z	; when zero, 1,2,3 input numbering
	goto	TV_123
	movf	TEMP,w
	xorlw	D'1'
	btfsc	STATUS,Z	; when equal to 1, use 4,5,6 input numbering
	goto	TV_456
	movf	TEMP,w
	xorlw	D'2'
	btfsc	STATUS,Z	; when equal to 2, use 7,8,9 input numbering
	goto	TV_789
;	movf	TEMP,w
;	xorlw	D'3'
;	btfsc	STATUS,Z	; when equal to 1, use 1,2,3 input numbering
;	goto	TV_123

; input 1,2,3
TV_123
	movf	REMOTE_L,w
	xorlw	B'00000001'	; bits 0-5 keycode (1), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG1
	movf	REMOTE_L,w
	xorlw	B'00000010'	; bits 0-5 keycode (2), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG2
	movf	REMOTE_L,w
	xorlw	B'00000011'	; bits 0-5 keycode (3), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG3
	goto	CLR_RMF

; input 4,5,6
TV_456
	movf	REMOTE_L,w
	xorlw	D'4'		; bits 0-5 keycode (4), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG1
	movf	REMOTE_L,w
	xorlw	D'5'		; bits 0-5 keycode (5), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG2
	movf	REMOTE_L,w
	xorlw	D'6'		; bits 0-5 keycode (6), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG3
	goto	CLR_RMF

; input 7,8,9
TV_789
	movf	REMOTE_L,w
	xorlw	D'7'		; bits 0-5 keycode (7), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG1
	movf	REMOTE_L,w
	xorlw	D'8'		; bits 0-5 keycode (8), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG2
	movf	REMOTE_L,w
	xorlw	D'9'		; bits 0-5 keycode (9), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG3
	goto	CLR_RMF

; satellite
	
SAT1
	movf	REMOTE_M,w	; most significant remote code 
	andlw	B'00110111'	; mask out bit 7 and 6 and toggle bit
	
	xorlw	B'00110010'	; compare with start bits and ms 3-bits of address
	btfss	STATUS,Z	; if zero then matching
	goto	CLR_RMF		; clear remote flag


; check RA0,RA1 selection
	movf	PORTA,w
	andlw	B'00000011'
	movwf	TEMP
	btfsc	STATUS,Z	; when zero, 1,2,3 input numbering
	goto	SAT1_123
	movf	TEMP,w
	xorlw	D'1'
	btfsc	STATUS,Z	; when equal to 1, use 4,5,6 input numbering
	goto	SAT1_456
	movf	TEMP,w
	xorlw	D'2'
	btfsc	STATUS,Z	; when equal to 2, use 7,8,9 input numbering
	goto	SAT1_789
;	movf	TEMP,w
;	xorlw	D'3'
;	btfsc	STATUS,Z	; when equal to 3, use 1,2,3 input numbering
;	goto	SAT1_123	
	
; input 123
SAT1_123
	movf	REMOTE_L,w	;  least significant remote code
	xorlw	B'00000001'	; bits 0-5 keycode (1), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG1
	movf	REMOTE_L,w
	xorlw	B'00000010'	; bits 0-5 keycode (2), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG2
	movf	REMOTE_L,w
	xorlw	B'00000011'	; bits 0-5 keycode (3), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG3
	goto	CLR_RMF

; input 4,5,6
SAT1_456
	movf	REMOTE_L,w
	xorlw	D'4'		; bits 0-5 keycode (4), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG1
	movf	REMOTE_L,w
	xorlw	D'5'		; bits 0-5 keycode (5), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG2
	movf	REMOTE_L,w
	xorlw	D'6'		; bits 0-5 keycode (6), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG3
	goto	CLR_RMF

; input 7,8,9
SAT1_789
	movf	REMOTE_L,w
	xorlw	D'7'		; bits 0-5 keycode (7), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG1
	movf	REMOTE_L,w
	xorlw	D'8'		; bits 0-5 keycode (8), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG2
	movf	REMOTE_L,w
	xorlw	D'9'		; bits 0-5 keycode (9), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG3
	goto	CLR_RMF

; satellite
SAT_2
	movf	REMOTE_M,w	; most significant remote code 
	andlw	B'00110111'	; mask out bit 7 and 6 and toggle bit

	xorlw	B'00110010'	; compare with start bits and ms 3-bits of address
	btfss	STATUS,Z	; if zero then matching
	goto	CLR_RMF		; clear remote flag
	
; check RA0,RA1 selection
	movf	PORTA,w
	andlw	B'00000011'
	movwf	TEMP
	btfsc	STATUS,Z	; when zero, 1,2,3 input numbering
	goto	SAT2_123
	movf	TEMP,w
	xorlw	D'1'
	btfsc	STATUS,Z	; when equal to 1, use 4,5,6 input numbering
	goto	SAT2_456
	movf	TEMP,w
	xorlw	D'2'
	btfsc	STATUS,Z	; when equal to 2, use 7,8,9 input numbering
	goto	SAT2_789
;	movf	TEMP,w
;	xorlw	D'3'
;	btfsc	STATUS,Z	; when equal to 3, use 1,2,3 input numbering
;	goto	SAT2_123	
	
; input 123
SAT2_123
; input
	movf	REMOTE_L,w	; least sig remote code
	xorlw	B'10000001'	; bits 0-5 keycode (1), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG1
	movf	REMOTE_L,w
	xorlw	B'10000010'	; bits 0-5 keycode (2), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG2
	movf	REMOTE_L,w
	xorlw	B'10000011'	; bits 0-5 keycode (3), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG3
	goto	CLR_RMF

; input 4,5,6
SAT2_456
	movf	REMOTE_L,w
	xorlw	D'132'		; bits 0-5 keycode (4), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG1
	movf	REMOTE_L,w
	xorlw	D'133'		; bits 0-5 keycode (5), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG2
	movf	REMOTE_L,w
	xorlw	D'134'		; bits 0-5 keycode (6), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG3
	goto	CLR_RMF

; input 7,8,9
SAT2_789
	movf	REMOTE_L,w
	xorlw	D'135'		; bits 0-5 keycode (7), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG1
	movf	REMOTE_L,w
	xorlw	D'136'		; bits 0-5 keycode (8), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG2
	movf	REMOTE_L,w
	xorlw	D'137'		; bits 0-5 keycode (9), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG3
	goto	CLR_RMF


INPUT_CHNG1
; change input selection to 1
	movlw	D'1'
	goto	INPUT_VAL

INPUT_CHNG2
; change input selection to 2
	movlw	D'2'
	goto	INPUT_VAL

INPUT_CHNG3
; change input selection to 3
	movlw	D'3'
;	goto	INPUT_VAL

INPUT_VAL
	movwf	INPUT		; sets input (1, 2 or 3)
	bsf		PORTB,4		; ack LED on
; store value
	bcf		INTCON,GIE	; disable interrupt
	movlw	EEPROM1
	call	EEREAD		; sets EEADR
	movf	INPUT,w
	call	EEWRITE
	bsf		INTCON,GIE	; interrupt enable

 ; read input selection (input1, input2 or input3)
	movlw	EEPROM1
	call	EEREAD
	movwf	INPUT

; set outputs for initial selected input

; Check for input 1
	movf	INPUT,w
	xorlw	D'01'
	btfsc	STATUS,Z
	goto	INPUT1Y
; check for input 2
	movf	INPUT,w
	xorlw	D'02'
	btfsc	STATUS,Z
	goto	INPUT2Y
; check for input 3	
	movf	INPUT,w
	xorlw	D'03'
	btfsc	STATUS,Z
	goto	INPUT3Y

INPUT1Y
; Q1 on, LED1 on
	movlw	B'00000010'
	movwf	PORTB
	movlw	B'00000100'
	movwf	PORTA
	goto	ACK_LED1

INPUT2Y
; Q2 on LED2 on
	movlw	B'00000100'
	movwf	PORTB
	movlw	B'00001000'
	movwf	PORTA
	goto	ACK_LED1

INPUT3Y
; Q3 on LED3 on
	movlw	B'00001000'
	movwf	PORTB
	movlw	B'00010000'
	movwf	PORTA
;	goto	ACK_LED1

ACK_LED1	

; flash ACK LED
	movlw	D'10'
	movwf	VALUE3		; number of flashes
FLASH_CYCLE
	movlw	D'20'		; flash period
LED_PERIOD
	call	DELAYT
	btfss	PORTB,4		; ACK LED
	goto	SET_ACK
	bcf		PORTB,4
	goto	FLASH
SET_ACK
	bsf		PORTB,4
FLASH
	decfsz	VALUE3,f
	goto	FLASH_CYCLE

CLR_RMF
	bcf		PORTB,4		; acknowledge LED off
	movlw	D'6'
	call	DELAYT
	clrf	REM_FLG		; remote flag cleared
	goto	CK_AGN

; **********************************************************

; subroutines

; delay subroutine
DELAY	
	movlw	D'255'		; 
DELAYT
	movwf	VALUE_1		; VALUE_1 = w
LP_X
	movlw	D'255'		; set delay period value 2 
	movwf	VALUE_2		; VALUE_2 = w
LP_Y
	decfsz	VALUE_2,f	; decrease VALUE_2, skip if zero
	goto 	LP_Y
	decfsz	VALUE_1,f	; decrease VALUE_1, skip if zero
	goto	LP_X
	return
	
; subroutine to read EEPROM memory 

EEREAD
	bsf 	STATUS,RP1	; select memory bank 2
	movwf 	EEADR		; indirect special function register
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,RD	; read EEPROM
	bcf 	STATUS,RP0	; select memory bank 2
	movf	EEDATA,w	; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	return

; subroutine to write to EEPROM

; EEPROM write 

EEWRITE
	bsf		STATUS,RP1	; select bank 2
	movwf	EEDATA		; data register
	bsf		STATUS,RP0	; bank 3
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,WREN	; enable write
	movlw	H'55'		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	H'AA'		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit
WRITE1	

	btfsc	EECON1,WR	; skip if write complete WR=0 when write complete
	goto 	WRITE1		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP0
	bcf		STATUS,RP1	; bank 0 
	return				; value written
	
	end


	
