                                ;Listing 4.8

        include "16F627.PLC"    ; Defines PLC instructions

                                ; First section  configure up/down counter
        ld      PORTA, 0        ; Read Port A bit 0 (Slower input)
        or      PORTA,1         ; OR with Port A bit 1 (Faster input)
        and     OSCL,1          ; Clock input to up/down counter
        ctr_ud  0, d'31', PORTA, 1, PORTA, 2
                                ; Up/down counter 0, final value = 31
                                ; Direction = Port A bit 1
                                ; Reset = Port A bit 2
                                ; Up/down counter working register = CUD0

                                ; Second section  configure PWM signal
        puti    d'32', AUX1     ; Put 32 into register AUX1 (= period)
        pwmr    0, CUD0, AUX1   ; Create PWM waveform based on CUD0 and AUX1

                                ; Third section  display PWM waveform
        ld      PWMR, 0         ; Load PWM status bit
        out     PORTB, 0        ; Output waveform to bit 0 of Port B

        endp                    ; Marks end of PLC program