/****************************************************************************
*
*   Module:     pic24video.c
*   Author:     Mike Hibbett
*   Date:       22/2/09
*   Purpose:    Header file for the PIC24 video library.
*                
****************************************************************************/


extern unsigned short frameBuffer[];

#define VID_WIDTH_PIXELS 208   // 13, 16 bit words in each line
#define VID_DEPTH_PIXELS 240   // covering 240 lines through duplication

#define PIC24VIDEO_SETPIX(x,y)     frameBuffer[((y)*(VID_WIDTH_PIXELS/16)) + ((x) / 16)] |= (0x8000 >> ((x) & 0x0F) )
#define PIC24VIDEO_CLRPIX(x,y)     frameBuffer[((y)*(VID_WIDTH_PIXELS/16)) + ((x) / 16)] &= ~(0x8000 >> ((x) & 0x0F) )

void PIC24VideoInit(void);
void PIC24VideoWaitFrame(void);
void PIC24VideoCls(void);
void PIC24VideoDrawRect( unsigned char xtl, unsigned char ytl, unsigned char xbr, unsigned char ybr );
void PIC24VideoClearRect( unsigned char xtl, unsigned char ytl, unsigned char xbr, unsigned char ybr );
void PIC24VideoDelayms( unsigned int delayTime );
void PIC24VideoDelays( unsigned int delayTime );
void PIC24VideoPlayNote( unsigned int freq, unsigned char duration );
void PIC24VideoStopNote( void );
void PIC24VideoPutChar(unsigned char x, unsigned char y, unsigned char ch);
void PIC24VideoPutStr(unsigned char x, unsigned char y, char *str);
