; TEACHINB01.ASM 07JUN07 - TEACH IN 2008 PT2
; turn on individual LEDs seperately

           include p16f628.inc

           __config  $3F30    ; internal 4MHz oscillator

	   CBLOCK h'20'
CLKCNT
	   ENDC

           ORG 0              ; reset vector
           goto STARTIT
           ORG 4              ; Interrupt vector address
           goto STARTIT
           ORG 5              ; PIC program memory location at which to start 

STARTIT:   BSF STATUS,5
           movlw b'00000000'  ; all PORTB as output
           movwf TRISB        ; data direction register for PORTB
           movlw b'10000111'  ; timer 1:256, pull-ups off (bit 7 = 1)
           movwf OPTION_REG
           BCF STATUS,5

	   call DELAY
           bsf PORTB,0        ; turn on LED at RB0
	   call DELAY
           bsf PORTB,1        ; turn on LED at RB1
	   call DELAY
           bsf PORTB,2        ; turn on LED at RB2
	   call DELAY
           bsf PORTB,3        ; turn on LED at RB3
	   call DELAY
           bsf PORTB,4        ; turn on LED at RB4
	   call DELAY
           bsf PORTB,5        ; turn on LED at RB5
	   call DELAY
           bsf PORTB,6        ; turn on LED at RB6
	   call DELAY
           bsf PORTB,7        ; turn on LED at RB7

PROGEND:   nop
           goto PROGEND

; ***********



DELAY      movlw 25                 ; set delay counter to 25
           movwf CLKCNT            ; (for 1/25th sec x 5)
           clrf INTCON             ; clear interupt flag
DELAY2                             ; 
           btfss INTCON,2          ; has a timer time-out been detected?
           goto DELAY2             ; no
           bcf INTCON,2            ; yes
           decfsz CLKCNT,F         ; dec counter, is it zero?
           goto DELAY2             ; no
           return                  ; yes

        END
