; TEACHING01.ASM 02FEB08 - TEACH IN 2008 PT7
; demo for using banks & blocks

#DEFINE BANK0 BCF STATUS,5  ; clear STATUS bit 5 (RP0)
#DEFINE BANK1 BSF STATUS,5  ; set   STATUS bit 5 (RP0)
#DEFINE BLOCK0 BCF STATUS,7 ; clear STATUS bit 7 (IRP)
#DEFINE BLOCK1 BSF STATUS,7 ; set   STATUS bit 7 (IRP)

           include p16f628.inc

           __config  h'3F30'    ; internal 4MHz oscillator

        CBLOCK h'20'
VALUE
LOOP
LOOPA
STORE
RSLINE
FSRSTORE
CLKCNT

DCOUNT
DSIGN 
DIGIT1
DIGIT2
DIGIT3
DIGIT4
DIGIT5
DIGIT6
DIGIT7
DIGIT8
DIGIT9
DIGIT10
REGA0
REGA1
REGA2
REGA3
MTEMP
MCOUNT

BANKVAL
TESTA
MEMBANK0

        ENDC

MEMBANK1 EQU H'20'     ; data memory for Bank 1 (at h'A0')

MEMBANK2 EQU H'20'     ; data memory for Bank 2 (at h'120')

MEMBANK3 EQU H'20'     ; data memory for Bank 3 (at h'1F0')

           ORG 0              ; reset vector
           goto STARTIT
           ORG 4              ; Interrupt vector address
           goto STARTIT
           ORG 5              ; PIC program memory location at which to start 

           include LCDheader.inc

STARTIT    clrf PORTA          ; clear PORTA's outputs if any
           clrf PORTB          ; clear PORTB's output if any
           movlw 7             ; needed by some PICs, including PIC16F628
           movwf CMCON         ; so that PORTA is treated as digital port

           BANK1               ; set for Bank 1
           CLRF TRISB          ; set PORTB for all outputs
           movlw 255           ; set PORTA for all inputs
           movwf TRISA
           movlw b'10000110'   ; timer 1:128, pull-ups off (bit 7 = 1)
           movwf OPTION_REG
           BANK0               ; set for Bank 0

           call PAUSIT
           call LCDSET
           call PAUSIT

           call SAMPLE1

here:      nop
           goto here

; *********

PAUSIT     movlw 5             ; set delay counter
           movwf CLKCNT        ; 
           clrf INTCON         ; clear interupt flag
PAUSE                          ; initial wait before setting up LCD
           btfss INTCON,2      ; has a timer time-out been detected?
           goto PAUSE          ; no
           bcf INTCON,2        ; yes
           decfsz CLKCNT,F     ; dec counter, is it zero?
           goto PAUSE          ; no
           return              ; yes

PAUSIT2    movlw 25            ; set delay counter
           movwf CLKCNT        ; 
           clrf INTCON         ; clear interupt flag
PAUSE2                         ; 
           btfss INTCON,2      ; has a timer time-out been detected?
           goto PAUSE2         ; no
           bcf INTCON,2        ; yes
           decfsz CLKCNT,F     ; dec counter, is it zero?
           goto PAUSE2         ; no
           return              ; yes

           include LCDroutines.inc

; *********** PART OF PETER HEMSLEY'S 32-BIT MATHS ROUTINES *******

;*** SIGNED BINARY TO DECIMAL ***
;REGA -> DIGITS 1 (MSD) TO 10 (LSD) & DSIGN
;DSIGN = 0 if REGA is positive, FF if negative
;return carry set if overflow
;Uses FSR register

bin2dec:
        call    clrdig          ;Clear all digits
        clrf    MTEMP           ;Reset sign flag
        call    chksgna         ;Make REGA positive
	skpnc
        call    negatea         ;Negative

        movlw   D'32'           ;Loop counter
        movwf   MCOUNT

b2dloop	rlf	REGA0,f		;Shift msb into carry
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f

        movlw   DIGIT10
        movwf   FSR             ;Pointer to digits
        movlw   D'10'           ;10 digits to do
        movwf   DCOUNT

adjlp	rlf	INDF,f		;Shift digit and carry 1 bit left
        movlw   -D'10'
	addwf	INDF,w		;Check and adjust for decimal overflow
	skpnc
        movwf   INDF

	decf	FSR,f		;Next digit
	decfsz	DCOUNT,f
        goto    adjlp

	decfsz	MCOUNT,f	;Next bit
        goto    b2dloop

	btfsc	MTEMP,0		;Check sign
	comf	DSIGN,f		;Negative
	clrc

BLANKIT: movlw 48
        iorwf DIGIT1,F
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F
        iorwf DIGIT9,F
        iorwf DIGIT10,F

        movlw 10          ; blank leading zeros
        movwf LOOP
        movlw DIGIT1
        movwf FSR
BLANK:  movf LOOP,W
        movf INDF,W
        andlw 15
        btfss STATUS,Z
        return
        bcf INDF,4
        incf FSR,F
        decfsz LOOP,F
        goto BLANK
        movlw 48
        iorwf DIGIT10,F
        return

; **************

;Set all digits to 0
;Used by bin2dec

clrdig	clrf	DSIGN
	clrf	DIGIT1
	clrf	DIGIT2
	clrf	DIGIT3
	clrf	DIGIT4
	clrf	DIGIT5
	clrf	DIGIT6
	clrf	DIGIT7
	clrf	DIGIT8
	clrf	DIGIT9
	clrf	DIGIT10
        return

;UTILITY ROUTINES

;Check sign of REGA and convert negative to positive
;Used by bin2dec

chksgna	rlf	REGA3,w
	skpc
        return

;Negate REGA
;Used by bin2dec

negatea movf    REGA3,w         ;Save sign in w
	andlw	0x80

	comf	REGA0,f		;2's complement
	comf	REGA1,f
	comf	REGA2,f
	comf	REGA3,f
        incfsz  REGA0,f
        goto    nega1
        incfsz  REGA1,f
        goto    nega1
        incfsz  REGA2,f
        goto    nega1
        incf    REGA3,f
nega1
        incf    MTEMP,f         ;flip sign flag
        addwf   REGA3,w         ;return carry set if -2147483648
        return

SHOWDIGIT1 movf DIGIT1,W         ; show decimal values
           call LCDOUT
SHOWDIGIT2 movf DIGIT2,W
           call LCDOUT
SHOWDIGIT3 movf DIGIT3,W
           call LCDOUT
SHOWDIGIT4 movf DIGIT4,W
           call LCDOUT
SHOWDIGIT5 movf DIGIT5,W
           call LCDOUT
SHOWDIGIT6 movf DIGIT6,W
           call LCDOUT
SHOWDIGIT7 movf DIGIT7,W
           call LCDOUT
SHOWDIGIT8 movf DIGIT8,W
           call LCDOUT
SHOWDIGIT9 movf DIGIT9,W
           call LCDOUT
SHOWDIGIT10 movf DIGIT10,W
           call LCDOUT
           return

SAMPLE1   BLOCK0         ; set for Block 0
          clrf VALUE

          movlw MEMBANK0 ; get address of 1st batch in BANK0
          call GETBATCH0 ; store values from counter

          movlw MEMBANK1 ; get address of 1st byte in BANK1
          iorlw 128      ; set bit 7 high (b'10000000' = 128 = h'80')
          call GETBATCH1 ; store values from counter

          movlw MEMBANK2 ; get address of 1st batch in BANK2
          call GETBATCH2 ; store values from counter

          goto PART2

GETBATCH0 movwf FSR      ; load FSR with value brought in on W
GETIT0    movf VALUE,W   ; simulated value to store into memory banks
          movwf INDF     ; store at address pointed to by FSR
          incf VALUE,F   ; increment simulation value
          incf FSR,F     ; increment address held by FSR
          movf FSR,W     ; is FSR max for this Bank?
          xorlw h'80'
          btfss STATUS,Z
          goto GETIT0    ; no, continue sampling
          return         ; yes, end of sub-routine

GETBATCH1 movwf FSR      ; load FSR with value brought in on W
GETIT1    movf VALUE,W   ; simulated value to store into memory banks
          movwf INDF     ; store at address pointed to by FSR
          incf VALUE,F   ; increment simulation value
          incf FSR,F     ; increment address held by FSR
          movf FSR,W     ; is FSR max for this Bank?
          xorlw h'F0'
          btfss STATUS,Z
          goto GETIT1    ; no, continue sampling
          return         ; yes, end of sub-routine

GETBATCH2 movwf FSR      ; load FSR with value brought in on W
          BLOCK1         ; set for BLOCK1
GETIT2    movf VALUE,W   ; simulated value to store into memory banks
          movwf INDF     ; store at address pointed to by FSR
          incf VALUE,F   ; increment simulation value
          incf FSR,F     ; increment address held by FSR
          decf FSR,W     ; is FSR max for this Bank?
          xorlw h'50'
          btfss STATUS,Z
          goto GETIT2    ; no, continue sampling
          BLOCK0         ; return to BLOCK0
          return         ; yes, end of sub-routine

;...........

PART2

SHOWBANK0 movlw '0'
          movwf BANKVAL
          call SHOWBANKVAL
          BLOCK0         ; set for Block 0
          movlw MEMBANK0 ; get address 1st byte of 1st batch
          movwf FSR      ; load FSR with value brought in on W
VAL0      call SHOWVALBANK
          movf FSR,W
          xorlw h'80'
          btfss STATUS,Z
          goto VAL0   ; no, continue sampling

SHOWBANK1 movlw '1'
          movwf BANKVAL
          call SHOWBANKVAL
          BLOCK0         ; set for Block 0
          movlw MEMBANK1 ; get address 1st byte of 2nd batch
          iorlw 128
          movwf FSR      ; load FSR with value brought in on W
VAL1      call SHOWVALBANK
          decf FSR,W
          xorlw h'FF'
          btfss STATUS,Z
          goto VAL1   ; no, continue sampling

SHOWBANK2 movlw '2'
          movwf BANKVAL
          call SHOWBANKVAL
          BLOCK1         ; set for Block 1
          movlw MEMBANK2 ; get address 1st byte of 1st batch
          movwf FSR      ; load FSR with value brought in on W
VAL2      call SHOWVALBANK
          BLOCK1         ; set for Block 1
          movf FSR,W
          xorlw h'80'
          btfss STATUS,Z
          goto VAL2   ; no, continue sampling
          BLOCK0

SHOWBANK3 movlw '3'
          movwf BANKVAL
          call SHOWBANKVAL
          BLOCK1         ; set for Block 1
          movlw MEMBANK3 ; get address 1st byte of 1st batch
          iorlw 128
          movwf FSR      ; load FSR with value brought in on W
VAL3      call SHOWVALBANK
          BLOCK1
          decf FSR,W
          xorlw h'FF'
          btfss STATUS,Z
          goto VAL3   ; no, continue sampling
          BLOCK0
          return         ; end of sub-routine

SHOWBANKVAL call LCD1      ; set LCD for cell 0 line 1
          BSF RSLINE,4
          movlw 'B'
          call LCDOUT
          movlw 'A'
          call LCDOUT
          movlw 'N'
          call LCDOUT
          movlw 'K'
          call LCDOUT
          movf BANKVAL,W
          call LCDOUT
          return

SHOWVALBANK movf INDF,W    ; get value from address pointed to by FSR
          movwf REGA0
          clrf REGA1
          clrf REGA2
          clrf REGA3
          movf FSR,W     ; temp store FSR
          movwf FSRSTORE
          BLOCK0
          call BIN2DEC   ; perform decimalistion
          call LCD21     ; set LCD for line 2
          BSF RSLINE,4
          call SHOWDIGIT8
          movf FSRSTORE,W
          movwf REGA0
          clrf REGA1
          clrf REGA2
          clrf REGA3
          movf FSR,W     ; temp store FSR
          call BIN2DEC   ; perform decimalistion
          call SHOWDIGIT7
          movf FSRSTORE,W
          movwf FSR      ; recall FSR
          call PAUSIT2   ; pause for a while
          incf FSR,F     ; increment address held by FSR
          return

          END
