; TEACHINE01.ASM 09JUN07 - TEACH IN 2008 PT5

#DEFINE BANK0 BCF STATUS,5     ; define STATUS register bit 5 clear as BANK0
#DEFINE BANK1 BSF STATUS,5     ; define STATUS register bit 5 set as BANK1

           list p=16f628       ; tell MPASM-type programmer to create a
                               ; list (LST) file

           include p16f628.inc ; bring in all standard register values

           CBLOCK h'20'

; registers needed for main progran
RSLINE
STORE
LOOP
LOOPA
CLKCNT
PREV
STORE0
STORE1
STORE2
TEMP

; registers needed for MATHSroutines facilities
REGA0
REGA1
REGA2
REGA3
REGB0
REGB1
REGB2
REGB3
REGC0
REGC1
REGC2
REGC3

MTEMP
COUNT0
COUNT1
COUNT2
DIGIT1
DIGIT2
DIGIT3
DIGIT4
DIGIT5
DIGIT6
DIGIT7
DIGIT8
BITCNT
DIGCNT

ROOTL
ROOTH
REMDRL
REMDRH
NUML
NUMM
NUMH
MCOUNT
          ENDC

           __config  h'3F21'     ; external xtal oscillator (3.2768MHz)

           ORG 0               ; reset vector
           goto STARTIT
           ORG 4               ; Interrupt vector address
           goto STARTIT
           ORG 5               ; PIC program memory location at which to start 
           goto STARTIT

           include LCDheader.inc

OVERTABLE  addwf PCL,F
	   retlw 'O' ; 0
	   retlw 'V' ; 1
	   retlw 'E' ; 2
	   retlw 'R' ; 3
	   retlw 'F' ; 4
	   retlw 'L' ; 5
	   retlw 'O' ; 6
	   retlw 'W' ; 7

STARTIT    clrf PORTA          ; clear PORTA's output if any
           clrf PORTB          ; clear PORTB's output if any
           movlw 7             ; needed by some PICs, including PIC16F628
           movwf CMCON         ; so that PORTA is treated as digital port

           clrf COUNT0
           clrf COUNT1
           clrf COUNT2

           BANK1
           movlw b'00010011'   ; PORTA 0 & 1, 4 as input
           movwf TRISA         ; data direction register for PORTA
           movlw b'00000000'   ; PORTB as output
           movwf TRISB         ; data direction register for PORTB
           movlw b'10000110'   ; timer 1:128, pull-ups off (bit 7 = 1)
           movwf OPTION_REG
           BANK0

           call PAUSIT

           call LCDSET
	   call PAUSIT

MAIN       movlw 25
           movwf CLKCNT
           clrf COUNT0
           clrf COUNT1
           clrf COUNT2
           movf PORTA,W       ; get current val of PORTA
           andlw b'00010000'
           movwf PREV         ; put into prev
           clrf INTCON        ; clear TMR0 overflow

MAIN0      btfss INTCON,2      ; has a timer time-out been detected?
           goto MAIN0A         ; no
           bcf INTCON,2        ; yes
           decfsz CLKCNT,F     ; dec counter, is it zero?
           goto MAIN0A         ; no
           goto MAIN3

MAIN0A     movf PORTA,W       ; is PORTA = prev?
           andlw b'00010000'
           movwf TEMP

           xorwf PREV,W
           btfsc STATUS,Z
           goto MAIN0         ; yes

           movf TEMP,W
           movwf PREV

           incfsz COUNT0,F     ; inc COUNTA, is it = zero?
           goto MAIN2          ; no, goto MAIN2
           incfsz COUNT1,F     ; yes, so inc the next counter byte (MSB), is it = zero
           goto MAIN2          ; no
           incfsz COUNT2,F     ; yes, so inc the next counter byte (MSB), is it = zero
           goto MAIN2          ; no
           call OVERFLOW
           goto MAIN   

MAIN2      btfss INTCON,2      ; has a timer time-out been detected?
           goto MAIN0          ; no
           bcf INTCON,2        ; yes
           decfsz CLKCNT,F     ; dec counter, is it zero?
           goto MAIN0          ; no

MAIN3      bcf STATUS,C        ; clear carry flag
           rrf COUNT2,F        ; divide asnswer by 2
           rrf COUNT1,F
           rrf COUNT0,F

           call BIN2DEC        ; decimalise answer
           call LCD1           ; set LCD for display from line 1 cell 1
           bsf RSLINE,4        ; and tell it to expect display data
	   call BLANKIT
           call SHOWDIGIT8
           movlw 'H'
           call LCDOUT
           movlw 'z'
           call LCDOUT

           call PERIOD

           call BIN2DEC        ; decimalise answer
           call LCD21          ; set LCD for display from line 2 cell 1
           bsf RSLINE,4        ; and tell it to expect display data
	   call BLANKIT
           call SHOWDIGIT8
           movlw 'u'
           call LCDOUT
           movlw 's'
           call LCDOUT
           movlw '/'
           call LCDOUT
           movlw 'c'
           call LCDOUT
           movlw 'y'
           call LCDOUT
           movlw 'c'
           call LCDOUT
           movlw 'l'
           call LCDOUT
           movlw 'e'
           call LCDOUT

           goto MAIN

OVERFLOW   call LCD1
           clrf LOOP           ; clear loop
           bsf RSLINE,4        ; set RS for data send
OFL2       movf LOOP,W         ; get table address
           call OVERTABLE      ; get message letter
           call LCDOUT         ; show it
           incf LOOP,F         ; inc loop
           btfss LOOP,3        ; has last LCD letter been sent?
           goto OFL2           ; no, so repeat for next one
	   return              ; return to the main program

PAUSIT     movlw 5             ; set delay counter to 5
           movwf CLKCNT        ; (for 1/25th sec x 5)
           clrf INTCON         ; clear interupt flag
PAUSE                          ; initial 1/5th sec wait before setting up LCD
           btfss INTCON,2      ; has a timer time-out been detected?
           goto PAUSE          ; no
           bcf INTCON,2        ; yes
           decfsz CLKCNT,F     ; dec counter, is it zero?
           goto PAUSE          ; no
           return              ; yes

; GET PERIOD TIMING ******

PERIOD    movlw h'40'
          movwf REGA0
          movlw h'42'
          movwf REGA1
          movlw h'0F'
          movwf REGA2
          clrf REGA3

          movf STORE0,W
          movwf REGB0
          movf STORE1,W
          movwf REGB1 
          movf STORE2,W
          movwf REGB2 
          clrf REGB3

          call DIVIDE32

          movf REGA0,W
          movwf COUNT0
          movf REGA1,W
          movwf COUNT1
          movf REGA2,W
          movwf COUNT2
          return

          include LCDroutines.inc

          include MATHSroutines.inc

           END
