; POLYLEDMSG37.ASM 02DEC06 - for readers to experiment with

; PIC16F628, INTERNAL OSC WDT OFF, POR ON, INTRC 100 4MHz

#DEFINE BANK0 BCF $03,5
#DEFINE BANK1 BSF $03,5

        List P = PIC16F628, R=DEC; 
        __CONFIG   h'3F30'

        include P16F628.inc

        CBLOCK
RECDVAL
PREVVAL
CLKCNT
        ENDC

PROMVAL .EQU $70    ; in both pages
SPBRG   .EQU $99    ; not in INC file for some odd reason.  Bank 1

; **************

        .ORG 0
        goto GIEOFF
        .ORG 4          ; Interrupt vector address
        goto GIEOFF
        .ORG 5          ; Start of program memory

GIEOFF: BCF INTCON,GIE  ; turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF

START:  bcf STATUS,RP0
        bcf STATUS,RP1
        movlw $07
        movwf CMCON
        clrf PORTA
        clrf PORTB
	clrf PREVVAL

        BANK1
        movlw %00001111       ; RA0-RA3 as input
        movwf TRISA
	movlw %11110110
        movwf TRISB          ;RB4-RB7 as input, RB1, RB2 for serial
        movlw B'00000100'     ; timer 1:32, pull-ups on
        movwf OPTION_REG
        BANK0

        call JOESETBAUD     ; initialise serial BAUD rate etc
        call PAUSIT

; *************** START OF MAIN PROG ***********

LOOPIT:	movf PORTA,W		; get RA0-RA3
	andlw %00001111
        movwf RECDVAL           ; store it

        movf PORTB,W
        andlw %11110000         ; get RB4-RB7
        iorwf RECDVAL,F         ; combine with PORTA byte

        xorwf PREVVAL,W         ; is it the same as prev val?
        btfsc STATUS,Z
        goto LOOPIT             ; yes 

        btfsc RECDVAL,7        ; is it a notelength byte?
        goto LOOPIT            ; yes

        movf RECDVAL,W         ; no; set it as PREVVAL and send to slave
        movwf PREVVAL
        iorlw 128              ; set bit 7 to suit Slaves Moving Mode
        call TXBYTE            ; send it to slaves
        goto LOOPIT

       ;*************** OUTPUT TO PC SERIAL PORT FOR DOWNLOAD

;  Modified from Joe Farr's file SAMPLE5.ASM
;  Orig Date: 10-Feb-2003, mod date 01MAR03

JOESETBAUD: BANK1               ; Configure the baud rate generator
        movlw 25                ; BRG for 9600baud from 4MHz, brgh=1
                                ; Internal osc is 4MHz
        movwf   SPBRG           ; In bank 1
        movlw   b'00100100'     ; BRGH = 1(High speed, bit 2) & ASYNC transmission (bit 5)
        movwf   TXSTA           ; In bank 1
        bcf 	STATUS,RP0  	; back to RAM page 0
        movlw   b'10010000'     ; ASYNC reception
        movwf   RCSTA           ; In bank 0
        call    FlushRXBuffer   ; Flush the RX buffer in bank 0
        return

; Send byte in W to the USART

TxByte: nop
        btfss   PIR1,TXIF       ; TX Buffer empty yet ?
        goto    TxByte          ; No - Keep waiting
        movwf   TXREG           ; Now empty - send this character
        return

; Flush the contents of the RX Buffer

FlushRXBuffer:
	movf    RCREG,W        	; Flush the RX buffer in bank 0
        movf    RCREG,W
        movf    RCREG,W
        return

; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F62x devices ********
          ;according to data sheet page 93 (is the same as for 16F87x devices
	  ; except that PIR2 of '87x has become PIR1 for '62x and page 2/3 not used)
	
                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in PROMVAL, which is located in both pages at or above $70
SETPRM: BANK1
        movwf EEADR     ;copy W into EEADR to set eeprom address
        movf PROMVAL,W  ;get data value from PROMVAL and hold in W
        movwf EEDATA    ;copy W into eeprom data byte register
        bsf EECON1,WREN ;enable write flag

MANUAL: movlw $55       ;these lines cause the action required by
        movwf EECON2    ;by the eeprom to store the data in EEDATA
        movlw $AA       ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ;set the ``perform write'' flag
        BANK0

CHKWRT: btfss PIR1,EEIF ;wait until bit 4 of PIR1 is set
        goto CHKWRT
        bcf PIR1,EEIF   ;clear bit 4 of PIR1
        return

;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F62x    retlwvices ****
;         the data sheet page 93 is wrong!  This routine here works!

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: BANK1
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bsf EECON1,RD   ;enable read flag
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        BANK0
        return

PAUSIT: movlw 100 ;0 ; 50 ;20        
        movwf CLKCNT
        clrf INTCON     ;clear interupt flag
PAUSE:  
        btfss INTCON,2  ;has a timer time-out been detected?
        goto PAUSE      ;no
        BCF INTCON,2    ;yes
        decfsz CLKCNT,F ;dec loop, is it zero?
        goto PAUSE      ;no
        return          ;yes

        END
