/*****************************************************************************
*   Filename:   CONFIG.H                                                     *
******************************************************************************
*   Author:     Ian	Pearson		                                             *
*   Title:      Field Applications Engineer                                  *
*   Company:    Microchip Technology Incorporated                            *
*   Revision:   0                                                            *
*   Date:       15-1-07                                                      *
******************************************************************************
* Software License Agreement												 *
*																			 *
* This software is owned by Microchip Technology Inc. ("Microchip") 		 *
* and is supplied to you for use exclusively as described in the 			 *
* associated software agreement.  This software is protected by 			 *
* software and other intellectual property laws.  Any use in 				 *
* violation of the software license may subject the user to criminal 		 *
* sanctions as well as civil liability.  Copyright 2006 Microchip			 *
* Technology Inc.  All rights reserved.										 *
*																			 *
* This software is provided "AS IS."  MICROCHIP DISCLAIMS ALL 				 *
* WARRANTIES, EXPRESS, IMPLIED, STATUTORY OR OTHERWISE, NOT LIMITED 		 *
* TO MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND 				 *
* INFRINGEMENT.  Microchip shall in no event be liable for special, 		 *
* incidental, or consequential damages.										 *
*																			 *
******************************************************************************
*   Include files:                                                           *
*      - nil									                             *
*      										                                 *
*      												                         *
******************************************************************************
*   This file contains the code to:                                          *
*      - Easily set the configuration bits for PIC24F                        *
*      - Copy of Defines from <processor>.h file to show possible settings   *
*     											                             *
*                                             								 *
******************************************************************************
*   Revision 0  15/01/2007                                                   *
*      - Original release 											         *
*      																		 *
*****************************************************************************/




/*****************************************************************************
*	The configuration register statements below can be modified to reflect	 *
*	the desired device configuration. The possible settings for each 		 *
*	configuration option are provided below.								 *
*																			 *
*	ONLY ONE INVOCATION OF CONFIG SHOULD APPEAR IN A PROJECT.				 *
*	THESE SETTINGS WILL OVERRIDE ANY CHANGES MADE WITHIN THE MPLAB CONFIG	 *
*	REGISTER WINDOW WHEN A BUILD IS PERFROMED								 *
*																			 *
******************************************************************************/

_CONFIG1( JTAGEN_OFF & GCP_OFF & GWRP_OFF & BKBUG_OFF & COE_OFF & ICS_PGx1 & FWDTEN_OFF & WINDIS_OFF & FWPSA_PR128 & WDTPS_PS32768 )
_CONFIG2( IESO_OFF & FNOSC_PRIPLL & FCKSM_CSECME & OSCIOFNC_ON & POSCMOD_HS )




/*****************************************************************************
*   Config1 - Configuration Register Details                                 *
*      																		 *
******************************************************************************
** Only one invocation of CONFIG1 should appear in a project,
** at the top of a C source file (outside of any function).
**
** The following constants can be used to set CONFIG1.
** Multiple options may be combined, as shown:
**
** _CONFIG1( OPT1_ON & OPT2_OFF & OPT3_PLL )
**
**   JTAG:
**     JTAGEN_OFF           Disabled
**     JTAGEN_ON            Enabled
**
**   Code Protect:
**     GCP_ON               Enabled
**     GCP_OFF              Disabled
**
**   Write Protect:
**     GWRP_ON              Enabled
**     GWRP_OFF             Disabled
**
**   Background Debugger:
**     BKBUG_ON             Enabled
**     BKBUG_OFF            Disabled
**
**   Clip-on Emulation mode:
**     COE_ON               Enabled
**     COE_OFF              Disabled
**
**   ICD pins select:
**     ICS_PGx1             EMUC/EMUD share PGC1/PGD1
**     ICS_PGx2             EMUC/EMUD share PGC2/PGD2
**
**   Watchdog Timer:
**     FWDTEN_OFF           Disabled
**     FWDTEN_ON            Enabled
**
**   Windowed WDT:
**     WINDIS_ON            Enabled
**     WINDIS_OFF           Disabled
**
**   Watchdog prescaler:
**     FWPSA_PR32           1:32
**     FWPSA_PR128          1:128
**
**   Watchdog postscale:
**     WDTPS_PS1            1:1
**     WDTPS_PS2            1:2
**     WDTPS_PS4            1:4
**     WDTPS_PS8            1:8
**     WDTPS_PS16           1:16
**     WDTPS_PS32           1:32
**     WDTPS_PS64           1:64
**     WDTPS_PS128          1:128
**     WDTPS_PS256          1:256
**     WDTPS_PS512          1:512
**     WDTPS_PS1024         1:1,024
**     WDTPS_PS2048         1:2,048
**     WDTPS_PS4096         1:4,096
**     WDTPS_PS8192         1:8,192
**     WDTPS_PS16384        1:16,384
**     WDTPS_PS32768        1:32,768
**
*/





/*****************************************************************************
*   Config2 - Configuration Register Details                                 *
*      																		 *
******************************************************************************
** Only one invocation of CONFIG2 should appear in a project,
** at the top of a C source file (outside of any function).
**
** The following constants can be used to set CONFIG2.
** Multiple options may be combined, as shown:
**
** _CONFIG2( OPT1_ON & OPT2_OFF & OPT3_PLL )
**
**   Two Speed Start-up:
**     IESO_OFF             Disabled
**     IESO_ON              Enabled
**
**   Oscillator Selection:
**     FNOSC_FRC            Fast RC oscillator
**     FNOSC_FRCPLL         Fast RC oscillator w/ divide and PLL
**     FNOSC_PRI            Primary oscillator (XT, HS, EC)
**     FNOSC_PRIPLL         Primary oscillator (XT, HS, EC) w/ PLL
**     FNOSC_SOSC           Secondary oscillator
**     FNOSC_LPRC           Low power RC oscillator
**     FNOSC_LPRCDIV        Fast RC oscillator with divide
**
**   Clock switching and clock monitor:
**     FCKSM_CSECME         Both enabled
**     FCKSM_CSECMD         Only clock switching enabled
**     FCKSM_CSDCMD         Both disabled
**
**   OSCO/RC15 function:
**     OSCIOFNC_ON          RC15
**     OSCIOFNC_OFF         OSCO or Fosc/2
**
**   Oscillator Selection:
**     POSCMOD_EC           External clock
**     POSCMOD_XT           XT oscillator
**     POSCMOD_HS           HS oscillator
**     POSCMOD_NONE         Primary disabled
**
*/
