; ..............................................................................
;    File   lpf.s
; ..............................................................................

		.equ lpfNumTaps, 107

; ..............................................................................
; Allocate and initialize filter taps

		.section .xdata
		.align 256

lpfTaps:
.hword 	0x0003,	0x0003,	0x0002,	0x0000,	0xFFFE,	0xFFFA,	0xFFF5,	0xFFEF,	0xFFE9
.hword 	0xFFE4,	0xFFE0,	0xFFDE,	0xFFDF,	0xFFE4,	0xFFEC,	0xFFF9,	0x0009,	0x001D
.hword 	0x0034,	0x004C,	0x0063,	0x0076,	0x0085,	0x008B,	0x0088,	0x0079,	0x005E
.hword 	0x0035,	0x0000,	0xFFC2,	0xFF7B,	0xFF31,	0xFEEA,	0xFEA9,	0xFE77,	0xFE59
.hword 	0xFE56,	0xFE73,	0xFEB4,	0xFF1B,	0xFFAB,	0x0060,	0x0139,	0x0230,	0x033E
.hword 	0x0459,	0x0578,	0x068F,	0x0793,	0x0879,	0x0937,	0x09C5,	0x0A1D,	0x0A3B
.hword 	0x0A1D,	0x09C5,	0x0937,	0x0879,	0x0793,	0x068F,	0x0578,	0x0459,	0x033E
.hword 	0x0230,	0x0139,	0x0060,	0xFFAB,	0xFF1B,	0xFEB4,	0xFE73,	0xFE56,	0xFE59
.hword 	0xFE77,	0xFEA9,	0xFEEA,	0xFF31,	0xFF7B,	0xFFC2,	0x0000,	0x0035,	0x005E
.hword 	0x0079,	0x0088,	0x008B,	0x0085,	0x0076,	0x0063,	0x004C,	0x0034,	0x001D
.hword 	0x0009,	0xFFF9,	0xFFEC,	0xFFE4,	0xFFDF,	0xFFDE,	0xFFE0,	0xFFE4,	0xFFE9
.hword 	0xFFEF,	0xFFF5,	0xFFFA,	0xFFFE,	0x0000,	0x0002,	0x0003,	0x0003

; ..............................................................................
; Allocate delay line in (uninitialized) Y data space

		.section .ybss,  "b"
		.align 256

lpfDelay:
		.space lpfNumTaps*2

; ..............................................................................
; Allocate and intialize filter structure

		.section .data
		.global _lpfFilter

_lpfFilter:
.hword lpfNumTaps
.hword lpfTaps
.hword lpfTaps+lpfNumTaps*2-1
.hword 0xff00
.hword lpfDelay
.hword lpfDelay+lpfNumTaps*2-1
.hword lpfDelay

; ..............................................................................
; ..............................................................................
; Sample assembly language calling program
;  The following declarations can be cut and pasted as needed into a program
;		.extern	_FIRFilterInit
;		.extern	_BlockFIRFilter
;		.extern	_lpfFilter
;
;		.section	.bss
;
;	 The input and output buffers can be made any desired size
;	   the value 40 is just an example - however, one must ensure
;	   that the output buffer is at least as long as the number of samples
;	   to be filtered (parameter 4)
;input:		.space	40
;output:	.space	40
;		.text
;
;
;  This code can be copied and pasted as needed into a program
;
;
; Set up pointers to access input samples, filter taps, delay line and
; output samples.
;		mov	#_lpfFilter, W0	; Initalize W0 to filter structure
;		call	_FIRFilterInit	; call this function once
;
; The next 4 instructions are required prior to each subroutine call
; to _BlockFIRFilter
;		mov	#_lpfFilter, W0	; Initalize W0 to filter structure
;		mov	#input, W1	; Initalize W1 to input buffer 
;		mov	#output, W2	; Initalize W2 to output buffer
;		mov	#20, W3	; Initialize W3 with number of required output samples
;		call	_BlockFIRFilter	; call as many times as needed
