'Copyright (C) 2002 Microsoft Corporation
'All rights reserved.
'THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER 
'EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF 
'MERCHANTIBILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

'Requires the Trial or Release version of Visual Studio .NET Professional (or greater).
' TURN OFF STRICT SINCE SOME MENU ITEMS ARE BUILT AT RUNTIME (LATE BINDING)
Option Strict Off
Imports System.Text
Imports System
Imports System.IO

Public Class frmMain
    Inherits System.Windows.Forms.Form

    ' Declare necessary class variables.
    Private m_CommPort As New Rs232
    Private m_IsDGCFound As Boolean = False
    Private m_DGCPort As Integer = 0
    Public NUM_DATAPOINTS As Byte
    '   Public DGC_DATA(250, 16) As Integer



#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

        ' So that we only need to set the title of the application once,
        ' we use the AssemblyInfo class (defined in the AssemblyInfo.vb file)
        ' to read the AssemblyTitle attribute.
        Dim ainfo As New AssemblyInfo

        Me.Text = ainfo.Title
        Me.mnuAbout.Text = String.Format("&About {0} ...", ainfo.Title)

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents mnuMain As System.Windows.Forms.MainMenu
    Friend WithEvents mnuFile As System.Windows.Forms.MenuItem
    Friend WithEvents mnuExit As System.Windows.Forms.MenuItem
    Friend WithEvents mnuHelp As System.Windows.Forms.MenuItem
    Friend WithEvents mnuAbout As System.Windows.Forms.MenuItem
    Friend WithEvents txtStatus As System.Windows.Forms.TextBox
    Friend WithEvents btnClear As System.Windows.Forms.Button
    Friend WithEvents btnCheckModems As System.Windows.Forms.Button
    Friend WithEvents mnuDGC As System.Windows.Forms.MenuItem
    Friend WithEvents mnuUpload As System.Windows.Forms.MenuItem
    Friend WithEvents mnuErase As System.Windows.Forms.MenuItem
    Friend WithEvents OpenFileDialog1 As System.Windows.Forms.OpenFileDialog
    Friend WithEvents mnuComm As System.Windows.Forms.MenuItem
    Friend WithEvents mnuQuery As System.Windows.Forms.MenuItem
    Friend WithEvents mnuSetdate As System.Windows.Forms.MenuItem
    Friend WithEvents SaveFileDialog1 As System.Windows.Forms.SaveFileDialog
    Friend WithEvents ListBox1 As System.Windows.Forms.ListBox
    Friend WithEvents mnuExport As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem2 As System.Windows.Forms.MenuItem
    Friend WithEvents mnuDeleteUData As System.Windows.Forms.MenuItem
    Friend WithEvents mnuChartData As System.Windows.Forms.MenuItem
    Friend WithEvents mnuImport As System.Windows.Forms.MenuItem
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents ListBox2 As System.Windows.Forms.ListBox
    Friend WithEvents Label2 As System.Windows.Forms.Label
    Friend WithEvents Label3 As System.Windows.Forms.Label
    Friend WithEvents Label4 As System.Windows.Forms.Label
    Friend WithEvents txtTotal As System.Windows.Forms.TextBox
    Friend WithEvents txtSelected As System.Windows.Forms.TextBox
    Friend WithEvents ToolTip1 As System.Windows.Forms.ToolTip
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container
        Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(frmMain))
        Me.mnuMain = New System.Windows.Forms.MainMenu
        Me.mnuFile = New System.Windows.Forms.MenuItem
        Me.mnuExit = New System.Windows.Forms.MenuItem
        Me.mnuExport = New System.Windows.Forms.MenuItem
        Me.mnuImport = New System.Windows.Forms.MenuItem
        Me.mnuHelp = New System.Windows.Forms.MenuItem
        Me.mnuAbout = New System.Windows.Forms.MenuItem
        Me.mnuDGC = New System.Windows.Forms.MenuItem
        Me.mnuQuery = New System.Windows.Forms.MenuItem
        Me.mnuUpload = New System.Windows.Forms.MenuItem
        Me.mnuErase = New System.Windows.Forms.MenuItem
        Me.mnuSetdate = New System.Windows.Forms.MenuItem
        Me.mnuComm = New System.Windows.Forms.MenuItem
        Me.MenuItem2 = New System.Windows.Forms.MenuItem
        Me.mnuChartData = New System.Windows.Forms.MenuItem
        Me.mnuDeleteUData = New System.Windows.Forms.MenuItem
        Me.txtStatus = New System.Windows.Forms.TextBox
        Me.btnClear = New System.Windows.Forms.Button
        Me.OpenFileDialog1 = New System.Windows.Forms.OpenFileDialog
        Me.SaveFileDialog1 = New System.Windows.Forms.SaveFileDialog
        Me.ListBox1 = New System.Windows.Forms.ListBox
        Me.Label1 = New System.Windows.Forms.Label
        Me.ListBox2 = New System.Windows.Forms.ListBox
        Me.Label2 = New System.Windows.Forms.Label
        Me.Label3 = New System.Windows.Forms.Label
        Me.Label4 = New System.Windows.Forms.Label
        Me.txtTotal = New System.Windows.Forms.TextBox
        Me.txtSelected = New System.Windows.Forms.TextBox
        Me.ToolTip1 = New System.Windows.Forms.ToolTip(Me.components)
        Me.SuspendLayout()
        '
        'mnuMain
        '
        Me.mnuMain.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuFile, Me.mnuHelp, Me.mnuDGC, Me.mnuComm, Me.MenuItem2})
        Me.mnuMain.RightToLeft = CType(resources.GetObject("mnuMain.RightToLeft"), System.Windows.Forms.RightToLeft)
        '
        'mnuFile
        '
        Me.mnuFile.Enabled = CType(resources.GetObject("mnuFile.Enabled"), Boolean)
        Me.mnuFile.Index = 0
        Me.mnuFile.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuExit, Me.mnuExport, Me.mnuImport})
        Me.mnuFile.Shortcut = CType(resources.GetObject("mnuFile.Shortcut"), System.Windows.Forms.Shortcut)
        Me.mnuFile.ShowShortcut = CType(resources.GetObject("mnuFile.ShowShortcut"), Boolean)
        Me.mnuFile.Text = resources.GetString("mnuFile.Text")
        Me.mnuFile.Visible = CType(resources.GetObject("mnuFile.Visible"), Boolean)
        '
        'mnuExit
        '
        Me.mnuExit.Enabled = CType(resources.GetObject("mnuExit.Enabled"), Boolean)
        Me.mnuExit.Index = 0
        Me.mnuExit.Shortcut = CType(resources.GetObject("mnuExit.Shortcut"), System.Windows.Forms.Shortcut)
        Me.mnuExit.ShowShortcut = CType(resources.GetObject("mnuExit.ShowShortcut"), Boolean)
        Me.mnuExit.Text = resources.GetString("mnuExit.Text")
        Me.mnuExit.Visible = CType(resources.GetObject("mnuExit.Visible"), Boolean)
        '
        'mnuExport
        '
        Me.mnuExport.Enabled = CType(resources.GetObject("mnuExport.Enabled"), Boolean)
        Me.mnuExport.Index = 1
        Me.mnuExport.Shortcut = CType(resources.GetObject("mnuExport.Shortcut"), System.Windows.Forms.Shortcut)
        Me.mnuExport.ShowShortcut = CType(resources.GetObject("mnuExport.ShowShortcut"), Boolean)
        Me.mnuExport.Text = resources.GetString("mnuExport.Text")
        Me.mnuExport.Visible = CType(resources.GetObject("mnuExport.Visible"), Boolean)
        '
        'mnuImport
        '
        Me.mnuImport.Enabled = CType(resources.GetObject("mnuImport.Enabled"), Boolean)
        Me.mnuImport.Index = 2
        Me.mnuImport.Shortcut = CType(resources.GetObject("mnuImport.Shortcut"), System.Windows.Forms.Shortcut)
        Me.mnuImport.ShowShortcut = CType(resources.GetObject("mnuImport.ShowShortcut"), Boolean)
        Me.mnuImport.Text = resources.GetString("mnuImport.Text")
        Me.mnuImport.Visible = CType(resources.GetObject("mnuImport.Visible"), Boolean)
        '
        'mnuHelp
        '
        Me.mnuHelp.Enabled = CType(resources.GetObject("mnuHelp.Enabled"), Boolean)
        Me.mnuHelp.Index = 1
        Me.mnuHelp.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuAbout})
        Me.mnuHelp.Shortcut = CType(resources.GetObject("mnuHelp.Shortcut"), System.Windows.Forms.Shortcut)
        Me.mnuHelp.ShowShortcut = CType(resources.GetObject("mnuHelp.ShowShortcut"), Boolean)
        Me.mnuHelp.Text = resources.GetString("mnuHelp.Text")
        Me.mnuHelp.Visible = CType(resources.GetObject("mnuHelp.Visible"), Boolean)
        '
        'mnuAbout
        '
        Me.mnuAbout.Enabled = CType(resources.GetObject("mnuAbout.Enabled"), Boolean)
        Me.mnuAbout.Index = 0
        Me.mnuAbout.Shortcut = CType(resources.GetObject("mnuAbout.Shortcut"), System.Windows.Forms.Shortcut)
        Me.mnuAbout.ShowShortcut = CType(resources.GetObject("mnuAbout.ShowShortcut"), Boolean)
        Me.mnuAbout.Text = resources.GetString("mnuAbout.Text")
        Me.mnuAbout.Visible = CType(resources.GetObject("mnuAbout.Visible"), Boolean)
        '
        'mnuDGC
        '
        Me.mnuDGC.Enabled = CType(resources.GetObject("mnuDGC.Enabled"), Boolean)
        Me.mnuDGC.Index = 2
        Me.mnuDGC.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuQuery, Me.mnuUpload, Me.mnuErase, Me.mnuSetdate})
        Me.mnuDGC.Shortcut = CType(resources.GetObject("mnuDGC.Shortcut"), System.Windows.Forms.Shortcut)
        Me.mnuDGC.ShowShortcut = CType(resources.GetObject("mnuDGC.ShowShortcut"), Boolean)
        Me.mnuDGC.Text = resources.GetString("mnuDGC.Text")
        Me.mnuDGC.Visible = CType(resources.GetObject("mnuDGC.Visible"), Boolean)
        '
        'mnuQuery
        '
        Me.mnuQuery.Enabled = CType(resources.GetObject("mnuQuery.Enabled"), Boolean)
        Me.mnuQuery.Index = 0
        Me.mnuQuery.Shortcut = CType(resources.GetObject("mnuQuery.Shortcut"), System.Windows.Forms.Shortcut)
        Me.mnuQuery.ShowShortcut = CType(resources.GetObject("mnuQuery.ShowShortcut"), Boolean)
        Me.mnuQuery.Text = resources.GetString("mnuQuery.Text")
        Me.mnuQuery.Visible = CType(resources.GetObject("mnuQuery.Visible"), Boolean)
        '
        'mnuUpload
        '
        Me.mnuUpload.Enabled = CType(resources.GetObject("mnuUpload.Enabled"), Boolean)
        Me.mnuUpload.Index = 1
        Me.mnuUpload.Shortcut = CType(resources.GetObject("mnuUpload.Shortcut"), System.Windows.Forms.Shortcut)
        Me.mnuUpload.ShowShortcut = CType(resources.GetObject("mnuUpload.ShowShortcut"), Boolean)
        Me.mnuUpload.Text = resources.GetString("mnuUpload.Text")
        Me.mnuUpload.Visible = CType(resources.GetObject("mnuUpload.Visible"), Boolean)
        '
        'mnuErase
        '
        Me.mnuErase.Enabled = CType(resources.GetObject("mnuErase.Enabled"), Boolean)
        Me.mnuErase.Index = 2
        Me.mnuErase.Shortcut = CType(resources.GetObject("mnuErase.Shortcut"), System.Windows.Forms.Shortcut)
        Me.mnuErase.ShowShortcut = CType(resources.GetObject("mnuErase.ShowShortcut"), Boolean)
        Me.mnuErase.Text = resources.GetString("mnuErase.Text")
        Me.mnuErase.Visible = CType(resources.GetObject("mnuErase.Visible"), Boolean)
        '
        'mnuSetdate
        '
        Me.mnuSetdate.Enabled = CType(resources.GetObject("mnuSetdate.Enabled"), Boolean)
        Me.mnuSetdate.Index = 3
        Me.mnuSetdate.Shortcut = CType(resources.GetObject("mnuSetdate.Shortcut"), System.Windows.Forms.Shortcut)
        Me.mnuSetdate.ShowShortcut = CType(resources.GetObject("mnuSetdate.ShowShortcut"), Boolean)
        Me.mnuSetdate.Text = resources.GetString("mnuSetdate.Text")
        Me.mnuSetdate.Visible = CType(resources.GetObject("mnuSetdate.Visible"), Boolean)
        '
        'mnuComm
        '
        Me.mnuComm.Enabled = CType(resources.GetObject("mnuComm.Enabled"), Boolean)
        Me.mnuComm.Index = 3
        Me.mnuComm.Shortcut = CType(resources.GetObject("mnuComm.Shortcut"), System.Windows.Forms.Shortcut)
        Me.mnuComm.ShowShortcut = CType(resources.GetObject("mnuComm.ShowShortcut"), Boolean)
        Me.mnuComm.Text = resources.GetString("mnuComm.Text")
        Me.mnuComm.Visible = CType(resources.GetObject("mnuComm.Visible"), Boolean)
        '
        'MenuItem2
        '
        Me.MenuItem2.Enabled = CType(resources.GetObject("MenuItem2.Enabled"), Boolean)
        Me.MenuItem2.Index = 4
        Me.MenuItem2.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuChartData, Me.mnuDeleteUData})
        Me.MenuItem2.Shortcut = CType(resources.GetObject("MenuItem2.Shortcut"), System.Windows.Forms.Shortcut)
        Me.MenuItem2.ShowShortcut = CType(resources.GetObject("MenuItem2.ShowShortcut"), Boolean)
        Me.MenuItem2.Text = resources.GetString("MenuItem2.Text")
        Me.MenuItem2.Visible = CType(resources.GetObject("MenuItem2.Visible"), Boolean)
        '
        'mnuChartData
        '
        Me.mnuChartData.Enabled = CType(resources.GetObject("mnuChartData.Enabled"), Boolean)
        Me.mnuChartData.Index = 0
        Me.mnuChartData.Shortcut = CType(resources.GetObject("mnuChartData.Shortcut"), System.Windows.Forms.Shortcut)
        Me.mnuChartData.ShowShortcut = CType(resources.GetObject("mnuChartData.ShowShortcut"), Boolean)
        Me.mnuChartData.Text = resources.GetString("mnuChartData.Text")
        Me.mnuChartData.Visible = CType(resources.GetObject("mnuChartData.Visible"), Boolean)
        '
        'mnuDeleteUData
        '
        Me.mnuDeleteUData.Enabled = CType(resources.GetObject("mnuDeleteUData.Enabled"), Boolean)
        Me.mnuDeleteUData.Index = 1
        Me.mnuDeleteUData.Shortcut = CType(resources.GetObject("mnuDeleteUData.Shortcut"), System.Windows.Forms.Shortcut)
        Me.mnuDeleteUData.ShowShortcut = CType(resources.GetObject("mnuDeleteUData.ShowShortcut"), Boolean)
        Me.mnuDeleteUData.Text = resources.GetString("mnuDeleteUData.Text")
        Me.mnuDeleteUData.Visible = CType(resources.GetObject("mnuDeleteUData.Visible"), Boolean)
        '
        'txtStatus
        '
        Me.txtStatus.AccessibleDescription = resources.GetString("txtStatus.AccessibleDescription")
        Me.txtStatus.AccessibleName = resources.GetString("txtStatus.AccessibleName")
        Me.txtStatus.Anchor = CType(resources.GetObject("txtStatus.Anchor"), System.Windows.Forms.AnchorStyles)
        Me.txtStatus.AutoSize = CType(resources.GetObject("txtStatus.AutoSize"), Boolean)
        Me.txtStatus.BackgroundImage = CType(resources.GetObject("txtStatus.BackgroundImage"), System.Drawing.Image)
        Me.txtStatus.Dock = CType(resources.GetObject("txtStatus.Dock"), System.Windows.Forms.DockStyle)
        Me.txtStatus.Enabled = CType(resources.GetObject("txtStatus.Enabled"), Boolean)
        Me.txtStatus.Font = CType(resources.GetObject("txtStatus.Font"), System.Drawing.Font)
        Me.txtStatus.ImeMode = CType(resources.GetObject("txtStatus.ImeMode"), System.Windows.Forms.ImeMode)
        Me.txtStatus.Location = CType(resources.GetObject("txtStatus.Location"), System.Drawing.Point)
        Me.txtStatus.MaxLength = CType(resources.GetObject("txtStatus.MaxLength"), Integer)
        Me.txtStatus.Multiline = CType(resources.GetObject("txtStatus.Multiline"), Boolean)
        Me.txtStatus.Name = "txtStatus"
        Me.txtStatus.PasswordChar = CType(resources.GetObject("txtStatus.PasswordChar"), Char)
        Me.txtStatus.ReadOnly = True
        Me.txtStatus.RightToLeft = CType(resources.GetObject("txtStatus.RightToLeft"), System.Windows.Forms.RightToLeft)
        Me.txtStatus.ScrollBars = CType(resources.GetObject("txtStatus.ScrollBars"), System.Windows.Forms.ScrollBars)
        Me.txtStatus.Size = CType(resources.GetObject("txtStatus.Size"), System.Drawing.Size)
        Me.txtStatus.TabIndex = CType(resources.GetObject("txtStatus.TabIndex"), Integer)
        Me.txtStatus.Text = resources.GetString("txtStatus.Text")
        Me.txtStatus.TextAlign = CType(resources.GetObject("txtStatus.TextAlign"), System.Windows.Forms.HorizontalAlignment)
        Me.ToolTip1.SetToolTip(Me.txtStatus, resources.GetString("txtStatus.ToolTip"))
        Me.txtStatus.Visible = CType(resources.GetObject("txtStatus.Visible"), Boolean)
        Me.txtStatus.WordWrap = CType(resources.GetObject("txtStatus.WordWrap"), Boolean)
        '
        'btnClear
        '
        Me.btnClear.AccessibleDescription = resources.GetString("btnClear.AccessibleDescription")
        Me.btnClear.AccessibleName = resources.GetString("btnClear.AccessibleName")
        Me.btnClear.Anchor = CType(resources.GetObject("btnClear.Anchor"), System.Windows.Forms.AnchorStyles)
        Me.btnClear.BackgroundImage = CType(resources.GetObject("btnClear.BackgroundImage"), System.Drawing.Image)
        Me.btnClear.Dock = CType(resources.GetObject("btnClear.Dock"), System.Windows.Forms.DockStyle)
        Me.btnClear.Enabled = CType(resources.GetObject("btnClear.Enabled"), Boolean)
        Me.btnClear.FlatStyle = CType(resources.GetObject("btnClear.FlatStyle"), System.Windows.Forms.FlatStyle)
        Me.btnClear.Font = CType(resources.GetObject("btnClear.Font"), System.Drawing.Font)
        Me.btnClear.Image = CType(resources.GetObject("btnClear.Image"), System.Drawing.Image)
        Me.btnClear.ImageAlign = CType(resources.GetObject("btnClear.ImageAlign"), System.Drawing.ContentAlignment)
        Me.btnClear.ImageIndex = CType(resources.GetObject("btnClear.ImageIndex"), Integer)
        Me.btnClear.ImeMode = CType(resources.GetObject("btnClear.ImeMode"), System.Windows.Forms.ImeMode)
        Me.btnClear.Location = CType(resources.GetObject("btnClear.Location"), System.Drawing.Point)
        Me.btnClear.Name = "btnClear"
        Me.btnClear.RightToLeft = CType(resources.GetObject("btnClear.RightToLeft"), System.Windows.Forms.RightToLeft)
        Me.btnClear.Size = CType(resources.GetObject("btnClear.Size"), System.Drawing.Size)
        Me.btnClear.TabIndex = CType(resources.GetObject("btnClear.TabIndex"), Integer)
        Me.btnClear.Text = resources.GetString("btnClear.Text")
        Me.btnClear.TextAlign = CType(resources.GetObject("btnClear.TextAlign"), System.Drawing.ContentAlignment)
        Me.ToolTip1.SetToolTip(Me.btnClear, resources.GetString("btnClear.ToolTip"))
        Me.btnClear.Visible = CType(resources.GetObject("btnClear.Visible"), Boolean)
        '
        'OpenFileDialog1
        '
        Me.OpenFileDialog1.Filter = resources.GetString("OpenFileDialog1.Filter")
        Me.OpenFileDialog1.Title = resources.GetString("OpenFileDialog1.Title")
        '
        'SaveFileDialog1
        '
        Me.SaveFileDialog1.Filter = resources.GetString("SaveFileDialog1.Filter")
        Me.SaveFileDialog1.Title = resources.GetString("SaveFileDialog1.Title")
        '
        'ListBox1
        '
        Me.ListBox1.AccessibleDescription = resources.GetString("ListBox1.AccessibleDescription")
        Me.ListBox1.AccessibleName = resources.GetString("ListBox1.AccessibleName")
        Me.ListBox1.Anchor = CType(resources.GetObject("ListBox1.Anchor"), System.Windows.Forms.AnchorStyles)
        Me.ListBox1.BackgroundImage = CType(resources.GetObject("ListBox1.BackgroundImage"), System.Drawing.Image)
        Me.ListBox1.ColumnWidth = CType(resources.GetObject("ListBox1.ColumnWidth"), Integer)
        Me.ListBox1.Dock = CType(resources.GetObject("ListBox1.Dock"), System.Windows.Forms.DockStyle)
        Me.ListBox1.Enabled = CType(resources.GetObject("ListBox1.Enabled"), Boolean)
        Me.ListBox1.Font = CType(resources.GetObject("ListBox1.Font"), System.Drawing.Font)
        Me.ListBox1.HorizontalExtent = CType(resources.GetObject("ListBox1.HorizontalExtent"), Integer)
        Me.ListBox1.HorizontalScrollbar = CType(resources.GetObject("ListBox1.HorizontalScrollbar"), Boolean)
        Me.ListBox1.ImeMode = CType(resources.GetObject("ListBox1.ImeMode"), System.Windows.Forms.ImeMode)
        Me.ListBox1.IntegralHeight = CType(resources.GetObject("ListBox1.IntegralHeight"), Boolean)
        Me.ListBox1.ItemHeight = CType(resources.GetObject("ListBox1.ItemHeight"), Integer)
        Me.ListBox1.Location = CType(resources.GetObject("ListBox1.Location"), System.Drawing.Point)
        Me.ListBox1.Name = "ListBox1"
        Me.ListBox1.RightToLeft = CType(resources.GetObject("ListBox1.RightToLeft"), System.Windows.Forms.RightToLeft)
        Me.ListBox1.ScrollAlwaysVisible = CType(resources.GetObject("ListBox1.ScrollAlwaysVisible"), Boolean)
        Me.ListBox1.SelectionMode = System.Windows.Forms.SelectionMode.MultiExtended
        Me.ListBox1.Size = CType(resources.GetObject("ListBox1.Size"), System.Drawing.Size)
        Me.ListBox1.TabIndex = CType(resources.GetObject("ListBox1.TabIndex"), Integer)
        Me.ToolTip1.SetToolTip(Me.ListBox1, resources.GetString("ListBox1.ToolTip"))
        Me.ListBox1.Visible = CType(resources.GetObject("ListBox1.Visible"), Boolean)
        '
        'Label1
        '
        Me.Label1.AccessibleDescription = resources.GetString("Label1.AccessibleDescription")
        Me.Label1.AccessibleName = resources.GetString("Label1.AccessibleName")
        Me.Label1.Anchor = CType(resources.GetObject("Label1.Anchor"), System.Windows.Forms.AnchorStyles)
        Me.Label1.AutoSize = CType(resources.GetObject("Label1.AutoSize"), Boolean)
        Me.Label1.Dock = CType(resources.GetObject("Label1.Dock"), System.Windows.Forms.DockStyle)
        Me.Label1.Enabled = CType(resources.GetObject("Label1.Enabled"), Boolean)
        Me.Label1.Font = CType(resources.GetObject("Label1.Font"), System.Drawing.Font)
        Me.Label1.Image = CType(resources.GetObject("Label1.Image"), System.Drawing.Image)
        Me.Label1.ImageAlign = CType(resources.GetObject("Label1.ImageAlign"), System.Drawing.ContentAlignment)
        Me.Label1.ImageIndex = CType(resources.GetObject("Label1.ImageIndex"), Integer)
        Me.Label1.ImeMode = CType(resources.GetObject("Label1.ImeMode"), System.Windows.Forms.ImeMode)
        Me.Label1.Location = CType(resources.GetObject("Label1.Location"), System.Drawing.Point)
        Me.Label1.Name = "Label1"
        Me.Label1.RightToLeft = CType(resources.GetObject("Label1.RightToLeft"), System.Windows.Forms.RightToLeft)
        Me.Label1.Size = CType(resources.GetObject("Label1.Size"), System.Drawing.Size)
        Me.Label1.TabIndex = CType(resources.GetObject("Label1.TabIndex"), Integer)
        Me.Label1.Text = resources.GetString("Label1.Text")
        Me.Label1.TextAlign = CType(resources.GetObject("Label1.TextAlign"), System.Drawing.ContentAlignment)
        Me.ToolTip1.SetToolTip(Me.Label1, resources.GetString("Label1.ToolTip"))
        Me.Label1.Visible = CType(resources.GetObject("Label1.Visible"), Boolean)
        '
        'ListBox2
        '
        Me.ListBox2.AccessibleDescription = resources.GetString("ListBox2.AccessibleDescription")
        Me.ListBox2.AccessibleName = resources.GetString("ListBox2.AccessibleName")
        Me.ListBox2.Anchor = CType(resources.GetObject("ListBox2.Anchor"), System.Windows.Forms.AnchorStyles)
        Me.ListBox2.BackgroundImage = CType(resources.GetObject("ListBox2.BackgroundImage"), System.Drawing.Image)
        Me.ListBox2.ColumnWidth = CType(resources.GetObject("ListBox2.ColumnWidth"), Integer)
        Me.ListBox2.Dock = CType(resources.GetObject("ListBox2.Dock"), System.Windows.Forms.DockStyle)
        Me.ListBox2.Enabled = CType(resources.GetObject("ListBox2.Enabled"), Boolean)
        Me.ListBox2.Font = CType(resources.GetObject("ListBox2.Font"), System.Drawing.Font)
        Me.ListBox2.HorizontalExtent = CType(resources.GetObject("ListBox2.HorizontalExtent"), Integer)
        Me.ListBox2.HorizontalScrollbar = CType(resources.GetObject("ListBox2.HorizontalScrollbar"), Boolean)
        Me.ListBox2.ImeMode = CType(resources.GetObject("ListBox2.ImeMode"), System.Windows.Forms.ImeMode)
        Me.ListBox2.IntegralHeight = CType(resources.GetObject("ListBox2.IntegralHeight"), Boolean)
        Me.ListBox2.ItemHeight = CType(resources.GetObject("ListBox2.ItemHeight"), Integer)
        Me.ListBox2.Location = CType(resources.GetObject("ListBox2.Location"), System.Drawing.Point)
        Me.ListBox2.Name = "ListBox2"
        Me.ListBox2.RightToLeft = CType(resources.GetObject("ListBox2.RightToLeft"), System.Windows.Forms.RightToLeft)
        Me.ListBox2.ScrollAlwaysVisible = CType(resources.GetObject("ListBox2.ScrollAlwaysVisible"), Boolean)
        Me.ListBox2.Size = CType(resources.GetObject("ListBox2.Size"), System.Drawing.Size)
        Me.ListBox2.TabIndex = CType(resources.GetObject("ListBox2.TabIndex"), Integer)
        Me.ToolTip1.SetToolTip(Me.ListBox2, resources.GetString("ListBox2.ToolTip"))
        Me.ListBox2.Visible = CType(resources.GetObject("ListBox2.Visible"), Boolean)
        '
        'Label2
        '
        Me.Label2.AccessibleDescription = resources.GetString("Label2.AccessibleDescription")
        Me.Label2.AccessibleName = resources.GetString("Label2.AccessibleName")
        Me.Label2.Anchor = CType(resources.GetObject("Label2.Anchor"), System.Windows.Forms.AnchorStyles)
        Me.Label2.AutoSize = CType(resources.GetObject("Label2.AutoSize"), Boolean)
        Me.Label2.Dock = CType(resources.GetObject("Label2.Dock"), System.Windows.Forms.DockStyle)
        Me.Label2.Enabled = CType(resources.GetObject("Label2.Enabled"), Boolean)
        Me.Label2.Font = CType(resources.GetObject("Label2.Font"), System.Drawing.Font)
        Me.Label2.Image = CType(resources.GetObject("Label2.Image"), System.Drawing.Image)
        Me.Label2.ImageAlign = CType(resources.GetObject("Label2.ImageAlign"), System.Drawing.ContentAlignment)
        Me.Label2.ImageIndex = CType(resources.GetObject("Label2.ImageIndex"), Integer)
        Me.Label2.ImeMode = CType(resources.GetObject("Label2.ImeMode"), System.Windows.Forms.ImeMode)
        Me.Label2.Location = CType(resources.GetObject("Label2.Location"), System.Drawing.Point)
        Me.Label2.Name = "Label2"
        Me.Label2.RightToLeft = CType(resources.GetObject("Label2.RightToLeft"), System.Windows.Forms.RightToLeft)
        Me.Label2.Size = CType(resources.GetObject("Label2.Size"), System.Drawing.Size)
        Me.Label2.TabIndex = CType(resources.GetObject("Label2.TabIndex"), Integer)
        Me.Label2.Text = resources.GetString("Label2.Text")
        Me.Label2.TextAlign = CType(resources.GetObject("Label2.TextAlign"), System.Drawing.ContentAlignment)
        Me.ToolTip1.SetToolTip(Me.Label2, resources.GetString("Label2.ToolTip"))
        Me.Label2.Visible = CType(resources.GetObject("Label2.Visible"), Boolean)
        '
        'Label3
        '
        Me.Label3.AccessibleDescription = resources.GetString("Label3.AccessibleDescription")
        Me.Label3.AccessibleName = resources.GetString("Label3.AccessibleName")
        Me.Label3.Anchor = CType(resources.GetObject("Label3.Anchor"), System.Windows.Forms.AnchorStyles)
        Me.Label3.AutoSize = CType(resources.GetObject("Label3.AutoSize"), Boolean)
        Me.Label3.Dock = CType(resources.GetObject("Label3.Dock"), System.Windows.Forms.DockStyle)
        Me.Label3.Enabled = CType(resources.GetObject("Label3.Enabled"), Boolean)
        Me.Label3.Font = CType(resources.GetObject("Label3.Font"), System.Drawing.Font)
        Me.Label3.Image = CType(resources.GetObject("Label3.Image"), System.Drawing.Image)
        Me.Label3.ImageAlign = CType(resources.GetObject("Label3.ImageAlign"), System.Drawing.ContentAlignment)
        Me.Label3.ImageIndex = CType(resources.GetObject("Label3.ImageIndex"), Integer)
        Me.Label3.ImeMode = CType(resources.GetObject("Label3.ImeMode"), System.Windows.Forms.ImeMode)
        Me.Label3.Location = CType(resources.GetObject("Label3.Location"), System.Drawing.Point)
        Me.Label3.Name = "Label3"
        Me.Label3.RightToLeft = CType(resources.GetObject("Label3.RightToLeft"), System.Windows.Forms.RightToLeft)
        Me.Label3.Size = CType(resources.GetObject("Label3.Size"), System.Drawing.Size)
        Me.Label3.TabIndex = CType(resources.GetObject("Label3.TabIndex"), Integer)
        Me.Label3.Text = resources.GetString("Label3.Text")
        Me.Label3.TextAlign = CType(resources.GetObject("Label3.TextAlign"), System.Drawing.ContentAlignment)
        Me.ToolTip1.SetToolTip(Me.Label3, resources.GetString("Label3.ToolTip"))
        Me.Label3.Visible = CType(resources.GetObject("Label3.Visible"), Boolean)
        '
        'Label4
        '
        Me.Label4.AccessibleDescription = resources.GetString("Label4.AccessibleDescription")
        Me.Label4.AccessibleName = resources.GetString("Label4.AccessibleName")
        Me.Label4.Anchor = CType(resources.GetObject("Label4.Anchor"), System.Windows.Forms.AnchorStyles)
        Me.Label4.AutoSize = CType(resources.GetObject("Label4.AutoSize"), Boolean)
        Me.Label4.Dock = CType(resources.GetObject("Label4.Dock"), System.Windows.Forms.DockStyle)
        Me.Label4.Enabled = CType(resources.GetObject("Label4.Enabled"), Boolean)
        Me.Label4.Font = CType(resources.GetObject("Label4.Font"), System.Drawing.Font)
        Me.Label4.Image = CType(resources.GetObject("Label4.Image"), System.Drawing.Image)
        Me.Label4.ImageAlign = CType(resources.GetObject("Label4.ImageAlign"), System.Drawing.ContentAlignment)
        Me.Label4.ImageIndex = CType(resources.GetObject("Label4.ImageIndex"), Integer)
        Me.Label4.ImeMode = CType(resources.GetObject("Label4.ImeMode"), System.Windows.Forms.ImeMode)
        Me.Label4.Location = CType(resources.GetObject("Label4.Location"), System.Drawing.Point)
        Me.Label4.Name = "Label4"
        Me.Label4.RightToLeft = CType(resources.GetObject("Label4.RightToLeft"), System.Windows.Forms.RightToLeft)
        Me.Label4.Size = CType(resources.GetObject("Label4.Size"), System.Drawing.Size)
        Me.Label4.TabIndex = CType(resources.GetObject("Label4.TabIndex"), Integer)
        Me.Label4.Text = resources.GetString("Label4.Text")
        Me.Label4.TextAlign = CType(resources.GetObject("Label4.TextAlign"), System.Drawing.ContentAlignment)
        Me.ToolTip1.SetToolTip(Me.Label4, resources.GetString("Label4.ToolTip"))
        Me.Label4.Visible = CType(resources.GetObject("Label4.Visible"), Boolean)
        '
        'txtTotal
        '
        Me.txtTotal.AccessibleDescription = resources.GetString("txtTotal.AccessibleDescription")
        Me.txtTotal.AccessibleName = resources.GetString("txtTotal.AccessibleName")
        Me.txtTotal.Anchor = CType(resources.GetObject("txtTotal.Anchor"), System.Windows.Forms.AnchorStyles)
        Me.txtTotal.AutoSize = CType(resources.GetObject("txtTotal.AutoSize"), Boolean)
        Me.txtTotal.BackgroundImage = CType(resources.GetObject("txtTotal.BackgroundImage"), System.Drawing.Image)
        Me.txtTotal.Dock = CType(resources.GetObject("txtTotal.Dock"), System.Windows.Forms.DockStyle)
        Me.txtTotal.Enabled = CType(resources.GetObject("txtTotal.Enabled"), Boolean)
        Me.txtTotal.Font = CType(resources.GetObject("txtTotal.Font"), System.Drawing.Font)
        Me.txtTotal.ImeMode = CType(resources.GetObject("txtTotal.ImeMode"), System.Windows.Forms.ImeMode)
        Me.txtTotal.Location = CType(resources.GetObject("txtTotal.Location"), System.Drawing.Point)
        Me.txtTotal.MaxLength = CType(resources.GetObject("txtTotal.MaxLength"), Integer)
        Me.txtTotal.Multiline = CType(resources.GetObject("txtTotal.Multiline"), Boolean)
        Me.txtTotal.Name = "txtTotal"
        Me.txtTotal.PasswordChar = CType(resources.GetObject("txtTotal.PasswordChar"), Char)
        Me.txtTotal.RightToLeft = CType(resources.GetObject("txtTotal.RightToLeft"), System.Windows.Forms.RightToLeft)
        Me.txtTotal.ScrollBars = CType(resources.GetObject("txtTotal.ScrollBars"), System.Windows.Forms.ScrollBars)
        Me.txtTotal.Size = CType(resources.GetObject("txtTotal.Size"), System.Drawing.Size)
        Me.txtTotal.TabIndex = CType(resources.GetObject("txtTotal.TabIndex"), Integer)
        Me.txtTotal.Text = resources.GetString("txtTotal.Text")
        Me.txtTotal.TextAlign = CType(resources.GetObject("txtTotal.TextAlign"), System.Windows.Forms.HorizontalAlignment)
        Me.ToolTip1.SetToolTip(Me.txtTotal, resources.GetString("txtTotal.ToolTip"))
        Me.txtTotal.Visible = CType(resources.GetObject("txtTotal.Visible"), Boolean)
        Me.txtTotal.WordWrap = CType(resources.GetObject("txtTotal.WordWrap"), Boolean)
        '
        'txtSelected
        '
        Me.txtSelected.AccessibleDescription = resources.GetString("txtSelected.AccessibleDescription")
        Me.txtSelected.AccessibleName = resources.GetString("txtSelected.AccessibleName")
        Me.txtSelected.Anchor = CType(resources.GetObject("txtSelected.Anchor"), System.Windows.Forms.AnchorStyles)
        Me.txtSelected.AutoSize = CType(resources.GetObject("txtSelected.AutoSize"), Boolean)
        Me.txtSelected.BackgroundImage = CType(resources.GetObject("txtSelected.BackgroundImage"), System.Drawing.Image)
        Me.txtSelected.Dock = CType(resources.GetObject("txtSelected.Dock"), System.Windows.Forms.DockStyle)
        Me.txtSelected.Enabled = CType(resources.GetObject("txtSelected.Enabled"), Boolean)
        Me.txtSelected.Font = CType(resources.GetObject("txtSelected.Font"), System.Drawing.Font)
        Me.txtSelected.ImeMode = CType(resources.GetObject("txtSelected.ImeMode"), System.Windows.Forms.ImeMode)
        Me.txtSelected.Location = CType(resources.GetObject("txtSelected.Location"), System.Drawing.Point)
        Me.txtSelected.MaxLength = CType(resources.GetObject("txtSelected.MaxLength"), Integer)
        Me.txtSelected.Multiline = CType(resources.GetObject("txtSelected.Multiline"), Boolean)
        Me.txtSelected.Name = "txtSelected"
        Me.txtSelected.PasswordChar = CType(resources.GetObject("txtSelected.PasswordChar"), Char)
        Me.txtSelected.RightToLeft = CType(resources.GetObject("txtSelected.RightToLeft"), System.Windows.Forms.RightToLeft)
        Me.txtSelected.ScrollBars = CType(resources.GetObject("txtSelected.ScrollBars"), System.Windows.Forms.ScrollBars)
        Me.txtSelected.Size = CType(resources.GetObject("txtSelected.Size"), System.Drawing.Size)
        Me.txtSelected.TabIndex = CType(resources.GetObject("txtSelected.TabIndex"), Integer)
        Me.txtSelected.Text = resources.GetString("txtSelected.Text")
        Me.txtSelected.TextAlign = CType(resources.GetObject("txtSelected.TextAlign"), System.Windows.Forms.HorizontalAlignment)
        Me.ToolTip1.SetToolTip(Me.txtSelected, resources.GetString("txtSelected.ToolTip"))
        Me.txtSelected.Visible = CType(resources.GetObject("txtSelected.Visible"), Boolean)
        Me.txtSelected.WordWrap = CType(resources.GetObject("txtSelected.WordWrap"), Boolean)
        '
        'frmMain
        '
        Me.AccessibleDescription = resources.GetString("$this.AccessibleDescription")
        Me.AccessibleName = resources.GetString("$this.AccessibleName")
        Me.AutoScaleBaseSize = CType(resources.GetObject("$this.AutoScaleBaseSize"), System.Drawing.Size)
        Me.AutoScroll = CType(resources.GetObject("$this.AutoScroll"), Boolean)
        Me.AutoScrollMargin = CType(resources.GetObject("$this.AutoScrollMargin"), System.Drawing.Size)
        Me.AutoScrollMinSize = CType(resources.GetObject("$this.AutoScrollMinSize"), System.Drawing.Size)
        Me.BackgroundImage = CType(resources.GetObject("$this.BackgroundImage"), System.Drawing.Image)
        Me.ClientSize = CType(resources.GetObject("$this.ClientSize"), System.Drawing.Size)
        Me.Controls.Add(Me.txtSelected)
        Me.Controls.Add(Me.txtTotal)
        Me.Controls.Add(Me.Label4)
        Me.Controls.Add(Me.Label3)
        Me.Controls.Add(Me.Label2)
        Me.Controls.Add(Me.ListBox2)
        Me.Controls.Add(Me.Label1)
        Me.Controls.Add(Me.ListBox1)
        Me.Controls.Add(Me.btnClear)
        Me.Controls.Add(Me.txtStatus)
        Me.Enabled = CType(resources.GetObject("$this.Enabled"), Boolean)
        Me.Font = CType(resources.GetObject("$this.Font"), System.Drawing.Font)
        Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle
        Me.Icon = CType(resources.GetObject("$this.Icon"), System.Drawing.Icon)
        Me.ImeMode = CType(resources.GetObject("$this.ImeMode"), System.Windows.Forms.ImeMode)
        Me.Location = CType(resources.GetObject("$this.Location"), System.Drawing.Point)
        Me.MaximizeBox = False
        Me.MaximumSize = CType(resources.GetObject("$this.MaximumSize"), System.Drawing.Size)
        Me.Menu = Me.mnuMain
        Me.MinimumSize = CType(resources.GetObject("$this.MinimumSize"), System.Drawing.Size)
        Me.Name = "frmMain"
        Me.RightToLeft = CType(resources.GetObject("$this.RightToLeft"), System.Windows.Forms.RightToLeft)
        Me.StartPosition = CType(resources.GetObject("$this.StartPosition"), System.Windows.Forms.FormStartPosition)
        Me.Text = resources.GetString("$this.Text")
        Me.ToolTip1.SetToolTip(Me, resources.GetString("$this.ToolTip"))
        Me.ResumeLayout(False)

    End Sub

#End Region

#Region " Standard Menu Code "
    ' <System.Diagnostics.DebuggerStepThrough()> has been added to some procedures since they are
    ' not the focus of the demo. Remove them if you wish to debug the procedures.
    ' This code simply shows the About form.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub mnuAbout_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuAbout.Click
        ' Open the About form in Dialog Mode
        Dim frm As New frmAbout
        frm.ShowDialog(Me)
        frm.Dispose()
    End Sub

    <System.Diagnostics.DebuggerStepThrough()> Private Sub mnuExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuExit.Click
        m_CommPort.Close() ' CLOSE PORT
        ' Close the current form
        Me.Close()
    End Sub
#End Region

    Function Convertbytes2int(ByRef B1 As Byte, ByRef B2 As Byte) As Integer
        Dim ANS As Integer
        ' MsgBox(Hex(B1) + " " + Hex(B2))
        ANS = 256 * B1  ' SHIFT HIGH ORDER BYTE
        ANS = ANS + B2  ' ADD LOW ORDER BYTE
        Return ANS
    End Function

    Private Sub mnuQuery_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuQuery.Click
        ' This function checks to see if the port is a DGC, by sending 
        '   an "Q" command to the port. If the port responds with a 0x00 "R", it is assumed to 
        '   be a Digital Geiger Counter. 
        If (m_DGCPort = 0) Then
            MsgBox("You must select a COM port first")
            Exit Sub
        End If

        ' Always wrap up working with Comm Ports in exception handlers.
        Try
            ' Attempt to open the port.
            m_CommPort.Open(m_DGCPort, 19200, 8, Rs232.DataParity.Parity_None, _
               Rs232.DataStopBit.StopBit_1, 4096)
            Try
                ' Write a QUERY Command to the Port.
                m_CommPort.Write(Encoding.ASCII.GetBytes("Q"))
                ' Sleep long enough for the DGC to respond and the timer to fire.
                System.Threading.Thread.Sleep(200)
                Application.DoEvents()

                ' Try to read two byte. If you get a 0x00 "R", then 
                '   query has been successful. 0x00 is abyte containing the
                ' number of data points storedon DGC
                m_CommPort.Read(2)
                If (Chr(m_CommPort.InputStream(1)) = "R") Then  'R
                    NUM_DATAPOINTS = m_CommPort.InputStream(0)
                    m_CommPort.ClearInputBuffer()
                    WriteMessage("Digital Geiger Counter with " + Format(NUM_DATAPOINTS, "000") + " datapoints identified on COM" + (m_DGCPort).ToString())
                    ' ENABLE OTHER MENU ITEMS
                    Me.mnuUpload.Enabled = True
                    Me.mnuErase.Enabled = True
                    Me.mnuSetdate.Enabled = True
                    'LEAVE PORT OPEN FOR ADDITIONAL COMMANDS
                Else
                    m_CommPort.Close() ' CLOSE PORT TO TRY AGAIN
                    WriteMessage("Digital Geiger Counter not identified on COM" + (m_DGCPort).ToString())
                End If
            Catch exc As Exception
                ' Nothing to read from the Comm Port, so set to False
                m_CommPort.Close() ' CLOSE PORT TO TRY AGAIN
                WriteMessage("Digital Geiger Query failed on COM" + (m_DGCPort).ToString())
            End Try
        Catch exc As Exception
            ' Port could not be opened or written to.
            MsgBox("Could not open port.", MsgBoxStyle.OKOnly, Me.Text)
        End Try
        ' COME HERE IF QUERY ABORTED   
    End Sub

    Private Function IsPortAvailable(ByVal ComPort As Integer) As Boolean
        ' This function attempts to open the passed Comm Port. If it is
        '   available, it returns True, else it returns False. To determine
        '   availability a Try-Catch block is used.
        Try
            m_CommPort.Open(ComPort, 115200, 8, Rs232.DataParity.Parity_None, _
                Rs232.DataStopBit.StopBit_1, 4096)
            ' If it makes it to here, then the Comm Port is available.
            m_CommPort.Close()
            Return True
        Catch
            ' If it gets here, then the attempt to open the Comm Port
            '   was unsuccessful.
            Return False
        End Try
    End Function

    Private Sub WriteMessage(ByVal message As String)
        ' This subroutine writes a message to the txtStatus TextBox.
        Me.txtStatus.Text = message + vbCrLf + Me.txtStatus.Text
    End Sub

    Private Sub WriteMessage(ByVal message As String, ByVal linefeed As Boolean)
        ' THIS WRITES A MESSAGE TO THE TXTSTATUS TEXTBOX AND ALLOWS LINE FEED TO BE SUPPRESSED
        If linefeed Then
            Me.txtStatus.Text = message + vbCrLf + Me.txtStatus.Text
        Else
            Me.txtStatus.Text = message + Me.txtStatus.Text
        End If
    End Sub

    Private Sub frmMain_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' THIS ROUTINE DETERMINES WHICH ARE VALID PORTS AND ADDS THEM TO THE PORT LIST ON THE 
        ' COMM MENU
        Dim i As Integer
        For i = 0 To 8
            If IsPortAvailable(i + 1) Then
                ' Write message to the user.
                WriteMessage("Port " + (i + 1).ToString() + _
                    " is a Com Port.")
                ' ADD MENU ITEMS FOR VALID PORTS
                Me.mnuComm.MenuItems.Add("COM" + (i + 1).ToString(), New EventHandler(AddressOf Com_Click))
            End If
        Next i
        ListBox1.Items.Clear()
        txtTotal.Text = ListBox1.Items.Count.ToString ' display item count
    End Sub

    Private Sub Com_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuComm.Click
        ' THIS ROUTINE GETS EXECUTED ANY TIME ONE OF THE MNUCOMM ITEMS GETS CLICKED ON
        If sender.CHECKED = True Then
            sender.checked = False
        Else
            sender.checked = True
        End If
        ' DETERMINE WHICH COM WAS CLICKED
        m_DGCPort = Mid(sender.text, 4, 1) ' GET THE FOURTH CHARACTER COMx

    End Sub

    Private Sub btnClear_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnClear.Click
        ' THIS ROUTINE ERASES THE STATUS WINDOW.
        txtStatus.Text = ""
    End Sub

    Private Sub mnuUpload_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuUpload.Click
        ' THIS ROUTINE UPLOADS ALL DATA ON THE DIGITAL GEIGER COUNTER TO THE PC
        Dim I As Integer
        Dim II As Byte
        Dim I_INT As Integer
        Dim INDEX As Integer
        Dim DGC_DATA(16) As Integer
        WriteMessage("Uploading " + Format(NUM_DATAPOINTS, "##0") + " datapoints...")

        Try
            For I = 1 To NUM_DATAPOINTS
                ' Write an upload "U" Command with desired data point to the Port.
                m_CommPort.Write("U" + Chr(I))
                ' Sleep long enough for the DGC to respond 
                System.Threading.Thread.Sleep(200)
                Application.DoEvents()

                ' NOW READ THE DATA
                Try
                    ' Try to read a 34 bytes. 
                    m_CommPort.Read(34)
                    'Parse the data
                    II = m_CommPort.InputStream(0) ' first item is datapoint #
                    I_INT = CInt(Val(II))
                    If (I <> I_INT) Then
                        Exit Sub
                    End If

                    If (Chr(m_CommPort.InputStream(33)) = "R") Then ' last item should be "R"
                        ' LOOKS LIKE GOOD DATA SO LETS STORE
                        For INDEX = 0 To 15 ' store the count data
                            'CONVERT BYTE DATA TO INTEGER BEFORE STORING
                            DGC_DATA(INDEX) = Convertbytes2int(m_CommPort.InputStream(INDEX * 2 + 2), m_CommPort.InputStream(INDEX * 2 + 1))
                        Next INDEX
                        m_CommPort.ClearInputBuffer()
                        WriteMessage("Datapoint #" + Format(I, "###") + " received.")

                        ' DISPLAY THE JUST RECEIVED DATAPOINT IN LISTBOX
                        ListBox1.Items.Add(Format(DGC_DATA(0), "000 ") + Format(DGC_DATA(1), "00000 ") + _
                        Format(DGC_DATA(2), "00/") + Format(DGC_DATA(3), "00/") + Format(DGC_DATA(4), "00 ") + _
                         Format(DGC_DATA(5), "00:") + Format(DGC_DATA(6), "00:") + Format(DGC_DATA(7), "00"))
                        txtTotal.Text = ListBox1.Items.Count ' display item count
                        m_CommPort.ClearInputBuffer()
                    End If
                Catch exc As Exception
                    m_CommPort.ClearInputBuffer()
                    WriteMessage("Datapoint #" + Format(I, "###") + " not received!")
                End Try

            Next I
            WriteMessage("Upload complete.")
        Catch ex As Exception
            ' Warn the user.
            WriteMessage("Unable to communicate with DGC")
        End Try
    End Sub

    Private Sub mnuErase_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuErase.Click
        ' THIS ROUTINE ERASES THE DATA IN THE FLASH PROGRAM MEMORY ON THE DIGITAL GEIGER COUNTER
        Dim ANS As Integer
        ANS = MsgBox("Are you sure you want to erase data in Digital Geiger Counter?", MsgBoxStyle.YesNo, "ERASE")
        If (ANS = vbYes) Then
            ' send "E" to DGC to erase EEPROM
            ' Always wrap up working with Comm Ports in exception handlers.

            ' Write an "E" Command to the Port.
            m_CommPort.Write(Encoding.ASCII.GetBytes("E"))  'E
            System.Threading.Thread.Sleep(1000)
            Application.DoEvents()
            ' Try to get info from the Comm Port.
            Try
                ' Try to read a single byte. If you get a "R", then 
                '   erase has been successful.
                m_CommPort.Read(1)
                If (Chr(m_CommPort.InputStream(0)) = "R") Then  'R
                    m_CommPort.ClearInputBuffer()
                    WriteMessage("Digital Geiger Counter erase successful.")
                Else
                    WriteMessage("Digital Geiger Counter erase failed!")
                End If
            Catch exc As Exception
                ' Nothing to read from the Comm Port, so set to False
                m_CommPort.ClearInputBuffer()
                WriteMessage("Digital Geiger Counter erase failed!")
            End Try
        End If
        ' COME HERE IF ERASE ABORTED     
    End Sub

    Private Sub mnuSetdate_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuSetdate.Click
        ' THIS ROUTINE SETS THE CLOCK ON THE DIGITAL GEIGER COUNTER TO THE TIME
        ' ON THE PERSONAL COMPUTER
        Dim ans As Integer
        Dim MYDATETIME(7) As Byte
        ans = MsgBox("Set DGC date/time to " + Format(Today, "MM/dd/yy ") + Format(TimeOfDay, "HH:mm:ss"), MsgBoxStyle.OKCancel, "SET DATE/TIME")
        If (ans = vbOK) Then
            ' extract time date information
            MYDATETIME(0) = CByte(83) ' character S
            MYDATETIME(1) = CByte(Month(Today))
            MYDATETIME(2) = CByte(Microsoft.VisualBasic.DateAndTime.Day(Today))
            MYDATETIME(3) = CByte(Year(Today) - 2000)
            MYDATETIME(4) = CByte(Hour(TimeOfDay))
            MYDATETIME(5) = CByte(Minute(TimeOfDay))
            MYDATETIME(6) = CByte(Second(TimeOfDay))

            ' Write an "S" Command with data to the Port.
            m_CommPort.Write(MYDATETIME)
            ' Sleep long enough for the DGC to respond.
            System.Threading.Thread.Sleep(1000)
            Application.DoEvents()
            ' Try to get info from the Comm Port.
            Try
                ' Try to read a single byte. If you get a "R", then 
                '   set date/time has been successful.
                m_CommPort.Read(1)
                If (Chr(m_CommPort.InputStream(0)) = "R") Then  'R
                    m_CommPort.ClearInputBuffer()
                    WriteMessage("Digital Geiger Counter set time/date successful.")
                Else
                    m_CommPort.ClearInputBuffer()
                    WriteMessage("Digital Geiger Counter set time/date failed!")
                End If
            Catch exc As Exception
                ' Nothing to read from the Comm Port, so set to False
                WriteMessage("Digital Geiger Counter set time/date failed!")
            End Try
        End If
        ' COME HERE IF SET ABORTED     

    End Sub

    Private Sub mnuExport_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuExport.Click
        ' THIS ROUTINE EXPORTS THE UPLOADED DATAPOINTS TO A SPACE DELIMITED TEXTFILE
        Dim I As Integer
        SaveFileDialog1.Filter = "Text file|*.txt"
        If SaveFileDialog1.ShowDialog() = DialogResult.OK Then
            FileOpen(1, SaveFileDialog1.FileName, OpenMode.Output, OpenAccess.Write, OpenShare.Default)
            For I = 0 To ListBox1.Items.Count() - 1
                ' WRITE EACH DATA POINT ON SEPARATE LINE IN FILE, DATA SEPARATED BY BLANKS
                PrintLine(1, ListBox1.Items(I))
            Next I
            WriteMessage(ListBox1.Items.Count.ToString + " datapoints exported to textfile " + SaveFileDialog1.FileName.ToString)
            FileClose(1)
        End If
    End Sub

    Private Sub frmMain_Closing(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles MyBase.Closing
        m_CommPort.Close() ' CLOSE PORT
    End Sub

    Private Sub mnuDeleteUData_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuDeleteUData.Click
        Dim MAXDATA As Integer
        Dim J As Integer
        Dim I As Integer
        MAXDATA = ListBox1.Items.Count
        Me.ListBox1.Items.Clear() ' REMOVE ALL DATA FROM LISTBOX
        ' ZERO DATA IN DATA ARRAY
        '      For I = 0 To MAXDATA - 1
        '     For J = 0 To 15
        '    DGC_DATA(I, J) = 0
        '   Next J
        '  Next I
        txtTotal.Text = ListBox1.Items.Count.ToString ' display item count
        txtSelected.Text = ListBox1.SelectedItems.Count.ToString ' display selected count

    End Sub

    Private Sub mnuChartData_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuChartData.Click
        Dim frm As New frmGraph
        Dim NUMSELECT As Integer
        Dim I As Integer
        Dim COUNT As Integer
        Dim TIME As Integer
        Dim MINTIME As Integer
        Dim MAXTIME As Integer
        Dim REST As String
        Dim LENGTH As Integer
        Dim MULT As Integer
        ' MAKE SURE ALL DATA HAS SAME COUNT TIME
        ' IF NOT, MAKE THEM THE SAME
        NUMSELECT = 0
        If ListBox1.SelectedIndices.Count < 2 Then
            MsgBox("You must select at least two data points for plotting.")
            Exit Sub
        End If
        ListBox2.Items.Clear()
        For I = 0 To ListBox1.SelectedIndices.Count - 1
            ListBox2.Items.Add(ListBox1.Items(ListBox1.SelectedIndices.Item(I)))
        Next I

        ' CHECK TO MAKE SURE ALL TIMES ARE CONSISTENT
        MAXTIME = 0
        MINTIME = 600
        For I = 0 To ListBox2.Items.Count - 1
            TIME = CInt(Mid(ListBox1.Items(I), 1, 3))
            If TIME > MAXTIME Then MAXTIME = TIME
            If TIME < MINTIME Then MINTIME = TIME
        Next
        If MINTIME <> MAXTIME Then
            ' SOME TIMES ARE NOT THE SAME AND MUST BE PROCESSED
            MsgBox("All data will be converted to " + Format(MAXTIME, "####") + " seconds.")
            For I = 0 To ListBox2.Items.Count - 1
                TIME = CInt(Mid(ListBox2.Items(I), 1, 3))
                MULT = MAXTIME / TIME
                COUNTPERIOD = TIME * MULT
                COUNT = CInt(Mid(ListBox2.Items(I), 5, 5))
                COUNT = COUNT * MULT
                LENGTH = Len(ListBox2.Items(I))
                REST = Mid(ListBox2.Items(I), 11, LENGTH)
                ListBox2.Items(I) = Format(COUNTPERIOD, "000 ") + Format(COUNT, "00000 ") + REST
            Next
        Else
            COUNTPERIOD = TIME ' ALL COUNT TIMES ARE SAME
        End If
        ' LOAD DATA FOR PLOTTING
        For I = 0 To ListBox2.Items.Count - 1
            m_Y(I) = CInt(Mid(ListBox2.Items(I), 5, 5))
            m_X(I) = CDate(Mid(ListBox2.Items(I), 11, 17))
        Next I
        PLOTPOINTS = ListBox2.Items.Count
        ' SHOW THE GRAPH
        frm.ShowDialog(Me)
        frm.Dispose()
    End Sub

    Private Sub mnuImport_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuImport.Click
        Dim MYLINE As String
        Dim I As Integer
        OpenFileDialog1.ShowDialog()
        FileOpen(1, OpenFileDialog1.FileName, OpenMode.Input, OpenAccess.Read, OpenShare.Default)
        Do While Not EOF(1)   ' Loop until end of file.
            MYLINE = LineInput(1)   ' Read line into variable.
            ListBox1.Items.Add(MYLINE)
        Loop
        FileClose(1)   ' Close file
        NUM_DATAPOINTS = ListBox1.Items.Count
        txtTotal.Text = ListBox1.Items.Count ' display item count
        'PARSE THE DATA IN THE LISTBOX
        ' For I = 1 To NUM_DATAPOINTS
        'DGC_DATA(I, 0) = Mid(ListBox1.Items(I - 1), 1, 3) ' TIME
        'DGC_DATA(I, 1) = Mid(ListBox1.Items(I - 1), 5, 5) 'COUNT
        'DGC_DATA(I, 2) = Mid(ListBox1.Items(I - 1), 11, 2) 'MONTH
        'DGC_DATA(I, 3) = Mid(ListBox1.Items(I - 1), 14, 2) 'DAY
        'DGC_DATA(I, 4) = Mid(ListBox1.Items(I - 1), 17, 2) 'YEAR
        'DGC_DATA(I, 5) = Mid(ListBox1.Items(I - 1), 20, 2) 'HOUR
        'DGC_DATA(I, 6) = Mid(ListBox1.Items(I - 1), 23, 2) 'MIN
        'DGC_DATA(I, 7) = Mid(ListBox1.Items(I - 1), 26, 2) 'SECOND
        'Next I
    End Sub

    Private Sub OpenFileDialog1_FileOk(ByVal sender As System.Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles OpenFileDialog1.FileOk

    End Sub

    Private Sub ListBox1_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ListBox1.SelectedIndexChanged
        txtSelected.Text = ListBox1.SelectedIndices.Count.ToString ' display selected item count
    End Sub
End Class
