Imports System.Drawing.Drawing2D

Public Class frmGraph
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents picGraph As System.Windows.Forms.PictureBox
    Friend WithEvents YMIN As System.Windows.Forms.Label
    Friend WithEvents YMED As System.Windows.Forms.Label
    Friend WithEvents YMAX As System.Windows.Forms.Label
    Friend WithEvents XMIN As System.Windows.Forms.Label
    Friend WithEvents XMAX As System.Windows.Forms.Label
    Friend WithEvents XMED As System.Windows.Forms.Label
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents Label2 As System.Windows.Forms.Label
    Friend WithEvents btnPRINT As System.Windows.Forms.Button
    Friend WithEvents TextBox1 As System.Windows.Forms.TextBox
    Friend WithEvents PrintDocument1 As System.Drawing.Printing.PrintDocument
    Friend WithEvents Label3 As System.Windows.Forms.Label
    Friend WithEvents TextBox2 As System.Windows.Forms.TextBox
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(frmGraph))
        Me.picGraph = New System.Windows.Forms.PictureBox
        Me.YMIN = New System.Windows.Forms.Label
        Me.YMED = New System.Windows.Forms.Label
        Me.YMAX = New System.Windows.Forms.Label
        Me.XMIN = New System.Windows.Forms.Label
        Me.XMAX = New System.Windows.Forms.Label
        Me.XMED = New System.Windows.Forms.Label
        Me.Label1 = New System.Windows.Forms.Label
        Me.Label2 = New System.Windows.Forms.Label
        Me.btnPRINT = New System.Windows.Forms.Button
        Me.TextBox1 = New System.Windows.Forms.TextBox
        Me.PrintDocument1 = New System.Drawing.Printing.PrintDocument
        Me.Label3 = New System.Windows.Forms.Label
        Me.TextBox2 = New System.Windows.Forms.TextBox
        Me.SuspendLayout()
        '
        'picGraph
        '
        Me.picGraph.BackColor = System.Drawing.Color.White
        Me.picGraph.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle
        Me.picGraph.Location = New System.Drawing.Point(58, 9)
        Me.picGraph.Name = "picGraph"
        Me.picGraph.Size = New System.Drawing.Size(566, 397)
        Me.picGraph.TabIndex = 0
        Me.picGraph.TabStop = False
        '
        'YMIN
        '
        Me.YMIN.Font = New System.Drawing.Font("Courier New", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.YMIN.Location = New System.Drawing.Point(0, 397)
        Me.YMIN.Name = "YMIN"
        Me.YMIN.Size = New System.Drawing.Size(58, 18)
        Me.YMIN.TabIndex = 3
        Me.YMIN.Text = "00000"
        '
        'YMED
        '
        Me.YMED.Font = New System.Drawing.Font("Courier New", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.YMED.Location = New System.Drawing.Point(0, 203)
        Me.YMED.Name = "YMED"
        Me.YMED.Size = New System.Drawing.Size(58, 19)
        Me.YMED.TabIndex = 4
        Me.YMED.Text = "00000"
        '
        'YMAX
        '
        Me.YMAX.Font = New System.Drawing.Font("Courier New", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.YMAX.Location = New System.Drawing.Point(0, 0)
        Me.YMAX.Name = "YMAX"
        Me.YMAX.Size = New System.Drawing.Size(58, 18)
        Me.YMAX.TabIndex = 5
        Me.YMAX.Text = "00000"
        '
        'XMIN
        '
        Me.XMIN.Font = New System.Drawing.Font("Courier New", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.XMIN.Location = New System.Drawing.Point(19, 415)
        Me.XMIN.Name = "XMIN"
        Me.XMIN.Size = New System.Drawing.Size(87, 37)
        Me.XMIN.TabIndex = 6
        Me.XMIN.Text = "MM/DD/YY HH:MM:SS"
        '
        'XMAX
        '
        Me.XMAX.Font = New System.Drawing.Font("Courier New", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.XMAX.Location = New System.Drawing.Point(547, 415)
        Me.XMAX.Name = "XMAX"
        Me.XMAX.Size = New System.Drawing.Size(87, 37)
        Me.XMAX.TabIndex = 7
        Me.XMAX.Text = "MM/DD/YY HH:MM:SS"
        '
        'XMED
        '
        Me.XMED.Font = New System.Drawing.Font("Courier New", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.XMED.Location = New System.Drawing.Point(288, 415)
        Me.XMED.Name = "XMED"
        Me.XMED.Size = New System.Drawing.Size(86, 37)
        Me.XMED.TabIndex = 8
        Me.XMED.Text = "MM/DD/YY HH:MM:SS"
        '
        'Label1
        '
        Me.Label1.Font = New System.Drawing.Font("Microsoft Sans Serif", 14.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label1.Location = New System.Drawing.Point(422, 415)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(68, 28)
        Me.Label1.TabIndex = 9
        Me.Label1.Text = "TIME"
        '
        'Label2
        '
        Me.Label2.BackColor = System.Drawing.Color.Transparent
        Me.Label2.Font = New System.Drawing.Font("Microsoft Sans Serif", 14.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label2.ImageAlign = System.Drawing.ContentAlignment.TopLeft
        Me.Label2.Location = New System.Drawing.Point(19, 28)
        Me.Label2.Name = "Label2"
        Me.Label2.Size = New System.Drawing.Size(19, 157)
        Me.Label2.TabIndex = 10
        Me.Label2.Text = "COUNTS"
        '
        'btnPRINT
        '
        Me.btnPRINT.BackColor = System.Drawing.SystemColors.Control
        Me.btnPRINT.Font = New System.Drawing.Font("Microsoft Sans Serif", 12.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.btnPRINT.Location = New System.Drawing.Point(547, 452)
        Me.btnPRINT.Name = "btnPRINT"
        Me.btnPRINT.Size = New System.Drawing.Size(77, 74)
        Me.btnPRINT.TabIndex = 12
        Me.btnPRINT.Text = "PRINT"
        '
        'TextBox1
        '
        Me.TextBox1.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle
        Me.TextBox1.Font = New System.Drawing.Font("Courier New", 12.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.TextBox1.Location = New System.Drawing.Point(58, 480)
        Me.TextBox1.Multiline = True
        Me.TextBox1.Name = "TextBox1"
        Me.TextBox1.Size = New System.Drawing.Size(480, 138)
        Me.TextBox1.TabIndex = 13
        Me.TextBox1.Text = "000 00000 MM/DD/YY HH:MM:SS"
        '
        'PrintDocument1
        '
        '
        'Label3
        '
        Me.Label3.Location = New System.Drawing.Point(58, 452)
        Me.Label3.Name = "Label3"
        Me.Label3.Size = New System.Drawing.Size(144, 19)
        Me.Label3.TabIndex = 14
        Me.Label3.Text = "Mouse (X,Y) Location"
        '
        'TextBox2
        '
        Me.TextBox2.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle
        Me.TextBox2.Location = New System.Drawing.Point(202, 452)
        Me.TextBox2.Name = "TextBox2"
        Me.TextBox2.Size = New System.Drawing.Size(336, 22)
        Me.TextBox2.TabIndex = 15
        Me.TextBox2.Text = "TextBox2"
        '
        'frmGraph
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(6, 15)
        Me.BackColor = System.Drawing.Color.White
        Me.ClientSize = New System.Drawing.Size(633, 625)
        Me.Controls.Add(Me.TextBox2)
        Me.Controls.Add(Me.TextBox1)
        Me.Controls.Add(Me.Label3)
        Me.Controls.Add(Me.btnPRINT)
        Me.Controls.Add(Me.Label2)
        Me.Controls.Add(Me.Label1)
        Me.Controls.Add(Me.XMED)
        Me.Controls.Add(Me.XMAX)
        Me.Controls.Add(Me.XMIN)
        Me.Controls.Add(Me.YMAX)
        Me.Controls.Add(Me.YMED)
        Me.Controls.Add(Me.YMIN)
        Me.Controls.Add(Me.picGraph)
        Me.Icon = CType(resources.GetObject("$this.Icon"), System.Drawing.Icon)
        Me.Name = "frmGraph"
        Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
        Me.Text = "Digital Geiger Counter Data Graph"
        Me.ResumeLayout(False)

    End Sub

#End Region

    Dim MAXXD As Date
    Dim MAXX As Double
    Dim MAXY As Single
    Dim MINXD As Date
    Dim MINX As Double
    Dim MINY As Single
    Private Declare Function BitBlt Lib "gdi32.dll" Alias "BitBlt" (ByVal _
      hdcDest As IntPtr, ByVal nXDest As Integer, ByVal nYDest As _
      Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal _
      hdcSrc As IntPtr, ByVal nXSrc As Integer, ByVal nYSrc As Integer, _
      ByVal dwRop As System.Int32) As Long
    Dim memoryImage As Bitmap

    Private Sub frmGraph_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' DATA IS ALREADY LOADED INT m_X(i) and m_Y(i)
        Dim i As Integer
        Dim AVERAGE As Single
        Dim SD As Single
        'SET OF X DATA TO USE
        MAXXD = CDate("02/12/01 13:00:33")
        MAXY = 0
        MINY = 660000
        MINXD = CDate("02/12/26 13:00:33")

        ' FIND MAXX,MAXY,MINX,MINY
        For i = 0 To PLOTPOINTS - 1
            If MAXXD < m_X(i) Then MAXXD = m_X(i)
            If MINXD > m_X(i) Then MINXD = m_X(i)
            If MAXY < m_Y(i) Then MAXY = m_Y(i)
            If MINY > m_Y(i) Then MINY = m_Y(i)
        Next i
        ' WRITE THE AXIS LABELS
        MAXX = MAXXD.ToOADate ' GET EQUIVALENTS OF DATE AS DOUBLE PRECISION
        MINX = MINXD.ToOADate
        YMAX.Text = Format(MAXY, "#####")
        YMED.Text = Format((MAXY - MINY) / 2 + MINY, "#####")
        YMIN.Text = Format(MINY, "####0")
        XMAX.Text = Format(MAXXD, "MM/dd/yy hh:mm:ss")
        XMED.Text = Format(Date.FromOADate((MINX + (MAXX - MINX) / 2)), "MM/dd/yy hh:mm:ss")
        XMIN.Text = Format(MINXD, "MM/dd/yy hh:mm:ss")
        ' CALCULATE AVERAGE AND STANDARD DEVIATION
        Call STATISTICS(AVERAGE, SD)
        ' REPORT STATISTICAL DATA
        TextBox1.Text = "Number of datapoints=" + Format(PLOTPOINTS, "#####") + vbCrLf + _
        "Maximum counts=" + Format(MAXY, "#####") + vbCrLf + _
        "Minimum counts=" + Format(MINY, "#####") + vbCrLf + _
"Standard deviation=" + Format(SD, "#####.000") + vbCrLf + _
"Average counts=" + Format(AVERAGE, "#####.000") + vbCrLf + _
"Count period in seconds=" + Format(COUNTPERIOD, "#####")

        'PICGRAPH_PAINT IS FIRED TO DRAW GRAPH
    End Sub

    Sub STATISTICS(ByRef AVERAGE As Single, ByRef SD As Single)
        Dim TOTAL As Double = 0.0
        Dim I As Integer
        'CALCLULATE AVERAGE
        TOTAL = 0.0#
        For I = 0 To PLOTPOINTS - 1
            TOTAL = TOTAL + CDbl(m_Y(I))
        Next
        AVERAGE = CSng(TOTAL / CDbl(PLOTPOINTS))
        ' CALCULATE STANDARD DEVIATION
        TOTAL = 0.0#
        For I = 0 To PLOTPOINTS - 1
            TOTAL = (CSng(m_Y(I)) - AVERAGE) ^ 2 + TOTAL
        Next
        SD = CSng((TOTAL / CDbl(PLOTPOINTS - 1)) ^ 0.5)

    End Sub

        ' Transform to make the data fit nicely.
    Private Sub picGraph_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles picGraph.Paint
        Dim YTIC As Single
        Dim XTIC As Single
        Dim i As Integer
        Dim dx As Single = 0
        Dim dy As Single = -1 * (CInt(YMAX.Text))
        e.Graphics.TranslateTransform(dx, dy)

        ' Scale.
        ' Make X run from XMIN TO XMAX
        Dim scale_x As Double = picGraph.ClientSize.Width / (MAXX - MINX)
        'Dim scale_x As Double = picGraph.ClientSize.Width / ((CInt(XMAX.Text) - (CInt(XMIN.Text))))
        ' Make Y run from YMAX to YMIN. Notice that this
        ' makes the Y scale negative, which flips the
        ' Y coordinates.
        Dim scale_y As Double = picGraph.ClientSize.Height / (MINY - MAXY)
        e.Graphics.ScaleTransform(CSng(scale_x), CSng(scale_y), MatrixOrder.Append)
        ' SCALE DATA SYMBOL
        YTIC = (MAXY - MINY) / 100
        XTIC = CSng(MAXX - MINX) / 100
        ' Draw.
        e.Graphics.Clear(picGraph.BackColor)
        Dim thin_pen As New Pen(Color.Red, 0)
        For i = 0 To PLOTPOINTS - 1
            ' XTIC/2 AN YTIC/2 ADJUSTMENTS ON NEXT LINE ARE TO CENTER BOXES AT DATA POINT
            e.Graphics.DrawRectangle(thin_pen, CSng(m_X(i).ToOADate - MINX - XTIC / 2), CSng(m_Y(i) - YTIC / 2), CSng(XTIC * 0.7), YTIC)
        Next i
        thin_pen.Dispose()
        Call Grid(e)
    End Sub

    Private Sub btnPRINT_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPRINT.Click
        CaptureScreen()
        PrintDocument1.Print()
    End Sub

    Private Sub CaptureScreen()
        Dim mygraphics As Graphics = Me.CreateGraphics()
        Dim s As Size = Me.Size
        memoryImage = New Bitmap(s.Width, s.Height, mygraphics)
        Dim memoryGraphics As Graphics = Graphics.FromImage(memoryImage)
        Dim dc1 As IntPtr = mygraphics.GetHdc
        Dim dc2 As IntPtr = memoryGraphics.GetHdc
        BitBlt(dc2, 0, 0, Me.ClientRectangle.Width, _
           Me.ClientRectangle.Height, dc1, 0, 0, 13369376)
        mygraphics.ReleaseHdc(dc1)
        memoryGraphics.ReleaseHdc(dc2)
    End Sub

    Private Sub PrintDocument1_PrintPage(ByVal sender As System.Object, _
       ByVal e As System.Drawing.Printing.PrintPageEventArgs) Handles _
       PrintDocument1.PrintPage
        e.Graphics.DrawImage(memoryImage, 0, 0)
    End Sub

    Private Sub TextBox1_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TextBox1.TextChanged

    End Sub
    Sub Grid(ByVal e As System.Windows.Forms.PaintEventArgs)
        'DRAW X Y GRID
        Dim YINC As Single
        Dim XINC As Single
        Dim I As Integer
        Dim thin_pen As New Pen(Color.Blue, 0)
        YINC = (MAXY - MINY) / 10
        XINC = CSng(MAXX - MINX) / 10
        For I = 1 To 9
            'HORIZONTAL GRID LINES
            e.Graphics.DrawLine(thin_pen, CSng(0), MINY + I * YINC, CSng(MAXX - MINX), MINY + I * YINC)
            ' VERTICAL GRID LINES
            e.Graphics.DrawLine(thin_pen, CSng(I * XINC), MINY, CSng(I * XINC), MAXY)
        Next I

        thin_pen.Dispose()
    End Sub

    Private Sub picGraph_MouseMove(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles picGraph.MouseMove
        Dim X As Date
        Dim Y As Double
        Dim xx As Single
        Dim yy As Single
        ' TAKE X,Y COORDINATES AND CONVERT TO SCALED COORDINATES
        ' CONVERT Y TO COUNTS
        Y = CDbl(MAXY) - ((CDbl(MAXY) - CDbl(MINY)) * CDbl(e.Y) / CDbl(picGraph.ClientSize.Height - 1))
        yy = CSng(e.Y) / CSng(picGraph.Height) 'picGraph.Height
        ' CONVERT X TO DATE FOR DISPLAY
        X = Date.FromOADate(MINX + ((MAXX - MINX) * CDbl(e.X) / CDbl(picGraph.ClientSize.Width - 1)))
        xx = CSng(e.X) / CSng(picGraph.Width)
        ' DISPLAY MOUSE COORDINATES IN TEXTBOX
        TextBox2.Text = Format(X, "(MM/dd/yy hh:mm:ss") + " , " + Format(Y, "####0)")
    End Sub

End Class
