; V2SCOPESPECTRUM900.ASM 20AUG06  - COPYRIGHT JOHN BECKER
; Virtual Scope & Spectrum Analyser Mk2

;PIC16F877-20, 20MHz, WDT OFF, POR ON, XTAL HS

;PROGRAM WRITTEN IN TASM - NEEDS TRANSLATING VIA TK3 TO SUIT MPASM

        List P = PIC16F877, R=DEC;
        __CONFIG   h'3F32'

        include P16F877.inc

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

        CBLOCK
POTVAL0
POTVAL1
POTVAL2
POTVAL3
ANAREG0
STORE
LOOP
PROMVAL
ABORT
BAUDVAL
MODE
CLKCNT
	ENDC

; *********** BITS *******

MEMOE      equ 0         ; PORTC,0
MEMWE      equ 1         ; PORTC,1

ADCCS      equ 2         ; PORTC,2
ADCINT     equ 4         ; PORTC,4
ADCRD      equ 5         ; PORTC,5

POTDATA    equ 0         ; PORTB,0  dig pot data bit
POTCLK     equ 1         ; PORTB,1  dig pot clock active high
POTRST     equ 3         ; PORTC,3  dig pot set active high
ANALAT     equ 3         ; PORTC,3  analogue reg latch (same as RST)

; **********************

        ORG 0
        goto GIEOFF
        nop
        nop
        nop
        ORG 4                 ; Interrupt vector address
        goto GIEOFF
        ORG 5

GIEOFF: BCF INTCON,GIE        ; turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto START

ROUTEIT: bsf PORTA,5          ; inhibit IC16 digital input chip (OE high)
        movf MODE,W
        andlw 3
        addwf PCL,F
        goto MULTICHANS       ;  0 ; scope
        goto MULTICHANS       ;  1 ; spectrun, same as scope
        goto DIGITALCHAN      ;  2 ; digital lines input
        goto DIGITALCHAN      ;  3 ; digital lines input

;*******************

START:  bcf STATUS,RP0
        bcf STATUS,RP1
        clrf PORTA            ; initialise all port outputs to zero
        bsf PORTA,5           ; inhibit IC16 digital input chip (OE high)
        clrf PORTB
        clrf PORTC
        clrf PORTD
        clrf PORTE

        bsf PORTC,MEMOE       ; mem OE high
        bsf PORTC,MEMWE       ; mem WE normally high

        clrf PORTB
        movlw 128
        movwf POTVAL0
        movwf POTVAL1
        movwf POTVAL2
        movwf POTVAL3
        clrf ANAREG0
        bsf PORTC,ADCCS       ; set ADC CS high

        BANK1
        clrf TRISA            ; PORTA as output at this stage
        movlw 255
        movwf TRISB           ; PORTB as input at this stage
        movlw B'10010010'     ; RC7 as input (RS232 receive)
        movwf TRISC           ; RC4 input for ADCINT
                              ; RC1 high impedance for MEM OE
        movlw 255
        movwf TRISD
        movlw %00000100       ; digital IC OE high
        movwf TRISE

        movlw B'00000110'     ; set for digital RA, RE
        movwf ADCON1
        movlw B'00000100'     ; timer 1:32, pull-ups on
        movwf OPTION_REG
        BANK0

        call PAUSIT
        call PAUSIT

        btfss PORTB,0          ; is RB0 low?
        goto RESETBAUD         ; yes

        BANK1
        clrf TRISB             ; PORTB as output
        BANK0

        call RECALLBAUD
        call SETBAUD

        movlw %00110001        ; set timer 1 for prescale 1/8, and timer on
        movwf T1CON

        bsf PORTC,ADCCS       ; set ADC CS high
        clrf PORTB
        clrf PORTE

        clrf TMR1L            ; reset timer 1
        clrf TMR1H
        bcf PIR1,0            ; clear timer 1 overflow

WAITPCSTART:
        btfss   PIR1,RCIF     ; Check for any RX'd data
        goto WAITPCSTART

        movf    RCREG,W       ; Store the RX'd data in 'W'
        sublw   'S'           ; Is this an 'S' for Settings receive?
        btfsc   STATUS,Z
        goto GETSETTINGS      ; yes
        goto WAITPCSTART


; *************** START OF MAIN PROG ***********

DIGITALCHAN:
        BANK1
        movlw B'10010000'     ; RC7 as input (RS232 receive)
        movwf TRISC           ; RC4 input for ADCINT, RC1 output for MEM OE
        BANK0
        bsf PORTC,ADCCS       ; prevent ADC conversion
        bsf PORTC,ADCRD       ; turn off ADC read
	bcf PORTA,5           ; open IC16 digital input chip

DIGITALCHAN3:
        btfss PORTE,2
        goto DIGITALCHAN3
        bcf PORTC,MEMWE       ; mem WE low   store val into mem
        bsf PORTC,MEMWE       ; mem WE high
        incfsz PORTB,F
        goto DIGITALCHAN3
        incf PORTA,F
        btfss PORTA,3
        goto DIGITALCHAN3
        goto SENDPC           ; output mem vals to PC

; *****************

SENDPC: call RecLoop          ; Wait and read from serial - character returned in W
        btfsc ABORT,0
        goto ENDTF
        movlw %00100000
        movwf PORTA
        clrf PORTE

        movf    RCREG,W       ; Store the RX'd data in 'W'
        sublw   'G'           ; Is this a 'G' for Go ?
        btfsc   STATUS,Z
        goto SENDPC2          ; yes
        movf    RCREG,W       ; Store the RX'd data in 'W'
        sublw   'S'           ; Is this an 'S' for Settings receive?
        btfsc   STATUS,Z
        goto GETSETTINGS      ; yes
        goto ENDTF

SENDPC2:

; 'G' has been received - Confirm ready state back to PC
        movlw   'R'             ; Signal 'R'eady
        call    TxByte
        bcf PORTC,MEMOE         ; mem OE low for data output
        movlw %00100000
        movwf PORTA
        clrf PORTB
        clrf PORTE

; Start sending the blocks
; First, wait for the PC to send us a 'B' command (Send block)

WaitB:  call  FlushRXBuffer     ; Make sure that the RX buffer is empty
        call    RecLoop         ; Wait and read from serial - character returned in W
        btfsc ABORT,0
        goto ENDTF

        sublw   'B'             ; Is this a 'B'
        btfsc   STATUS,Z
        goto    SendNext        ; Yes a 'B'
        goto    WaitB           ; Not a 'B'

; 'B' received, send a block
SendNext: comf PORTD,W
        call TXBYTE             ; send it to PC
        incfsz PORTB,F
        goto SendNext

; Data portion of the block has been sent, now send the Block terminator
SENDPC3: movlw   0x0D          ; send CR
        call    TxByte
        movlw   0x0A           ; send LF
        call    TxByte

        incf PORTA,F
        btfss PORTA,3 
        goto SENDPC4
        movlw %00100000
        movwf PORTA
        incf PORTE,F
        btfsc PORTE,1
        goto ENDTF

SENDPC4: goto WAITB

ENDTF:  bsf PORTC,MEMOE        ; mem OE high
        goto ROUTEIT

; ***************        

SETBAUD: movf BAUDVAL,W
        bcf STATUS,RP1
        bsf STATUS,RP0
	movwf   SPBRG           ; In bank 1
        movlw   b'00100100'     ; BRGH = 1(High speed) & ASYNC transmission
        movwf   TXSTA           ; In bank 1
        bcf 	STATUS,RP0  	; back to RAM page 0
        movlw   b'10010000'     ; ASYNC reception
        movwf   RCSTA           ; In bank 0
        call 	FlushRXBuffer   ; Flush the RX buffer in bank 0
        return

; Receive a character from RS232
; (This routine does not return until a character has been received, or there's a timeout)
; The received character is in the W register

RecLoop: bcf ABORT,0           ; clear abort flag
        clrf TMR1L             ; reset timer 1
        clrf TMR1H
        bcf PIR1,0             ; clear timer 1 overflow

RecLoop2: btfss PIR1,0         ; has timer 1 overflowed?
        goto RECLOOP3          ; no
        movlw 0
        bsf ABORT,0            ; yes, set flag
        return

RECLOOP3: nop
        btfss   PIR1,RCIF       ; Check for any RX'd data
        goto    RecLoop2        ; Nothing RX'd
        movf    RCREG,W         ; Store the RX'd data in 'W'
        return

; Flush the contents of the RX Buffer

FlushRXBuffer:
	movf    RCREG,W        	; Flush the RX buffer in bank 0
        movf    RCREG,W
	movf    RCREG,W
        return

; Send byte to output

TxByte:
        nop
        btfss   PIR1,TXIF       ; TX Buffer empty yet ?
        goto    TxByte          ; No - Keep waiting
        movwf   TXREG           ; Now empty - send this character
        return

;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F87x devices ****
;         according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bsf STATUS,RP0  ;set for Page 3
        bcf EECON1,EEPGD ;point to data memory
        bsf EECON1,RD   ;enable read flag
        bcf STATUS,RP0  ;set for Page 2 
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        bcf STATUS,RP1  ;set for Page 0
        return

; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F87x devices ********
          ;according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in PROMVAL
SETPRM: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bcf STATUS,RP1  ;set for Page 0
        MOVF PROMVAL,W  ;get data value from STORE1 and hold in W
        bsf STATUS,RP1  ;set for Page 2
        movwf EEDATA    ;copy W into eeprom data byte register
        bsf STATUS,RP0  ;set for page 3
        bcf EECON1,EEPGD ;point to Data memory
        bsf EECON1,WREN ;enable write flag

MANUAL: movlw H'55'       ;these lines cause the action required by
        movwf EECON2    ;by the eeprom to store the data in EEDATA
        movlw H'AA'       ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ;set the ``perform write'' flag
        bcf STATUS,RP1  ;set for Page 0
        bcf STATUS,RP0

CHKWRT: btfss PIR2,EEIF ;wait until bit 4 of PIR2 is set
        goto CHKWRT
        bcf PIR2,EEIF   ;clear bit 4 of PIR2
        return

; **************

SETDIGIPOTS:
          bsf PORTC,POTRST    ; set dig pot to receive data
          bcf PORTB,POTDATA   ; clear stack bit
          call CLKPOT         ; send stack bit
          movf POTVAL2,W      ; copy pot 2 val to W
          call SETPOTS        ; send it
          movf POTVAL3,W      ; copy pot 3 val to W
          call SETPOTS        ; send it

          bcf PORTB,POTDATA   ; clear stack bit
          call CLKPOT         ; send stack bit
          movf POTVAL0,W      ; copy pot 0 val to W
          call SETPOTS        ; send it
          movf POTVAL1,W      ; copy pot 1 val to W
          call SETPOTS        ; send it
          movf ANAREG0,W
          call SETPOTS

          bcf PORTC,POTRST    ; disable dig pot from receiving data
          bsf PORTC,ANALAT    ; latch analog reg with data
          bcf PORTC,ANALAT    ; 
          return

SETPOTS:  movwf STORE         ; store W
          movlw 8             ; set loop for 8 actions
          movwf LOOP
DIGLOOP0: bcf PORTB,POTDATA   ; clear data bit
          rlf STORE,F         ; rotate store left (MSB out first)
          btfsc STATUS,C      ; is CARRY set?
          bsf PORTB,POTDATA   ; yes, set data bit
          call CLKPOT         ; send data bit
          decfsz LOOP,F       ; dec loop, is it 0?
          goto DIGLOOP0       ; no, repeat for next bit
          return

CLKPOT:   bsf PORTB,POTCLK    ; take dig pot clk high
          bcf PORTB,POTCLK    ; take dig pot clk low
          return

; **************

GETSETTINGS:  ; receive settings from PC
              ; BAUD rate is dealt with seperately
; 'S' has been received - Confirm ready state back to PC
        movlw   'S'
        call    TxByte
        movlw 1
        movwf LOOP

GETS2:  call TIMEX
        movwf ANAREG0
        call TxByte
        call TIMEX
        movwf POTVAL0
        call TxByte
        call TIMEX
        movwf POTVAL1
        call TxByte
        call TIMEX
        movwf POTVAL2
        call TxByte
        call TIMEX
        movwf POTVAL3
        call TxByte
        call TIMEX
        movwf MODE
        call TxByte
        btfsc STATUS,Z
        incf MODE,F
        call SETDIGIPOTS

GETS4:  movlw %00100000
        movwf PORTA
        clrf PORTB
        clrf PORTE
        goto ROUTEIT

TIMEX:  btfss   PIR1,RCIF       ; Check for any RX'd data
        goto TIMEX              ; Nothing RX'd
        movf    RCREG,W         ; Store the RX'd data in 'W'
        return

; ***********

RECALLBAUD:
        movlw 0
        call PRMGET
        movwf BAUDVAL
        return

RESETBAUD: movlw 81      ; 9600 Baud with 20MHz XTAL (See PIC data sheet)
        movwf BAUDVAL
        movwf PROMVAL
        call SETBAUD
        movlw 0
        call SETPRM

RST2:   call TIMEX
        sublw   'V'      ; Is this a 'V' for Valid baud?
        btfss   STATUS,Z
        goto RST2        ; no
        movlw   'V'      ; yes, confirm back to PC
        call    TxByte

        call TIMEX
        movwf PROMVAL
        call TxByte ; new baud val has been received - Confirm back to PC
        movlw 0
        call SETPRM     ; store new val for recall when PIC restarted

HOLDIT: nop             ; hold here indefinitely
        goto HOLDIT

PAUSIT: movlw 50        ;wait set
        movwf CLKCNT
        clrf INTCON     ;clear interupt flag
PAUSE:  btfss INTCON,2  ;has a timer time-out been detected?
        goto PAUSE      ;no
        BCF INTCON,2    ;yes
        decfsz CLKCNT,F ;dec loop, is it zero?
        goto PAUSE      ;no
        return          ;yes

;*************

MULTICHANS:
          clrf PORTB

MULTICHAN0A:
          movlw %00100000       ; DIG OE high
          movwf PORTA
          clrf PORTE            ; ADC chan 0, MEM block 0
          bcf PORTC,ADCRD       ; ADC read low

MTC0A:    bsf PORTE,0           ; ADC chan 1
          bcf PORTC,ADCCS       ; start ADC conversion
;          nop  ; 20aug
;          bcf PORTC,ADCRD       ; ADC read low ; 20aug

WAITADC2: btfsc PORTC,ADCINT    ; wait for ADC INT to go low
          goto WAITADC2         ; going low also stores data to mem
;          bsf PORTC,ADCRD       ; ADC read high  ; 20aug
          bsf PORTC,ADCCS       ; ADC chip select off (end conversion)

;          bcf PORTE,0           ; ADC chan 0, also sets MEM A10 low
          clrf PORTE
          nop

          bcf PORTC,ADCCS       ; start ADC conversion
;          nop                                    ; 20aug
;          bcf PORTC,ADCRD       ; ADC read low   ; 20aug

WAITADC3: btfsc PORTC,ADCINT    ; wait for ADC INT to go low
          goto WAITADC3         ; going low also stores data to MEM
;          bsf PORTC,ADCRD       ; ADC read high   ; 20aug
          bsf PORTC,ADCCS       ; ADC chip select off (end conversion)
          incfsz PORTB,F
          goto MTC0A
          incf PORTA,F
          btfss PORTA,3
          goto MTC0A
MTC0B:    goto SENDPC           ; output mem vals to PC

; **************

          org H'2100'  ; data eeprom address
          DE H'15'     ; 0  57600 Baud 20MHz
          DE H'15'

          END


