;*****************************************************************************        
;
;   Module:     app.inc
;               
;   Author:     Mike Hibbett, mikehibbett@oceanfree.net 
;                                                                  
;   Version:    1.0 11/10/05                                              
;
;               The main user application code , entered
;               following execution of the bootloader. 
;
;               All your application code should go in here, or be #included.
;               The exception is interrupt routines, which should go in
;               interrupts.inc and the setting of the config registers, which 
;               should go in config.inc
;
;
;*****************************************************************************        

    ; Pull in the source code for the SPI low level routines
    #include "spi.inc"    



;*****************************************************************************        
;
; RAM Variables
;
;*****************************************************************************        
tmpHexByte  EQU 0x40        ; used by DspHexByte for formatting text



;*****************************************************************************        
;
;   Function :  Main
;               This is the entry point of your actual application program
;
;               This code just demonstrates the SPI functions in SPI.INC
;
;   Input:      None.
;
;   Output:     None - it never returns
;
;*****************************************************************************        
Main
    ; Do the basic hardware initialisation
    call    AppHWInit
    
    ; Configure the PICs internal SPI module for communication
    call    SPIHWInit
    
    
    ; Comment out this line if you wish to test the FLASH
    goto    testEEPROM
        
    ;
    ; Test the 25P32 Flash device
    ; 
    
    
    clrf    devAddL
    clrf    devAddM
    clrf    devAddH

    ; Perform a single byte write
    movlw   0xA4
    movwf   devData    
    call    FlashWriteByte
    
    ; Perform a single byte read
    call    FlashReadByte

    ; Write an array of 6 bytes
    
    ; Generate some random data to write
    movlw   0xF6
    movwf   devBuff
    movlw   0xDC
    movwf   devBuff+1
    movlw   0x39
    movwf   devBuff+2
    movlw   0x27
    movwf   devBuff+3
    movlw   0x81
    movwf   devBuff+4
    movlw   0x3C
    movwf   devBuff+5
   
    movlw   6
    movwf   devCount        ; Indicate how many bytes to write

    call    FlashWriteBuffer
      
    movlw   6
    movwf   devCount        ; Indicate how many bytes to write

    ; Read an array of 6 bytes
    call    FlashReadBuffer
    
    goto    finish         


testEEPROM
    ; 
    ; Now to test the 25C256 code
    ; 
    
    clrf    devAddL
    clrf    devAddH
    
    
    ; Perform a single byte write
    movlw   0xA4
    movwf   devData    
    call    EEPWriteByte
    
    ; Perform a single byte read
    call    EEPReadByte

    ; Generate some random data to write
    movlw   1
    movwf   devBuff
    movlw   2
    movwf   devBuff+1
    movlw   3
    movwf   devBuff+2
    movlw   4
    movwf   devBuff+3
    movlw   5
    movwf   devBuff+4
    movlw   6
    movwf   devBuff+5
   
    ; Write an array of 6 bytes
    movlw   6
    movwf   devCount        ; Indicate how many bytes to write
    call    EEPWriteBuffer
    
    ; Read an array of 6 bytes
    movlw   6
    movwf   devCount        ; Indicate how many bytes to write
    call    EEPReadBuffer
    
    ; Print the buffer and then stop
    
finish

    ; Print the 6 bytes in the buffer 
    movlw   0x0A
    call    RS232TxByte
    movlw   0x0D
    call    RS232TxByte
    movlw   '>'
    call    RS232TxByte
    movf    devBuff,W
    call    DspHexByte
    movf    devBuff+1,W
    call    DspHexByte
    movf    devBuff+2,W
    call    DspHexByte
    movf    devBuff+3,W
    call    DspHexByte
    movf    devBuff+4,W
    call    DspHexByte
    movf    devBuff+5,W
    call    DspHexByte

        
    ; And now stop
Mainloop
    goto    Mainloop




;*****************************************************************************        
;
;   Function :  AppHWInit
;               Perform the hardware initialisation required by the application
;
;   Input:      None.
;
;   Output:     None
;
;*****************************************************************************        
AppHWInit
    ; Nothing special required by the application, as it is a simple
    ; demo of the SPI routines.
    
    ; The main application will call an SPI init routine to set up the 
    ; SPI hardware requirements, and we will use the default bootloader RS232 
    ; interface for user I/O
    return
    


;*****************************************************************************        
;
;   Function :  DspHexByte
;               Write a 2 digit hex byte in uppercase to the user interface
;
;   Input:      byte to display in W
;
;   Output:     2 characters written to the UI
;
;*****************************************************************************        
DspHexByte    
    movwf   tmpHexByte
    swapf   tmpHexByte,W
    sublw   0x09
    swapf   tmpHexByte,W
    andlw   0x0F
    btfss   STATUS,DC
    addlw   'A' - .10 - '0'
    addlw   '0'
    call    RS232TxByte
    movf    tmpHexByte, W
    sublw   0x09
    movf    tmpHexByte, W
    andlw   0x0F
    btfss   STATUS,DC
    addlw   'A' - .10 - '0'
    addlw   '0'
    call    RS232TxByte
    return
