;*****************************************************************************        
;
;   Module:     constants.inc
;               
;   Author:     Mike Hibbett 
;                                                                  
;   Version:    0.1 10/6/05                                           
;
;               equate statements for variable locations
;               equate statements for constants
;               NOTE: CPU constants are extracted from gputils header file,
;               p18f2420.inc, found in the gputils header subdirectory
;
;*****************************************************************************        


; Initial, power up hardware definition constants.

PORTA_TRIS_VAL          EQU 0x3D    
PORTA_LEVELS            EQU 0x00

PORTB_TRIS_VAL          EQU 0x00
PORTB_LEVELS            EQU 0x00

PORTC_TRIS_VAL          EQU 0x80
PORTC_LEVELS            EQU 0x03    ; Ensures e2proms are deselected


COMP_OFF_VAL            EQU 0x07    ; Disconnect comparitor from I/O pins
ADC_OFF_VAL             EQU 0x0F    ; Disconnect A/D from I/O pins
CVRCON_OFF_VAL          EQU 0x00    ; reference voltage on used


; LCD Port connections
LCD_E                   EQU 3
LCD_RW                  EQU 2
LCD_RS                  EQU 1

CONTROL                 EQU LATB
DATA_BUS                EQU LATB
DATA_BUS_TRIS           EQU TRISB
DATA_BUS_INPUT          EQU 0xF0
DATA_BUS_OUTPUT         EQU 0x00

; PC Interface bits
RX_DATA                 EQU 0
TX_DATA                 EQU 1


; Keyboard bits on PORTA
KEY_NEXT                EQU 4
KEY_SELECT              EQU 5
KEY_CLEAR               EQU 3
KEY_RECORD              EQU 2

KEY_NEXT_TIMER_VAL      EQU 0x02        ; Ignore UI key for 100ms ( 50 - 100ms )
KEY_SELECT_TIMER_VAL    EQU 0x02        ; Ignore UI key for 100ms ( 50 - 100ms )
KEY_CLEAR_TIMER_VAL     EQU 0x28        ; Ignore UI key for 2s 
KEY_RECORD_TIMER_VAL    EQU 0x28        ; Ignore UI key for 2s

; Application setup values
PORTC_APP_TRIS_VAL      EQU 0xD0

; Maximum number of camera locations that may be stored
MAX_LOCATIONS           EQU D'10800'

; SPI Bus constants
SSPSTAT_VAL             EQU 0x80    ; 10000000
SSPCON1_VAL             EQU 0x31    ; 00110001

; SPI EEPROM constants
EEPROM_DUMMY_WRITE      EQU 0x00    ; Used for clocking data in

EEPROM_WREN             EQU 0x06    ; Write enable
EEPROM_WRDI             EQU 0x04    ; Write disable
EEPROM_RDSR             EQU 0x05    ; Read status register  
EEPROM_WRSR             EQU 0x01    ; Write status register
EEPROM_READ             EQU 0x03    ; Read data from memory
EEPROM_WRITE            EQU 0x02    ; Write data to memory


; Several GPS Modules are supported. 
; The Holux and RF solutions ones run at 4800 baud,
; The crownhills one at 9600.
; Set the GPS_BAUDRATE to the appropriate define, BAUD_4800 or BAUD_9600
BAUD_9600               EQU D'1040'
BAUD_4800               EQU D'2083'

  ifdef ( B9600 ) 
GPS_BAUDRATE            EQU BAUD_9600
  else
GPS_BAUDRATE            EQU BAUD_4800
  endif 


; The GPS module returns speed in knots; These values equate
; the returned value on *my* tacho. Note, car tachos are 
; calibrated high to help us keep our speed down. That is
; why the mapping between MPH and Knots is not the 'correct' value
SPEED_30MPH             EQU 0x19
SPEED_40MPH             EQU 0x22
SPEED_50MPH             EQU 0x2A
SPEED_60MPH             EQU 0x32
SPEED_70MPH             EQU 0x3B

SPEED_30KPH             EQU 0x10
SPEED_50KPH             EQU 0x1A
SPEED_80KPH             EQU 0x2A
SPEED_100KPH            EQU 0x34
SPEED_120KPH            EQU 0x3F

; If travelling below a certain speed, no need to sound an alert
; in proximity to a speed camera, because you cannot be driving
; over a limit. It's 30MPH in the uk, at the moment. 
 ifdef ( MILES )
SPEED_NO_ALERT          EQU SPEED_30MPH
 else
SPEED_NO_ALERT          EQU SPEED_30KPH
 endif

; When displaying the CameraBar Graph, we give differing audible alerts
; Depending on the proximity. Three alerts are supported.
; These constants define the distances at which they are triggered

ALERT1_DISTANCE         EQU 0x041D  ; Nearby
ALERT2_DISTANCE         EQU 0x01B3  ; Close
ALERT3_DISTANCE         EQU 0x0056  ; Too close!

; Definitions of the different alerts given by the unit,
; which map to indexes in the TuneList array in the file melody.inc
ALERT_SILENCE           EQU 0
ALERT_POWER_UP          EQU 1
ALERT_GPS_LOCK_OK       EQU 2
ALERT_GPS_LOCK_LOST     EQU 3
ALERT_OVER_SPEED        EQU 4
ALERT_CAMERA_NEAR       EQU 5
ALERT_CAMERA_CLOSE      EQU 6
ALERT_CAMERA_HERE       EQU 7
ALERT_KEY_PRESS         EQU 8

; flags1 bit fields
OVERSPEED_FLAG1         EQU 0
GPS_LOCK_FLAG1          EQU 1   ; Keep this bit here, to match INLOCKFLAG2
MASK_ALERT_FLAG1        EQU 2
; TMPDSP_FLAG1            EQU 3
SPEEDHEAD_VALID_FLAG1   EQU 4

; flags2 bit fields
NEWDATAFLAG2            EQU 0
INLOCKFLAG2             EQU 1
KEY_NEXT_FLAG2          EQU 2
KEY_SELECT_FLAG2        EQU 3
KEY_CLEAR_FLAG2         EQU 4
KEY_RECORD_FLAG2        EQU 5
NEWALTDATAFLAG2         EQU 6
NEWSPEEDDATAFLAG2       EQU 7


; Variables held in Bank 0 ( low address ) GPR
lcdTmp                  EQU 0x00
lcdTmp2                 EQU 0x01
delay1                  EQU 0x02
delay2                  EQU 0x03
delay3                  EQU 0x04
tmpVal                  EQU 0x05
bitDelay                EQU 0x06
bitCount                EQU 0x07
hostByte                EQU 0x08
progAddHigh             EQU 0x09        ; NOTE: bootloader uses 0x40 - 0x7F
progAddLow              EQU 0x0A        ;       as a buffer for write data
progRxResult            EQU 0x0B        ;
progRxCheck             EQU 0x0C        ; a simple sum of AAD..D ( 66 bytes )
progCounter             EQU 0x0D
rxErrCount              EQU 0x0E        ; Count GPS RS232  rx data errors
intTmr1                 EQU 0x10        ; a 50ms timer, managed by interrupt routine.
;appTmpDspTmr            EQU 0x11        ; a 50ms timer, managed by interrupt routine.
appDspTmr               EQU 0x12        ; a 50ms timer, managed by interrupt routine.
inChar                  EQU 0x13
rxState                 EQU 0x14
rxSubState              EQU 0x15
flags2                  EQU 0x16        ; Interrupt flags 
iLatDeg                 EQU 0x17
iTmp                    EQU 0x18
tmpL                    EQU 0x19
tmpM                    EQU 0x1A
tmpH                    EQU 0x1B
tmp1L                   EQU 0x1C
tmp1M                   EQU 0x1D
tmp1H                   EQU 0x1E
iLatmmhh                EQU 0x1F        ; 3 bytes
iLongmmhh               EQU 0x22        ; 3 bytes
iLongDeg                EQU 0x25
flags1                  EQU 0x26
scanLat                 EQU 0x27        ; 3 bytes
eepAddL                 EQU 0x2A
eepAddH                 EQU 0x2B
scanNumL                EQU 0x2C
scanNumH                EQU 0x2D
Latmmhh                 EQU 0x2E        ; 3 bytes
Longmmhh                EQU 0x31        ; 3 bytes
scanLong                EQU 0x34        ; 3 bytes
dist                    EQU 0x37        ; 3 bytes
scanDist                EQU 0x3A        ; 3 bytes
currentPosL             EQU 0x3D
currentPosH             EQU 0x3E
cosineValueH            EQU 0x3F
cosineValueL            EQU 0x40

tmpHexByte              EQU 0x41
LatDeg                  EQU 0x42

; Variables used by AN617.INC

LOOPCOUNT               EQU     0x43

TEMPB2                  EQU     0x44
TEMPB1                  EQU     0x45
TEMPB0                  EQU     0x46
TEMP                    EQU     0x46    ; temporary storage
;
;       binary operation arguments
;
AARGB7                  EQU     0x47
AARGB6                  EQU     0x48
AARGB5                  EQU     0x49
AARGB4                  EQU     0x4a
AARGB3                  EQU     0x4b
AARGB2                  EQU     0x4c
AARGB1                  EQU     0x4d
AARGB0                  EQU     0x4e
AARG                    EQU     0x4e    ; most significant byte of argument A
;
BARGB3                  EQU     0x4F
BARGB2                  EQU     0x50
BARGB1                  EQU     0x5a
BARGB0                  EQU     0x5b
BARG                    EQU     0x5b    ; most significant byte of argument B


LongDeg                 EQU     0x5c
eepData                 EQU     0x5d
numEntriesH             EQU     0x5e
numEntriesL             EQU     0x5f
lastCurrentPosH         EQU     0x60
lastCurrentPosL         EQU     0x61
defaultDisplay          EQU     0x62
keyStates               EQU     0x63
keyNextTmr              EQU     0x64
keySelectTmr            EQU     0x65
keyClearTmr             EQU     0x66
keyRecordTmr            EQU     0x67
intPCLATH               EQU     0x68
tmr0ValH                EQU     0x69
tmr0ValL                EQU     0x6A
intTuneCurrent          EQU     0x6B
tuneCurrent             EQU     0x6C
intNoteTimer            EQU     0x6D
intTBLPTRL              EQU     0x6E
intTBLPTRH              EQU     0x6F
intTABLAT               EQU     0x70
intNotePtrH             EQU     0x71
intNotePtrL             EQU     0x72
iAlt1                   EQU     0x73
iAlt2                   EQU     0x74
iSpeedH                 EQU     0x75
iSpeedL                 EQU     0x76
Alt1                    EQU     0x77
Alt2                    EQU     0x78
SpeedH                  EQU     0x79
SpeedL                  EQU     0x7A
iAlt3                   EQU     0x7B
iAlt4                   EQU     0x7C
Alt3                    EQU     0x7D
Alt4                    EQU     0x7E

latText                 EQU     0x80    ; ' dd mm.mm N',0 - 12 chars
longText                EQU     0x90    ; 'ddd mm.mm E',0 - 12 chars
iHead1                  EQU     0xA1
iHead2                  EQU     0xA2
iHead3                  EQU     0xA3
Head1                   EQU     0xA4
Head2                   EQU     0xA5
Head3                   EQU     0xA6

; The following are used by the bin2BCD routine

bin         EQU     0xA7
hundreds    EQU     0xA8
tensones    EQU     0xA9
