; DALEK172.ASM 08APR05 - COPYRIGHT JOHN BECKER - EPE PIC CYBERVOX MK2

;PIC18F252, WDT OFF, POR ON, RC osc

        list    p=18F252,r=dec
        include P18F252.inc

	__config H'300000'  H'00'
	__config H'300001'  H'23'   RC osc
	__config H'300002'  H'08'
	__config H'300003'  H'00'
	__config H'300004'  H'00'
	__config H'300005'  H'01'
	__config H'300006'  H'80'
	__config H'300007'  H'00'
	__config H'300008'  H'0F'
	__config H'300009'  H'C0'
	__config H'30000A'  H'0F'
	__config H'30000B'  H'E0'
	__config H'30000C'  H'0F'
	__config H'30000D'  H'40'
	
A       equ 0                  ; set value for Access bank bit

        CBLOCK
MEMORYBANK		       ; must be last item in block if other equates added
        ENDC

 	 org	 0
	 goto    START
         org     0008h         ; H'08'
         retfie		       ; high priority interrupt vector
         org     0018h         ; H'18'  
         retfie                ; low priority interrupt vector

START:   clrf PORTA,A
         clrf PORTB,A
         clrf PORTC,A
         movlw %00011011       ; RA0, RA1, RA3, RA4 as inputs, RA2 as output
         movwf TRISA,A
         movlw %00000010       ; RB1 as input
         movwf TRISB,A
         clrf TRISC,A

         bcf INTCON2,7,A       ; PORTB pullups on

         movlw %00001110       ; set LHS justify, RA0 as analog inputs
         movwf ADCON1,A        ; with RA2, RA5, RE0-2 digital, ref to +VE and 0V
         movlw B'01000001'     ; set AD on (bit 0), Fosc/8 (8 & 7 = 01, & ADCON1 bit 6 = 0)
         movwf ADCON0,A
         bsf ADCON0,GO,A       ; start data conversion

; *********** MAIN PROGRAM **********

WAITAD0: btfsc ADCON0,GO,A
         goto WAITAD0    
         movf INDF1,W,A        ; get echo data from current memory address
         movwf PORTC,A         ; output to PORTC
         movf ADRESH,W,A       ; get ADC MSB val on its own
         movwf POSTINC1,A      ; store into current memory address & inc address counter
         movf FSR1H,W,A        ; is address counter equal maximum permisible?
         xorlw 6
         btfsc STATUS,Z,A
         lfsr FSR1,MEMORYBANK  ; yes, so reset counter to address of MEMORYBANK
         incf PORTB,F,A        ; RB0 used for sample rate freq counting in prototype

  	 btfsc PORTA,4,A       ; toggle RA2 depending on status of RA4
	 bcf PORTA,2,A
	 btfss PORTA,4,A
	 bsf PORTA,2,A

         bsf ADCON0,GO,A       ; restart data conversion
         goto WAITAD0          ; repeat

; ***************

         END

