;MHB
;22-4-04
;sneaky.asm
;A covert communication system
;designed for the 16f628 4MHz
;
;Error condition:
; turn right and left tremblers on if there is a poor rx signal
; or if A,B or Z not detected  

		list  p=16f628,n=90,t=on

  INCLUDE "P16f628.inc"
 

;set this to TX_OSC for 4MHz
 __CONFIG H'3F21'

#define 	page0   bcf status,5
#define 	page1   bsf status,5


;vectors
		org	H'0'	;cold start for 16f628
		goto	start	;vector to start
		org	H'04'	;interrupt vector
		goto	int	;service an interval

;equates
porta		equ	H'5'	;port a data reg
portb		equ	H'6'	;port b
trisa		equ	H'85'
trisb		equ	H'86'

z		equ	D'2'	;the status zero bit (Z)
status		equ	H'03'	;the status register
intcon		equ	H'0B'	;interrupt resister
gie		equ	H'7'	;gie is bit 7 in the interrupt reg
option		equ	H'81'	;option register
pc		equ	H'02'	;program counter register

spbrg		equ	H'99'	;bank 1, async speed
txsta		equ	H'98'	;bank 1, tx status
rcsta		equ	H'18'	;bank 0, rx status
txreg		equ	H'19'
rcreg		equ	H'1A'
pir1		equ	H'0C'
cmcon		equ	H'1F'	;comparators
rp0		equ	D'5'	;bank select bit 5

;define storage space
		org	H'20'	;spaced from working area

w_sav		res	1	;temp w reg
s_sav		res	1	;temp status 
temp1		res	1
temp2		res	1
temp3		res	1
tim1		res	1	;timer counter
tim2		res	1	;timer counter

xmtreg		res	1
rcvreg		res	1
rxerror		res	1
delay2		res	1

#define	gdrxled		portb,4	;good rx data
#define	vref		porta,1	;reference voltage for receiver signal strength
#define rxlevel		porta,2	;rx carrier signal strength
#define txled		portb,5	;transmitter data led
#define badrxled	portb,5	;rx poor signal level indication
#define pcb		portb,7	;tx or rx pcb definition

#define txlsw		portb,0	;tx left foot switch
#define rxpic		portb,1	;rx data input
#define txpic		portb,2	;tx data output
#define txrsw		portb,1	;tx right foot switch

#define txmtr		portb,4	;tx feedback trembler
#define rxlmtr		porta,3	;rx left trembler
#define rxrmtr		porta,4	;rx right trembler

;****** START ******
;clear downs, interrupt enables, and port assignments
start		clrf	porta	;clear for good practice
		clrf	portb	;clear for good practice
	
;set up port a
		clrf	porta
		movlw	B'00000101'
		movwf	cmcon		;select ra1,ra2 comparator

		page1
		movlw	B'00000110'	;B'00010110'
		movwf	trisa
		page0
		movlw	H'ff'		;make sure ok led if off
		movwf	porta		;

;set up port b
		page1
		movlw	B'10001011'	;
		movwf	trisb		
		page0
		movlw	H'ff'		;set leds and mtrs off
		movwf	portb		;

;****** SETUP ASYNCHRONUS CHANNEL ******
;setup async channel-  1 start, 8 data, 1 stop - 2400bps.
;setup receive status and control register		
;select serial port, 8 bit, receive disable
		movlw	B'10000000'	;
		movwf	rcsta		;

;setup transmit status and control register
;internal clock source,8 bit,tx disable,async mode,brgh=0
		bsf	status,rp0
		movlw	B'00000000'		
		movwf	txsta
		bcf	status,rp0

;baud rate generation 2400bps @ 4 MHz crystal
;select 2400bps (brgh=0,spbrg=D25)
		bsf	status,rp0
		movlw	D'25'
		movwf	spbrg		;
		bcf	status,rp0



;****** SETUP INTERRUPTS ******
;Disable global interrupt flags
			bcf	intcon,7	;disable all interrupts


;****** MAINLINE ******
;the mainline selection is based upon each pcb hardware setting on rb7
;check if this is the tx pcb or the rx pcb and execute the correct bit of code	
hwcheck		btfsc	pcb		;rb7=0 for tx pcb
		goto	rxmain

;transmitter mode selected - 
txmain	
		bcf	txmtr		;turn off tx trembler
		btfsc	txlsw		;check transmitter left foot switch
		goto	txmain1
		call	mtrl		;send letter A
		bsf	txmtr		;signal button press with trembler
		call	pt_four		;must wait for receiver trembler to finish 

txmain1		btfsc	txrsw		;check transmitter right foot switch
		goto	txmain2
		call	mtrr		;send letter B
		bsf	txmtr		;signal button press with trembler
		call	pt_four		;must wait for receiver trembler to finish 

txmain2		movlw	"Z"		;send check character when no other,
		call	send		;button is pressed	
		call	dlay35ms	;wait for byte to be tx'ed	

		goto	txmain		;loop forever


;receiver mode selected
rxmain		nop

chkagc		nop
		call	rxagc		;check the rx agc level and loop with both mtrs on if poor
		bcf	rxrmtr		;turn off right motor
		bcf	rxlmtr		;turn off left motor

		call	rcvr		;wait for a character or exit with an rx error
		movlw	"A"
		subwf	rcvreg,w
		btfsc	status,z
		goto	validrxl	;a valid left foot character detected
		
		movlw	"B"
		subwf	rcvreg,w
		btfsc	status,z
		goto	validrxr	;a valid right character detected

		movlw	"Z"
		subwf	rcvreg,w
		btfsc	status,z
		goto	rxmain		;a valid sync character detected

		bcf	badrxled	;not A,B,Z so light bad data led
		bsf	rxrmtr		; turn on right mtr
		call 	dlay1ms		; 

		bsf	rxlmtr		;and left motor
		call	dlay1ms		;

		goto	rxmain		;loop 'til signal improves

;signal a valid received command detected by turning on led and moving motor for .4sec
validrxl	bsf	rxlmtr		;turn on left motor	
		call	rxokled		;wait 0.8 sec and flash led if good data
		bcf	rxlmtr		;turn off left motor
		goto	rxmain

;signal a valid received command detected by turning on led and moving motor for .4sec
validrxr	bsf	rxrmtr		;turn on right motor	
		call	rxokled		;wait 0.8 sec and flash led if good data
		bcf	rxrmtr		;turn off right motor
		goto	rxmain


;*****************************
;****** END OF MAINLINE ******
;*****************************



;**********************************
;****** START OF SUBROUTINES ******
;**********************************



;***** MTRL ******
;send the command to activate left trembler
mtrl		movlw	"A"
		call	send		;send motor command character
		call	dlay1ms
		call	txokled		;flash led
		return

;***** MTRR ******
;send the command to activate right trembler
mtrr		movlw	"B"
		call	send		;send motor command character
		call	dlay1ms
		call	txokled		;flash led
		return

;****** RXAGC ******
;check the received signal level (agc) by comparing the rx agc output on ra2 with a reference 
;voltage of 1.5V volts applied to ra1. 
;ra1=1.5V, ra2 1.0V (bad) to 2.5V (good)
rxagc		bsf	badrxled		;ensure bad data led is off
		btfss	cmcon,7			;check comparator 2
		goto	bad1			;ra2<ra1 - signal level bad
		bcf	rxrmtr	 		;ra2>ra1 - signal level good
		bcf	rxlmtr
		return
;turn on both motors all the time to indicate poor rx level
bad1		bcf	badrxled		;light bad data led
		bsf	rxrmtr		;turn on right and left mtr,loop 'til signal improves
		call	dlay1ms
		bsf	rxlmtr
		call	dlay1ms		;
		goto	rxagc

;****** TXOKLED ******
;signal a transmission by flashing the tx led on rb5
txokled		movlw	B'00100000'	;toggle bit
		xorwf	portb,f
		call	dlay35ms	;
		movlw	B'00100000'	;toggle bit
		xorwf	portb,f
		call	dlay35ms	;
		return

;****** RXOKLED ******
;signal good data by flashing the led on rb4
rxokled		movlw	B'00010000'
		xorwf	portb,f
		call	pt_four
		movlw	B'00010000'
		xorwf	portb,f
		call	pt_four
		return

;****** SEND ******
;output the ascii character in the W reg
send		movwf	xmtreg
		call	xmtr
		return

;******* TRANSMITTER ******
;This routine simply outputs the 8 bit contents of xmtreg using
;the internal USART
;Speed is as defined above.  
;send the value in xmtreg 
xmtr			bsf	status,rp0
			bsf	txsta,5		;enable tx channel
			bcf	status,rp0

			movf	xmtreg,w	;load the output reg
			movwf	txreg		;(which sends)

			bsf	status,rp0			
txend			btfss	txsta,1		;transmitted all bits?
			goto	txend
			bcf	txsta,5		;disable tx channel
			bcf	status,rp0
			return

;****** RECEIVER ******
;Receive the 8 bits and store the result in rcvreg.
 
rcvr
			clrf	rcvreg		;clear received char store
			bsf	rcsta,4		;enable rx channel
rxend			btfss	pir1,5		;recieved all bits?
			goto	rxend

;check for overrun or framing errors
			btfsc	rcsta,1
			goto 	badrx
			btfsc	rcsta,2
			goto	badrx
;good data - store the character
			movf	rcreg,w		;fetch the chr
			movwf	rcvreg		;and save it
			bcf	rcsta,4		;reset errors and disable rx channel
			return
;bad data - exit with error flag set and rcvreg=0
badrx			bcf	rcsta,4		;reset overrun flag
			bsf	rcsta,4		;
			bcf	rcsta,4		;disable rx channel
			movf	rcreg,w		;dummy read
			clrf	rcvreg
			return			;return with rcvreg cleared 

;****** INTERRUPT SERVICE ******
int 			retfie			;dummy return


;delay 0.39S second with 4Mhz clock
pt_four		movlw	H'ff'	;set outer loop
		movwf	temp1	;this loop is .6*255*255=39321uS
del1		movlw	H'ff'	;set inner loop
		movwf	temp2	;this loop is 3*.2*256=153us
del2		decfsz	temp2,1	;this loop is 6uS
		goto	del2
		decfsz	temp1,1	;decrement and test outer
		goto	del1
		return

;delay 1ms with 4Mhz clock
dlay1ms		movlw	D'7'	;set outer loop
		movwf	temp1	;this loop is .6*255*7=1075uS
del6		movlw	H'ff'	;set inner loop
		movwf	temp2	;this loop is 3*.2*256=153us
del5		decfsz	temp2,1	;this loop is .6uS
		goto	del5
		decfsz	temp1,1	;decrement and test outer
		goto	del6
		return

;delay 35ms with 4Mhz clock
dlay35ms	movlw	D'45'	;set outer loop
		movwf	temp1	;this loop is 45*768=34560uS
del4		movlw	H'ff'	;set inner loop
		movwf	temp2	;this loop is 3*256=768us
del3		decfsz	temp2,1	;this loop is 3uS
		goto	del3
		decfsz	temp1,1	;decrement and test outer
		goto	del4
		return

		end

	
