	list p = pic16f84  	;SK42-1
 				;CODE FOR PIC2

	pcl		equ 02h
	status		equ 03h
	porta		equ 05h
	portb		equ 06h
	trisa		equ 05h
	trisb		equ 06h
	w		equ 00h
	f		equ 01h
	z		equ 02h
	delay0 		equ 0Ch
	delay1 		equ 0Dh
	delay2 		equ 0Eh
	trig		equ 0Fh
	slowloop1 	equ 10h
	slowloop2	equ 11h
	fastloop 	equ 12h
	oscloop 	equ 13h
	outosc 		equ 14h
	slowdata 	equ 15h
	fastdata 	equ 16h
	oscdata		equ 17h
	pointer		equ 18h

 	goto start
 	org 0004h
 	goto start

seq1:
 	addwf pcl, f	;When the Saints come marching in.
 	retlw 0FEh	;Mark.
 	retlw 014h	;G
 	retlw 057h
 	retlw 01Fh	;1 quaver.
 	retlw 0Eh;B'
 	retlw 063h
 	retlw 028h	;1
 	retlw 010h	;C'
 	retlw 02Fh
 	retlw 02Ah	;1
 	retlw 0FEh	;Mark.
 	retlw 010h	;D'
 	retlw 0Ch
 	retlw 0BCh	;4 quavers = 1 minim
 	retlw 0FFh	;Rest.
 	retlw 014h	;G
 	retlw 057h
 	retlw 01Fh	;1
 	retlw 0Eh	;B'
 	retlw 063h
 	retlw 028h	;1
 	retlw 010h	;C'
 	retlw 02Fh
 	retlw 02Ah	;1
 	retlw 0FEh	;Mark.
 	retlw 010h	;D'
 	retlw 0Ch
 	retlw 0BCh	;4
 	retlw 0FFh	;Rest.
 	retlw 014h	;G
 	retlw 057h
 	retlw 01Fh	;1
 	retlw 0Eh	;B'
 	retlw 063h
 	retlw 028h	;1
 	retlw 010h	;C'
 	retlw 02Fh
 	retlw 02Ah	;1
 	retlw 0FEh	;Mark.
 	retlw 010h	;D'
 	retlw 0Ch
 	retlw 05Eh	;2 quavers = 1 crochet
 	retlw 0Eh	;B'
 	retlw 063h
 	retlw 050h	;2
 	retlw 014h	;G
 	retlw 057h
 	retlw 03Fh	;2
 	retlw 0Eh	;B'
 	retlw 063h
 	retlw 050h	;2
 	retlw 0FEh	;Mark.
 	retlw 016h	;A'
 	retlw 07h
 	retlw 090h	;4
 	retlw 0FFh	;Rest.
 	retlw 0Eh	;B'
 	retlw 063h
 	retlw 028h	;1
 	retlw 0Eh	;B'
 	retlw 063h
 	retlw 028h	;1
 	retlw 016h	;A'
 	retlw 07h
 	retlw 024h	;1
 	retlw 0FEh	;Mark.
 	retlw 014h	;G
 	retlw 057h
 	retlw 02Fh	;3 = dotted crochet
 	retlw 014h	;G
 	retlw 057h
 	retlw 01Fh	;1
 	retlw 0Eh	;B'
 	retlw 063h
 	retlw 050h	;2
 	retlw 010h	;D'
 	retlw 0Ch
 	retlw 05Eh	;2
 	retlw 0FEh	;Mark.
 	retlw 010h	;D'
 	retlw 00Ch
 	retlw 02Fh	;1
 	retlw 010h	;C'
 	retlw 02Fh
 	retlw 02Ah	;1
 	retlw 010h	;C'
 	retlw 02Fh
 	retlw 02Ah	;2
 	retlw 0FFh	;Rest.
 	retlw 0Eh	;B'
 	retlw 063h
 	retlw 028h	;1
 	retlw 0Eh	;B'
 	retlw 063h 
 	retlw 028h	;1
 	retlw 010h	;C'
 	retlw 02Fh
 	retlw 02Ah	;1
 	retlw 0FEh	;Mark.
 	retlw 010h	;D'
 	retlw 0Ch
 	retlw 05Eh	;2
 	retlw 0Eh	;B'
 	retlw 063h
 	retlw 050h	;2
 	retlw 014h	;G
 	retlw 057h
 	retlw 03Fh	;2
 	retlw 016h	;A'
 	retlw 07h
 	retlw 048h	;2
 	retlw 0FEh	;Mark.
 	retlw 014h	;G
 	retlw 057h
 	retlw 07Eh	;4
 	retlw 0FEh	;Mark.
 	retlw 0		;End.
 
seq2:
 	addwf pcl,f 	;Robot voice sounds.
 	retlw 024h	;C
 	retlw 020h
 	retlw 02Ah
 	retlw 010h	;C'
 	retlw 02Fh
 	retlw 054h
 	retlw 0Ah	;E'
 	retlw 051h
 	retlw 06Ah
 	retlw 0Ah	;G'
 	retlw 029h
 	retlw 07Eh
 	retlw 08h	;C''
 	retlw 015h
 	retlw 0A8h
 	retlw 06h	;G''
 	retlw 01h
 	retlw 0F9h


start:
	bsf status,5	;Page1.
 	clrf trisa	;Port A as outputs.
 	movlw 03Dh	;RB1, 6, 7 as outputs.
 	movwf trisb
 	clrwdt
 	bcf status, 5	;Page0.

 	clrf porta
 	clrf portb	;Includes reset flip-flop.
 	movlw 02h
 	call pause2
 	bsf portb, 1	;Reset input high.
 
 	bsf portb, 6	;Send marker.
wait1:	btfss portb, 5	;Wait for 'ready'.
 	goto wait1
wait2: 	btfsc portb,5	;Wait for end of 'ready'
 	goto wait2
 	bcf portb, 6	;Clear marker.
 	btfss portb, 2	;Read select switch.
 	goto behave1	;Dancer.
 	goto behave2	;Talker.

behave1:
 	call trigger	;Wait for sound.
 	btfss trig, 0
 	goto behave1

cycle:
 	bsf porta, 1	;Red on.
 	call reset
 	movlw 0Ah
 	call pause2
 	call trigger
 	btfsc trig, 0
 	goto saints
 	bcf porta, 1	;Red off.
 	bsf porta, 2	;Green on.
 	call reset
 	movlw 0Ah
 	call pause2
 	call trigger
 	btfsc trig, 0 
 	goto talk1
 	bcf porta, 2	;Green off.
 	bsf porta, 3	;Blue on.
 	call reset
 	movlw 0Ah
 	call pause2
	call trigger
 	btfsc trig, 0
 	goto talk2
 	bcf porta, 3	;Blue off.
 	call reset
 	goto cycle
 
saints:
 	clrf porta	;LEDs off.
 	clrf pointer	;Set pointer to start of sequence.
nextnote:
 	movf pointer,w
 	call seq1	;To get next note.
 	addlw 00h	;Z set if value is zero (end).
 	btfsc status, z	;Skip if value is zero.
 	goto done
 	addlw 01h	;Z set if value is FFh (rest).
 	btfsc status, z	;Skip if value is FFh.
 	goto rest
 	addlw 01h	;Z set if value is FEh (mark).
 	btfsc status, z	;Skip if value is FEh.
 	goto mark
 	movwf slowdata	;Store in loop counter.
 	incf pointer, f	;Next word of data.
 	movf pointer,w
 	call seq1	;Second value.
 	movwf fastdata	;Store in loop counter.
 	incf pointer, f	;Next word of data.
 	movf pointer, w
 	call seq1	;Third value.
 	movwf oscdata	;Store in osc counter.
 	call oscillate	;To sound note.
 	incf pointer, f	;Start of next note.
 	goto nextnote

done: 	movlw 0Ah	;Finally to repeat tune.
 	call pause2
 	goto cycle

rest: 	movlw 04h	;Set outer loop counter.
 	movwf outosc
outerloop: movlw 0C0h	;Set inner loop counter.
 	movwf oscloop
innerloop: decfsz oscloop, f	;Count down inner loop.
 	goto innerloop
 	decfsz outosc, f	;Count down outer loop.
 	goto outerloop
 	incf pointer, f	;Next note.
 	goto nextnote

mark: 	bsf portb ,6	;Set mark.
 	bsf porta, 2	;Green LED on.
 	call pause1
 	bcf portb ,6	;Clear mark.
 	bcf porta, 2	;Green LED off.
 	incf pointer, f	;Next note.
 	goto nextnote

talk1:
	movlw 0Fh	;G''
 	movwf pointer
 	call onenote
 	call pause1
 	movlw 06h	;E'
 	movwf pointer
 	call onenote
 	call pause1
 	bcf porta, 2	;Green LED off.
 	goto cycle

talk2:
 	movlw 0Fh	;G''
 	movwf pointer
 	call onenote
 	call pause1
 	movlw 0Ch	;C''
 	movwf pointer
 	call onenote
 	call pause1
 	bcf porta, 3	;Blue LED off.
 	goto cycle
 
oscillate:
 	movlw 05h	;Set outer loop counter.
 	movwf outosc
nextloop: movf oscdata, w	;Set oscillator loop.
 	movwf oscloop
nextosc: bsf porta, 0	;To speaker.
 	call pause3
 	bcf porta, 0
 	call pause3
 	decfsz oscloop, f	;Count down oscillator loop.
 	goto nextosc
 	decfsz outosc, f	;Count down outer loop.
 	goto nextloop
 	return			;If note finished.

onenote:
 	movf pointer, w
 	call seq2
 	movwf slowdata
 	incf pointer, f
 	movf pointer, w
 	call seq2
 	movwf fastdata
 	incf pointer, f
 	movf pointer, w
 	call seq2
 	movwf oscdata
 	call oscillate
 	return


behave2: 
 	btfsc portb, 5	;Read data2.
 	goto data1xx
 	btfsc portb, 4	;Read data1.
 	goto data01x
 	btfsc portb, 3	;Read data0.
 	goto isspinl
 	goto isstop

data01x: btfsc portb, 3	;Read data0.
 	goto isfwd
 	goto isspinr

data1xx: btfsc portb, 4	;Read data1.
 	goto data11x
 	btfsc portb, 3 	;Read data0.
 	goto islight
 	goto isbumps

data11x: btfsc portb, 3
 	goto isreverse
 	goto isdark

isspinl: clrf porta
 	bsf porta, 3	;Blue LED on.
 	movlw 03h	;C'
 	movwf pointer
 	call onenote
 	call pause1
 	movlw 0Ch	;C''
 	movwf pointer
 	call onenote
 	call pause1
 	goto behave2

isstop: clrf porta
 	movlw 00h	;C
 	movwf pointer
 	call onenote
 	call pause1
 	movlw 0Fh	;G''
 	movwf pointer
 	call onenote
 	call pause1
 	goto behave2

isfwd: 	clrf porta
 	bsf porta, 1	;Red LED on.
 	movlw 03h	;C'
 	movwf pointer
 	call onenote
 	call pause1
 	movlw 00h	;C
	movwf pointer
 	call onenote
 	call pause1
 	goto behave2

isspinr: clrf porta
 	bsf porta, 2 	;Green LED on.
 	movlw 03h	;C'
 	movwf pointer
 	call onenote
 	call pause1
 	movlw 06h	;E'
 	movwf pointer
 	call onenote
 	call pause1
 	goto behave2

isbumps: clrf porta
 	bsf porta, 1	;Red LED on.
 	movlw 06h	;E'
 	movwf pointer
 	call onenote
 	call pause1
 	clrf porta	;Red LED off
 	bsf porta, 2	;Green LED on. 
 	movlw 03h	;C'
 	movwf pointer
 	call onenote
 	call pause1
 	goto behave2

islight: clrf porta
 	bsf porta, 2	;Green LED on.
 	movlw 0Ch	;C''
 	movwf pointer
 	call onenote
 	call pause1
 	clrf porta
 	bcf porta, 2	;Green LED off.
 	bsf porta, 3	;Blue LED on.
 	movlw 03h	;C'
 	movwf pointer
 	call onenote
 	call pause1
 	goto behave2

isreverse: movlw 09h	;G'
 	movwf pointer
 	call onenote
 	call pause1
 	movlw 00h	;C
 	movwf pointer
 	call onenote
 	call pause1
 	goto behave2

isdark: clrf porta
 	bsf porta, 3	;Blue LED on.
 	movlw 0Ch	;C''
 	movwf pointer
 	call onenote
 	call pause1
 	clrf porta	;Blue LED off.
 	bsf porta, 1	;Red LED on.
 	movlw 09h	;G'
 	movwf pointer
 	call onenote
 	call pause1
 	goto behave2
 
trigger:
 	clrf trig	;Trigger flag = 0.
 	btfss portb, 0	;Sound switch triggered?
 	return		;If not, with trig = 0.
 	incf trig, f	;Trigger flag = 1.
 	return 		;If triggered with trig = 1.

reset:
 	bcf portb, 1	;Reset input low.
 	movlw 02h
 	call pause2
 	bsf portb, 1	;Reset input high.
 	movlw 02h
 	call pause2
 	return

pause2: 
 	movwf delay2	;Already has value in w.

dloop2: call pause1
 	decfsz delay2, f
 	goto dloop2
 	return
pause1: movlw 0FFh
 	movwf delay1
dloop1: call pause0
 	decfsz delay1, f
 	goto dloop1
 	return
pause0: movlw 0FFh
 	movwf delay0
dloop0: decfsz delay0, f
 	goto dloop0
 	return

pause3:
 	movf slowdata, w
 	movwf slowloop1	;Set outer slow loop counter.
dloop4: movlw 0Fh
 	movwf slowloop2	;Set inner slow loop counter.
dloop5: decfsz slowloop2, f	;Count down inner slow loop.
 	goto dloop5
 	nop
 	decfsz slowloop1, f	;Count down outer slow loop.
 	goto dloop4
 	nop
 	movf fastdata,w
 	movwf fastloop	;Set fast loop counter.
dloop6: decfsz fastloop, f	;Count down fast loop.
 	goto dloop6
 	nop
 	return

	end
