;********************************************************************
;
; PIC ON A STRIP : 24 HOUR TIMER MODULE 
;
; BY LES CLARKE 21-5-2003 
; 
;	SOURCE FILE 	ETAP.ASM
;	CODE FILE	ETAP.HEX
;	EE DATA	FILE	TAPEE.HEX  	 	
;********************************************************************
;*
;* PROCESSOR PIC16F84A  FREQ: 32768 XTAL LP SETTING
;* MPASM ASSEMBLY TXT FOR PIC BASED TIMER CONTROLLING
;* A MOTORISED LOW PRESSURE WATER VALVE. 
;*       
;*   B0 > LCD D4
;*   B1 > LCD D5                                                                                                                                                                                    
;*   B2 > LCD D6
;*   B3 > LCD D7
;*   B4 > LCD RS
;*   B5 > LCD E 
;*   B6 < POSITION SWITCH S5
;*   B7 > MOTOR ON
;		
;*   A0 < SW 1   
;*   A1 < SW 2  
;*   A2 < SW 3  
;*   A3 < SW 4  
;*   A4 < TEST STRAP   
;*
; MODE REG BITS
;0=1=SET TIME 
;1=1=SET WINDOW
;2=1=SET DURATION / FREQUENCY
;3=1=TAKE SHORT ISR
;4=1=RESTART WINDOW
;5
;6
;7
; WSTAT REG BITS
;0=1=WINDOW ACTIVE : 0=WINDOW INACTIVE	
;1=1=VALVE OPEN : 0=VALVE SHUT
;2=1=CHANGE VALVE POSITION
;3=1=DISPLAY TIME FLAG
;4
;5
;6
;7
;
;***************************************************
; TIME OR WINDOW SETUP HAS TO BE ENTERED BEFORE TIMER CAN FUNCTION
; WINDOW DISPLAY - (X)REQUIRES SETTING:(A) ACTIVE OR (I) INACTIVE 
; VALVE IS (S) SHUT OR (O) OPEN. 	
;***************************************************
;

	LIST P=16F84A

	#INCLUDE <P16F84A.INC>

	__CONFIG	H'3FF0' ; CP OFF (B13-B4): PWRT ENABLED: WD DISABLED 
	__BADRAM H'07', H'50'-H'7F', H'87'  ; XT= LP
;*
;* REGISTER DEFINITIONS
;*
LOOP	EQU	0X0C	; LOOP COUNT 1 
LOOPA	EQU	0X0D	; LOOP COUNT 2 (LCD)
RSLINE	EQU	0X0E	; BIT 4 RS LINE FOR LCD
TEMP	EQU	0X0F	; TEMP REGISTER
ASCIL	EQU	0X10	; ASCII LOW STORE
ASCIH	EQU	0X11	; ASCII HI STORE
EEREF	EQU	0X12	; EEDATA REFERENCE 
STORE	EQU	0X13	; GENERAL STORE
FREQCO	EQU	0X14	; FREQUENCY COUNTER
DURCO	EQU	0X15	; DURATION COUNTER
;------ FILES INITALISED AT POWER ON
SECS	EQU	0X16	; SECONDS REGISTER
MINS	EQU	0X17	; MINUTES REGISTER
HOURS   EQU	0X18	; HOURS REGISTER
DCTRL	EQU	0X19	; DISPLAY CONTROL
MODE	EQU	0X1A	; MODE FLAGS
WINA	EQU	0X1B	; WINDOW ACTIVE HOUR (HEX)
WINI	EQU	0X1C	; WINDOW INACTIVE HOUR (HEX)
ODUR	EQU	0X1D	; ON DURATION MINS (HEX)
OFREQ	EQU	0X1E	; ON FREQUENCY HOUR (HEX)
WSTAT	EQU	0X1F	; WINDOW STATUS
;---- DATA SETTINGS FOR DISPLAY -----------
WIN	EQU	0X20	; W=WINDOW 
SPC1	EQU	0X21	;  SPACE 1
WINFH	EQU	0X22	; FROM WINDOW HI
WINFL	EQU	0X23	; FROM WINDOW LOW
AROW	EQU	0X24	; >> ARROW
WINTH	EQU	0X25	; TO WINDOW HI
WINTL	EQU	0X26	; TO WINDOW LOW
SPC2	EQU	0X27	;  SPACE 2
;------------------------------------------
POC	EQU	0X28	; 'P'OR 'C' 
DASH	EQU	0X29	; - 
DURH	EQU	0X2A	; DURATION HI
DURL	EQU	0X2B	; DURATION LOW
CHAT	EQU	0X2C	; @ CHARACTER 
FREQ	EQU	0X2D	; FREQUENCY (HOURS)
ASH	EQU	0X2E	; h
SPC3	EQU	0X2F	; SPACE 3
;------------------------------------------
WAOI	EQU	0X30	; WINDOW ACTIVE OR INACTIVE
VOOC	EQU	0X31	; VALVE OPEN OR SHUT
SPC4	EQU	0X32	; SPACE 4
AHRSH	EQU	0X33	; ASCII HOURS HIGH
AHRSL	EQU	0X34	; ASCII HOURS LOW
DOTS	EQU	0X35	; ASCII :
AMINH	EQU	0X36	; ASCII MINUTES HIGH 
AMINL	EQU	0X37	; ASCII MINUTES LOW
;-----------------------------------------
FSR_TMP EQU	0X4D	; FSR TEMP REG
S_TEMP	EQU	0X4E	; STATUS TEMP
W_TEMP  EQU	0X4F	; W TEMP
;
;----------------------------------------
; NOTE  1 CPU CYCLE @ 32.768 KHZ = 122 USEC
;---------------------------------------- 
                               
	ORG	0 	; 
	GOTO 	START	;
	ORG	4 	; 
	GOTO	ISR	; TIMER0 INTERUPT PROCESS TIME
;	
;----- START UP -----------------------------------------
;
START  	CLRF	INTCON  ; DISABLES ALL INTS
;
;---- INITIALISE IO PORTS ----------------------------------------
;
	CLRF	PORTB		; PORT B IS LOW WHEN OUTPUT ENABLED
	CLRF	PORTA		; PORT A IS LOW WHEN OUTPUT ENABLED
	BSF	STATUS,RP0 	; SELECT BANK 1
	MOVLW	B'01000000'	; PORT B SELECTION
				; B0 LCD D4 OUT
				; B1 LCD D5 OUT
				; B2 LCD D6 OUT
				; B3 LCD D7 OUT
				; B4 LCD RS OUT
				; B5 LCD E  OUT
				; B6 POSITION SWITCH IN
				; B7 MOTOR DRIVE OUT	
	MOVWF	TRISB		; SET
				; PORT A SELECTION
	MOVLW	B'00011111'	; A0 SW 1 IN
				; A1 SW 2 IN
				; A2 SW 3 IN
				; A3 SW 4 IN
				; A4 TEST
	MOVWF	TRISA		; SET
;
;---- INITIALISE TMR0 -----------------------------
;
	MOVLW	B'00000100'	; PULL UP, PRE 1:32
	MOVWF 	OPTION_REG	; 
;
;---- INITIALIZE THE DEFAULT DATA -----------------
;---- COPY EEDATA FROM EEADR 00 TO REGISTERS H'16-2F
;
	BCF	STATUS, RP0 	; BANK 0
	MOVLW	0X34		; 52 BYTES TO GET		
	MOVWF	LOOP		; LOAD TX COUNTER
	MOVLW	0X16		; START REGISTER ADDRESS 16
	MOVWF	FSR		; SET UP INDIRECT
	CLRF	EEREF		; START AT EE 00	
EEREAD	MOVF	EEREF,W		; LOAD EE ADDRESS	
	MOVWF	EEADR 		; TO READ FROM
	BSF	STATUS, RP0 	; BANK 1
	BSF	EECON1, RD	; START READ OPERATION
	BCF	STATUS, RP0 	; BANK 0
	MOVF	EEDATA, W	; W = EEDATA
	MOVWF	INDF		; SAVE
	INCF	FSR,1		; +1 TO REG ADDR 
	INCF	EEREF,1		; +1 TO EE ADDR		
	DECFSZ	LOOP,1		; USING TX COUNTER
	GOTO	EEREAD		; DO MORE EE READS
;
;---- INITIALISE  INTERRUPTS --------------------------------
;	
	BCF	STATUS,RP0	; SELECT BANK 0
	MOVLW	B'10100000'	; ENABLE GLOBAL INT + TIMER 0 
	MOVWF	INTCON		; SET INTERUPTS TIMER 0		
	GOTO	SETUP		; JUMP TABLE
;
;---- LCD INITIALISATION TABLE ------------------------------------
;
TABLCD	ADDWF	PCL,F		; 
	RETLW	B'00110011'	; PREAMBLE 
	RETLW	B'00110011'	;
	RETLW	B'00110010'	; 4-BIT OPERATION
	RETLW	B'00101000'	; 2 LINES (2X8=1X16)
	RETLW	B'00001000'	; DISPLAY OFF
	RETLW	B'00001100'	; DISPLAY ON CURSOR OFF
	RETLW	B'00000110'	; SET ENTRY MODE TO INCREMENT EACH ADDRESS
	RETLW	B'00000001'	; CLEAR / HOME CURSOR	
				; END OF INITIALISATION TABLE				
;
;---- INITIALISE THE LCD DISPLAY -----------------------------
;
SETUP	CALL 	DLY5		; 1/5 SEC DELAY 
LCDSET	CLRF	LOOP		; CLR LCD SET-UP LOOP
	CLRF	RSLINE		; CLEAR RS LINE FOR INSTRUCTION SEND
LCDST2	MOVF	LOOP,W		; GET TABLE ADDRESS
	CALL	TABLCD		; GET SET-UP INSTRUCTION
	CALL	LCDOUT		; PERFORM IT
	INCF	LOOP,F		; INC LOOP
	BTFSS	LOOP,3		; LAST LCD SET-UP DONE?
	GOTO	LCDST2		; NO
	CALL	DLY5		; YES, SECOND 1/5TH SEC DELAY
;
;---- TEST MODE ? ---------------------
;
	BTFSS	PORTA,4		; CHECK TEST STRAP
	GOTO	TEST		; DO TESTING
;
;---- MOST OF THE TIME PIC LOOPS HERE ------------------	
;
SCAN	BTFSC	WSTAT,3		; CHECK TIME DISPLAY
	CALL	LCDTIM		; DISPLAY TIME
	MOVF	MODE,1		; TEST ANY SET MODE BIT	
	BTFSS	STATUS,Z	; IF ZERO LEAVE
	GOTO	SMODE		; GOTO SET MODE.
	BTFSC	WSTAT,2		; CHECK CHANGE FLAG
	CALL	VALVE		; CHANGE VALVE POSITION.
	MOVF	DCTRL,1		; TEST DISPLAY CONTROL
	BTFSC	STATUS,Z	; IF ZERO LEAVE
	GOTO	SCAN		;
	BTFSC	DCTRL,7		; TEST DISPLAY BIT7 
	CALL	VPROG		; VIEW PROG MESSAGE	
	BTFSC	DCTRL,6		; TEST DISPLAY BIT6 
	CALL	VWIN		; VIEW WINDOW	
	BTFSC	DCTRL,4		; TEST DISPLAY BIT5 
	CALL	DDFS1		; LOAD VIEW D/F SETUP
	BTFSC	DCTRL,2		; TEST DISPLAY BIT3 
	CALL	VSET		; DISPLAY [?]SET
	BTFSS	DCTRL,0		; DONE CLEAR ALL
	GOTO	SCAN		;
	CLRF	DCTRL		; RESET DISPLAY CONTROL
	BTFSC	WSTAT,0		; IF WINDOW ACTIVE 
	GOTO	DFREM		; SHOW D/F REMAINING
	MOVLW	0X20		; SHOW WIN SET UP
	CALL	LCDF1		; DISPLAY FRAME 1
	GOTO	SCAN		; LOOP
DFREM	CALL	LDDFC		; LOAD DISPLAY DUR /FREQ COUNT	
	GOTO	SCAN		; LOOP
;
;---- CHANGE VALVE POSITION ------------------------
;
VALVE	BTFSS	WSTAT,1		; IF VALVE OPEN =0 GO SHUT IT
	GOTO	VSHUT		;
	;---- OPEN VALVE 
VOPEN	BTFSS	PORTB,6		; B6=1 IF VALVE SHUT
	GOTO	VALOK		; VALVE IS IN DESIRED POSITION
	BSF	PORTB,7		; B7=1 DRIVES MOTOR
	GOTO	VOPEN
	;---- SHUT VALVE
VSHUT	BTFSC	PORTB,6		; B6=1 IF VALVE SHUT
	GOTO	VALOK		; VALVE IN DESIRED POSITION
	BSF	PORTB,7		; B7=1 DRIVES MOTOR
	GOTO	VSHUT
	;---- POSITION CONFIRMED	
VALOK	BCF	PORTB,7		; B7=0 STOPS MOTOR
	BCF	WSTAT,2		; CLEAR VALVE CHANGE BIT
	MOVLW	0X4F		; VALVE OPEN CHAR O
	BTFSS	WSTAT,1		; BIT1=1=OPEN
	MOVLW	0X53		; VALVE SHUT CHAR S
	MOVWF	VOOC		; SET CHAR
	RETURN 		
;
;---------- SETTINGS MODE ---------------------------------	
;
SMODE	MOVLW	0X3A		; REG ADDRESS  
	CALL	LCDF1		; DISPLAY 'SET'
	BTFSC	MODE,0		; MODE 0  
	GOTO	STIM		; SET TIME
	BTFSC	MODE,1		; MODE 1  
	GOTO	SWIN		; SET WINDOW
	BTFSC	MODE,2		; MODE 2  
	GOTO	SFRE		; SET FREQUENCY 
 	GOTO	SCAN		; 
;
;---- MODE 0 - SET TIME		
;
STIM	; + (MINS) SET SECS=59 SET INTERRUPT 
	BTFSC	PORTA,3		; TEST SWITCH
	GOTO	INCFST		; NOTHING TO DO
	MOVLW	0X3B		; MAKE SECS = 59
	MOVWF	SECS		; SPEED INCREMENT
	BSF	INTCON,2	; SET INTERUPT
	NOP			; WAIT INTERUPT WILL OCCURE
	GOTO	SCAN		; MORE TO DO
	; + TEN MINS
INCFST	BTFSC	PORTA,2		; TEST SWITCH
	GOTO	UNSET		; LEAVE OR NOTHING TO DO
	MOVLW	0X0A		; INCREMENT BY 10
	ADDWF	MINS,1		; SPEED INCREMENT
	BSF	INTCON,2	; SET INTERUPT
	NOP			; WAIT INTERUPT WILL OCCURE
	GOTO	SCAN		; MORE TO DO
;
;---- EXIT ALL SET MODES
;
UNSET	BTFSC	PORTA,0		; TEST SWITCH
	GOTO	SCAN		; NOTHING TO DO
	BTFSS	MODE,4		; TEST RESTART WIN BIT
	CALL	CAWIN		; CHECK ACTIVE WINDOW
	CLRF	MODE		; STOP MODE
	MOVLW	0X01		; SET DISPLAY 
	MOVWF	DCTRL		; DISPLAY CONTROL
	GOTO	SCAN		; 
;
;---- MODE 1 SET WINDOW
;
SWIN	MOVLW	0X20 		; WINDOW START ADDRESS 
	CALL	LCDF2		; DISPLAY FRAME 2
	;------ INC ACTIVE WINDOW HOURS
INC1	BTFSC	PORTA,1		; TEST SWITCH 1
	GOTO	INC2		; LEAVE OR NOTHING TO DO	 	
 	CALL	DLY5		; SHORT DELAY
	INCF	WINA,1		; + ON WINDOW
	MOVF	WINA,W		; GET ON TIME
	SUBLW	0X17		; 23 ? 	
	BTFSS	STATUS,C	; IF => THEN CLEAR HRS
	CLRF	WINA		; HOURS=00
	MOVF	WINA,W		; GET ON HOURS
	CALL	H2AD		; TO ASCII
	MOVF	ASCIL,W		; GET LOW 
	MOVWF	WINFL		; PUT LOW
	MOVF	ASCIH,W		; GET HI 
	MOVWF	WINFH		; PUT HI
	GOTO	SCAN		;
	;------- INCREMENT INACTIVE WINDOW HOURS	
INC2	BTFSC	PORTA,3		; TEST SWITCH 3
	GOTO	UNSET		; LEAVE OR NOTHING TO DO	 	
 	CALL	DLY5		; SHORT DELAY
	INCF	WINI,1		; + INACT WINDOW
	MOVF	WINI,W		; GET INACT TIME
	SUBLW	0X18		; 24 ? 	
	BTFSS	STATUS,C	; IF => THEN CLEAR HRS
	CLRF	WINI		; HOURS=00
	MOVF	WINI,W		; GET INACT HOURS
	CALL	H2AD		; TO ASCII
	MOVF	ASCIL,W		; GET LOW 
	MOVWF	WINTL		; PUT LOW
	MOVF	ASCIH,W		; GET HI 
	MOVWF	WINTH		; PUT HI
	GOTO	SCAN		;
;
;----- MODE  2 SET DURATION /FREQUENCY
;
SFRE	CALL	DDFS2		; LOAD DISPLAY SETTINGS
	;----- INCREMENT DURATION	
	BTFSC	PORTA,1		; TEST SWITCH 1
	GOTO	INC3		; LEAVE OR NOTHING TO DO	 	
	CALL	DLY5		; SHORT DELAY
	INCF	ODUR,1		; + ON DURATION
	MOVF	ODUR,W		; GET ON MINS
	SUBLW	0X1E		; 30 ? 	
	BTFSS	STATUS,C	; IF => THEN MAKE 1 
	GOTO	ONE		;
	GOTO	SCAN		;
	;---- INCREMENT FREQUENCY
INC3	BTFSC	PORTA,2		; TEST SWITCH 2
	GOTO	UNSET		; LEAVE OR NOTHING TO DO	 	
	CALL	DLY5		; SHORT DELAY
	INCF	OFREQ,1		; + FREQUENCY
	MOVF	OFREQ,W		; GET ON TIME
	SUBLW	0X08		; MAX EVERY 8 HOURS 	
	BTFSS	STATUS,C	; IF => THEN CLEAR HRS
	BCF	OFREQ,3		; FREQ = 01
	GOTO	SCAN		;
	;----- DURATION MINIMUM = 1
ONE	CLRF	ODUR		; DURATION=00
	INCF	ODUR,1		; 
	GOTO	SCAN		;
;
;---- LCDTIM -- DISPLAY STATUS AND TIME AS 00:00 @ C0 ( SECOND FRAME )
;
LCDTIM	BCF	WSTAT,3		; CLEAR TIME DISPLAY BIT
	CALL 	ATIME		; CONVERT TIME TO ASCII
	MOVLW	0X3A		; DOTS
	BTFSS	SECS,0		; ODD SEC ?
	MOVLW	0X20		; SPACE
	MOVWF	DOTS		; FLASH DOTS
	MOVLW	0X30		; SET TIME START
	MOVWF	FSR		; HOLD FOR INDF 
	CALL	LCDF2		; 
	RETURN
;
;---- DISPLAY DATA @ ADDR=W FIRST FRAME 
;
LCDF1	MOVWF	FSR		; HOLD FOR INDF 
	CLRF	RSLINE		; CLEAR RS LINE FOR INSTRUCTION SEND
	MOVLW	0X80		; 80 = DISPLAY 1ST CHR
	CALL	LCDOUT		; SEND IT
	CLRF	LOOP		; CLEAR LOOP
	BSF	RSLINE,4	; SET RS FOR DATA SEND
MOR1	MOVF	INDF,W		; GET DATA 
	CALL	LCDOUT		; SHOW IT
	INCF	FSR,F		; INC POINTER
	INCF	LOOP,1		; INC LOOP
	BTFSS	LOOP,3		; 8 CHARACTERS BEEN SENT?
	GOTO	MOR1		; NO, SO REPEAT FOR NEXT ONE
	RETURN			
;
;---- DISPLAY DATA @ ADDR=W SECOND FRAME 
;
LCDF2	MOVWF	FSR		; HOLD FOR INDF 
	CLRF	RSLINE		; CLEAR RS LINE FOR INSTRUCTION SEND
	MOVLW	0XC0		; C0 = DISPLAY 9TH CHR	
	CALL	LCDOUT		; SEND IT
	CLRF	LOOP		; CLEAR LOOP
	BSF	RSLINE,4	; SET RS FOR DATA SEND
MOR2	MOVF	INDF,W		; GET DATA 
	CALL	LCDOUT		; SHOW IT
	INCF	FSR,F		; INC POINTER
	INCF	LOOP,1		; INC LOOP
	BTFSS	LOOP,3		; 8 CHARACTERS BEEN SENT?
	GOTO	MOR2		; NO, SO REPEAT FOR NEXT ONE
	RETURN			
;
;---- LOAD DISPLAY D/F COUNTS FRAME 1 ----------
;
LDDFC	MOVF	DURCO,W		; GET ACTIVE DURATION
	CALL	H2AD		; TO ASCII
	MOVF	ASCIL,W		; GET LOW 
	MOVWF	DURL		; PUT LOW
	MOVF	ASCIH,W		; GET HI 
	MOVWF	DURH		; PUT HI
	MOVF	FREQCO,W	; GET ACTIVE FREQUENCY
	CALL	H2AD		; TO ASCII
	MOVF	ASCIL,W		; GET LOW 
	MOVWF	FREQ		; PUT LOW
	MOVLW	0X43		; LOAD 'C'
	MOVWF	POC		; SET IT
	GOTO	DDF1		; GO AND DISPLAY	
;
;---- LOAD D/F SETTINGS -----------------------
;
LDFS	MOVF	ODUR,W		; GET ON DURATION
	CALL	H2AD		; TO ASCII
	MOVF	ASCIL,W		; GET LOW 
	MOVWF	DURL		; PUT LOW
	MOVF	ASCIH,W		; GET HI 
	MOVWF	DURH		; PUT HI
	MOVF	OFREQ,W		; GET FREQUENCY
	CALL	H2AD		; TO ASCII
	MOVF	ASCIL,W		; GET LOW 
	MOVWF	FREQ		; PUT LOW
	MOVLW	0X50		; LOAD 'P'ROGRAM
	MOVWF	POC		; SET IT
	RETURN
;
;---- DISPLAY D/F FRAME 1 -----------------------
;
DDF1	MOVLW	0X28		; D/F REG ADDRESS
	CALL	LCDF1		; DISPLAY FRAME 1 
	RETURN			;
;
;---- DISPLAY D/F FRAME 2 -----------------------
;
DDF2	MOVLW	0X28		; D/F REG ADDRESS
	CALL	LCDF2		; DISPLAY FRAME 1 
	RETURN			;
;
;---- DISPLAY WIN FRAME 1 ------------------------
;
VWIN	MOVLW	0X20		; WINDOWT REG ADDRESS 
	CALL	LCDF1		; DISPLAY
	RETURN			;
;
;---- DISPLAY SET ? ------------------------------
;
VSET	MOVLW	0X38		; ?-SET  REG ADDRESS 
	CALL	LCDF1		; OR ?-OPEN (TEST) 
	RETURN			;
;
;---- DISPLAY PROG ------------------------------
;
VPROG	MOVLW	0X40		; PROG REG  ADDRESS 
	CALL	LCDF1		; 
	RETURN			;
;
;----- DISPLAY SHUT (TEST MODE) ---------------------
;
SHUTD	MOVLW	0X40		; ?-SHUT REG ADDRESS
	CALL	LCDF1		; 
	RETURN			;
;
;----- LOAD / DISPLAY D/F SETTINGS FRAME 1 ----------------
;
DDFS1	CALL	LDFS		; LOAD COUNTS
	CALL	DDF1		; DISPLAY
	RETURN
;
;------ LOAD / DISPLAY D/F SETTINGS FRAME 2 ----------------
;
DDFS2	CALL	LDFS		; LOAD COUNTS
	CALL	DDF2		; DISPLAY
	RETURN
;-------------------------------------------------------
; LCDOUT - SETS CHARACTER AT DISPLAY ADDRESS
; SPECIFIED TIME BETWEEN FULL BYTES WAS BETWEEN 40
; AND 120 uSEC WITH THIS 'SLOW' XTAL DELAYS NOT REQUIRED 
;-------------------------------------------------------
LCDOUT	MOVWF	STORE		; TEMP STORE DATA
	CALL	SENDIT		; SEND MSB
	CALL	SENDIT		; SEND LSB
	RETURN			
;
;---- SEND BYTE IN STORE AS 2 NIBBLES -------------------				
;
SENDIT	SWAPF	STORE,F		; SWAP DATA NIBBLES
	MOVF	STORE,W		; GET DATA BYTE
	ANDLW	0X0F		; GET NIBBLE FROM BYTE (LSB)
	IORWF	RSLINE,W	; OR THE RS BIT
	MOVWF	PORTB		; OUTPUT THE BYTE
	BSF	PORTB,5		; SET E LINE HIGH
	BCF	PORTB,5		; SET E LINE LOW
	RETURN			
;
;---- LCD WRITE DELAYS ---------------------------------	
; DEVICE SPECIFIC  DLY5 apx = 1/5 SEC
;-------------------------------------------------------
; 
DLY5 	MOVLW	0XFF		; 256*7*122uSEC= 0.21 SEC
	MOVWF	LOOPA		; SET UP DELAY
WDLY	NOP			; EXTEND THE LOOP	
	NOP			; EXTEND THE LOOP	
	NOP			; EXTEND THE LOOP	
	NOP			; EXTEND THE LOOP	
	DECFSZ	LOOPA,F		; DEC LOOP UNTIL ZERO
	GOTO	WDLY		; WAIT DELAY COUNT
	RETURN			
;
;---- CONVERT TIME TO ASCII ----------------
;
ATIME	;------ DECODE MINS
	;
	MOVF	MINS,W		; GET MINUTES
	CALL	H2AD		; HEX TO ASCII
	MOVF	ASCIL,W		; GET LOW
	MOVWF	AMINL		; PUT LOW
	MOVF	ASCIH,W		; GET HI
	MOVWF	AMINH		; PUT HI
	;
	;------ DECODE HOURS
	;
	MOVF	HOURS,W		; GET HOURS
	CALL	H2AD		; HEX TO ASCII
	MOVF	ASCIL,W		; GET LOW
	MOVWF	AHRSL		; PUT LOW
	MOVF	ASCIH,W		; GET HI
	MOVWF	AHRSH		; PUT HI
	RETURN
;
;---- HEX TO ASCII DECIMAL -------------------------
;
H2AD	MOVWF	TEMP		; SAVE	
	MOVLW	0X30		; START AT ZERO
	MOVWF	ASCIL		; SAVE LOW
	MOVWF	ASCIH		; SAVE HI
NEXTCO	MOVF	TEMP,1		; TEST ZERO
	BTFSC	STATUS,Z 	; SKIP IF NOT ZERO
	RETURN			; FINISHED COUNT 
	DECF	TEMP,1		; -1 COUNT
	INCF	ASCIL,1		; +1 LOW RESULT
	MOVF	ASCIL,W		; GET LOW
	SUBLW	0X3A		; CHECK IF >9
	BTFSS	STATUS,Z 	; SKIP IF =
	GOTO	NEXTCO
	;-------- COUNT = 3A ---------
	MOVLW	0X30		; START AT ZERO
	MOVWF	ASCIL		; SAVE LOW
	INCF	ASCIH,1		; +1 HIGH RESULT
	GOTO	NEXTCO
;
;---- TEST MODE ( NO WAY OUT ! ) ------------------------------
;
TEST	BSF	MODE,3		; TAKE SHORT ISR.
	;	
	; COPY EE DATA FOR TEST FROM EEADR 34 TO REGISTERS H'3A>
	;
	BCF STATUS, RP0 	; BANK 0
	MOVLW	0X0C		; 12 BYTES TO GET		
	MOVWF	LOOP		; LOAD COUNTER
	MOVLW	0X3A		; START REGISTER ADDRESS 
	MOVWF	FSR		; SET UP INDIRECT
	MOVLW	0X34		; EE START		
	MOVWF	EEREF		; SAVE	
TEREAD	MOVF	EEREF,W		; LOAD EE ADDRESS	
	MOVWF	EEADR 		; TO READ FROM
	BSF	STATUS, RP0 	; BANK 1
	BSF	EECON1, RD	; START READ OPERATION
	BCF	STATUS, RP0 	; BANK 0
	MOVF	EEDATA, W	; W = EEDATA
	MOVWF	INDF		; SAVE
	INCF	FSR,1		; +1 TO REG ADDR 
	INCF	EEREF,1		; +1 TO EE ADDR		
	DECFSZ	LOOP,1		; USING TX COUNTER
	GOTO	TEREAD		; DO MORE TEST EE READS
	GOTO	TSHUT		; GOTO TEST VALVE
TLOOP	BTFSS	PORTA,0		; CHECK SWITCH 0
	GOTO	TOPEN		; TEST OPEN
	BTFSC	PORTA,1		; CHECK SWITCH 1
	GOTO	TLOOP		; DO IT AGAIN
TSHUT	CALL	SHUTD		; DISPLAY ?-SHUT
	BCF	WSTAT,1		; VALVE SHUT	
	BSF	WSTAT,2		; VALVE CHANGE	
	CALL	VALVE		; CHANGE VALVE
	GOTO	TLOOP		; 
TOPEN	CALL	VSET		; DISPLAY ?-OPEN
	BSF	WSTAT,1		; VALVE OPEN	
	BSF	WSTAT,2		; VALVE CHANGE	
	CALL	VALVE		; CHANGE VALVE
	GOTO	TLOOP		; 
;
;---- CHECK FOR SWITCH OR ROLL DISPLAY
;
SW00	MOVF	DCTRL,1		; CHECK DISPLAY ACTIVE
	BTFSS	STATUS,Z	; IF NZ THEN SHIFT
	GOTO	SHIFT		;
	BTFSS	PORTA,0		; CHECK DISPLAY SWITCH
	BSF	DCTRL,7		; SET TIME DISPLAY
	RETURN
SHIFT	BTFSS	PORTA,1		; CHECK SET SWITCH
	GOTO	SETM0		; SET MODE.
	BTFSS	PORTA,2		; CHECK SET SWITCH
	GOTO	SETM1		; SET MODE.
	BTFSS	PORTA,3		; CHECK SET SWITCH
	GOTO	SETM2		; SET MODE.
	BCF	STATUS,C	; CLEAR CARRY.
	RRF	DCTRL,1		; SET NEXT DISPLAY 
	RETURN
;
;---- SET MODES 0-1-2 ----------------------------------
;
SETM2	BSF	MODE,2		; ENABLE SET MODE (FREQUENCY)
	BSF	MODE,3		; SET SHORT ISR
	BSF	MODE,4		; SET WINACT SKIP BIT
	RETURN			; LEAVE WINDOW AS IS
				;
SETM1	BSF	MODE,1		; ENABLE SET MODE(WINDOW)
	BSF	MODE,3		; SET SHORT ISR
	GOTO	EXSM		; PREP SET MODE  
				;
SETM0	BSF	MODE,0		; ENABLE SET MODE(TIME) 
EXSM	CLRF	DCTRL		; STOP DISPLAY CYCLE
	MOVLW	0X49		; WINDOW INACTIVE FLAG 
	MOVWF	WAOI		; LOAD TO DISPLAY
 	CLRF	WSTAT		; CLEAR WINDOW STATUS
	CALL	VALVE		; SHUT VALVE
	RETURN
;
;---- CHECK HOURS IF WINDOW ACTIVE ------------------------
;
WINACT	BTFSS	WSTAT,0		; 
	GOTO	OPENW		; CHECK TO WINDOW OPEN
	; WINDOW IS ACTIVE COME HERE EVERY HOUR  
	; TO CHECK IF WINDOW INACTIVE HOURS = WINI	
	MOVF	WINI,W		; GET INACTIVE HOURS
	SUBWF	HOURS,W		; 
	BTFSS	STATUS,Z	; SKIP IF = SET INACTIVE
	RETURN			; 
INAW	;--- INACTIVE WINDOW
	MOVLW	0X20		; LOAD SPACE
	MOVWF	SPC4		; TO DISPLAY
	MOVLW	0X49		; WINDOW INACTIVE FLAG 
	MOVWF	WAOI		; LOAD TO DISPLAY
	CLRF	WSTAT		; CLEAR WINDOW STATUS
	BSF	DCTRL,0		; FORCES DISPLAY UPDATE	
	RETURN
OPENW	;--- CHECK IF WINDOW ACTIVE     	
	MOVF	WINA,W		; GET ACTIVE TIME
	SUBWF	HOURS,W		; 
	BTFSS	STATUS,Z	; SKIP IF =
	RETURN			; NOT TO ACTIVATE
PREA	MOVLW	0X2A		; LOAD *
	MOVWF	SPC4		; TO DISPLAY
	;--- ACTIVATE WINDOW	
ACTI	MOVF	ODUR,W		; GET DURATION
	MOVWF	DURCO		; LOAD DURATION COUNTER
	MOVLW	0X01		; OPEN VALVE AT NEXT HOUR COUNT
	MOVWF	FREQCO		; LOAD COUNTER
	MOVLW	0X41		; A=ACTIVE WINDOW FLAG
	MOVWF	WAOI		; LOAD TO DISPLAY
	BSF	WSTAT,0		; SET WINDOW ACTIVE	
	CALL	LDDFC		; DISPLAY D/F
	RETURN			; 
;
;---- INITIALIZE WINDOW AFTER NEW SET UP ---------
;
CAWIN	MOVF	WINA,W		; GET ACTIVE TIME
	SUBWF	HOURS,W		; 
	BTFSS	STATUS,C	; SKIP IF TIME < ACTIVE
	GOTO	INAW		; MAKE INACTIVE
				; CHECK TIME > INACTIVE TIME 
	MOVF	WINI,W		; GET INACTIVE HOURS
	SUBWF	HOURS,W		; 
	BTFSS	STATUS,C	; SKIP TO SET INACTIVE
	GOTO	PREA		; MAKE READY NEXT HOUR
	GOTO	INAW		; MAKE INACTIVE 	
;
;---- CHECK FREQUENCY ACTIVE ----------------------
;
UDFREQ	DECF	FREQCO,1	; DOWN COUNT FREQUENCY
	CALL	LDDFC		; DISPLAY DUR/FREQ COUNT 
	MOVF	FREQCO,1	; TEST IF ZERO
	BTFSS	STATUS,Z	; 
	GOTO	EXITI		; NOT Z GO BACK
	;---------- OPEN VALVE IF ZERO	
	BSF	WSTAT,1		; SET VALVE OPEN BIT
	BSF	WSTAT,2		; SET VALVE CHANGE FLAG
	MOVF	OFREQ,W		; GET FREQUENCY
	MOVWF	FREQCO		; RELOAD FREQUENCY COUNTER
	MOVLW	0X20		; LOAD SPACE
	MOVWF	SPC4		; TO DISPLAY
	GOTO	EXITI		; GO BACK
;
;---- UPDATE VALVE --------------------------------------
;
UDVAL	DECF	DURCO,1		; DOWN COUNT ON DURATION
	CALL	LDDFC		; DISPLAY DUR/FREQ 
	MOVF	DURCO,1		; TEST IF ZERO
	BTFSS	STATUS,Z	; 
	GOTO	CKMIN		; NOT Z GO BACK
	;---------- SHUT VALVE IF TIMER ZERO	
	BCF	WSTAT,1		; CLEAR VALVE OPEN BIT
	BSF	WSTAT,2		; SET CHANGE FLAG
	MOVF	ODUR,W		; GET DURATION
	MOVWF	DURCO		; RELOAD DURATION COUNTER
	CALL	LDDFC		; DISPLAY DUR/FREQ 
	GOTO	CKMIN		; GO BACK
;
;--------INTERRUPT SERVICE ROUTINE -------------------------	
;
ISR	;---------- COME HERE EVERY SECOND -----------------
	; SAVE CONTEXT
	;
	MOVWF	W_TEMP 		; COPY W TO TEMP REGISTER,
	SWAPF	STATUS, W 	; SWAP STATUS TO BE SAVED INTO W
	MOVWF	S_TEMP		; SAVE STATUS TO STATUS_TEMP REGISTER
	MOVF	FSR,W		; SAVE FSR
	MOVWF	FSR_TMP		; TO REG
	;
	;----------- INCREMENT REGISTERS -------------
	;
TIME	BTFSC	MODE,3		; IF SET TAKE SHORT ISR
	GOTO	SHORT		; DETOUR
	INCF	SECS,1		; SECONDS
	BTFSS	MODE,0		; SKIP IF SET MODE 
	CALL	SW00		; CHECK ANY SWITCH
	;
	;----------- TEST SECONDS = D'60 --------------
	;
	MOVF	SECS,W		; GET SECONDS
	SUBLW	0X3B		;  	
	BTFSC	STATUS,C	; IF => THEN + MINS
	GOTO	CKMIN		; CHECK MINS		
	;
	;------------- +1 MINS ----------------------------
	;
	INCF	MINS,1		; +1 MINS
	CLRF	SECS		; CLEAR SECONDS
	;
	;---- IF VALVE OPEN GO UPDATE VALVE TIMER
	; 	
	BTFSC	WSTAT,1		; BIT 1=1=VALVE OPEN 
	GOTO	UDVAL		; UPDATE OPEN VALVE TIMER. 
	;
	;-------- TEST MINS = D'60 --------------------
	;
CKMIN	MOVF	MINS,W		; GET MINUTES
	SUBLW	0X3B		;  	
	BTFSC	STATUS,C 	; IF => THEN + HOURS
	GOTO	EXITI		; EXIT INTERRUPT	
	;
	;-------ADD 1 TO HOURS ---------------------------
	;
	INCF	HOURS,1		; +1 HOURS
	CLRF	MINS		; CLEAR MINUTES
	;
	;----------- TEST HOURS = D'24 --------------------
	;
	MOVF	HOURS,W		; GET HOURS
	SUBLW	0X17		; 24 ? 	
	BTFSS	STATUS,C	; IF >24 THEN SET TO 0
	CLRF	HOURS		; CLEAR HOURS	
	BTFSC	MODE,0		; WINACT NOT ALLOWED SETTING TIME
	GOTO	EXITI		; SO EXIT INTERRUPT
	CALL	WINACT		; CHECK WINDOW ACTIVE
	BTFSC	WSTAT,0		; TEST BIT 0=1=WINDOW ACTIVE 
	GOTO	UDFREQ		; IF WINDOW OPEN UPDATE FREQUENCY
EXITI	BSF	WSTAT,3		; DISPLAY TIME FLAG 
SEXIT	BCF	INTCON,2	; ALLOW TIMER 0
	;
	;------- RESTORE CONTEXT ------------------
	;
	MOVF	FSR_TMP,W	; GET FSR
	MOVWF	FSR		; RESTORE
	SWAPF	S_TEMP,W	; SWAP NIBBLES IN STATUS_TEMP REGISTER
				; AND PLACE RESULT INTO W
	MOVWF	STATUS 		; MOVE W INTO STATUS REGISTER
				; (SETS BANK TO ORIGINAL STATE)
	SWAPF W_TEMP,F		; SWAP NIBBLES IN W_TEMP AND PLACE RESULT IN W_TEMP
	SWAPF W_TEMP,W		; SWAP NIBBLES IN W_TEMP AND PLACE RESULT INTO W
	RETFIE			; RETURN FROM INTERUPT
;------------------------------------------------------
; SHORT ISR TO ADVANCE TIME WHILE SETTING MODE 
;------------------------------------------------------
SHORT	INCF	SECS,1	; SECONDS
	;----------- TEST = D'60 --------------------
	MOVF	SECS,W		; GET SECONDS
	SUBLW	0X3B		;  	
	BTFSC	STATUS,C	; IF => THEN + MINS
	GOTO	SCKMIN		; CHECK MINS		
	;------- +1 MINS ----------------------------
	INCF	MINS,1		; +1 MINS
	CLRF	SECS		; CLEAR SECONDS
	;-------- TEST MINS = D'60 --------------------
SCKMIN	MOVF	MINS,W		; GET MINUTES
	SUBLW	0X3B		;  	
	BTFSC	STATUS,C 	; IF => THEN + HOURS
	GOTO	SEXIT		; EXIT ISR		
	;-------ADD 1 TO HOURS ---------------------------
	INCF	HOURS,1		; +1 HOURS
	CLRF	MINS		; CLEAR MINUTES
	;----------- TEST HOURS = D'24 --------------------
	MOVF	HOURS,W		; GET HOURS
	SUBLW	0X17		; 24 ? 	
	BTFSS	STATUS,C	; IF >24 THEN SET TO 0
	CLRF	HOURS		; CLEAR HOURS	
	GOTO	SEXIT		; GOTO SHORT EXIT !
;----------------------------------------------------------------------
	END
