; EPE Pic 'n Mix - August 2004
; Andrew Jarvis
; pnm0804_timer0.asm v1.0
; 02 June 2004
;
; Example code to demonstrate 'Hello World' using Timer0
; Uses a PIC16F628 with internal 4MHz oscillator
; Produces flashing LED pattern on RB4 (pin 10)

	list p=PIC16f628,r=hex
	#include <p16f628.inc>
	errorlevel  -302	; suppress message 302, warning about ensuring correct bank bits

	__CONFIG   _INTRC_OSC_NOCLKOUT & _WDT_OFF & _PWRTE_ON & _BODEN_OFF & _MCLRE_OFF & _LVP_OFF & _DATA_CP_OFF & _CP_OFF  
	
icount 	equ 0x20		; interrupt counter
	
	org 0			; reset vector
	goto start
	org 4			; interrupt vector
	
	; note - usual interrupt service routine handling procedures
	; omitted for clarity in this simple example.
	
	bcf INTCON, T0IF	; clear the TMR0 overflow interrupt flag
	rlf icount, F		; rotate through 8 bit register
	btfss STATUS, C		; only allow LED to toggle if carry bit set
	retfie	
	movlw 0x10		
	xorwf PORTB, F		; toggle PORTB<4>
	retfie			; exit isr
	
start
	banksel TRISB		; Bank 1
	clrf TRISB		; set PORTB as outputs

	movlw b'10000111'	; pull ups disabled, prescaler assigned to TMR0
	movwf OPTION_REG	; TMR0 prescaler rate 1:256

	banksel PORTB		; Bank 0
	clrf PORTB		; reset PORTB
	
	movlw b'00000001'	; set icount<0>, and subsequently rotate
	movwf icount		; through the file to count the interrupts

	bcf STATUS, C		; be sure no rogue carry bit rotated into icount
		
	movlw b'10100000'	; enable global and TMR0 overflow interrupts
	movwf INTCON
	
	; do nothing, interrupt service routine will do all the work :-)
main	goto main

	end
	
