; EPE Pic 'n Mix - August 2004
; Andrew Jarvis
; pnm0804_loops.asm v1.0
; 02 June 2004
;
; Example code to demonstrate 'Hello World' using instruction timing loops
; Uses a PIC16F628 with internal 4MHz oscillator
; Produces flashing LED pattern on RB4 (pin 10)

	list      p=PIC16f628,r=hex
	#include <p16f628.inc>
	errorlevel  -302	; suppress message 302, warning about ensuring correct bank bits

	__CONFIG   _INTRC_OSC_NOCLKOUT & _WDT_OFF & _PWRTE_ON & _BODEN_OFF & _MCLRE_OFF & _LVP_OFF & _DATA_CP_OFF & _CP_OFF
	
delay1	equ 0x20		; delay loop counter 1
delay2  equ 0x21		; delay loop counter 2

	org 0			; reset vector
	goto start
	org 4			; interrupt vector
	retfie

start	
	banksel TRISB		; Bank 1
	clrf TRISB		; set PORTB as outputs
	banksel PORTB		; Bank 0
	clrf PORTB		; reset PORTB
	
	clrf delay1		; initialise delay loop counter 1
	clrf delay2		; initialise delay loop counter 2
	
	movlw 0x10		
loop	xorwf PORTB, F		; toggle PORTB<4>
wait	decfsz delay1, F	; inner loop, decrement delay1 until zero
	goto wait
	decfsz delay2, F	; outer loop, decrement delay2 until zero
	goto wait		
	goto loop		; start over

	end
	
