; SEISMO87.ASM 29DEC03 - COPYRIGHT JOHN BECKER - EPE SEISMOGRAPH LOGGER

;PIC16F876, 3.2768MHz, WDT OFF, POR ON, XTAL XS

;PROGRAM WRITTEN IN TASM VARIANT - NEEDS TRANSLATING VIA TK3 TO SUIT MPASM

;Config register bits
; CP1 CP0 CP1 CP0 NIL CPD LVP BOR MCL OS2 POR WDT OS1 OS0
;  1   1   1   1   1   1   0   0   1   0   0   0   0   1
;N.B. Logic 1/0 do NOT necessarily mean that the function is On/Off
;respectively - refer to PIC16F876 data sheet

#DEFINE CHAN0 iorlw B'00000000'

#DEFINE BLOCK0 BCF STATUS,7             ; clear STATUS bit 7 (IRP)
#DEFINE BLOCK1 BSF STATUS,7             ; set   STATUS bit 7 (IRP)
#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5
#DEFINE SERIALDELAY call CYCLES5  ; set serial chip write delay value
                         ; CYCLES25 for 20MHz, CYCLES5 for 4MHz or below

        List P = PIC16F876, R=DEC;
        __CONFIG   h'3F31'

        include P16F876.inc

        CBLOCK

REGA0				;lsb
REGA1
REGA2
REGA3				;msb

REGB0				;lsb
REGB1
REGB2
REGB3				;msb

DSIGN				;Digit Sign. 0=positive,FF(or non zero)=negative
DIGIT1				;MSD
DIGIT2
DIGIT3
DIGIT4
DIGIT5				;Decimal digits
DIGIT6
DIGIT7
DIGIT8
DIGIT9
DIGIT10				;LSD
MTEMP
MCOUNT
DCOUNT
VALIDITY
ABORT

LOOP        ; loop counter
LOOPA       ; loop counter for LCD
RSLINE      ; LCD command/data flag
CLKCNT      ; pre-counter for seconds
STORE1      ; general store
MEMHI     
MEMLO     
WADDRL    
WADDRH    
RADDRH    
RADDRL    
POLLCNT     ; serial eeprom use
SLAVE       ; serial eeprom use
TXBUF       ; serial eeprom use
BCOUNT  
COUNT   
DATAI   
DATAO   
EEPROM  
ECHAN
MEMCNT
                 
ADCMSB
ADCLSB
SAMPLEDELAY
DELAYCOUNT
ECHANTEMP

	ENDC

; ***** VALUES HELD IN BOTH BANKS

        CBLOCK H'70'
PROMVAL
MEMFUL
        ENDC

             ;************************************************************
             ;           Bit Definitions
             ;************************************************************

DI:         .EQU $07        ; eeprom input bit
DO:         .EQU $06        ; eeprom output bit
SDATA:      .EQU $04        ; serial EE data line (PORTC)
SCLK:       .EQU $03        ; serial EE clock line (PORTC)

        ORG 0
        goto GIEOFF
        ORG 4            ; Interrupt vector address
        goto GIEOFF
        ORG 5

GIEOFF: BCF INTCON,GIE   ; turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto START

LCDSET: clrf LOOP        ;clr LCD set-up loop
        clrf RSLINE      ;clear RS line for instruction send
LCDST2: movf LOOP,W      ;get table address
        call TABLCD      ;get set-up instruction
        call LCDOUT      ;perform it
        incf LOOP,F      ;inc loop
        btfss LOOP,3     ;has last LCD set-up instruction now been done?
        goto LCDST2      ;no
        return

TABLCD: addwf PCL,F      ;LCD initialisation table
        retlw %00110011  ;initialise lcd - first byte
        retlw %00110011  ;2nd byte (repeat of first)
        retlw %00110010  ;set for 4-bit operation
        retlw %00101100  ;set for 2 lines
        retlw %00000110  ;set entry mode to increment each address
        retlw %00001100  ;set display on, cursor off, blink off
        retlw %00000001  ;clear display
        retlw %00000010  ;return home, cursor & RAM to zero
                         ;end inititalisation table

MESSAG1: addwf PCL,F
        retlw 'E'
        retlw 'P'
        retlw 'E'
        retlw ' '
        retlw 'S'
        retlw 'E'
        retlw 'I'
        retlw 'S'
        retlw 'M'
        retlw 'O'
        retlw 'G'
        retlw 'R'
        retlw 'A'
        retlw 'P'
        retlw 'H'
        retlw ' '

MESSAGS: addwf PCL,F
        retlw 'S'
        retlw 'A'
        retlw 'M'
        retlw 'P'
        retlw 'L'
        retlw 'E'
        retlw ' '
        retlw 'D'
        retlw 'E'
        retlw 'L'
        retlw 'A'
        retlw 'Y'
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '

MESSAG2: addwf PCL,F
        retlw 'C'
        retlw 'L'
        retlw 'E'
        retlw 'A'
        retlw 'R'
        retlw 'I'
        retlw 'N'
        retlw 'G'
        retlw ' '
        retlw 'E'
        retlw 'E'
        retlw 'P'
        retlw 'R'
        retlw 'O'
        retlw 'M'
        retlw ' '

MESSAG5: addwf PCL,F
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw '0'
        retlw ' '
        retlw 'O'
        retlw 'F'
        retlw ' '
        retlw 'C'
        retlw 'H'
        retlw 'I'
        retlw 'P'
        retlw ' '
        retlw ' '

MESSAGJ:  addwf PCL,F
           retlw 'S'
           retlw 'E'
           retlw 'R'
           retlw 'I'
           retlw 'A'
           retlw 'L'
           retlw ' '
           retlw 'O'
           retlw 'C'
           retlw 'X'
           retlw ' '
           retlw 'T'
           retlw 'O'
           retlw ' '
           retlw 'P'
           retlw 'C'

MESSAGW:  addwf PCL,F
           retlw 'W'
           retlw 'A'
           retlw 'I'
           retlw 'T'
           retlw 'I'
           retlw 'N'
           retlw 'G'
           retlw ' '
           retlw 'P'
           retlw 'C'
           retlw ' '
           retlw 'T'
           retlw 'R'
           retlw 'I'
           retlw 'G'
           retlw ' '

;*******************

START:  bcf STATUS,RP0
        bcf STATUS,RP1
        clrf PORTA       ; initialise all port outputs to zero
        clrf PORTB
        clrf PORTC

        BANK1
        movlw %11000000
        movwf TRISB
        movlw B'10000100'       ; set RHS justify, RA0, RA1, RA3 as analog inputs
        movwf ADCON1            ; with ref to +VE and 0V
        movlw %00000001         ; RA0 as input
        movwf TRISA
        movlw %10100100         ; RC7, RC5, RC2 as input
        movwf TRISC
        movlw B'00000110'       ; timer 1:128 (1/25th sec), pull-ups off
        movwf OPTION_REG
        BANK0

        movlw B'10000001'       ; set AD on, Fosc/32
        CHAN0                   ; set for CHAN0 - RA0
        movwf ADCON0

        clrf INTCON
        call PAUSIT
        call LCDSET
        clrf INTCON
        call PAUSIT

        call SHOWTITLE

        call JOESETBAUD  ; set baud rate

        movlw 5
        movwf CLKCNT

        movlw %00000000     ; T1 ext osc disable (bit3=0), T1 stopped (bit0=0), internal clock (bit1=0), bit2 dont care
        movwf T1CON

        clrf TMR1L       ; reset timer 1
        clrf TMR1H

        call CHIPCOUNT

        btfss PORTC,2   ; is external serial chip clearance needed?
        goto SHOWC2
        call CLEARIT    ; yes
        call CLRLINE2
        call CLEARADR

SHOWC2: movlw 0          ; get previous eeprom address & rate values
        call PRMGET
        movwf ECHAN 
        movlw 1
        call PRMGET
        movwf WADDRH
        movlw 2
        call PRMGET
        movwf WADDRL
        movlw 3
        call PRMGET
        btfsc STATUS,Z
        movlw 1
        movwf SAMPLEDELAY
        movwf DELAYCOUNT

        btfsc PORTC,5   ; is sample delay change needed?
        call CHANGERATE

        call SHOWTITLE

        call PAUSIT
        call PAUSIT
        call PAUSIT

        call SHOWRATE

        movlw 25                ; initial basic CLKCNT val for secs timing
        movwf CLKCNT
        bcf INTCON,2

        bcf PIR1,0       ; timer rollover flag
        goto MAIN4

;********* START OF MAIN PROGRAM ********

MAIN:   btfss   PIR1,RCIF       ; Check for any RX'd data
        goto MAIN2              ; Nothing RX'd
        movf    RCREG,W         ; Store the RX'd data in 'W'
        sublw   'S'             ; Is this an 'S' for Set ?
        btfss   STATUS,Z
        goto MAIN2              ; no

        bsf PORTA,2             ; yes
        call SHOWWAIT
        call STORECOUNT

MAIN3A: btfss   PIR1,RCIF       ; Check for any RX'd data
        goto MAIN3A             ; Nothing RX'd
        movf    RCREG,W         ; Store the RX'd data in 'W'
        sublw   'G'             ; Is this a 'G' for Go ?
        btfsc   STATUS,Z
        call JOEDOWNLOAD        ; Yes, a 'G'
        bcf PORTA,2

MAIN2:  btfss INTCON,2          ; has a timer time-out been detected?
        goto MAIN               ; no
        bcf INTCON,2            ; yes

        call GETADC
        rlf ADCLSB,W       ; shift lsb bit 7 into msb
        rlf ADCMSB,W
        iorlw 128          ; set msb bit 7 high
        call TXBYTE        ; send it to PC
        movf ADCLSB,W      ; clr lsb bit 7
        andlw %01111111
        call TXBYTE        ; send it to PC

        decfsz CLKCNT,F         ; increment system clock counter. Is it = 0?
        goto MAIN                 
        movlw 25                ; yes, reset start value of CLKCNT
        movwf CLKCNT
        decfsz SAMPLEDELAY,F
        goto MAIN
        movf DELAYCOUNT,W
        movwf SAMPLEDELAY

MAIN4:  call GETADC

        movf ADCMSB,W
        movwf REGA1
        movf ADCLSB,W
        movwf REGA0
        clrf REGA2
        clrf REGA3

        call LCD1
        call BIN2DEC
        call SHOWDIG6
        movlw ' '
        call LCDOUT

        movf WADDRH,W        ; show write address
        movwf REGA1
        movf WADDRL,W
        movwf REGA0
        clrf REGA2
        clrf REGA3
        call BIN2DEC
        call SHOWDIG3
        movf WADDRH,W
        movwf RADDRH    
        movf WADDRL,W
        movwf RADDRL    
        movlw ' '
        call LCDOUT
        movf ECHAN,W
        iorlw 48
        call LCDOUT
        movlw ' '
        call LCDOUT

        call STOREIT         ; store it to external eeprom

        movf MEMFUL,W     ; is ECHAN now equal to MEMCNT? (MEMFUL = 1) ** 28DEC03
        btfss STATUS,Z
        clrf ECHAN
        goto MAIN

;********** LCD CONTROL SECTION *********

LCD1:   movlw %10000000
        goto LCDLIN
LCD6:   movlw %10000110
        goto LCDLIN
LCD11:  movlw %10001011
        goto LCDLIN

LCD16:  movlw %10010000
        goto LCDLIN

LCD21:  movlw %11000000
        goto LCDLIN

LCD2F:  movlw %11001111
        goto LCDLIN

LCD210: movlw %11001101
        goto LCDLIN
LCD21D: movlw %11011011
        goto LCDLIN

LCDOUT: movwf STORE1    ; temp store value that will be output to LCD
        movlw 255       ; set minimum time between sending full bytes to LCD
        movwf LOOPA
DELAY:  decfsz LOOPA,F
        goto DELAY
        call SENDIT     ; send MSB, then (by default) send LSB

SENDIT: swapf STORE1,F  ; swap byte nibbles
        movf STORE1,W   ; get nibble (MSB)
        andlw 15        ; AND to isolate nibble
        iorwf RSLINE,W  ; OR the RS bit
        movwf PORTB     ; output the byte
        nop
        bsf PORTB,5     ; set E high
        nop
        bcf PORTB,5     ; set E low
        return

LCDLIN: bcf RSLINE,4    ; sets LCD command/line
        call LCDOUT     ; and outputs cmmand code to LCD
        bsf RSLINE,4    ; set RS flag
        return

PAUSIT: movlw 14        ; 1/5th sec wait set
        movwf CLKCNT
        clrf INTCON     ; clear interupt flag
PAUSE:                  ;
        btfss INTCON,2  ; has a timer time-out been detected?
        goto PAUSE      ; no
        bcf INTCON,2    ; yes
        decfsz CLKCNT,F ; dec loop, is it zero?
        goto PAUSE      ; no
        return          ; yes

; **************

CLEARIT: call CLRLINE1        ; clear entire external serial eeprom
        call CLRLINE2

        clrf LOOP
        call LCD1
        bsf RSLINE,4
SHOWCLR: movf LOOP,W
        call MESSAG2          ; clearing eeprom
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto SHOWCLR

        clrf LOOP
        call LCD21
        bsf RSLINE,4
SHOWCL2: movf LOOP,W
        call MESSAG5          ; clearing eeprom
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto SHOWCL2
        call LCD2F
        incf ECHAN,W
        iorlw 48
        call LCDOUT
        call CLEARADR

CLEAR2: call SAVESAMPLE
        btfsc MEMFUL,0    ; is MEMFUL set from address inc routine?
        goto CLEAR4       ; yes
        btfss STATUS,C    ; is there a carry from address inc routine?
        goto CLEAR2       ; no

        movf WADDRL,W     ; yes, so show count
        movwf REGA0
        movf WADDRH,W
        movwf REGA1
        clrf REGA2
        clrf REGA3
        call BIN2DEC
        call LCD21
        bsf RSLINE,4
        call SHOWDIG5     ; show current record count
        call LCD2F
        incf ECHAN,W
        iorlw 48
        call LCDOUT

        rlf WADDRL,W       ; shift lsb bit 7 into msb
        rlf WADDRH,W
        iorlw 128          ; set msb bit 7 high
        call TXBYTE        ; send it to PC
        movf WADDRL,W      ; clr lsb bit 7
        andlw %01111111
        call TXBYTE        ; send it to PC

        goto CLEAR2

CLEAR4: call CLEARADR
        call STORECOUNT  ; store reset count value to eeprom
        movlw 255
        call TXBYTE        ; send it to PC as final value
        movlw 255
        call TXBYTE        ; send it to PC

        return

; **********

SHOWTITLE: clrf LOOP
        call LCD1
        bsf RSLINE,4
SHOWMS1: movf LOOP,W
        call MESSAG1
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto SHOWMS1
        return

SHOWRATE: clrf LOOP
        call LCD21
        bsf RSLINE,4
SHOWRS1: movf LOOP,W
        call MESSAGS
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto SHOWRS1

        call LCD210
        movf DELAYCOUNT,W
        movwf REGA0
        clrf REGA1
        clrf REGA2
        clrf REGA3
        call BIN2DEC
        call SHOWDIG8

        call PAUSIT
        return


; *********

CLRLINE1: call LCD1     ;set address for line 1 cell 1
        bsf RSLINE,4    ;set RS for data send
        clrf LOOP       ;
CLRL1:  movlw ' '       ;clear cell
        call LCDOUT     ;
        incf LOOP,F     ;inc loop
        btfss LOOP,4    ;has last LCD letter been sent?
        goto CLRL1      ;no
        return

CLRLINE2: call LCD21
        bsf RSLINE,4
        movlw 16
        movwf LOOP
CL2:    movlw ' '
        call LCDOUT
        decfsz LOOP,F
        goto CL2
        return

; ***************

STOREIT: movf ADCMSB,W    ; store bottom sensor vals to external serial EEPROM chip
         movwf MEMHI
         movf ADCLSB,W
         movwf MEMLO
         call SAVESAMPLE
         return

;*********

;SERIALMEM01 30MAR02 from LOG430.ASM 29OCT99 - JOHN BECKER - EPE DATA LOGGER MODIFIED EXTRACT
; MODIFIED FOR PORTA

SAVESAMPLE: movf MEMHI,W   ; store MSB
        call WRBYTE
        incf WADDRL,F      ; inc address
        movf MEMLO,W       ; store LSB
        call WRBYTE
        decf WADDRL,F      ; dec address back to prev count
        call INCADDRESS
        return

;*********** cycles pause called by Serial EEPROM write routines ****

; the CALL takes 2 clock cycles
; the RETURN takes 2 clock cycles
; a pause of 4 clock cycles is created by just CALLing CYCLES4 and returning
; each NOP adds a further 1 cycle pause

CYCLES25:  NOP
CYCLES24:  NOP
CYCLES23:  NOP
CYCLES22:  NOP
CYCLES21:  NOP
CYCLES20:  NOP
CYCLES19:  NOP
CYCLES18:  NOP
CYCLES17:  NOP
CYCLES16:  NOP
CYCLES15:  NOP
CYCLES14:  NOP
CYCLES13:  NOP
CYCLES12:  NOP
CYCLES11:  NOP
CYCLES10:  NOP
CYCLES9:   NOP
CYCLES8:   NOP
CYCLES7:   NOP
CYCLES6:   NOP
CYCLES5:   NOP
CYCLES4:   return

;*************


;CONVERTED MPASM FILE C:\ASMCNV\2WDPOLL.ASM
;       TO TASM  FILE C:\PIC\2WDPOLL.ASM 03-12-1999 19:28:42
; see Microchip CD-ROM disk 2, download\appnote\category\eeproms\00567.ZIP
; the original used timings based on a 4MHz clock
; this routine has been modified to enable different xtal rates
; Defining SERIALDELAY as "call CYCLE5" is for 4MHz or less xtal
; Defining SERIALDELAY as "call CYCLE25" is for 20MHz xtal

          ;***************************************************************
          ;       Byte Write Routine with data polling
          ;***************************************************************

WRBYTE:   movwf DATAO         ;entry with val to send in W, stored to DATAO
          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100000   ; set slave address and write mode
          MOVWF SLAVE

BYTE:     CALL BSTART         ; generate start bit
          MOVF SLAVE,W        ; move slave address
          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it

          movf WADDRH,W       ; send address high byte
          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it

          movf WADDRL,W       ; send address low byte
          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it

          MOVF DATAO,W        ; move data byte
          MOVWF TXBUF         ; to tranmit buffer
          CALL TX             ; and transmit it
          CALL BSTOP          ; generate stop bit

          MOVLW 40            ; now start polling for a low ack bit
          MOVWF POLLCNT       ; set max number of times to poll
POLL:     CALL BSTART         ; generate start bit

          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100000   ; set slave address and write mode

          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it
          BTFSS EEPROM,DI     ; was the ack bit low?
          GOTO EXITPOLL       ; yes, do another byte
          DECFSZ POLLCNT,F    ; is poll counter down to zero?
          GOTO POLL           ; no, poll again.
EXITPOLL: return

          ;**************************************************************
          ;       Start Bit Subroutine - generates a start bit
          ;       (Low going data line while clock is high)
          ;**************************************************************

BSTART:   BSF PORTC,SDATA    ; make sure data is high
          BANK1
          MOVLW %10100111
          MOVWF TRISC        ; set data and clock lines for output
          BANK0
          BCF PORTC,SCLK     ; make sure clock is low
          NOP                 
          BSF PORTC,SCLK     ; set clock high
          SERIALDELAY        ; timing adjustment
          BCF PORTC,SDATA    ; data line goes low during
                             ; high clock for start bit
          SERIALDELAY        ; timing adjustment
          BCF PORTC,SCLK     ; start clock train
          NOP                 
          NOP                 
          RETLW 0             

          ;************************************************************
          ;       Stop Bit Subroutine - generates a stop bit
          ;       (High going data line while clock is high)
          ;************************************************************

BSTOP:    BANK1
          MOVLW %10100111
          MOVWF TRISC        ; set data/clock lines as outputs
          BANK0
          BCF PORTC,SDATA    ; make sure data line is low
          SERIALDELAY        ; timing adjustment        
          BSF PORTC,SCLK     ; set clock high
          SERIALDELAY        ; timing adjustment
          BSF PORTC,SDATA    ; data goes high while clock high for stop bit
          SERIALDELAY        ; timing adjustment
          BCF PORTC,SCLK     ; set clock low again
          SERIALDELAY        ; timing adjustment
          RETLW 0

            ;*************************************************************
            ;       BITOUT routine takes one bit of data in 'do' and
            ;       transmits it to the serial EE device
            ;*************************************************************

BITOUT:   BANK1
          MOVLW %10100111
          MOVWF TRISC
          BANK0
          BTFSS EEPROM,DO    ; check for state of data bit to xmit
          GOTO BITLOW        ;
          BSF PORTC,SDATA    ; set data line high
          GOTO CLKOUT        ; go toggle the clock

BITLOW:   BCF PORTC,SDATA    ; output a low bit
CLKOUT:   BSF PORTC,SCLK     ; set clock line high
          SERIALDELAY        ; timing adjustment
          BCF PORTC,SCLK     ; return clock line low
          RETLW 0             

          ;**************************************************************
          ;       BITIN routine reads one bit of data from the
          ;       serial EE device and stores it in 'di'
          ;**************************************************************

BITIN:    BSF EEPROM,DI       ; assume input bit is high
          BANK1
          MOVLW %10110111     ; make sdata an input line
          MOVWF TRISC
          BANK0
          BSF PORTC,SDATA    ; set sdata line for input
          BSF PORTC,SCLK     ; set clock line high
          SERIALDELAY        ; timing adjustment
          BTFSS PORTC,SDATA  ; read the data bit
          BCF EEPROM,DI      ; input bit was low
          BCF PORTC,SCLK     ; set clock line low
          RETLW 0

          ;****************************************************************
          ;       Transmit Data Subroutine
          ;****************************************************************

TX:       MOVLW 8
          MOVWF COUNT         ; set the #bits to 8
TXLP:     BCF EEPROM,DO       ; assume bit out is low
          BTFSC TXBUF,7       ; is bit out really low?
          BSF EEPROM,DO       ; otherwise data bit =1
          CALL BITOUT         ; serial data out
          RLF TXBUF,F         ; rotate txbuf left
          DECFSZ COUNT,F      ; 8 bits done?
          GOTO TXLP           ; no - go again
          CALL BITIN          ; read ack bit
          RETLW 0             

                              
;CONVERTED MPASM FILE C:\ASMCNV\2WSEQR.ASM
;       TO TASM  FILE C:\PIC\2WSEQR.ASM 03-12-1999 19:29:04

          ;************************************************************
          ;       2-Wire Sequential Read Program
          ;************************************************************
          ;       Stop Bit Subroutine - generates a stop bit
          ;       (High going data line while clock is high)
          ;************************************************************

BSTOP2:   BANK1
          MOVLW %10100111     ;
          MOVWF TRISC         ; set data/clock lines as outputs
          BANK0
          BCF PORTC,SDATA     ; make sure data line is low
          SERIALDELAY
          BSF PORTC,SCLK      ; set clock high
          SERIALDELAY
          BSF PORTC,SDATA     ; data goes high while clock high for stop bit
          SERIALDELAY
          BCF PORTC,SCLK      ; set clock low again
          SERIALDELAY
          RETLW 0

          ;**************************************************************
          ;       BITIN2 routine reads one bit of data from the
          ;       serial EE device and stores it in 'di'
          ;**************************************************************

BITIN2:   BSF EEPROM,DI       ; assume input bit is high
          BANK1
          MOVLW %10110111     ; make sdata an input line
          MOVWF TRISC
          BANK0
          BSF PORTC,SCLK      ; set clock line high
          SERIALDELAY
          BTFSS PORTC,SDATA  ; read the data bit
          BCF EEPROM,DI       ; input bit was low, set 'di' accordingly
          BCF PORTC,SCLK     ; set clock line low
          RETLW 0             

          ;****************************************************************
          ;       Transmit Data Subroutine
          ;****************************************************************

TX2:      MOVLW 8
          MOVWF COUNT         ; set the #bits to 8
TXLP2:    BCF EEPROM,DO       ; assume bit out is low
          BTFSC TXBUF,7       ; is bit out really low?
          BSF EEPROM,DO       ; no, set it high
          CALL BITOUT         ; send the bit to serial EE
          RLF TXBUF,F         ; rotate txbuf left
          DECFSZ COUNT,F      ; 8 bits done?
          GOTO TXLP2          ; no - go again
          CALL BITIN2         ; read ack bit
          BTFSC EEPROM,DI     ; check ack bit
          NOP
          RETLW 0             

          ;****************************************************************
          ;       Receive data Routine
          ;****************************************************************

RX:       MOVLW 8             ; set # bits to 8
          MOVWF COUNT         
          CLRF DATAI          ; clear input register
          BCF STATUS,0        ; make sure carry bit is low
RXLP:     RLF DATAI,F         ; rotate DATAI 1 bit left
          CALL BITIN2         ; read a bit
          BTFSC EEPROM,DI     
          BSF DATAI,0         ; set bit 0 if necessary
          DECFSZ COUNT,F      ; 8 bits done?
          GOTO RXLP           ; no, do another
          RETLW 0             

          ;**************************************************************
          ;       READ (sequential read routine)
          ;**************************************************************

READ:     MOVLW 2             
          MOVWF BCOUNT        ; set number of bytes to read
          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100000     ; set slave address and write mode
          MOVWF SLAVE         

          CALL BSTART         ; generate start bit
          MOVF SLAVE,W        ; get slave address
          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and send it

          movf RADDRH,W       ; send address high byte
          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and send it

          MOVF RADDRL,W       ; get word address
          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and send it

          CALL BSTART         ; generate start bit
          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100001     ; set slave address and write mode

          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and transmit it
                              ;
RBYTE:    CALL RX             ; read 1 byte from device
          DECFSZ BCOUNT,F     ; are both bytes read?
          GOTO LOWACK         ; no, send low ack and do another
          BSF EEPROM,DO       ; yes, send high ack bit
          CALL BITOUT         ; to stop transmission
          CALL BSTOP2         ; and send a stop bit
          movf DATAI,W
          movwf MEMLO         ;data low byte
          return

LOWACK:   movf DATAI,W
          movwf MEMHI         ; data high byte
          BCF EEPROM,DO       ; send low ack bit
          CALL BITOUT         ; to continue transmission
          GOTO RBYTE          ; and read another byte

;**************

JOEDOWNLOAD: movlw %00110000  ; set timer 1 for prescale 1/8, and timer off
        movwf T1CON
        clrf TMR1L       ; reset timer 1
        clrf TMR1H

        bcf PIR1,0       ; timer rollover flag
        bsf T1CON,0      ; start timer 1
        call CLRLINE2     ; clear LCD line 2

         clrf LOOP
         call LCD1
         bsf RSLINE,4
SHOWMSGJ movf LOOP,W
         call MESSAGJ      ; sending to PC message
         call LCDOUT
         incf LOOP,F
         btfss LOOP,4
         goto SHOWMSGJ

;         call STORECOUNT

         call JOESENDPC    ; send chips to PC

LS2:     call SHOWTITLE
        call SHOWRATE

        movlw %00110000  ; set timer 1 for prescale 1/8, and timer off
        movwf T1CON

        movlw 0          ; get previous eeprom address & rate values
        call PRMGET
        movwf ECHAN 

         movlw 25          ; reset clk counter
         movwf CLKCNT
         return 

SHOWWAIT: clrf LOOP
         call LCD1
         bsf RSLINE,4
SHOWMSGW movf LOOP,W
         call MESSAGW      ; waiting PC message
         call LCDOUT
         incf LOOP,F
         btfss LOOP,4
         goto SHOWMSGW
         return

       ;*************** OUTPUT TO PC SERIAL PORT FOR DOWNLOAD

;  Modified from Joe Farr's file SAMPLE5.ASM
;  Orig Date: 10-Feb-2003, mod date 01MAR03
;---------------------------------------------------------------------
; Description:
; Sends 100 blocks of 258 bytes (256 data + 2 trailer) to the
; serial port.
; On receipt of a 'G' command from the PC, the PIC waits for 'B'
; command and then sends a 258 byte block. The PIC again waits for a 'B'
; command before sending the next block.
; The block being sent is reflected on the PORTB LEDS.
; Each block contains ASCII codes (0 to 255).
;
; The PIC waits for a character before sending back the ASCII block
;
;---------------------------------------------------------------------

JOESETBAUD
        BANK1                   ; Configure the baud rate generator
;        movlw 129               ; BRG for 9600baud from 20MHz, brgh=1
;        movlw 64                ; 4800 Baud with 20MHz XTAL (See PIC data sheet for these values)
;        movlw 42                ; 4800 Baud with 3.2768MHz XTAL (See PIC data sheet for these values)
;        movlw 47                ; 4800 Baud with 3.6864MHz XTAL (See PIC data sheet for these values)
;        movlw 23                ; 9600 Baud with 3.6864MHz XTAL (See PIC data sheet for these values)
        movlw 20                ; 9600 Baud with 3.2768MHz XTAL (See PIC data sheet for these values)
        movwf   SPBRG           ; In bank 1
        movlw   b'00100100'     ; BRGH = 1(High speed, bit 2) & ASYNC transmission (bit 4)
        movwf   TXSTA           ; In bank 1
        bcf     STATUS,RP0      ; back to RAM page 0
        movlw   b'10010000'     ; ASYNC reception
        movwf   RCSTA           ; In bank 0
        call    FlushRXBuffer   ; Flush the RX buffer in bank 0
        return

; ***********

COPY_REGA_REGB:
        movf REGA0,W    
        movwf REGB0
        movf REGA1,W
        movwf REGB1
        movf REGA2,W
        movwf REGB2
        movf REGA3,W
        movwf REGB3
        return

; *********** PART OF PETER HEMSLEY'S 32-BIT MATHS ROUTINES *******

;*** SIGNED BINARY TO DECIMAL ***
;REGA -> DIGITS 1 (MSD) TO 10 (LSD) & DSIGN
;DSIGN = 0 if REGA is positive, FF if negative
;Return carry set if overflow
;Uses FSR register

bin2dec:
        call    clrdig          ;Clear all digits
        clrf    MTEMP           ;Reset sign flag
	call	chksgna		;Make REGA positive
	skpnc
        call    negatea         ;Negative

	movlw	D'32'		;Loop counter
	movwf	MCOUNT

b2dloop	rlf	REGA0,f		;Shift msb into carry
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f

	movlw	DIGIT10
	movwf	FSR		;Pointer to digits
	movlw	D'10'		;10 digits to do
	movwf	DCOUNT

adjlp	rlf	INDF,f		;Shift digit and carry 1 bit left
        movlw   -D'10'
	addwf	INDF,w		;Check and adjust for decimal overflow
	skpnc
	movwf	INDF

	decf	FSR,f		;Next digit
	decfsz	DCOUNT,f
	goto	adjlp

	decfsz	MCOUNT,f	;Next bit
	goto	b2dloop

	btfsc	MTEMP,0		;Check sign
	comf	DSIGN,f		;Negative
	clrc

BLANKIT: movlw 48
        iorwf DIGIT1,F
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F
        iorwf DIGIT9,F
        iorwf DIGIT10,F

        movlw 10          ; blank leading zeros
        movwf LOOP
        movlw DIGIT1
        movwf FSR
BLANK:  movf LOOP,W
        movf INDF,W
        andlw 15
        btfss STATUS,Z
        return
        bcf INDF,4
        incf FSR,F
        decfsz LOOP,F
        goto BLANK
        movlw 48
        iorwf DIGIT10,F
        return

; **************

;Negate REGA
;Used by chksgna, multiply, divide, mod, bin2dec, dec2bin

negatea	movf	REGA3,w		;Save sign in w
	andlw	0x80

	comf	REGA0,f		;2's complement
	comf	REGA1,f
	comf	REGA2,f
	comf	REGA3,f
	incfsz	REGA0,f
	goto	nega1
	incfsz	REGA1,f
	goto	nega1
	incfsz	REGA2,f
	goto	nega1
	incf	REGA3,f
nega1
	incf	MTEMP,f		;flip sign flag
	addwf	REGA3,w		;Return carry set if -2147483648
	return

;Check sign of REGA and convert negative to positive
;Used by multiply, divide, bin2dec

chksgna	rlf	REGA3,w
	skpc
	return			;Positive


;Set all digits to 0
;Used by bin2dec

clrdig	clrf	DSIGN
	clrf	DIGIT1
	clrf	DIGIT2
	clrf	DIGIT3
	clrf	DIGIT4
	clrf	DIGIT5
	clrf	DIGIT6
	clrf	DIGIT7
	clrf	DIGIT8
	clrf	DIGIT9
	clrf	DIGIT10
	return

; ***********

SHOWDIG1: movf DIGIT1,W
          call LCDOUT
SHOWDIG2: movf DIGIT2,W
          call LCDOUT
SHOWDIG3: movf DIGIT3,W
          call LCDOUT
SHOWDIG4: movf DIGIT4,W
          call LCDOUT
SHOWDIG5: movf DIGIT5,W
          call LCDOUT
SHOWDIG6: movf DIGIT6,W
          call LCDOUT
SHOWDIG7: movf DIGIT7,W
          call LCDOUT
SHOWDIG8: movf DIGIT8,W
          call LCDOUT
SHOWDIG9: movf DIGIT9,W
          call LCDOUT
SHOWDIG10: movf DIGIT10,W
          call LCDOUT
        return

; ************

INCADDRESS: clrf MEMFUL
         movlw 2
         addwf WADDRL,F    ;inc write address by 2
         btfss STATUS,C
         return 
         incf WADDRH,F
         btfss WADDRH,7    ; is bit 7 of MSB now set?
         return            ; no

         clrf WADDRH       ; clear MSB
         incf ECHAN,F      ; inc channel count
         movf MEMCNT,W     ; is ECHAN now equal to MEMCNT?
         xorwf ECHAN,W
         btfsc STATUS,Z
         bsf MEMFUL,0
         return

; *****************

CLEARADR: clrf MEMHI
        clrf MEMLO
        clrf WADDRH      ; set write address MSB
        clrf WADDRL      ; set write address LSB
        clrf RADDRH      ; set read address MSB
        clrf RADDRL      ; set read address LSB
        clrf ECHAN
        clrf MEMFUL
        return

; ****** GET SERIAL EEPROM CHIP COUNT

CHIPCOUNT: clrf ECHAN

GETCHIP  clrf WADDRH      ; set write address MSB
         clrf WADDRL      ; set write address LSB
         clrf RADDRH      ; set read address MSB
         clrf RADDRL      ; set read address LSB

         call READ        ; read from EEPROM chip
         movf MEMLO,W     ; get LSB value
         movwf VALIDITY

         comf MEMLO,F     ; invert value
         clrf WADDRL      ; set write address LSB
         call SAVESAMPLE

         clrf RADDRL      ; set read address LSB
         call READ        ; read from EEPROM chip
         xorwf VALIDITY,W ; is 2nd read value same as 1st read?
         btfsc STATUS,Z
         goto STORECHIPS   ; yes

WRITEBACK comf MEMLO,F
         clrf WADDRL      ; set write address LSB
         call SAVESAMPLE
         clrf RADDRL      ; set write address LSB

         call READ        ; read from EEPROM chip
         incf ECHAN,F
         btfss ECHAN,3
         goto GETCHIP

STORECHIPS: movf ECHAN,W
        movwf MEMCNT
        clrf ECHAN
        clrf WADDRH
        clrf WADDRL

        movwf PROMVAL     ; store chipcount
        movlw 4
        call SETPRM

SHOWCHIPS: call LCD21
         bsf RSLINE,4

         movf MEMCNT,W
         iorlw 48
         call LCDOUT

         movlw ' '
         call LCDOUT
         movlw 'E'
         call LCDOUT
         movlw 'E'
         call LCDOUT
         movlw 'P'
         call LCDOUT
         movlw 'R'
         call LCDOUT
         movlw 'O'
         call LCDOUT
         movlw 'M'
         call LCDOUT
         movlw ' '
         call LCDOUT
         movlw 'C'
         call LCDOUT
         movlw 'H'
         call LCDOUT
         movlw 'I'
         call LCDOUT
         movlw 'P'
         call LCDOUT
         bcf STATUS,C
         rrf ECHAN,W
         btfsc STATUS,Z
         return
         movlw 'S'
         call LCDOUT
         return

; *********** READ ADC CHANNEL *****

GETADC:         bsf ADCON0,GO           ; start data conversion
                nop

GETADC2:        btfsc ADCON0,GO
                goto GETADC2
                movf ADRESH,W           ; get ADC MSB val
                movwf ADCMSB            ; store it into ADCMSB
                BANK1
                movf ADRESL,W           ; get ADC LSB val
                BANK0
                movwf ADCLSB            ; store it into ADCLSB
                return


; *********** CHANGE SAMPLE DELAY *********

CHANGERATE: call SHOWRATE
            call CLRLINE1
            call LCD1
            movlw 'S'
            call LCDOUT
            movlw 'E'
            call LCDOUT
            movlw 'T'
            call LCDOUT

CHANGE1:    btfsc PORTC,5   ; wait switch release
            goto CHANGE1
            call PAUSIT

CHANGE2:    call SHOWRATE
            movf DELAYCOUNT,W  ; get delay count
            call TXBYTE        ; send it to PC
CHANGE3:    call PAUSIT
            btfsc PORTC,5   ; is switch set?
            goto CHANGE4

            btfss PORTC,2
            goto CHANGE3
            bcf STATUS,C
            rlf DELAYCOUNT,F
            movf DELAYCOUNT,W
            btfsc STATUS,Z
            bsf DELAYCOUNT,0
            goto CHANGE2

CHANGE4:    movf DELAYCOUNT,W
            movwf SAMPLEDELAY
            movwf PROMVAL
            movlw 3
            call SETPRM
            return


;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F87x devices ****
;         according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bsf STATUS,RP0  ;set for Page 3
        bcf EECON1,EEPGD ;point to data memory
        bsf EECON1,RD   ;enable read flag
        bcf STATUS,RP0  ;set for Page 2 
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        bcf STATUS,RP1  ;set for Page 0
        return

; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F87x devices ********
          ;according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in PROMVAL
SETPRM: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bcf STATUS,RP1  ;set for Page 0
        MOVF PROMVAL,W  ;get data value from STORE1 and hold in W
        bsf STATUS,RP1  ;set for Page 2
        movwf EEDATA    ;copy W into eeprom data byte register
        bsf STATUS,RP0  ;set for page 3
        bcf EECON1,EEPGD ;point to Data memory
        bsf EECON1,WREN ;enable write flag

MANUAL: movlw $55       ;these lines cause the action required by
        movwf EECON2    ;by the eeprom to store the data in EEDATA
        movlw $AA       ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ;set the ``perform write'' flag
        bcf STATUS,RP1  ;set for Page 0
        bcf STATUS,RP0

CHKWRT: btfss PIR2,EEIF ;wait until bit 4 of PIR2 is set
        goto CHKWRT
        bcf PIR2,EEIF   ;clear bit 4 of PIR2
        return

; ***********

STORECOUNT: movf ECHAN,W      ; set recording count into EEPROM
        movwf PROMVAL
        movlw 0
        call SETPRM

        movf WADDRH,W
        movwf PROMVAL
        movlw 1
        call SETPRM

        movf WADDRL,W
        movwf PROMVAL
        movlw 2
        call SETPRM
        return

; ***************

JOESENDPC
        clrf RADDRH       ; reset start address for reading EEPROM chip
        clrf RADDRL

; 'G' has been received - Confirm ready state back to PC

        movlw   'S'
        call    TxByte
        movlw   'E'
        call    TxByte
        movlw   'I'
        call    TxByte
        movlw   'S'
        call    TxByte
        movlw   'M'
        call    TxByte
        movlw   'O'
        call    TxByte
        movlw   ' '
        call    TxByte
        movf MEMCNT,W            ; number of EEPROM chips
        iorlw 48
        call    TxByte

        movlw 3                  ; sample rate
        call PRMGET
        call TxByte

        movf ECHAN,W             ; send current ECHAN & WRITE address
        call    TxByte
        movf WADDRH,W
        call    TxByte
        movf WADDRL,W
        call    TxByte

        movf MEMCNT,W
        btfsc STATUS,Z           ; are there any eeprom chips installed?
        return                   ; no

BYPASS: movf ECHAN,W             ; temp store ECHAN
        movwf ECHANTEMP
        clrf ECHAN

        goto WAITB

WaitG 				; Wait for any character to be received
        call 	FlushRXBuffer   ; Make sure that the RX buffer is empty
        call    RecLoop         ; Wait and read from serial - character returned in W
        sublw   'G'             ; Is this a 'G'
        btfss   STATUS,Z
        goto    WaitG           ; Not a 'G'

;        movlw 'R'
;        call LCDOUT

; 'G' has been received - Confirm ready state back to PC
SendR:  movlw   'R'             ; Signal 'R'eady
        call    TxByte

; Start sending the blocks
; First, wait for the PC to send us a 'B' command (Send block)

WaitB
	call 	FlushRXBuffer   ; Make sure that the RX buffer is empty
        call    RecLoop         ; Wait and read from serial - character returned in W
        movwf   PORTB
        sublw   'B'             ; Is this a 'B'
        btfsc   STATUS,Z
        goto    SendNext        ; Yes a 'B'
        btfsc ABORT,0           ; is abort tranfser flag set?
        goto    ENDTF           ; yes, so abort transfer
        goto    WaitB           ; Not a 'B'

; 'B' received, send a block

SendNext
         call READ         ; read from EEPROM chip
         movf MEMLO,W      ; get LSB value
         call TXBYTE       ; send it to PC
         movf MEMHI,W      ; get MSB value
         call TXBYTE       ; send it to PC
       
         movlw 2
         addwf RADDRL,F    ; inc read address by 2
         btfss STATUS,C
         goto SendNext

; Data portion of the block has been sent, now send the Block terminator
        movlw   0x0D            ; CR
        call    TxByte
        movlw   0x0A            ; LF
        call    TxByte

        incf RADDRH,F
        btfss RADDRH,7    ; is bit 7 of MSB high? (32768)
        goto    WaitB

        clrf RADDRH       ; reset start address for reading EEPROM chip
        clrf RADDRL

        incf ECHAN,F
        movf ECHAN,W
;        decf ECHAN,W
        xorwf MEMCNT,W
        btfss STATUS,Z
        goto WAITB

ENDTF:  movf ECHANTEMP,W   ; restore count into ECHAN
        movwf ECHAN
        return

; Receive a character from RS232
; (This routine does not return until a character has been received)
; The received character is in the W register

RecLoop:
        clrf TMR1L            ; reset timer 1
        clrf TMR1H
        bcf PIR1,0            ; clear timer 1 overflow

RecLoop2:
        btfss PIR1,0          ; has timer 1 overflowed?
        goto RECLOOP3         ; no
        movlw 0
        bsf ABORT,0           ; yes, set flag
        return

RECLOOP3: nop
        btfss   PIR1,RCIF       ; Check for any RX'd data
        goto    RecLoop2        ; Nothing RX'd
        movf    RCREG,W         ; Store the RX'd data in 'W'
        return

; Send byte in W to the USART

TxByte: nop
        btfss   PIR1,TXIF       ; TX Buffer empty yet ?
        goto    TxByte          ; No - Keep waiting
        movwf   TXREG           ; Now empty - send this character
        return

; Flush the contents of the RX Buffer

FlushRXBuffer
	movf    RCREG,W        	; Flush the RX buffer in bank 0
        movf    RCREG,W
	movf    RCREG,W
        return

        ORG $2100

        DE 0,0,0,1,0,0

        END


